import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CardIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M22 18.5C22 19.3284 21.3284 20 20.5 20H3.5C2.67157 20 2 19.3284 2 18.5V6.5C2 5.67157 2.67157 5 3.5 5H20.5C21.3284 5 22 5.67157 22 6.5V18.5ZM4 8.5C4 8.22386 4.22386 8 4.5 8H5.5C5.77614 8 6 8.22386 6 8.5V9.5C6 9.77614 5.77614 10 5.5 10H4.5C4.22386 10 4 9.77614 4 9.5V8.5ZM4.5 15C4.22386 15 4 15.2239 4 15.5V16.5C4 16.7761 4.22386 17 4.5 17H19.5C19.7761 17 20 16.7761 20 16.5V15.5C20 15.2239 19.7761 15 19.5 15H4.5Z"
            fill={props.fill}
        />
    </svg>
);

CardIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default CardIcon;
