import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CloseIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M19.2071 6.20701C19.3892 6.01841 19.49 5.76581 19.4878 5.50361C19.4855 5.24141 19.3803 4.9906 19.1949 4.80519C19.0095 4.61978 18.7587 4.51461 18.4965 4.51234C18.2343 4.51006 17.9817 4.61085 17.7931 4.79301L12.0001 10.586L6.20708 4.79301C6.01848 4.61085 5.76588 4.51006 5.50368 4.51234C5.24148 4.51461 4.99067 4.61978 4.80526 4.80519C4.61985 4.9906 4.51469 5.24141 4.51241 5.50361C4.51013 5.76581 4.61092 6.01841 4.79308 6.20701L10.5861 12L4.79308 17.793C4.69757 17.8853 4.62139 17.9956 4.56898 18.1176C4.51657 18.2396 4.48898 18.3708 4.48783 18.5036C4.48668 18.6364 4.51198 18.7681 4.56226 18.891C4.61254 19.0139 4.68679 19.1255 4.78069 19.2194C4.87458 19.3133 4.98623 19.3876 5.10913 19.4378C5.23202 19.4881 5.3637 19.5134 5.49648 19.5123C5.62926 19.5111 5.76048 19.4835 5.88249 19.4311C6.00449 19.3787 6.11483 19.3025 6.20708 19.207L12.0001 13.414L17.7931 19.207C17.9817 19.3892 18.2343 19.49 18.4965 19.4877C18.7587 19.4854 19.0095 19.3802 19.1949 19.1948C19.3803 19.0094 19.4855 18.7586 19.4878 18.4964C19.49 18.2342 19.3892 17.9816 19.2071 17.793L13.4141 12L19.2071 6.20701Z"
            fill={props.fill}
        />
    </svg>
);

CloseIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default CloseIcon;
