import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CovidShildIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M12 2C9.42857 3.25 6.21429 4.67287 3 4.5L3.64286 13.043C3.64286 14.9229 4.61282 16.6846 6.24146 17.7627L12 22L17.7585 17.7627C19.3872 16.6846 20.3571 14.9229 20.3571 13.043L21 4.5C17.7857 4.67287 14.5714 3.25 12 2ZM15.9356 6.78057C15.7616 7.13697 15.3359 7.30859 14.8747 7.25041L13.7598 9.18152C14.0778 9.43711 14.3391 9.76045 14.5217 10.1296L16.3376 9.64308C16.6043 9.57161 16.8785 9.7299 16.95 9.99663C17.0214 10.2634 16.8631 10.5375 16.5964 10.609L14.7976 11.091C14.807 11.1844 14.8118 11.2791 14.8118 11.375C14.8118 11.6539 14.7712 11.9234 14.6955 12.1777L16.6162 13.2866C16.9569 12.9985 17.3871 12.9088 17.7224 13.0961C18.1897 13.3571 18.2957 14.0573 17.9591 14.66C17.6224 15.2627 16.9707 15.5397 16.5033 15.2787C16.1447 15.0784 15.9989 14.6196 16.1025 14.1447L14.243 13.0711C13.9722 13.4288 13.6178 13.7197 13.2089 13.9148L13.9697 16.7541C14.0412 17.0208 13.8829 17.295 13.6162 17.3665C13.3494 17.4379 13.0753 17.2796 13.0038 17.0129L12.2439 14.177C12.1633 14.184 12.0817 14.1875 11.9993 14.1875C11.6396 14.1875 11.2957 14.12 10.9796 13.997L10.0051 15.6847C10.3038 16.0285 10.3987 16.4674 10.2077 16.8078C9.94574 17.2746 9.24533 17.3792 8.64328 17.0414C8.04122 16.7036 7.7655 16.0513 8.02744 15.5845C8.22543 15.2316 8.6739 15.0857 9.14107 15.1813L10.1269 13.4737C9.83423 13.2124 9.59653 12.8908 9.43336 12.5283L6.43825 13.3309C6.17152 13.4023 5.89735 13.2441 5.82588 12.9773C5.75441 12.7106 5.9127 12.4364 6.17944 12.365L9.1926 11.5576C9.18873 11.4972 9.18677 11.4363 9.18677 11.375C9.18677 10.9865 9.26556 10.6163 9.40803 10.2797L8.36191 9.67571C8.0238 9.9617 7.59721 10.0515 7.26288 9.86723C6.79409 9.6088 6.68425 8.90919 7.01754 8.30462C7.35083 7.70004 8.00105 7.41944 8.46984 7.67788C8.83147 7.87724 8.9795 8.33913 8.87528 8.8174L9.95659 9.4417C10.1984 9.18632 10.4875 8.97626 10.81 8.82558L10.3867 7.24569C10.3152 6.97896 10.4735 6.70479 10.7402 6.63332C11.007 6.56185 11.2811 6.72014 11.3526 6.98687L11.7771 8.57115C11.8504 8.56542 11.9245 8.5625 11.9993 8.5625C12.3073 8.5625 12.6037 8.61201 12.881 8.7035L13.9734 6.81155C13.6421 6.48344 13.5146 6.04099 13.689 5.68374C13.9239 5.2027 14.6172 5.05828 15.2375 5.36116C15.8579 5.66404 16.1704 6.29953 15.9356 6.78057Z"
            fill={props.fill}
        />
    </svg>
);

CovidShildIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default CovidShildIcon;
