import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DefaultAviaIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M24 0H0V24H24V0ZM21 19H7L4 6H10L21 17V19Z"
            fill={props.fill}
        />
    </svg>
);

DefaultAviaIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default DefaultAviaIcon;
