import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DryCleaningIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M9.17495 9.0543L2.06766 11.4972C0.800514 12.0028 0 13.1851 0 14.5C0 15.8807 1.11929 17 2.5 17H4V15H2.5C2.22386 15 2 14.7761 2 14.5C2 14.003 2.30261 13.556 2.76411 13.3714L9.82505 10.9457C10.3473 10.7662 10.6252 10.1972 10.4457 9.67495C10.2662 9.15265 9.69724 8.87478 9.17495 9.0543Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M5 23V15H5.00959C5.02157 14.8039 5.04849 14.6648 5.10899 14.546C5.20487 14.3578 5.35785 14.2049 5.54601 14.109C5.75992 14 6.03995 14 6.6 14H17.4C17.9601 14 18.2401 14 18.454 14.109C18.6422 14.2049 18.7951 14.3578 18.891 14.546C18.9515 14.6648 18.9784 14.8039 18.9904 15H19V23C19 23 15.5 24 12 24C8.5 24 5 23 5 23ZM7.58751 21.1047C7.28226 21.0542 7 21.2887 7 21.5981C7 21.8318 7.16382 22.0322 7.39412 22.072C8.19475 22.2104 10.0974 22.5 12 22.5C13.9026 22.5 15.8052 22.2104 16.6059 22.072C16.8362 22.0322 17 21.8318 17 21.5981C17 21.2887 16.7177 21.0542 16.4125 21.1047C15.5263 21.2513 13.7632 21.5 12 21.5C10.2368 21.5 8.47368 21.2513 7.58751 21.1047Z"
            fill={props.fill}
        />
        <path
            d="M20 17H21.5C22.8807 17 24 15.8807 24 14.5C24 13.1851 23.1995 12.0028 21.9787 11.5144L14.1353 8.83133C14.0544 8.80367 14 8.72761 14 8.64209V7.3411C14 7.26423 14.0441 7.19417 14.1133 7.16085C15.3517 6.56533 16 5.4556 16 4C16 1.79086 14.2091 0 12 0C9.79086 0 8 1.79086 8 4C8 4.55228 8.44771 5 9 5C9.55229 5 10 4.55228 10 4C10 2.89543 10.8954 2 12 2C13.1046 2 14 2.89543 14 4C14 4.71085 13.7683 5.10756 13.2466 5.35843C12.4846 5.72487 12 6.49558 12 7.3411V8.64209C12 9.58281 12.5981 10.4194 13.4883 10.7238L21.2838 13.3891C21.6974 13.556 22 14.003 22 14.5C22 14.7761 21.7761 15 21.5 15H20V17Z"
            fill={props.fill}
        />
    </svg>
);

DryCleaningIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default DryCleaningIcon;
