import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FilterIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M15 11C14.1131 10.9999 13.2514 10.7052 12.5502 10.1622C11.849 9.61917 11.3481 8.85863 11.126 8H3C2.73478 8 2.48043 7.89465 2.29289 7.70711C2.10536 7.51957 2 7.26522 2 7C2 6.73479 2.10536 6.48043 2.29289 6.2929C2.48043 6.10536 2.73478 6 3 6H11.126C11.3484 5.14176 11.8496 4.38168 12.5507 3.83908C13.2519 3.29647 14.1134 3.00206 15 3.00206C15.8866 3.00206 16.7481 3.29647 17.4493 3.83908C18.1504 4.38168 18.6516 5.14176 18.874 6H21C21.2652 6 21.5196 6.10536 21.7071 6.2929C21.8946 6.48043 22 6.73479 22 7C22 7.26522 21.8946 7.51957 21.7071 7.70711C21.5196 7.89465 21.2652 8 21 8H18.874C18.652 8.85863 18.151 9.61917 17.4498 10.1622C16.7486 10.7052 15.8869 10.9999 15 11ZM3 16C2.73478 16 2.48043 16.1054 2.29289 16.2929C2.10536 16.4804 2 16.7348 2 17C2 17.2652 2.10536 17.5196 2.29289 17.7071C2.48043 17.8946 2.73478 18 3 18H5.126C5.34844 18.8582 5.84957 19.6183 6.55074 20.1609C7.2519 20.7035 8.1134 20.9979 9 20.9979C9.8866 20.9979 10.7481 20.7035 11.4493 20.1609C12.1504 19.6183 12.6516 18.8582 12.874 18H21C21.2652 18 21.5196 17.8946 21.7071 17.7071C21.8946 17.5196 22 17.2652 22 17C22 16.7348 21.8946 16.4804 21.7071 16.2929C21.5196 16.1054 21.2652 16 21 16H12.874C12.6516 15.1418 12.1504 14.3817 11.4493 13.8391C10.7481 13.2965 9.8866 13.0021 9 13.0021C8.1134 13.0021 7.2519 13.2965 6.55074 13.8391C5.84957 14.3817 5.34844 15.1418 5.126 16H3ZM15 9C15.5304 9 16.0391 8.78929 16.4142 8.41422C16.7893 8.03914 17 7.53044 17 7C17 6.46957 16.7893 5.96086 16.4142 5.58579C16.0391 5.21072 15.5304 5 15 5C14.4696 5 13.9609 5.21072 13.5858 5.58579C13.2107 5.96086 13 6.46957 13 7C13 7.53044 13.2107 8.03914 13.5858 8.41422C13.9609 8.78929 14.4696 9 15 9ZM11 17C11 17.5304 10.7893 18.0391 10.4142 18.4142C10.0391 18.7893 9.53043 19 9 19C8.46957 19 7.96086 18.7893 7.58579 18.4142C7.21071 18.0391 7 17.5304 7 17C7 16.4696 7.21071 15.9609 7.58579 15.5858C7.96086 15.2107 8.46957 15 9 15C9.53043 15 10.0391 15.2107 10.4142 15.5858C10.7893 15.9609 11 16.4696 11 17Z"
            fill={props.fill}
        />
    </svg>
);

FilterIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default FilterIcon;
