import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FlightIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M22.0643 21.7345L18.5559 9.8058C17.3262 11.3375 15.7612 12.9712 13.7715 14.6227L19.2189 22.7939C19.3346 22.9674 19.5522 23.0421 19.75 22.9761L21.7668 22.3038C22.0031 22.2251 22.1346 21.9734 22.0643 21.7345Z"
            fill={props.fill}
        />
        <path
            d="M9.25004 22.1397V18.0529C8.08634 18.8945 7.07982 19.593 6.21066 20.1726L7.22458 22.7074C7.31702 22.9385 7.57504 23.0559 7.80998 22.9737L8.93862 22.5787C9.12514 22.5134 9.25004 22.3373 9.25004 22.1397Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M7.31797 14.7498C8.27935 13.5633 9.38732 12.2714 10.5278 10.9955L1.20602 4.78099C1.03245 4.66529 0.957809 4.44773 1.02377 4.24984L1.69604 2.23305C1.77479 1.99679 2.02646 1.86528 2.26539 1.93555L15.4532 5.81432C19.644 1.75354 22.2335 0.534874 22.8491 1.15049C23.4961 1.79749 22.1199 4.62751 17.545 9.20247C12.97 13.7774 5.08347 20.5337 4.27469 19.7249C4.08914 19.5393 4.30192 18.9814 4.79528 18.1764L1.29243 16.7753C1.06133 16.6829 0.943985 16.4248 1.02621 16.1899L1.4212 15.0613C1.48648 14.8747 1.66252 14.7498 1.86014 14.7498H7.31797Z"
            fill={props.fill}
        />
    </svg>
);

FlightIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default FlightIcon;
