import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FurnitureIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M17 15.6772C16.8743 15.6478 16.7497 15.6193 16.6261 15.5919C15.084 14.864 13.542 14.5 12 14.5C10.4697 14.5 8.93943 14.8584 7.40916 15.5753C7.2735 15.6058 7.13662 15.6374 6.99852 15.6703L6.99807 13.617C6.99936 13.5781 7 13.5391 7 13.5C7 11.7427 5.70496 10.2879 4.01722 10.038L3.68536 8.87555C2.96471 6.35132 4.40393 3.72342 6.98625 2.84843C8.65554 2.28281 10.3255 2 11.9962 2C13.6688 2 15.3414 2.28344 17.0141 2.85032C19.5962 3.72542 21.0353 6.35322 20.3146 8.87733L19.9833 10.0379C18.2953 10.2876 17 11.7426 17 13.5L17.0001 13.5391C17.0003 13.5651 17.0004 13.5911 17 13.6172V15.6772ZM10.5 6.75C10.5 7.16421 10.1642 7.5 9.75 7.5C9.33579 7.5 9 7.16421 9 6.75C9 6.33579 9.33579 6 9.75 6C10.1642 6 10.5 6.33579 10.5 6.75ZM9.75 11.5C10.1642 11.5 10.5 11.1642 10.5 10.75C10.5 10.3358 10.1642 10 9.75 10C9.33579 10 9 10.3358 9 10.75C9 11.1642 9.33579 11.5 9.75 11.5ZM15 10.75C15 11.1642 14.6642 11.5 14.25 11.5C13.8358 11.5 13.5 11.1642 13.5 10.75C13.5 10.3358 13.8358 10 14.25 10C14.6642 10 15 10.3358 15 10.75ZM14.25 7.5C14.6642 7.5 15 7.16421 15 6.75C15 6.33579 14.6642 6 14.25 6C13.8358 6 13.5 6.33579 13.5 6.75C13.5 7.16421 13.8358 7.5 14.25 7.5Z"
            fill={props.fill}
        />
        <path
            d="M18 16.602V13.5C18 12.1193 19.1193 11 20.5 11C21.8807 11 23 12.1193 23 13.5C23 14.8807 21.8807 16 20.5 16C20.3061 16 20.1174 15.9779 19.9362 15.9362L21.1304 17.1304L19.5 23H18V19.6326C15.9999 19.8775 13.9998 20 11.9999 20C9.9999 20 7.99995 19.8776 6 19.6327L6 23H4.55268L2.88384 17.1162L4.06384 15.9362C3.88264 15.9779 3.6939 16 3.5 16C2.11929 16 1 14.8807 1 13.5C1 12.1193 2.11929 11 3.5 11C4.88071 11 6 12.1193 6 13.5V16.602C7.99989 15.8673 9.99985 15.5 11.9999 15.5C13.9999 15.5 16 15.8673 18 16.602Z"
            fill={props.fill}
        />
    </svg>
);

FurnitureIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default FurnitureIcon;
