import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const GeolocationOutlineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M2.76133 12.7265L9.49857 14.4998L11.2715 21.2369C11.3489 21.5311 11.5561 21.7741 11.8344 21.8971C12.3395 22.1203 12.93 21.8917 13.1532 21.3866L20.6111 4.5082C20.7078 4.28938 20.7078 4.03995 20.6111 3.82113C20.4214 3.39174 19.9195 3.19745 19.4901 3.38717L2.61172 10.8448C2.33342 10.9677 2.12624 11.2107 2.0488 11.5049C1.90823 12.039 2.22724 12.586 2.76133 12.7265ZM10.0076 12.5657L6.03316 11.5196L17.581 6.41719L12.4785 17.965L11.4327 13.9908C11.2492 13.2936 10.7048 12.7492 10.0076 12.5657Z"
            fill={props.fill}
        />
    </svg>
);

GeolocationOutlineIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default GeolocationOutlineIcon;
