import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HandLuggage10Icon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6.00001 8.15137C3.79087 8.15137 2.00001 9.94222 2.00001 12.1514L2 16.001C1.99999 18.2101 3.79086 20.001 6 20.001H18C20.2091 20.001 22 18.2101 22 16.001L22 12.1514C22 9.94223 20.2092 8.15137 18 8.15137H6.00001ZM12.8099 16.7932C13.1339 16.9312 13.4819 17.0002 13.8539 17.0002C14.2259 17.0002 14.5709 16.9282 14.8889 16.7842C15.2129 16.6402 15.4949 16.4272 15.7349 16.1452C15.9749 15.8632 16.1609 15.5152 16.2929 15.1012C16.4309 14.6872 16.4999 14.2072 16.4999 13.6612C16.4999 13.1152 16.4309 12.6382 16.2929 12.2302C16.1609 11.8162 15.9749 11.4742 15.7349 11.2042C15.4949 10.9282 15.2129 10.7212 14.8889 10.5832C14.5709 10.4452 14.2259 10.3762 13.8539 10.3762C13.4819 10.3762 13.1339 10.4452 12.8099 10.5832C12.4859 10.7212 12.2039 10.9282 11.9639 11.2042C11.7239 11.4802 11.5349 11.8252 11.3969 12.2392C11.2589 12.6532 11.1899 13.1332 11.1899 13.6792C11.1899 14.2312 11.2589 14.7142 11.3969 15.1282C11.5349 15.5422 11.7239 15.8872 11.9639 16.1632C12.2039 16.4392 12.4859 16.6492 12.8099 16.7932ZM14.4659 16.0012C14.2739 16.0852 14.0669 16.1272 13.8449 16.1272C13.6289 16.1272 13.4249 16.0852 13.2329 16.0012C13.0409 15.9112 12.8729 15.7702 12.7289 15.5782C12.5909 15.3862 12.4799 15.1372 12.3959 14.8312C12.3179 14.5192 12.2789 14.1382 12.2789 13.6882C12.2789 13.2382 12.3179 12.8602 12.3959 12.5542C12.4799 12.2422 12.5909 11.9902 12.7289 11.7982C12.8729 11.6002 13.0409 11.4592 13.2329 11.3752C13.4249 11.2852 13.6319 11.2402 13.8539 11.2402C14.0699 11.2402 14.2739 11.2852 14.4659 11.3752C14.6579 11.4592 14.8229 11.6002 14.9609 11.7982C15.1049 11.9902 15.2159 12.2422 15.2939 12.5542C15.3779 12.8602 15.4199 13.2382 15.4199 13.6882C15.4199 14.1382 15.3779 14.5192 15.2939 14.8312C15.2159 15.1372 15.1049 15.3862 14.9609 15.5782C14.8229 15.7702 14.6579 15.9112 14.4659 16.0012ZM8.83929 16.9102H9.90129V10.4572H8.98329L7.48929 11.9332V13.0132L8.83929 11.6902V16.9102Z"
            fill={props.fill}
        />
        <path
            d="M8.50398 6.77629L8.49683 6.88298H8.60376H9.35206H9.44362L9.45167 6.79178C9.55782 5.5907 10.6003 4.894 11.8963 4.894C13.1918 4.894 14.2358 5.59061 14.3598 6.79324L14.369 6.88298H14.4592H15.2075H15.3157L15.3072 6.77519C15.2394 5.90783 14.8312 5.23633 14.2144 4.78375C13.5997 4.3327 12.7826 4.10209 11.8963 4.10209C11.0101 4.10209 10.1928 4.33268 9.58038 4.78386C8.96573 5.23666 8.56213 5.90856 8.50398 6.77629Z"
            fill={props.fill}
            stroke={props.fill}
            strokeWidth={0.2}
        />
    </svg>
);

HandLuggage10Icon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default HandLuggage10Icon;
