import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HeartFilledSolidIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M21 8.63895C21 3.75134 14.8854 2.22699 12.9842 6.50503C12.6021 7.36458 11.4049 7.36458 11.0227 6.50503C9.12153 2.22699 3 3.75024 3 8.63895C3 12.2066 6.20837 16.3984 12.0035 20C17.7997 16.3995 21 12.2054 21 8.63895Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M12.5089 20.8555C18.7813 17.1489 22 13.2162 22 8.99825C22 2.9979 15.2512 1.11111 12 5.10154C8.74876 1.11111 2 2.9979 2 8.99825C2 13.2162 5.21867 17.1489 11.4911 20.8555C11.805 21.041 12.195 21.041 12.5089 20.8555ZM12.911 7.41109C14.6772 3.51015 20 4.54081 20 8.99825C20 12.2506 17.3835 15.5454 12 18.8289C6.61652 15.5454 4 12.2506 4 8.99825C4 4.54081 9.32276 3.51015 11.089 7.41109C11.4436 8.19437 12.5564 8.19437 12.911 7.41109Z"
            fill="white"
        />
    </svg>
);

HeartFilledSolidIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default HeartFilledSolidIcon;
