import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const Luggage23Icon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <mask
            id="b0050fa6__mask0_14213_168"
            style={{
                maskType: 'alpha',
            }}
            maskUnits="userSpaceOnUse"
            x={6}
            y={21}
            width={12}
            height={2}
        >
            <rect x={6} y={21} width={12} height={2} fill="#C4C4C4" />
        </mask>
        <g mask="url(#b0050fa6__mask0_14213_168)">
            <circle cx={8.5} cy={21.5} r={1.5} fill={props.fill} />
            <circle cx={15.5} cy={21.5} r={1.5} fill={props.fill} />
        </g>
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M7.61935 5H16.3806C17.8032 5 19 6.15556 19 7.57778V17.2779C19 18.2203 18.2144 19.3101 17.3461 19.8271C17.1262 19.958 16.8685 20.0001 16.6125 20.0001H16.5H15.5L14 20.0001H13.5H11H10H8.5H7.39583C7.13448 20.0001 6.87124 19.956 6.64812 19.8199C5.79582 19.3 5 18.2159 5 17.2779V7.57778C5 6.15556 6.19677 5 7.61935 5ZM9.13226 1C8.77097 1 8.47742 1.28889 8.47742 1.64444V4H9.5V3.96117V3.00006V2.00006H14.5V4H15.5452V1.64444C15.5452 1.28889 15.2516 1 14.8903 1H9.13226ZM7.261 15.5H11.5V14.582H8.413C8.911 14.21 9.349 13.871 9.727 13.565C10.111 13.253 10.429 12.953 10.681 12.665C10.939 12.377 11.134 12.089 11.266 11.801C11.398 11.513 11.464 11.204 11.464 10.874C11.464 10.58 11.413 10.316 11.311 10.082C11.215 9.842 11.074 9.641 10.888 9.479C10.702 9.311 10.477 9.182 10.213 9.092C9.955 9.002 9.661 8.957 9.331 8.957C8.911 8.957 8.551 9.02 8.251 9.146C7.951 9.266 7.681 9.431 7.441 9.641V10.676C7.693 10.43 7.966 10.232 8.26 10.082C8.56 9.932 8.881 9.857 9.223 9.857C9.583 9.857 9.859 9.953 10.051 10.145C10.249 10.337 10.348 10.595 10.348 10.919C10.348 11.183 10.291 11.435 10.177 11.675C10.063 11.915 9.88 12.173 9.628 12.449C9.382 12.719 9.064 13.016 8.674 13.34C8.284 13.664 7.813 14.039 7.261 14.465V15.5ZM16.6838 14.456C16.7978 14.216 16.8548 13.946 16.8548 13.646C16.8548 13.424 16.8128 13.223 16.7288 13.043C16.6508 12.863 16.5428 12.71 16.4048 12.584C16.2728 12.452 16.1168 12.347 15.9368 12.269C15.7628 12.185 15.5798 12.131 15.3878 12.107C15.5498 12.077 15.7058 12.026 15.8558 11.954C16.0058 11.876 16.1378 11.777 16.2518 11.657C16.3658 11.531 16.4558 11.387 16.5218 11.225C16.5938 11.063 16.6298 10.877 16.6298 10.667C16.6298 10.415 16.5788 10.184 16.4768 9.974C16.3808 9.764 16.2398 9.584 16.0538 9.434C15.8738 9.284 15.6518 9.167 15.3878 9.083C15.1298 8.999 14.8388 8.957 14.5148 8.957C14.0828 8.957 13.7168 9.008 13.4168 9.11C13.1168 9.212 12.8618 9.347 12.6518 9.515V10.514C12.8738 10.328 13.1228 10.172 13.3988 10.046C13.6748 9.914 14.0078 9.848 14.3978 9.848C14.7758 9.848 15.0638 9.929 15.2618 10.091C15.4598 10.247 15.5588 10.463 15.5588 10.739C15.5588 11.045 15.4568 11.282 15.2528 11.45C15.0488 11.612 14.7818 11.693 14.4518 11.693H13.6058V12.602H14.4158C15.3038 12.602 15.7478 12.944 15.7478 13.628C15.7478 13.964 15.6308 14.228 15.3968 14.42C15.1628 14.612 14.8298 14.708 14.3978 14.708C13.9658 14.708 13.5998 14.642 13.2998 14.51C12.9998 14.372 12.7478 14.219 12.5438 14.051V15.059C12.7418 15.209 12.9968 15.335 13.3088 15.437C13.6268 15.539 14.0108 15.59 14.4608 15.59C14.8208 15.59 15.1478 15.545 15.4418 15.455C15.7358 15.365 15.9878 15.236 16.1978 15.068C16.4078 14.894 16.5698 14.69 16.6838 14.456Z"
            fill={props.fill}
        />
    </svg>
);

Luggage23Icon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default Luggage23Icon;
