import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const Luggage40Icon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <mask
            id="c3392635__mask0_14213_170"
            style={{
                maskType: 'alpha',
            }}
            maskUnits="userSpaceOnUse"
            x={6}
            y={21}
            width={12}
            height={2}
        >
            <rect x={6} y={21} width={12} height={2} fill="#C4C4C4" />
        </mask>
        <g mask="url(#c3392635__mask0_14213_170)">
            <circle cx={8.5} cy={21.5} r={1.5} fill={props.fill} />
            <circle cx={15.5} cy={21.5} r={1.5} fill={props.fill} />
        </g>
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M7.61935 5H16.3806C17.8032 5 19 6.15556 19 7.57778V17.2779C19 18.2203 18.2144 19.3101 17.3461 19.8271C17.1262 19.958 16.8685 20.0001 16.6125 20.0001H16.5H15.5L14 20.0001H13.5H11H10H8.5H7.39583C7.13448 20.0001 6.87124 19.956 6.64812 19.8199C5.79582 19.3 5 18.2159 5 17.2779V7.57778C5 6.15556 6.19677 5 7.61935 5ZM9.13226 1C8.77097 1 8.47742 1.28889 8.47742 1.64444V4H9.5V3.96117V3.00006V2.00006H14.5V4H15.5452V1.64444C15.5452 1.28889 15.2516 1 14.8903 1H9.13226ZM13.31 15.3272C13.634 15.4652 13.982 15.5342 14.354 15.5342C14.726 15.5342 15.071 15.4622 15.389 15.3182C15.713 15.1742 15.995 14.9612 16.235 14.6792C16.475 14.3972 16.661 14.0492 16.793 13.6352C16.931 13.2212 17 12.7412 17 12.1952C17 11.6492 16.931 11.1722 16.793 10.7642C16.661 10.3502 16.475 10.0082 16.235 9.73816C15.995 9.46216 15.713 9.25516 15.389 9.11716C15.071 8.97916 14.726 8.91016 14.354 8.91016C13.982 8.91016 13.634 8.97916 13.31 9.11716C12.986 9.25516 12.704 9.46216 12.464 9.73816C12.224 10.0142 12.035 10.3592 11.897 10.7732C11.759 11.1872 11.69 11.6672 11.69 12.2132C11.69 12.7652 11.759 13.2482 11.897 13.6622C12.035 14.0762 12.224 14.4212 12.464 14.6972C12.704 14.9732 12.986 15.1832 13.31 15.3272ZM14.966 14.5352C14.774 14.6192 14.567 14.6612 14.345 14.6612C14.129 14.6612 13.925 14.6192 13.733 14.5352C13.541 14.4452 13.373 14.3042 13.229 14.1122C13.091 13.9202 12.98 13.6712 12.896 13.3652C12.818 13.0532 12.779 12.6722 12.779 12.2222C12.779 11.7722 12.818 11.3942 12.896 11.0882C12.98 10.7762 13.091 10.5242 13.229 10.3322C13.373 10.1342 13.541 9.99316 13.733 9.90916C13.925 9.81916 14.132 9.77416 14.354 9.77416C14.57 9.77416 14.774 9.81916 14.966 9.90916C15.158 9.99316 15.323 10.1342 15.461 10.3322C15.605 10.5242 15.716 10.7762 15.794 11.0882C15.878 11.3942 15.92 11.7722 15.92 12.2222C15.92 12.6722 15.878 13.0532 15.794 13.3652C15.716 13.6712 15.605 13.9202 15.461 14.1122C15.323 14.3042 15.158 14.4452 14.966 14.5352ZM10.541 15.5347V14.0767H11.369V13.2037H10.541V9.0817H9.344L6.5 13.2937V14.0767H9.506V15.5347H10.541ZM9.506 10.2787V13.2037H7.535L9.506 10.2787Z"
            fill={props.fill}
        />
    </svg>
);

Luggage40Icon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default Luggage40Icon;
