import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const MapIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M13 17C13 17.0327 13.0016 17.065 13.0046 17.0969L9.99575 18.0928C9.99856 18.0622 10 18.0313 10 18V6.32514L13 5.33765V17ZM8 6.24075V18C8 18.0233 8.00079 18.0463 8.00236 18.0692L5.00018 17.0068L5 5.00009L8 6.24075ZM14.9973 17.0747L18 18L17.9998 6L15 5.22288V17C15 17.0251 14.9991 17.05 14.9973 17.0747ZM13.1433 3.18945L9 4.47856L4.36334 2.60009C3.70767 2.34438 3 2.82632 3 3.53009L3.00018 17.7299C3.00018 18.1614 3.277 18.5443 3.6868 18.6795L8.37342 20.3223C8.82769 20.4722 9.32063 20.4547 9.76284 20.2723L14.0211 18.9223L18.6367 20.4067C19.2923 20.6624 20 20.1805 20 19.4767L19.9998 5.27696C19.9998 4.84542 19.723 4.46256 19.3132 4.32733L14.8801 3.12945C14.3122 2.94207 13.6961 2.96143 13.1433 3.18945Z"
            fill={props.fill}
        />
    </svg>
);

MapIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default MapIcon;
