import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const MessageIcon = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <path
            d="M7.12495 22.1813C7.65932 22.1813 8.05308 21.9187 8.69995 21.3469L11.9156 18.5157H17.5593C20.3812 18.5157 21.9656 16.8844 21.9656 14.1V6.81565C21.9656 4.03128 20.3812 2.40002 17.5593 2.40002H5.60621C2.79369 2.40002 1.19995 4.03128 1.19995 6.81565V14.1C1.19995 16.8937 2.84058 18.5157 5.54058 18.5157H5.92495V20.8126C5.92495 21.6469 6.36558 22.1813 7.12495 22.1813ZM7.5937 20.0813V17.4094C7.5937 16.8563 7.34995 16.6407 6.82495 16.6407H5.67182C3.90932 16.6407 3.06558 15.75 3.06558 14.0437V6.8719C3.06558 5.16565 3.90932 4.27502 5.67182 4.27502H17.503C19.2562 4.27502 20.1 5.16565 20.1 6.8719V14.0437C20.1 15.75 19.2562 16.6407 17.503 16.6407H11.8125C11.2406 16.6407 10.9593 16.7344 10.5656 17.1469L7.5937 20.0813Z"
            fill={props.fill}
        />
    </svg>
);

MessageIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default MessageIcon;
