import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const NoTicketReturnIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#e98210e1__clip0_19073_4587)">
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M12 17C13.3261 17 14.5979 16.4732 15.5355 15.5355C16.4732 14.5979 17 13.3261 17 12C17 10.6739 16.4732 9.40215 15.5355 8.46447C14.5979 7.52679 13.3261 7 12 7C10.7739 7.001 9.59193 7.45795 8.684 8.282L11 10.402L3.998 12.127L5.099 5L7.196 6.92C8.49104 5.68634 10.2114 4.99877 12 5C13.8565 5 15.637 5.7375 16.9497 7.05025C18.2625 8.36301 19 10.1435 19 12C19 13.8565 18.2625 15.637 16.9497 16.9497C15.637 18.2625 13.8565 19 12 19C10.7005 18.9994 9.42682 18.6368 8.32182 17.9529C7.21682 17.269 6.32419 16.2908 5.744 15.128L7.545 14.227C8.367 15.865 10.043 17 12 17Z"
                fill={props.fill}
            />
            <path
                d="M4.90781 22.172C4.90518 21.864 5.02175 21.5463 5.23244 21.2872L20.2684 3.33797C20.4865 3.08515 20.7787 2.91498 21.082 2.86411C21.3852 2.81325 21.6753 2.88576 21.8898 3.06602C22.1042 3.24629 22.2258 3.51989 22.2285 3.82789C22.2311 4.1359 22.1145 4.45367 21.9038 4.71276L6.86789 22.662C6.64975 22.9148 6.35759 23.085 6.05433 23.1358C5.75107 23.1867 5.46097 23.1142 5.24653 22.9339C5.03208 22.7536 4.91045 22.48 4.90781 22.172Z"
                fill="white"
            />
            <path
                d="M4.49599 19.9307C4.49369 19.6611 4.59569 19.3831 4.78005 19.1564L17.9365 3.45084C18.1274 3.22962 18.383 3.08073 18.6484 3.03622C18.9137 2.99171 19.1676 3.05516 19.3552 3.21289C19.5428 3.37062 19.6493 3.61002 19.6516 3.87953C19.6539 4.14903 19.5519 4.42708 19.3675 4.65378L6.21106 20.3593C6.02019 20.5806 5.76455 20.7295 5.4992 20.774C5.23384 20.8185 4.98001 20.755 4.79237 20.5973C4.60473 20.4396 4.4983 20.2002 4.49599 19.9307Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="e98210e1__clip0_19073_4587">
                <rect
                    width={16}
                    height={18}
                    fill="white"
                    transform="translate(4 3)"
                />
            </clipPath>
        </defs>
    </svg>
);

NoTicketReturnIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default NoTicketReturnIcon;
