import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const NotIncludedIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M5.79289 5.79289C5.40237 6.18342 5.40237 6.81658 5.79289 7.20711L10.5858 12L5.79289 16.7929C5.40237 17.1834 5.40237 17.8166 5.79289 18.2071C6.18342 18.5976 6.81658 18.5976 7.20711 18.2071L12 13.4142L16.7929 18.2071C17.1834 18.5976 17.8166 18.5976 18.2071 18.2071C18.5976 17.8166 18.5976 17.1834 18.2071 16.7929L13.4142 12L18.2071 7.20711C18.5976 6.81658 18.5976 6.18342 18.2071 5.79289C17.8166 5.40237 17.1834 5.40237 16.7929 5.79289L12 10.5858L7.20711 5.79289C6.81658 5.40237 6.18342 5.40237 5.79289 5.79289Z"
            fill={props.fill}
        />
    </svg>
);

NotIncludedIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default NotIncludedIcon;
