import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const QuarantineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M11.6461 2.35348C11.8413 2.15822 12.1579 2.15821 12.3532 2.35347L22.1464 12.1464C22.4614 12.4613 22.2383 12.9999 21.7928 12.9999H13.7323C13.9025 12.7058 13.9998 12.3642 13.9998 11.9999C13.9998 10.8954 13.1044 9.99992 11.9998 9.99992C10.8953 9.99992 9.99985 10.8954 9.99985 11.9999C9.99985 12.3642 10.0972 12.7058 10.2674 12.9999H2.20706C1.76161 12.9999 1.53852 12.4614 1.8535 12.1464L11.6461 2.35348ZM10.2675 13H4V21.5C4 21.7761 4.22386 22 4.5 22H19.5C19.7761 22 20 21.7761 20 21.5V13H13.7322C13.3864 13.5978 12.7401 13.9999 11.9998 13.9999C11.2596 13.9999 10.6133 13.5978 10.2675 13ZM8.00006 16.9999C8.00006 15.8954 8.89549 14.9999 10.0001 14.9999H14.0001C15.1046 14.9999 16.0001 15.8954 16.0001 16.9999V19.4999C16.0001 19.7761 15.7762 19.9999 15.5001 19.9999H8.50006C8.22392 19.9999 8.00006 19.7761 8.00006 19.4999V16.9999Z"
            fill={props.fill}
        />
    </svg>
);

QuarantineIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default QuarantineIcon;
