import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SleepingIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M14.4908 8.35673C12.3354 8.84275 9.98984 9.09632 7.62313 9.09632C5.25642 9.09632 2.88971 8.84275 0.755444 8.35673C0.417341 8.29333 0.100372 8.50464 0.0158463 8.84275C-0.00528526 8.92727 -0.00528526 9.0118 0.0158463 9.09632C0.184898 10.0261 0.353947 10.9981 0.480736 12.0336C0.607523 13.0479 0.670919 14.1044 0.670919 15.2033C0.670919 16.281 0.607523 17.3375 0.480736 18.3518C0.353947 19.4084 0.184898 20.3805 0.0158463 21.3102C-0.0475464 21.6483 0.163767 21.9653 0.501867 22.0287C0.586393 22.0498 0.670918 22.0498 0.755444 22.0287C2.88971 21.5427 5.25642 21.2891 7.62313 21.2891C9.98984 21.2891 12.3354 21.5427 14.4908 22.0287C14.8289 22.0921 15.1459 21.8808 15.2304 21.5638C15.2515 21.4582 15.2515 21.3736 15.2304 21.2891C15.0614 20.3593 14.8923 19.3873 14.7655 18.3518C14.6387 17.3375 14.5753 16.281 14.5753 15.2033C14.5753 14.1044 14.6387 13.0479 14.7655 12.0336C14.8923 10.9981 15.0614 10.005 15.2304 9.07519C15.2938 8.73709 15.0825 8.42012 14.7444 8.35673C14.6599 8.33559 14.5753 8.33559 14.4908 8.35673ZM23.3449 3.43312C21.1472 3.53878 18.7805 3.36973 16.456 2.96823C14.1316 2.54561 11.8494 1.91167 9.82079 1.04528C9.50382 0.918494 9.14459 1.06641 9.0178 1.38338C8.97554 1.46791 8.95441 1.55243 8.97554 1.63696C8.97554 2.58787 8.97554 3.58104 8.91214 4.61648C8.84875 5.63078 8.76422 6.68735 8.57404 7.76505L8.55291 7.82844C10.4547 7.78618 12.3777 7.57487 14.2161 7.15224C14.4486 7.08885 14.7233 7.08884 14.9557 7.13111C15.97 7.32129 16.6462 8.29333 16.456 9.30764C16.287 10.2585 16.1179 11.2095 16.0123 12.1815C15.8855 13.1747 15.801 14.189 15.801 15.2033V15.2667C17.6183 15.6682 19.3722 16.2176 20.9781 16.8938C21.2951 17.0206 21.6543 16.8727 21.7811 16.5557C21.8234 16.4712 21.8445 16.3866 21.8445 16.3021C21.8234 15.3512 21.8445 14.358 21.8868 13.3226C21.9502 12.3083 22.0558 11.2517 22.246 10.174C22.4362 9.09632 22.6898 8.08202 22.9856 7.08884C23.3026 6.09567 23.6407 5.16589 23.9577 4.27838C24.0844 3.94028 23.9154 3.60217 23.5984 3.47539C23.5139 3.45425 23.4294 3.43312 23.3449 3.43312Z"
            fill={props.fill}
        />
    </svg>
);

SleepingIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default SleepingIcon;
