import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SoundproofIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 27"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M17.5899 9.63115C17.0852 9.22736 16.3281 9.27784 15.8991 9.80781C15.47 10.3378 15.571 11.0949 16.101 11.5239C16.7823 12.0791 17.2114 12.9371 17.2114 13.8709C17.2114 14.8804 16.7319 15.7636 15.9748 16.3188C15.4953 16.6722 15.4196 17.3788 15.7981 17.833L15.8991 17.934C16.3028 18.4135 17.0599 18.5144 17.5394 18.1359C18.8013 17.1517 19.6088 15.587 19.6088 13.8709C19.6088 12.1548 18.8265 10.6406 17.5899 9.63115Z"
            fill={props.fill}
        />
        <path
            d="M20.3407 6.2495C19.836 5.84571 19.1041 5.94666 18.6751 6.42615C18.2713 6.93088 18.3218 7.68798 18.8265 8.09177C20.4921 9.47978 21.5773 11.5492 21.5773 13.8709C21.5773 16.1927 20.4921 18.2874 18.8265 19.6501C18.3218 20.0539 18.2713 20.811 18.6751 21.3157C19.0789 21.8205 19.836 21.9214 20.3407 21.5176C22.5615 19.7258 24 16.975 24 13.8962C23.9748 10.7921 22.5615 8.04129 20.3407 6.2495Z"
            fill={props.fill}
        />
        <path
            d="M10.5489 4.40723L4.4164 9.12647H1.41325C0.630915 9.12647 0 9.75739 0 10.5397V17.2022C0 17.9845 0.630915 18.6154 1.41325 18.6154H4.4164L10.5741 23.3347C11.6593 24.1675 13.1987 23.4104 13.1987 22.0224V5.69429C13.1987 4.35675 11.6341 3.57442 10.5489 4.40723Z"
            fill={props.fill}
        />
        <path
            d="M20.1696 23.5873C19.7704 23.5344 19.4058 23.3404 19.1545 23.0472L1.91992 2.21598C1.67969 1.91514 1.57569 1.54282 1.63032 1.1792C1.68496 0.815592 1.89386 0.48978 2.21203 0.271944C2.5302 0.0541079 2.93219 -0.038324 3.33141 0.0145564C3.73063 0.0674368 4.09514 0.261398 4.34644 0.554666L21.5811 21.3859C21.8213 21.6867 21.9253 22.059 21.8707 22.4226C21.816 22.7862 21.6071 23.1121 21.289 23.3299C20.9708 23.5477 20.5688 23.6402 20.1696 23.5873Z"
            fill="white"
        />
        <path
            d="M19.0315 25.53C18.6323 25.4771 18.2678 25.2831 18.0165 24.9899L1.78186 5.15866C1.54162 4.85783 1.43762 4.4855 1.49226 4.12189C1.5469 3.75828 1.7558 3.43247 2.07397 3.21463C2.39214 2.9968 2.79413 2.90436 3.19335 2.95724C3.59257 3.01012 3.95708 3.20409 4.20838 3.49735L20.443 23.3285C20.6832 23.6294 20.7872 24.0017 20.7326 24.3653C20.678 24.7289 20.4691 25.0547 20.1509 25.2726C19.8327 25.4904 19.4307 25.5828 19.0315 25.53Z"
            fill={props.fill}
        />
    </svg>
);

SoundproofIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default SoundproofIcon;
