import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const StarOutlineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M12 17.328L6.59703 20.614C6.47069 20.6909 6.32441 20.7288 6.17661 20.7228C6.02881 20.7168 5.88607 20.6672 5.76636 20.5803C5.64665 20.4935 5.55531 20.3731 5.50382 20.2344C5.45234 20.0957 5.44302 19.9449 5.47703 19.801L6.93303 13.646L2.13703 9.52297C2.02492 9.4265 1.94384 9.29904 1.90398 9.15661C1.86411 9.01418 1.86725 8.86315 1.91299 8.7225C1.95874 8.58186 2.04504 8.45787 2.16106 8.36614C2.27708 8.27441 2.41762 8.21903 2.56503 8.20697L8.86803 7.68997L11.308 1.85497C11.3651 1.71847 11.4612 1.6019 11.5843 1.51991C11.7075 1.43791 11.8521 1.39417 12 1.39417C12.148 1.39417 12.2926 1.43791 12.4157 1.51991C12.5389 1.6019 12.635 1.71847 12.692 1.85497L15.132 7.68997L21.435 8.20697C21.5824 8.21921 21.7228 8.27471 21.8386 8.36651C21.9545 8.45831 22.0407 8.5823 22.0863 8.72292C22.1319 8.86353 22.135 9.0145 22.0951 9.15684C22.0552 9.29918 21.9741 9.42656 21.862 9.52297L17.067 13.646L18.523 19.801C18.557 19.9449 18.5477 20.0957 18.4962 20.2344C18.4448 20.3731 18.3534 20.4935 18.2337 20.5803C18.114 20.6672 17.9713 20.7168 17.8235 20.7228C17.6756 20.7288 17.5294 20.6909 17.403 20.614L12 17.328ZM12.52 15.303L15.889 17.353L14.981 13.515C14.9387 13.3365 14.9463 13.1499 15.0029 12.9755C15.0595 12.801 15.163 12.6455 15.302 12.526L18.292 9.95597L14.362 9.63297C14.1796 9.61791 14.0048 9.55307 13.8567 9.44551C13.7086 9.33794 13.5928 9.19179 13.522 9.02297L12 5.38297L10.479 9.02097C10.4083 9.19012 10.2925 9.33657 10.1442 9.44433C9.99584 9.55209 9.82075 9.617 9.63803 9.63197L5.70803 9.95497L8.69803 12.525C8.83708 12.6445 8.94057 12.8 8.99718 12.9745C9.05379 13.1489 9.06135 13.3355 9.01903 13.514L8.11103 17.351L11.481 15.302C11.6376 15.2068 11.8173 15.1564 12.0005 15.1564C12.1838 15.1564 12.3635 15.2068 12.52 15.302V15.303Z"
            fill={props.fill}
        />
    </svg>
);

StarOutlineIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default StarOutlineIcon;
