import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const StopIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22ZM18 10.5H6V13.5H18V10.5Z"
            fill={props.fill}
        />
    </svg>
);

StopIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default StopIcon;
