import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ToursIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M12.564 11.6338L14.586 17.1892C13.8921 17.1831 13.2005 17.2256 12.5027 17.3128L10.6837 12.3154C10.9803 12.2025 11.2824 12.0901 11.5898 11.9782C11.9187 11.8585 12.2435 11.7437 12.564 11.6338Z"
            fill={props.fill}
        />
        <path
            d="M8.64203 0.658252L8.84054 1.20364C8.49071 1.24869 8.15306 1.328 7.82758 1.44159C7.52304 1.54786 7.22965 1.68397 6.9474 1.84991L6.76264 1.34229C6.57375 0.823314 6.84134 0.249472 7.36032 0.0605795C7.8793 -0.128313 8.45314 0.139274 8.64203 0.658252Z"
            fill={props.fill}
        />
        <path
            d="M21.7417 7.93582C20.5511 6.04411 16.6596 1.03761 9.41916 2.27201C10.4172 3.23899 11.6902 5.24613 13.2381 8.29342C12.4176 8.5507 11.57 8.83865 10.695 9.15713C9.81606 9.47702 8.97801 9.80279 8.18069 10.1347C7.40297 6.78511 7.08879 4.42087 7.23817 3.04198C0.783661 6.74158 1.0226 13.1401 1.32832 15.3666C1.37885 15.7346 1.80795 15.8843 2.10827 15.6656C3.35023 14.7614 6.40558 12.7647 11.2985 10.9838C16.1886 9.20393 19.8051 8.77133 21.3361 8.66648C21.7069 8.64109 21.9397 8.25039 21.7417 7.93582Z"
            fill={props.fill}
        />
        <path
            d="M4.99896 20.6649C4.66876 20.776 4.33594 20.888 4 21C4 21.5523 4.44771 22 5 22H20C21.1046 22 22 21.1046 22 20C15.3919 17.168 10.5662 18.7917 4.99896 20.6649Z"
            fill={props.fill}
        />
    </svg>
);

ToursIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default ToursIcon;
