import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TrainIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M5.035 19.93C3 19.5 2 18.6103 2 15.7525V5.16605C2 3.87293 2.82859 2.72532 4.05603 2.31844L7.37282 1.53C7.88398 0.605563 8.86889 0 10 0H14C15.123 0 16.1019 0.617028 16.6161 1.53055L19.9841 2.32429C21.1918 2.72909 21.9818 3.89643 22 5.17V15.75C21.9644 18.5976 21 19.5 18.965 19.93L17.8701 20.0872L20.76 23.68C20.8262 23.7684 20.8083 23.8937 20.72 23.96C20.6853 23.986 20.6432 24 20.6 24H17.6789C17.6031 24 17.5339 23.9572 17.5 23.8894L16.5 22H7.5L6.5 23.8894C6.46612 23.9572 6.39687 24 6.32111 24H3.39995C3.28949 24 3.19995 23.9105 3.19995 23.8C3.19995 23.7567 3.21399 23.7146 3.23995 23.68L6.12982 20.0872L5.035 19.93ZM5.41001 4.59658C4.29047 4.82013 3.58804 5.87378 3.80466 6.95689L4.24357 10.269C4.5 11.5 5.04719 12.0015 6 12.1161C8.12867 12.372 10.3574 12.5 12 12.5C13.6426 12.5 15.8713 12.372 18 12.1161C18.9528 12.0015 19.5933 11.5 19.7565 10.269C19.8049 9.90367 19.848 9.53622 19.8913 9.16832C19.9796 8.41602 20.0682 7.66189 20.2023 6.92048C20.3988 5.83352 19.6769 4.79307 18.59 4.59656C16.39 4.19886 13.8022 4 12 4C10.1978 4 7.60996 4.19886 5.41001 4.59658ZM10.118 1C10.0108 1 9.90496 1.02498 9.80902 1.07295C9.46769 1.24361 9.32933 1.65867 9.5 2L9.8618 2.72361C9.9465 2.893 10.1196 3 10.309 3H13.691C13.8804 3 14.0535 2.893 14.1382 2.72361L14.5 2C14.548 1.90405 14.5729 1.79825 14.5729 1.69098C14.5729 1.30936 14.2636 1 13.882 1H10.118ZM5.5 18C6.32843 18 7 17.3284 7 16.5C7 15.6716 6.32843 15 5.5 15C4.67157 15 4 15.6716 4 16.5C4 17.3284 4.67157 18 5.5 18ZM20 16.5C20 17.3284 19.3284 18 18.5 18C17.6716 18 17 17.3284 17 16.5C17 15.6716 17.6716 15 18.5 15C19.3284 15 20 15.6716 20 16.5ZM14.4 18L15.47 20H8.53003L9.60003 18H14.4Z"
            fill={props.fill}
        />
    </svg>
);

TrainIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default TrainIcon;
