import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ViewOnSeaIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M2 7.10002H3.66667C5.26463 7.10002 6.66709 6.53629 7.83333 5.44378C8.99958 6.53629 10.402 7.10002 12 7.10002C13.598 7.10002 15.0004 6.53629 16.1667 5.44378C17.3329 6.53629 18.7354 7.10002 20.3333 7.10002H22V4.90002H20.3333C19.0215 4.90002 17.9524 4.3355 17.0435 3.13577L16.1667 1.97839L15.2899 3.13577C14.381 4.3355 13.3118 4.90002 12 4.90002C10.6882 4.90002 9.61902 4.3355 8.71013 3.13577L7.83333 1.97839L6.95653 3.13577C6.04765 4.3355 4.97849 4.90002 3.66667 4.90002H2V7.10002Z"
            fill={props.fill}
        />
        <path
            d="M3.66667 14.1H2V11.9H3.66667C4.97849 11.9 6.04765 11.3355 6.95653 10.1358L7.83333 8.97839L8.71013 10.1358C9.61902 11.3355 10.6882 11.9 12 11.9C13.3118 11.9 14.381 11.3355 15.2899 10.1358L16.1667 8.97839L17.0435 10.1358C17.9524 11.3355 19.0215 11.9 20.3333 11.9H22V14.1H20.3333C18.7354 14.1 17.3329 13.5363 16.1667 12.4438C15.0004 13.5363 13.598 14.1 12 14.1C10.402 14.1 8.99958 13.5363 7.83333 12.4438C6.66709 13.5363 5.26463 14.1 3.66667 14.1Z"
            fill={props.fill}
        />
        <path
            d="M3.66667 21.1H2V18.9H3.66667C4.97849 18.9 6.04765 18.3355 6.95653 17.1358L7.83333 15.9784L8.71013 17.1358C9.61902 18.3355 10.6882 18.9 12 18.9C13.3118 18.9 14.381 18.3355 15.2899 17.1358L16.1667 15.9784L17.0435 17.1358C17.9524 18.3355 19.0215 18.9 20.3333 18.9H22V21.1H20.3333C18.7354 21.1 17.3329 20.5363 16.1667 19.4438C15.0004 20.5363 13.598 21.1 12 21.1C10.402 21.1 8.99958 20.5363 7.83333 19.4438C6.66709 20.5363 5.26463 21.1 3.66667 21.1Z"
            fill={props.fill}
        />
    </svg>
);

ViewOnSeaIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default ViewOnSeaIcon;
