import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ViewOnStadiumIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M19 5.71253V3.3001L18 3.20014V5.50678C17.6745 5.44689 17.3409 5.39206 17 5.34241V3.10019L16.2778 3.028C16.1098 3.01121 15.9705 2.89077 15.9295 2.727L15.6324 1.5384C15.5788 1.32408 15.7091 1.1069 15.9234 1.05332C15.9651 1.0429 16.0082 1.03926 16.0511 1.04256L21.4068 1.4544C21.6271 1.47134 21.7919 1.66363 21.775 1.88389C21.771 1.93549 21.7571 1.98582 21.734 2.03211L21.1849 3.13019C21.0736 3.35286 20.8363 3.48365 20.5886 3.45889L20 3.40005V5.96749C19.6785 5.87646 19.3448 5.79141 19 5.71253Z"
            fill={props.fill}
        />
        <path
            d="M4 5.96749V3.39979L3.40961 3.45883C3.16169 3.48362 2.92425 3.35261 2.81302 3.12966L2.26531 2.0318C2.16669 1.83412 2.24699 1.59393 2.44467 1.49531C2.49086 1.47226 2.54108 1.45837 2.59255 1.45441L7.94443 1.04259C8.1647 1.02564 8.357 1.19046 8.37395 1.41072C8.37724 1.45359 8.37361 1.49671 8.36318 1.53843L8.06603 2.72701C8.02509 2.89078 7.88575 3.01121 7.71778 3.02801L7 3.09979V5.34241C6.65908 5.39206 6.3255 5.44689 6 5.50678V3.19979L5 3.29979V5.71253C4.65522 5.79141 4.32155 5.87646 4 5.96749Z"
            fill={props.fill}
        />
        <path
            d="M12 15C3 15 0 12 0 12V18C0 18.8443 2.13828 21.114 8.22008 21.8006L8.8908 18.447C9.05907 17.6056 9.79782 17 10.6558 17H13.3442C14.2022 17 14.9409 17.6056 15.1092 18.447L15.7799 21.8006C21.8617 21.114 24 18.8443 24 18V12C24 12 21 15 12 15Z"
            fill={props.fill}
        />
        <path
            d="M9.87138 18.6431C9.94617 18.2692 10.2745 18 10.6558 18H13.3442C13.7255 18 14.0538 18.2692 14.1286 18.6431L14.8086 22.0431C14.8953 22.4764 14.6143 22.8978 14.181 22.9845C14.1294 22.9948 14.0768 23 14.0242 23H9.97584C9.53402 23 9.17584 22.6418 9.17584 22.2C9.17584 22.1473 9.18105 22.0948 9.19138 22.0431L9.87138 18.6431Z"
            fill={props.fill}
        />
        <path
            d="M0 9.99999C0 10.837 0.777 11.614 2.097 12.256C2.709 9.67599 6.513 7.99999 12 7.99999C17.487 7.99999 21.291 9.67599 21.903 12.256C23.223 11.614 24 10.837 24 9.99999C24 7.79099 18.627 5.99999 12 5.99999C5.373 5.99999 0 7.79099 0 9.99999Z"
            fill={props.fill}
        />
        <path
            d="M7.035 13.643C5.5 13.41 4.14 13.072 3.033 12.657C3.1661 11.8291 3.77934 11.0833 4.79683 10.4844L7.46727 12.7734C7.17695 13.0505 7.02513 13.349 7.035 13.643Z"
            fill={props.fill}
        />
        <path
            d="M8.33595 12.2009C8.77387 11.9917 9.3112 11.8159 9.93075 11.6927L9.03578 9.18681C7.76858 9.35714 6.67195 9.63807 5.77439 10.0052L8.33595 12.2009Z"
            fill={props.fill}
        />
        <path
            d="M10.9408 11.5477C11.2775 11.5166 11.6312 11.5 12 11.5C12.3688 11.5 12.7225 11.5166 13.0592 11.5477L13.9416 9.07681C13.3271 9.02636 12.679 8.99999 12 8.99999C11.321 8.99999 10.6729 9.02636 10.0584 9.07681L10.9408 11.5477Z"
            fill={props.fill}
        />
        <path
            d="M14.9642 9.18681L14.0693 11.6927C14.6888 11.8159 15.2261 11.9917 15.664 12.2009L18.2256 10.0052C17.3281 9.63807 16.2314 9.35714 14.9642 9.18681Z"
            fill={props.fill}
        />
        <path
            d="M16.5327 12.7734L19.2032 10.4844C20.2207 11.0833 20.8339 11.8291 20.967 12.657C19.86 13.072 18.5 13.41 16.965 13.643C16.9749 13.349 16.823 13.0505 16.5327 12.7734Z"
            fill={props.fill}
        />
    </svg>
);

ViewOnStadiumIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default ViewOnStadiumIcon;
