import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const WarningFilledIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M12 22C17.523 22 22 17.523 22 12C22 6.477 17.523 2 12 2C6.477 2 2 6.477 2 12C2 17.523 6.477 22 12 22ZM10.5 16.991C10.5 16.124 11.159 15.5 11.991 15.5C12.841 15.5 13.5 16.124 13.5 16.991C13.5 17.858 12.841 18.5 11.991 18.5C11.159 18.5 10.5 17.858 10.5 16.991ZM11.172 6C11.1045 6.00007 11.0378 6.01379 10.9757 6.04035C10.9137 6.0669 10.8577 6.10573 10.8111 6.1545C10.7645 6.20327 10.7282 6.26097 10.7045 6.32413C10.6807 6.38729 10.67 6.4546 10.673 6.522L10.979 13.522C10.9847 13.6508 11.0398 13.7724 11.133 13.8614C11.2262 13.9505 11.3501 14.0001 11.479 14H12.522C12.6509 14.0001 12.7748 13.9505 12.868 13.8614C12.9612 13.7724 13.0163 13.6508 13.022 13.522L13.327 6.522C13.33 6.45451 13.3192 6.38712 13.2954 6.3239C13.2717 6.26067 13.2353 6.20292 13.1886 6.15414C13.1418 6.10535 13.0857 6.06654 13.0236 6.04005C12.9614 6.01356 12.8946 5.99993 12.827 6H11.172Z"
            fill={props.fill}
        />
    </svg>
);

WarningFilledIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default WarningFilledIcon;
