import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const WatchIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M12 22C17.523 22 22 17.523 22 12C22 6.477 17.523 2 12 2C6.477 2 2 6.477 2 12C2 17.523 6.477 22 12 22ZM12 20C14.1217 20 16.1566 19.1571 17.6569 17.6569C19.1571 16.1566 20 14.1217 20 12C20 9.87827 19.1571 7.84344 17.6569 6.34315C16.1566 4.84285 14.1217 4 12 4C9.87827 4 7.84344 4.84285 6.34315 6.34315C4.84285 7.84344 4 9.87827 4 12C4 14.1217 4.84285 16.1566 6.34315 17.6569C7.84344 19.1571 9.87827 20 12 20ZM16.42 14.894C16.4717 14.7733 16.4991 14.6435 16.5006 14.5122C16.5022 14.3808 16.4778 14.2505 16.429 14.1285C16.3801 14.0066 16.3078 13.8955 16.216 13.8015C16.1242 13.7076 16.0148 13.6327 15.894 13.581L13 12.34V7C13 6.73478 12.8946 6.48043 12.7071 6.29289C12.5196 6.10536 12.2652 6 12 6C11.7348 6 11.4804 6.10536 11.2929 6.29289C11.1054 6.48043 11 6.73478 11 7V12.67C11 13.27 11.358 13.813 11.91 14.049L15.106 15.419C15.3497 15.5235 15.625 15.5268 15.8712 15.4284C16.1174 15.3299 16.3145 15.1377 16.419 14.894H16.42Z"
            fill={props.fill}
        />
    </svg>
);

WatchIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default WatchIcon;
