import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const WithoutLuggageIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#1a54596b__clip0_14213_167)">
            <mask
                id="1a54596b__mask0_14213_167"
                style={{
                    maskType: 'alpha',
                }}
                maskUnits="userSpaceOnUse"
                x={6}
                y={22}
                width={12}
                height={2}
            >
                <rect x={6} y={22} width={12} height={2} fill="#C4C4C4" />
            </mask>
            <g mask="url(#1a54596b__mask0_14213_167)">
                <circle cx={8.5} cy={22.5} r={1.5} fill={props.fill} />
                <circle cx={15.5} cy={22.5} r={1.5} fill={props.fill} />
            </g>
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M7.61935 6H16.3806C17.8032 6 19 7.15556 19 8.57778V18.2779C19 19.2203 18.2144 20.3101 17.3461 20.8271C17.1262 20.958 16.8685 21.0001 16.6125 21.0001H16.5H15.5L14 21.0001H13.5H11H10H8.5H7.39583C7.13448 21.0001 6.87124 20.956 6.64812 20.8199C5.79582 20.3 5 19.2159 5 18.2779V8.57778C5 7.15556 6.19677 6 7.61935 6ZM9.13226 2C8.77097 2 8.47742 2.28889 8.47742 2.64444V5H9.5V4.96117V4.00006V3.00006H14.5V5H15.5452V2.64444C15.5452 2.28889 15.2516 2 14.8903 2H9.13226ZM9.64884 16.3761C9.40033 16.6246 8.9974 16.6246 8.74889 16.3761C8.50037 16.1276 8.50037 15.7247 8.74889 15.4762L11.1625 13.0625L8.74889 10.6488C8.50037 10.4003 8.50037 9.9974 8.74889 9.74889C8.9974 9.50037 9.40033 9.50037 9.64884 9.74889L12.0625 12.1625L14.4762 9.74889C14.7247 9.50037 15.1276 9.50037 15.3761 9.74889C15.6246 9.9974 15.6246 10.4003 15.3761 10.6488L12.9625 13.0625L15.3761 15.4762C15.6246 15.7247 15.6246 16.1276 15.3761 16.3761C15.1276 16.6246 14.7247 16.6246 14.4762 16.3761L12.0625 13.9625L9.64884 16.3761Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="1a54596b__clip0_14213_167">
                <rect width={24} height={24} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

WithoutLuggageIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default WithoutLuggageIcon;
