import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const WheelIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 32 32"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#0533dc86__clip0_25594_5139)">
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M18.7013 28.719C23.9213 27.6158 27.9856 23.3805 28.8358 18.0717C28.6704 18.0801 28.4991 18.0885 28.3226 18.0972C25.0984 18.2553 20.1692 18.4969 18.5 20.5C17.1758 22.089 18.0624 26.0195 18.7013 28.719ZM28.8395 13.9511C27.9973 8.63167 23.9287 4.38578 18.7013 3.28104C18.0624 5.98053 17.1758 9.911 18.5 11.5C20.2698 13.6237 25.3022 13.816 28.7469 13.9476C28.7779 13.9488 28.8088 13.95 28.8395 13.9511ZM15.8984 3.00039C8.76544 3.05502 3 8.85421 3 16C3 23.1458 8.76547 28.945 15.8984 28.9996C14.166 27.213 11 22.9915 11 15.9999C11 9.00827 14.1659 4.78693 15.8984 3.00039ZM32 16C32 24.8366 24.8366 32 16 32C7.16344 32 -3.13124e-07 24.8366 -6.99382e-07 16C-1.08564e-06 7.16344 7.16344 -3.13124e-07 16 -6.99382e-07C24.8366 8.21708e-07 32 7.16344 32 16ZM16 14C17.1046 14 18 14.8954 18 16C18 17.1046 17.1046 18 16 18C14.8954 18 14 17.1046 14 16C14 14.8954 14.8954 14 16 14Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="0533dc86__clip0_25594_5139">
                <rect width={32} height={32} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

WheelIcon.defaultProps = {
    width: 32,
    height: 32,
    fill: 'currentColor',
};

export default WheelIcon;
