import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DiscoveryIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 36 36"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6 18C6 24.6274 11.3726 30 18 30C24.6274 30 30 24.6274 30 18C30 11.3726 24.6274 6 18 6C11.3726 6 6 11.3726 6 18ZM18 8.57143C16.1026 8.57143 14.3362 9.13186 12.8571 10.0962V11.4857C12.8571 12.2431 13.4712 12.8571 14.2286 12.8571H20.0571C20.8146 12.8571 21.4286 13.4712 21.4286 14.2286V15.7176C21.4286 16.0814 21.5731 16.4302 21.8303 16.6874L22.4439 17.301C22.8613 17.7185 23.499 17.8219 24.027 17.5579L25.8133 16.6648C26.2779 16.4325 26.5714 15.9576 26.5714 15.4381V14.0666C25.0807 10.8234 21.8033 8.57143 18 8.57143ZM15.9235 27.1992C16.5916 27.3493 17.2866 27.4286 18 27.4286C18.2218 27.4286 18.4419 27.4209 18.6599 27.4058L22.4292 22.3801C22.8387 21.8341 22.7844 21.0701 22.3018 20.5875L18.4017 16.6874C18.1445 16.4302 17.7957 16.2857 17.4319 16.2857H12.1313C11.541 16.2857 11.0169 16.6634 10.8303 17.2235L9.86226 20.1275C9.62274 20.8461 10.0111 21.6227 10.7296 21.8623L13.9209 22.926C14.3304 23.0625 14.6518 23.3839 14.7883 23.7934L15.9235 27.1992Z"
            fill={props.fill}
        />
    </svg>
);

DiscoveryIcon.defaultProps = {
    width: 36,
    height: 36,
    fill: 'currentColor',
};

export default DiscoveryIcon;
