import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const LocationIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 36 36"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#21f69bfa__clip0_20742_4793)">
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M11.4604 27.5891C7.86407 24.6361 3.78955 21.2904 3.78955 14.4C3.78955 6.444 10.1518 0 18.0001 0C25.8483 0 32.2106 6.4471 32.2106 14.4C32.2106 21.3033 28.1383 24.653 24.5418 27.6113C21.8865 29.7954 19.4905 31.7662 19.1843 34.7963L19.1711 34.9272C19.1095 35.5366 18.603 36 17.9985 36C17.392 36 16.885 35.5327 16.8276 34.9209L16.8159 34.7963C16.5313 31.7529 14.1273 29.779 11.4604 27.5891ZM21.7894 14.2104C21.7894 16.3032 20.0928 17.9998 17.9999 17.9998C15.9071 17.9998 14.2104 16.3032 14.2104 14.2104C14.2104 12.1175 15.9071 10.4209 17.9999 10.4209C20.0928 10.4209 21.7894 12.1175 21.7894 14.2104Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="21f69bfa__clip0_20742_4793">
                <rect width={36} height={36} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

LocationIcon.defaultProps = {
    width: 36,
    height: 36,
    fill: 'currentColor',
};

export default LocationIcon;
