import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const PlaneIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 36 36"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M13.0272 21.3762C13.9472 20.232 15.1325 18.8199 16.5369 17.2788L7.34891 11.1535C6.98894 10.9135 6.89166 10.4272 7.13165 10.0672L8.30294 8.31027C8.50842 8.00205 8.90171 7.87989 9.24566 8.01747L21.0176 12.7263C27.1286 7.002 29.2312 6.62075 29.8052 7.1948C30.3801 7.76972 29.9968 9.87777 24.2476 16.0103C21.9973 18.4106 18.2299 21.6491 15.6238 23.8178V28.8766C15.6238 29.1 15.4976 29.3043 15.2977 29.4042L14.231 29.9376C13.9396 30.0833 13.5853 29.9652 13.4396 29.6738C13.4323 29.6591 13.4256 29.6442 13.4195 29.629L11.6913 25.3087L7.37096 23.5805C7.06848 23.4595 6.92136 23.1162 7.04235 22.8138C7.04842 22.7986 7.05512 22.7837 7.06243 22.769L7.59582 21.7023C7.69574 21.5024 7.89999 21.3762 8.12342 21.3762H13.0272ZM24.9789 17.7441L28.9829 27.7541C29.1204 28.098 28.9983 28.4913 28.6901 28.6968L26.9331 29.8681C26.5732 30.1081 26.0868 30.0108 25.8468 29.6508L20.5664 21.7302C21.7945 20.7862 23.0423 19.707 24.248 18.5013C24.502 18.2473 24.7455 17.9948 24.9789 17.7441Z"
            fill={props.fill}
        />
    </svg>
);

PlaneIcon.defaultProps = {
    width: 36,
    height: 36,
    fill: 'currentColor',
};

export default PlaneIcon;
