import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const QuestionnaireIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 36 36"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M9 8C9 7.5 9.47059 7 10 7H21V13H27V29C27 29.5 26.5294 30 26 30H10C9.47059 30 9 29.5 9 29V8Z"
            fill={props.fill}
        />
        <path
            d="M21 7H19V14C19 14.5 19.4706 15 20 15H27V13H21V7Z"
            fill="white"
        />
        <path d="M21 13H27L21 7V13Z" fill={props.fill} />
        <path
            d="M11.1176 20C11.1176 19.4477 11.6471 19 12.1765 19H23.8235C24.3529 19 24.8824 19.4477 24.8824 20C24.8824 20.5523 24.3529 21 23.8235 21H12.1765C11.6471 21 11.1176 20.5523 11.1176 20Z"
            fill="white"
        />
        <path
            d="M11.1176 25C11.1176 24.4477 11.6471 24 12.1765 24H23.8235C24.3529 24 24.8824 24.4477 24.8824 25C24.8824 25.5523 24.3529 26 23.8235 26H12.1765C11.6471 26 11.1176 25.5523 11.1176 25Z"
            fill="white"
        />
    </svg>
);

QuestionnaireIcon.defaultProps = {
    width: 36,
    height: 36,
    fill: 'currentColor',
};

export default QuestionnaireIcon;
