import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ShildIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 36 36"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M18.6833 6.05253C18.5423 5.98249 18.3774 5.98249 18.2364 6.05253C15.4283 7.44799 11.9945 8.97608 8.52826 8.9582C8.22672 8.95664 7.97936 9.20754 8.00136 9.50827L8.70987 19.1928C8.70987 21.4487 9.84149 23.5627 11.7416 24.8563L18.1581 29.7127C18.3366 29.8478 18.5831 29.8478 18.7616 29.7127L25.1782 24.8563C27.0782 23.5627 28.2098 21.4487 28.2098 19.1928L28.9184 9.50827C28.9404 9.20754 28.693 8.95664 28.3915 8.9582C24.9253 8.97608 21.4915 7.44799 18.6833 6.05253ZM23.9131 13.7568C24.5527 14.2427 24.6444 15.1153 24.1179 15.7057L18.562 21.9365C18.2895 22.2421 17.8883 22.4254 17.4598 22.4402C17.0313 22.4549 16.6164 22.2997 16.32 22.0137L12.876 18.6906C12.3033 18.1381 12.3243 17.2616 12.923 16.733C13.5216 16.2043 14.4711 16.2238 15.0437 16.7763L17.3196 18.9723L21.8017 13.9459C22.3282 13.3554 23.2735 13.2708 23.9131 13.7568Z"
            fill={props.fill}
        />
    </svg>
);

ShildIcon.defaultProps = {
    width: 36,
    height: 36,
    fill: 'currentColor',
};

export default ShildIcon;
