import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const StarIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 36 36"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M18 25.992L9.89484 30.9215C9.36399 31.2444 8.67192 31.0758 8.34906 30.545C8.19537 30.2922 8.14737 29.9892 8.21545 29.7014L10.3991 20.4696L3.20623 14.2846C2.73513 13.8795 2.68161 13.1692 3.08671 12.6981C3.27954 12.4738 3.55293 12.3345 3.84769 12.3104L13.3024 11.5344L16.962 2.78223C17.2017 2.20901 17.8606 1.93863 18.4339 2.17832C18.7068 2.29241 18.9237 2.50937 19.0378 2.78223L22.6975 11.5344L32.1522 12.3104C32.7714 12.3612 33.2322 12.9044 33.1813 13.5236C33.1572 13.8184 33.0178 14.0918 32.7936 14.2846L25.6008 20.4696L27.7843 29.7014C27.9274 30.306 27.5532 30.9122 26.9485 31.0551C26.6607 31.1232 26.3577 31.0752 26.1051 30.9215L18 25.992Z"
            fill={props.fill}
        />
    </svg>
);

StarIcon.defaultProps = {
    width: 36,
    height: 36,
    fill: 'currentColor',
};

export default StarIcon;
