import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const StarOutlineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 36 36"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M16.9607 24.2832C17.5992 23.8949 18.4008 23.8949 19.0393 24.2832L25.3564 28.1252L23.6545 20.93C23.4825 20.2028 23.7302 19.4404 24.2968 18.9532L29.903 14.1325L22.534 13.5277C21.7892 13.4666 21.1406 12.9954 20.8524 12.3059L17.9999 5.48436L15.1476 12.3059C14.8593 12.9954 14.2107 13.4666 13.466 13.5277L6.09689 14.1325L11.7031 18.9532C12.2697 19.4404 12.5174 20.2028 12.3454 20.93L10.6434 28.1253L16.9607 24.2832ZM8.85638 29.2122C8.85604 29.2124 8.8557 29.2126 8.85536 29.2128L8.85558 29.2127L8.85638 29.2122ZM19.0378 2.78223C18.9237 2.50937 18.7068 2.29241 18.4339 2.17832C17.8606 1.93863 17.2017 2.20901 16.962 2.78223L13.3024 11.5344L3.84769 12.3104C3.55293 12.3345 3.27954 12.4738 3.08671 12.6981C2.68161 13.1692 2.73513 13.8795 3.20623 14.2846L10.3991 20.4696L8.21545 29.7014C8.14737 29.9892 8.19537 30.2922 8.34906 30.545C8.67192 31.0758 9.36399 31.2444 9.89484 30.9215L18 25.992L26.1051 30.9215C26.3577 31.0752 26.6607 31.1232 26.9485 31.0551C27.5532 30.9122 27.9274 30.306 27.7843 29.7014L25.6008 20.4696L32.7936 14.2846C33.0178 14.0918 33.1572 13.8184 33.1813 13.5236C33.2322 12.9044 32.7714 12.3612 32.1522 12.3104L22.6975 11.5344L19.0378 2.78223ZM31.4886 12.769L31.4896 12.7681L31.4896 12.7681C31.4893 12.7684 31.489 12.7687 31.4886 12.769ZM27.1438 29.2123C27.1442 29.2126 27.1446 29.2128 27.145 29.2131L27.1444 29.2127L27.1438 29.2123ZM26.4884 29.1088L26.4881 29.1088L26.4884 29.1088Z"
            fill={props.fill}
        />
    </svg>
);

StarOutlineIcon.defaultProps = {
    width: 36,
    height: 36,
    fill: 'currentColor',
};

export default StarOutlineIcon;
