import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const LocationIcon = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 38 38"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable={false}
        {...props}
    >
        <path
            d="M4 15.2c0 12.667 13.044 13.985 13.75 21.53l.012.131c.06.646.596 1.139 1.236 1.139a1.25 1.25 0 001.238-1.132l.014-.139C21.011 29.2 34 27.867 34 15.2 34 6.805 27.284 0 19 0 10.716 0 4 6.802 4 15.2z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M19 19a4 4 0 100-8 4 4 0 000 8z"
            fill="#fff"
        />
    </svg>
);

LocationIcon.defaultProps = {
    width: 38,
    height: 38,
    fill: 'currentColor',
};

export default LocationIcon;
