import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const AdLowPriceM = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 109 69"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <path
            d="M85.1826 61.3001C89.7259 59.2496 92.3231 57.0216 92.0882 54.9392C91.5249 49.9451 74.9286 47.6826 55.0196 49.8859C35.1106 52.089 19.4279 57.9236 19.9913 62.9177C20.5547 67.912 37.1509 70.1744 57.0599 67.9712C59.8314 67.6645 62.5167 67.2853 65.0919 66.8498C65.6238 68.6907 71.9408 69.5082 79.4999 68.6717C87.264 67.8125 93.3798 65.537 93.1601 63.5896C93.0061 62.2241 89.7735 61.3854 85.1826 61.3001Z"
            fill="#FF8500"
        />
        <path
            d="M24.9118 46.9194C24.8769 46.802 24.8164 46.6939 24.7346 46.6029C24.6528 46.5119 24.5518 46.4402 24.439 46.393C24.439 46.393 22.6811 45.6522 21.8355 45.3056C20.9614 44.9502 20.01 45.574 18.904 46.2946C18.3721 46.692 17.7851 47.0097 17.1616 47.2377C16.5165 47.1888 15.88 47.0593 15.267 46.8522C15.4192 46.3476 15.7223 45.6188 16.0263 44.8961C16.9427 42.719 17.4481 41.5196 16.4894 40.986C15.6214 40.5684 14.727 40.2084 13.8118 39.9083C13.3581 39.7459 12.7782 39.5643 7.1676 44.1832C6.87787 44.0804 6.59568 43.9809 6.28948 43.8716L5.40158 43.5565C3.5859 42.9229 2.44404 43.5766 1.12077 44.3327L0.879851 44.4697C0.59474 44.6222 0.360181 44.8545 0.204818 45.1382C0.049455 45.4219 -0.0199885 45.7448 0.00496809 46.0673C0.0708896 47.1506 1.06866 48.2493 2.5466 48.8659C3.32951 49.1924 3.93176 49.3995 4.37041 49.5511C4.75614 49.6386 5.12037 49.8028 5.44143 50.0339C5.56757 50.1596 6.19505 50.9294 6.80217 51.6742C10.5581 56.2816 11.9115 57.7687 12.5935 58.0388C13.8721 58.5482 15.2148 58.8785 16.5837 59.0206C16.6683 59.021 16.7528 59.0167 16.8368 59.0077C16.9906 58.9917 17.1384 58.9393 17.2679 58.8548C17.3974 58.7703 17.5049 58.6561 17.5815 58.5216C17.9469 57.8881 17.7695 56.8596 15.7544 52.4392C15.6462 52.2022 15.5656 52.0265 15.5282 51.937C15.4012 51.6363 15.1034 50.9319 10.5841 49.5422C10.3737 49.4766 10.146 49.4969 9.9505 49.5986C9.75503 49.7004 9.60773 49.8754 9.54074 50.0855C9.50846 50.1894 9.49706 50.2986 9.5072 50.4069C9.51733 50.5153 9.54881 50.6205 9.59981 50.7166C9.65081 50.8126 9.72032 50.8977 9.80433 50.9667C9.88834 51.0357 9.98519 51.0875 10.0893 51.1188C11.4556 51.4969 12.7782 52.0186 14.0348 52.6753C14.0812 52.7817 14.1503 52.9325 14.235 53.1187C14.8907 54.4766 15.4633 55.8731 15.9498 57.3004C15.0305 57.1174 14.1281 56.8581 13.2519 56.525C12.5772 56.1301 9.43903 52.2812 8.09861 50.6376C7.21882 49.5575 6.78832 49.0312 6.61416 48.8611C6.12526 48.4414 5.54409 48.1434 4.91811 47.9914C4.47697 47.8398 3.92767 47.6504 3.19359 47.3441C1.98259 46.8395 1.61555 46.0867 1.70832 45.9029L1.9541 45.7626C3.23509 45.0307 3.7942 44.7486 4.84975 45.1138L5.72463 45.4249C14.3147 48.4903 16.6285 49.0142 17.4529 48.8619C18.3076 48.613 19.1098 48.2103 19.8204 47.6738C20.2704 47.3474 20.7568 47.0745 21.2698 46.8605C21.6849 47.0314 22.2822 47.2804 22.7909 47.4932C21.8265 48.6289 19.8732 50.582 17.7215 50.7618C17.6129 50.7701 17.507 50.7998 17.41 50.8492C17.3129 50.8987 17.2266 50.9669 17.1561 51.0499C17.0855 51.1329 17.0321 51.2291 16.9989 51.3329C16.9657 51.4367 16.9533 51.546 16.9626 51.6546C16.9718 51.7632 17.0024 51.8688 17.0527 51.9655C17.103 52.0622 17.1719 52.1479 17.2555 52.2178C17.3391 52.2877 17.4356 52.3403 17.5396 52.3726C17.6436 52.4049 17.753 52.4163 17.8614 52.4061C21.6914 52.0869 24.6765 47.7987 24.8019 47.6166C24.871 47.5159 24.9168 47.4011 24.9358 47.2804C24.9548 47.1598 24.9466 47.0364 24.9118 46.9194ZM13.4773 41.5438C14.401 41.8767 14.9504 42.0968 15.2751 42.237C15.1286 42.74 14.7542 43.6283 14.4881 44.2602C14.1577 45.0451 13.8499 45.7861 13.6698 46.3793C12.5064 46.0176 10.9911 45.5178 9.00264 44.8277C10.4185 43.6333 11.9135 42.5362 13.4773 41.5438Z"
            fill="#157BF0"
        />
        <path
            d="M73.8612 55.6489C73.6473 55.6493 73.4337 55.6331 73.2223 55.6006L61.4745 53.8015C60.8027 53.6998 60.1654 53.4375 59.6165 53.0367C59.0676 52.6359 58.6235 52.1086 58.3217 51.4994C58.023 50.8928 57.8771 50.2222 57.8965 49.5462C57.9159 48.8702 58.1002 48.2092 58.4332 47.6207L82.3211 5.37643C82.7477 4.63067 83.39 4.03172 84.1634 3.65848C84.9369 3.28523 85.8052 3.1552 86.654 3.28553L98.4001 5.08463C99.0722 5.18621 99.7098 5.44861 100.259 5.84953C100.808 6.25045 101.252 6.77805 101.554 7.38752C101.852 7.99419 101.998 8.66478 101.979 9.34083C101.959 10.0169 101.775 10.6779 101.441 11.2662L77.5544 53.5097C77.1818 54.1603 76.6439 54.7008 75.9954 55.0764C75.3468 55.4521 74.6106 55.6496 73.8612 55.6489ZM86.0118 4.88715C85.558 4.88702 85.1122 5.00671 84.7194 5.23414C84.3266 5.46157 84.0007 5.78869 83.7746 6.18247L59.8867 48.4268C59.6826 48.7823 59.5696 49.1829 59.5579 49.5928C59.5463 50.0027 59.6363 50.409 59.82 50.7756C60.0003 51.1462 60.2684 51.467 60.6011 51.7101C60.9338 51.9532 61.3208 52.1111 61.7285 52.1701L73.4763 53.9692C73.9903 54.048 74.5161 53.9693 74.9845 53.7434C75.453 53.5175 75.8422 53.1551 76.1009 52.7037L99.9879 10.4594C100.192 10.104 100.306 9.7034 100.317 9.29348C100.329 8.88356 100.239 8.47711 100.055 8.11055C99.8751 7.73984 99.6068 7.41894 99.274 7.17587C98.9412 6.93279 98.554 6.77494 98.1462 6.71608L86.3992 4.91698C86.2711 4.89706 86.1416 4.88709 86.0118 4.88715Z"
            fill="#157BF0"
        />
        <path
            d="M96.6705 57.656C96.1828 57.6558 95.6958 57.6186 95.2138 57.5448C93.7904 57.3144 92.434 56.7777 91.2381 55.9716C90.0423 55.1656 89.0355 54.1095 88.2872 52.8761C86.6563 50.2422 86.0392 47.1042 86.5513 44.0483C87.5751 37.4959 93.1418 32.8901 98.9249 33.7752C100.348 34.0055 101.705 34.5422 102.901 35.3482C104.097 36.1542 105.104 37.2104 105.852 38.4438C107.483 41.0777 108.099 44.2153 107.587 47.2709V47.2717C107.14 50.3428 105.596 53.1477 103.241 55.167C101.414 56.7493 99.0861 57.6313 96.6705 57.656ZM97.4852 35.3163C93.0416 35.3163 89.0099 39.1063 88.1985 44.3014C87.7481 46.9641 88.2809 49.6998 89.6975 51.9984C90.3102 53.0394 91.1467 53.931 92.1464 54.6083C93.1461 55.2857 94.284 55.732 95.4774 55.9147C96.6709 56.0975 97.89 56.0121 99.0464 55.6649C100.203 55.3176 101.267 54.7172 102.163 53.9071C104.187 52.1258 105.523 49.6913 105.939 47.0267C106.355 44.3621 105.825 41.6358 104.441 39.3216C103.819 38.2903 102.982 37.4062 101.986 36.7303C100.989 36.0544 99.8585 35.6028 98.671 35.4066C98.2786 35.3467 97.8822 35.3165 97.4852 35.3164V35.3163Z"
            fill="#157BF0"
        />
        <path
            d="M63.6515 23.9881C63.1638 23.9879 62.6768 23.9507 62.1947 23.8769C60.7715 23.6465 59.4151 23.1098 58.2193 22.3039C57.0234 21.498 56.0165 20.4421 55.2681 19.209C53.6373 16.575 53.0202 13.4371 53.5322 10.3812C54.5552 3.82797 60.117 -0.769738 65.9058 0.107243C71.7061 0.996321 75.5913 7.05056 74.5683 13.6038C74.1211 16.6748 72.5768 19.4797 70.2216 21.499C68.3954 23.0813 66.067 23.9634 63.6515 23.9881ZM64.4661 1.64841C60.0226 1.64841 55.9908 5.43847 55.1794 10.6335C54.729 13.2961 55.2618 16.0319 56.6785 18.3304C57.2911 19.3715 58.1276 20.263 59.1274 20.9404C60.1271 21.6178 61.2649 22.064 62.4584 22.2468C63.6518 22.4295 64.8709 22.3442 66.0273 21.9969C67.1837 21.6497 68.2484 21.0492 69.1441 20.2392C71.194 18.4755 72.5358 16.0283 72.9211 13.3507C73.8041 7.69783 70.5431 2.48832 65.6511 1.7387C65.2589 1.67875 64.8628 1.64857 64.4661 1.64841Z"
            fill="#157BF0"
        />
        <path
            d="M80.0368 28.7913C77.1231 13.3346 63.0135 2.97679 48.5222 5.65651L40.5264 7.13613L40.7616 8.47177C30.8707 14.0394 25.2072 26.0197 27.559 38.4952C29.863 50.718 39.1698 59.7451 50.1285 61.6654L50.4038 63.2291L59.0354 61.636C59.0481 61.6337 59.0609 61.6324 59.0736 61.63L59.1105 61.6222L59.2841 61.5901L59.2831 61.5854C73.6542 58.8024 82.9363 44.1726 80.0368 28.7913Z"
            fill="#FF6526"
        />
        <path
            opacity={0.17}
            d="M77.6062 21.357L69.5937 23.3031L61.4536 12.781L69.6958 11.2561L69.8063 11.3489L70.8185 12.2251C73.6627 14.7895 75.9699 17.8935 77.6062 21.357Z"
            fill="white"
        />
        <path
            d="M51.5977 63.0002C65.9994 59.8777 74.9758 44.884 71.6472 29.5107C68.3186 14.1375 53.9454 4.20616 39.5438 7.32856C25.1421 10.451 16.1657 25.4447 19.4943 40.818C22.8229 56.1913 37.1961 66.1226 51.5977 63.0002Z"
            fill="url(#7f12d9c4__paint0_linear_7649_66)"
        />
        <path
            d="M49.791 56.4006C60.7781 54.0186 67.6263 42.5798 65.0869 30.8514C62.5475 19.1231 51.5821 11.5464 40.595 13.9285C29.608 16.3106 22.7598 27.7494 25.2992 39.4778C27.8386 51.2061 38.804 58.7827 49.791 56.4006Z"
            fill="#FB730D"
        />
        <path
            d="M51.0765 55.4036C40.4115 57.6331 29.7796 50.1202 27.3294 38.6231C24.8791 27.1259 31.5385 15.9981 42.2034 13.7686C42.7733 13.6495 43.3429 13.5639 43.9114 13.4995C42.9568 13.5307 42.0058 13.6329 41.0663 13.8052C30.0109 15.8495 22.8507 27.0661 25.0735 38.858C27.2964 50.6499 38.0606 58.5518 49.1161 56.5074C52.1715 55.9432 55.0443 54.6449 57.4875 52.7241C55.5402 54.017 53.3643 54.9264 51.0765 55.4036Z"
            fill="#FF6526"
        />
        <path
            d="M49.1525 37.5082C50.3638 37.2611 51.5144 36.7771 52.5383 36.0839C53.5622 35.3908 54.4392 34.5021 55.1191 33.469C55.7989 32.4358 56.2682 31.2785 56.5 30.0634C56.7317 28.8483 56.7214 27.5994 56.4697 26.3883C56.0732 23.9164 54.7154 21.7019 52.6929 20.2283C50.6704 18.7546 48.1474 18.1416 45.6747 18.523L42.0597 19.1726L37.4095 20.0083C37.3037 20.0299 37.2032 20.0721 37.1138 20.1327C37.0244 20.1932 36.9478 20.2708 36.8885 20.361C36.8291 20.4512 36.7881 20.5523 36.7679 20.6584C36.7477 20.7645 36.7485 20.8735 36.7705 20.9793L38.8913 32.5564L35.8451 33.1038C35.7393 33.1254 35.6389 33.1677 35.5494 33.2282C35.46 33.2887 35.3834 33.3663 35.3241 33.4565C35.2647 33.5468 35.2237 33.6478 35.2035 33.7539C35.1833 33.86 35.1842 33.9691 35.2062 34.0748L36.0991 38.9491C36.1337 39.165 36.2523 39.3583 36.4289 39.487C36.6055 39.6157 36.8258 39.6692 37.0417 39.6359L40.0879 39.0885L40.657 42.1948L37.6107 42.7422C37.505 42.7638 37.4045 42.806 37.3151 42.8665C37.2257 42.9271 37.1491 43.0047 37.0897 43.0949C37.0303 43.1851 36.9894 43.2862 36.9691 43.3923C36.9489 43.4984 36.9498 43.6074 36.9718 43.7132L37.8647 48.5876C37.8993 48.8035 38.0178 48.9969 38.1945 49.1255C38.3711 49.2542 38.5914 49.3077 38.8073 49.2744L41.8535 48.727L42.2087 50.6657C42.2433 50.8816 42.3619 51.075 42.5385 51.2036C42.7151 51.3323 42.9354 51.3858 43.1513 51.3525L47.8016 50.5169C47.9073 50.4953 48.0078 50.4531 48.0972 50.3925C48.1866 50.332 48.2632 50.2544 48.3226 50.1642C48.3819 50.074 48.4229 49.9729 48.4431 49.8668C48.4634 49.7607 48.4625 49.6517 48.4405 49.5459L48.0854 47.6072L54.1114 46.5244C54.2172 46.5028 54.3176 46.4605 54.407 46.4C54.4964 46.3395 54.573 46.2619 54.6324 46.1716C54.6917 46.0814 54.7327 45.9804 54.753 45.8743C54.7732 45.7682 54.7723 45.6591 54.7503 45.5534L53.8574 40.679C53.8228 40.4631 53.7042 40.2697 53.5276 40.1411C53.351 40.0124 53.1307 39.9589 52.9148 39.9922L46.8887 41.075L46.3283 38.0157L49.1525 37.5082ZM44.199 26.3917C44.177 26.286 44.1761 26.1769 44.1963 26.0708C44.2166 25.9647 44.2575 25.8637 44.3169 25.7734C44.3763 25.6832 44.4529 25.6056 44.5423 25.5451C44.6317 25.4846 44.7322 25.4423 44.8379 25.4208L46.8937 25.0513C47.6547 24.9485 48.426 25.1429 49.0476 25.5941C49.6692 26.0453 50.0932 26.7188 50.2317 27.4746C50.3701 28.2305 50.2124 29.0106 49.7912 29.6531C49.37 30.2957 48.7177 30.7512 47.9697 30.9251L45.9139 31.2945C45.698 31.3278 45.4777 31.2743 45.3011 31.1456C45.1245 31.017 45.0059 30.8236 44.9713 30.6077L44.199 26.3917Z"
            fill="#FF8700"
        />
        <path
            d="M48.0512 37.712C49.2625 37.4649 50.4131 36.9809 51.437 36.2877C52.4609 35.5946 53.338 34.7059 54.0178 33.6728C54.6976 32.6396 55.1669 31.4823 55.3987 30.2672C55.6304 29.0521 55.6201 27.8032 55.3684 26.5921C54.9719 24.1202 53.6141 21.9057 51.5916 20.4321C49.5691 18.9585 47.046 18.3455 44.5734 18.7269L40.9584 19.3765L36.3082 20.2121C36.2024 20.2337 36.1019 20.276 36.0125 20.3365C35.9231 20.397 35.8465 20.4746 35.7872 20.5648C35.7278 20.6551 35.6868 20.7561 35.6666 20.8622C35.6463 20.9683 35.6472 21.0774 35.6692 21.1831L37.79 32.7603L34.7438 33.3077C34.638 33.3293 34.5375 33.3715 34.4481 33.4321C34.3587 33.4926 34.2821 33.5702 34.2228 33.6604C34.1634 33.7506 34.1224 33.8517 34.1022 33.9578C34.0819 34.0639 34.0828 34.1729 34.1048 34.2787L34.9977 39.153C35.0324 39.3688 35.1509 39.5622 35.3275 39.6909C35.5042 39.8195 35.7245 39.8731 35.9404 39.8398L38.9866 39.2924L39.5556 42.3986L36.5094 42.9461C36.4036 42.9676 36.3032 43.0099 36.2138 43.0704C36.1243 43.1309 36.0478 43.2085 35.9884 43.2987C35.929 43.389 35.888 43.49 35.8678 43.5961C35.8476 43.7022 35.8485 43.8113 35.8705 43.917L36.7634 48.7914C36.798 49.0073 36.9166 49.2006 37.0932 49.3293C37.2698 49.458 37.4901 49.5115 37.706 49.4782L40.7523 48.9308L41.1074 50.8695C41.142 51.0854 41.2606 51.2788 41.4372 51.4074C41.6138 51.5361 41.8341 51.5896 42.05 51.5563L46.7003 50.7207C46.8061 50.6991 46.9065 50.6569 46.9959 50.5963C47.0853 50.5358 47.1619 50.4582 47.2213 50.368C47.2807 50.2778 47.3216 50.1767 47.3419 50.0706C47.3621 49.9645 47.3612 49.8555 47.3392 49.7497L46.9841 47.811L53.0101 46.7281C53.1159 46.7066 53.2164 46.6643 53.3058 46.6038C53.3952 46.5432 53.4718 46.4657 53.5311 46.3754C53.5905 46.2852 53.6315 46.1842 53.6517 46.0781C53.672 45.972 53.6711 45.8629 53.6491 45.7572L52.7561 40.8828C52.7215 40.6669 52.603 40.4735 52.4264 40.3448C52.2498 40.2162 52.0294 40.1626 51.8135 40.196L45.7875 41.2788L45.227 38.2195L48.0512 37.712ZM43.0977 26.5956C43.0757 26.4898 43.0748 26.3807 43.095 26.2746C43.1153 26.1685 43.1562 26.0675 43.2156 25.9773C43.275 25.887 43.3516 25.8095 43.441 25.7489C43.5304 25.6884 43.6309 25.6461 43.7366 25.6246L45.7924 25.2552C46.5534 25.1523 47.3248 25.3466 47.9464 25.7979C48.5679 26.2491 48.992 26.9226 49.1305 27.6784C49.2689 28.4343 49.1112 29.2144 48.6899 29.857C48.2687 30.4995 47.6164 30.955 46.8684 31.1289L44.8126 31.4984C44.5967 31.5317 44.3764 31.4781 44.1998 31.3495C44.0232 31.2208 43.9046 31.0274 43.87 30.8116L43.0977 26.5956Z"
            fill="url(#7f12d9c4__paint1_linear_7649_66)"
        />
        <path
            d="M75.5743 44.3633C76.9362 48.025 79.1702 52.1357 83.0007 53.3159C83.1636 53.369 83.3093 53.4646 83.423 53.5928C83.5367 53.721 83.6141 53.8772 83.6474 54.0453C83.6806 54.2135 83.6685 54.3874 83.6122 54.5493C83.5559 54.7112 83.4575 54.8551 83.3271 54.9662C80.3109 57.7848 78.2202 61.4528 77.3313 65.4856C77.2825 65.6819 77.1749 65.8585 77.0228 65.9917C76.8707 66.1249 76.6815 66.2083 76.4806 66.2306C76.2797 66.2529 76.0768 66.2131 75.8992 66.1166C75.7216 66.02 75.5779 65.8714 75.4873 65.6906C73.1247 60.9672 71.218 58.0278 68.1605 56.5015C68.0144 56.4285 67.8892 56.3195 67.7969 56.1847C67.7045 56.0499 67.6479 55.8939 67.6325 55.7312C67.617 55.5685 67.6433 55.4045 67.7086 55.2548C67.774 55.105 67.8764 54.9744 68.0062 54.8752C70.3737 52.9936 72.4556 49.3869 73.6833 44.4803C73.7329 44.2741 73.8474 44.0892 74.0098 43.9529C74.1722 43.8166 74.374 43.7359 74.5856 43.7228C74.7972 43.7097 75.0074 43.7649 75.1853 43.8801C75.3633 43.9954 75.4996 44.1647 75.5743 44.3633Z"
            fill="white"
        />
        <path
            d="M24.7091 4.73011C24.6847 10.4849 25.7283 17.246 29.3459 20.5644C29.4547 20.6783 29.5362 20.8153 29.5844 20.9653C29.6326 21.1152 29.6461 21.2741 29.624 21.4301C29.6019 21.586 29.5447 21.7349 29.4568 21.8655C29.3688 21.9961 29.2524 22.1051 29.1163 22.1841C23.5775 25.1009 19.1967 29.8183 16.6953 35.5595C16.6227 35.7435 16.4869 35.8956 16.3123 35.9883C16.1377 36.0811 15.9357 36.1086 15.7427 36.0657C15.5497 36.0228 15.3784 35.9124 15.2594 35.7544C15.1404 35.5964 15.0817 35.4011 15.0937 35.2037C14.7887 27.4394 12.4772 21.1705 10.7141 18.6277C10.6281 18.5021 10.5714 18.3587 10.5482 18.2082C10.525 18.0577 10.536 17.904 10.5801 17.7583C10.6243 17.6126 10.7007 17.4787 10.8035 17.3665C10.9064 17.2543 11.0332 17.1667 11.1744 17.1101C14.6351 15.8813 19.5969 11.6777 23.1058 4.32627C23.1802 4.13788 23.3205 3.983 23.5006 3.89055C23.6807 3.79809 23.8883 3.77437 24.0846 3.82382C24.2809 3.87326 24.4525 3.99249 24.5674 4.15926C24.6824 4.32602 24.7327 4.52892 24.7091 4.73011Z"
            fill="white"
        />
        <path
            d="M29.1167 22.1889C23.5761 25.1028 19.1933 29.8192 16.6911 35.5603C16.6142 35.7584 16.4636 35.919 16.2709 36.0083C16.0782 36.0975 15.8584 36.1086 15.6577 36.0391V36.0308C16.1578 34.8504 19.3829 21.4708 17.5245 18.3178C20.5496 16.7908 23.3747 6.84472 24.1665 3.85693C24.3355 3.9296 24.4781 4.05251 24.575 4.20899C24.6719 4.36548 24.7184 4.54799 24.7082 4.7318C24.6831 10.4848 25.7249 17.2448 29.3417 20.5712C29.4508 20.6845 29.5327 20.8211 29.5813 20.9707C29.6299 21.1203 29.6439 21.279 29.6222 21.4348C29.6006 21.5906 29.5438 21.7394 29.4562 21.8701C29.3686 22.0007 29.2526 22.1097 29.1167 22.1889Z"
            fill="#D8E5FF"
        />
        <path
            d="M15.6577 36.0308V36.0391C15.4893 35.9749 15.3447 35.8605 15.2433 35.7114C15.142 35.5623 15.0888 35.3857 15.091 35.2054C14.791 27.4384 12.4742 21.1737 10.7158 18.6314C10.6113 18.4827 10.548 18.309 10.5325 18.1279C12.8314 18.6225 15.202 18.6869 17.5244 18.3179C19.3829 21.4708 16.1577 34.8504 15.6577 36.0308Z"
            fill="#ECF1FF"
        />
        <path
            d="M83.3283 54.9622C80.3104 57.782 78.2182 61.4515 77.328 65.486C77.2823 65.688 77.1723 65.8697 77.0145 66.0037C76.8566 66.1376 76.6596 66.2166 76.453 66.2288C75.6446 63.2986 76.2613 55.8783 77.9697 54.3844C75.4946 53.592 74.5612 44.1164 74.5195 43.7285C74.7423 43.6947 74.9698 43.7397 75.163 43.8557C75.3562 43.9717 75.5029 44.1515 75.5779 44.364C76.9363 48.0206 79.1698 52.131 83.0033 53.3114C83.166 53.3648 83.3115 53.4607 83.4248 53.589C83.5382 53.7173 83.6154 53.8736 83.6485 54.0416C83.6816 54.2097 83.6694 54.3836 83.6131 54.5454C83.5568 54.7071 83.4585 54.851 83.3283 54.9622Z"
            fill="url(#7f12d9c4__paint2_linear_7649_66)"
        />
        <path
            d="M103.208 24.5515C103.138 24.5516 103.068 24.543 103 24.5257C102.895 24.4994 102.795 24.4525 102.708 24.3877C102.621 24.3229 102.547 24.2414 102.491 24.148C102.435 24.0546 102.399 23.951 102.383 23.8434C102.367 23.7357 102.373 23.626 102.4 23.5205L103.013 21.1645C103.071 20.9523 103.21 20.7713 103.399 20.6602C103.589 20.5492 103.815 20.5169 104.028 20.5704C104.133 20.5967 104.233 20.6436 104.32 20.7084C104.407 20.7732 104.481 20.8547 104.537 20.9481C104.593 21.0415 104.629 21.145 104.645 21.2527C104.66 21.3604 104.655 21.4701 104.628 21.5755L104.015 23.9316C103.968 24.1096 103.863 24.267 103.717 24.3791C103.571 24.4912 103.392 24.5519 103.208 24.5515Z"
            fill="#157BF0"
        />
        <path
            d="M101.498 31.1265C101.428 31.1266 101.358 31.118 101.29 31.1007C101.185 31.0744 101.085 31.0275 100.998 30.9627C100.911 30.8979 100.837 30.8164 100.781 30.723C100.725 30.6296 100.689 30.526 100.673 30.4184C100.657 30.3107 100.663 30.201 100.69 30.0955L101.303 27.7395C101.36 27.5269 101.499 27.3455 101.689 27.2343C101.879 27.1232 102.105 27.0912 102.318 27.1454C102.423 27.1717 102.523 27.2186 102.61 27.2834C102.697 27.3482 102.771 27.4297 102.827 27.5231C102.883 27.6165 102.919 27.72 102.935 27.8277C102.951 27.9354 102.945 28.0451 102.918 28.1505L102.305 30.5066C102.258 30.6846 102.153 30.842 102.007 30.9541C101.861 31.0662 101.682 31.1269 101.498 31.1265Z"
            fill="#157BF0"
        />
        <path
            d="M107.169 27.8111C107.098 27.8112 107.028 27.8026 106.96 27.7853L104.581 27.1783C104.476 27.1521 104.377 27.1052 104.289 27.0404C104.202 26.9755 104.128 26.8941 104.072 26.8006C104.017 26.7072 103.98 26.6037 103.964 26.496C103.949 26.3883 103.955 26.2786 103.982 26.1732C104.039 25.9609 104.178 25.7797 104.368 25.6686C104.557 25.5576 104.783 25.5254 104.996 25.5791L107.375 26.1861C107.571 26.2348 107.743 26.3538 107.857 26.5205C107.971 26.6873 108.02 26.8901 107.994 27.0906C107.969 27.2911 107.87 27.4752 107.718 27.608C107.566 27.7408 107.37 27.8131 107.169 27.8111L107.169 27.8111Z"
            fill="#157BF0"
        />
        <path
            d="M100.529 26.1176C100.459 26.1177 100.389 26.1091 100.321 26.0918L97.9419 25.4848C97.8364 25.4586 97.7371 25.4117 97.6498 25.3469C97.5624 25.282 97.4888 25.2006 97.433 25.1071C97.3773 25.0137 97.3405 24.9102 97.3249 24.8025C97.3093 24.6948 97.3152 24.5851 97.3421 24.4797C97.3997 24.2673 97.5383 24.0861 97.7281 23.975C97.9179 23.8639 98.1438 23.8318 98.357 23.8856L100.736 24.4926C100.932 24.5413 101.103 24.6603 101.217 24.8271C101.331 24.9938 101.38 25.1966 101.355 25.3971C101.329 25.5975 101.231 25.7816 101.079 25.9145C100.927 26.0473 100.731 26.1196 100.529 26.1176L100.529 26.1176Z"
            fill="#157BF0"
        />
        <path
            d="M7.92786 7.74434C7.85761 7.74452 7.78761 7.73586 7.71951 7.71857C7.61399 7.6923 7.5147 7.64541 7.42736 7.58059C7.34003 7.51577 7.26636 7.4343 7.21061 7.34088C7.15486 7.24746 7.11813 7.14392 7.10253 7.03624C7.08692 6.92855 7.09276 6.81884 7.1197 6.71342L7.73254 4.35731C7.79043 4.14514 7.92911 3.96411 8.11883 3.85306C8.30855 3.74202 8.53421 3.70979 8.7474 3.7633C8.85292 3.78956 8.95221 3.83646 9.03955 3.90128C9.12689 3.96609 9.20055 4.04756 9.2563 4.14098C9.31205 4.2344 9.34879 4.33794 9.36439 4.44562C9.37999 4.55331 9.37415 4.66302 9.34722 4.76844L8.73439 7.12453C8.68731 7.30251 8.58262 7.45986 8.4367 7.572C8.29078 7.68414 8.11185 7.74474 7.92786 7.74434Z"
            fill="#157BF0"
        />
        <path
            d="M6.2179 14.32C6.14765 14.3202 6.07765 14.3115 6.00955 14.2942C5.90403 14.2679 5.80474 14.2211 5.7174 14.1562C5.63006 14.0914 5.5564 14.0099 5.50065 13.9165C5.4449 13.8231 5.40817 13.7196 5.39257 13.6119C5.37696 13.5042 5.3828 13.3945 5.40974 13.2891L6.02256 10.933C6.08024 10.7207 6.21887 10.5395 6.40866 10.4284C6.59844 10.3173 6.82421 10.2852 7.03742 10.3389C7.14295 10.3652 7.24223 10.4121 7.32957 10.4769C7.41691 10.5417 7.49058 10.6232 7.54633 10.7166C7.60208 10.81 7.63881 10.9136 7.65441 11.0213C7.67001 11.1289 7.66418 11.2387 7.63724 11.3441L7.02441 13.7002C6.97733 13.8781 6.87265 14.0355 6.72674 14.1476C6.58082 14.2598 6.40189 14.3204 6.2179 14.32Z"
            fill="#157BF0"
        />
        <path
            d="M11.888 11.0048C11.8178 11.005 11.7478 10.9963 11.6797 10.979L9.30081 10.3721C9.19529 10.3458 9.096 10.2989 9.00866 10.2341C8.92132 10.1693 8.84766 10.0878 8.79191 9.99438C8.73616 9.90096 8.69943 9.79743 8.68383 9.68974C8.66822 9.58205 8.67406 9.47234 8.701 9.36692C8.75829 9.15437 8.89686 8.97292 9.08676 8.86176C9.27665 8.7506 9.50263 8.71867 9.71586 8.77287L12.0947 9.37983C12.2907 9.42853 12.462 9.54755 12.5761 9.71428C12.6902 9.88102 12.7391 10.0839 12.7136 10.2843C12.6881 10.4848 12.5899 10.6689 12.4378 10.8017C12.2856 10.9345 12.0899 11.0068 11.888 11.0048L11.888 11.0048Z"
            fill="#157BF0"
        />
        <path
            d="M5.2487 9.31058C5.17844 9.31076 5.10844 9.3021 5.04035 9.28481L2.66149 8.67866C2.55594 8.65243 2.45662 8.60557 2.36926 8.54076C2.28189 8.47595 2.20821 8.39448 2.15245 8.30105C2.0967 8.20761 2.05997 8.10406 2.04439 7.99636C2.02881 7.88865 2.03468 7.77893 2.06167 7.67351C2.11903 7.461 2.2576 7.27958 2.44748 7.16843C2.63736 7.05729 2.86331 7.02533 3.07653 7.07945L5.4554 7.68558C5.65138 7.73429 5.82267 7.85331 5.93675 8.02004C6.05083 8.18678 6.09977 8.38962 6.07427 8.59007C6.04877 8.79053 5.95061 8.97463 5.79842 9.10745C5.64623 9.24027 5.45061 9.31255 5.24869 9.31057L5.2487 9.31058Z"
            fill="#157BF0"
        />
        <defs>
            <linearGradient
                id="7f12d9c4__paint0_linear_7649_66"
                x1={39.5438}
                y1={7.32856}
                x2={66.494}
                y2={73.1438}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FFE572" />
                <stop offset={1} stopColor="#FFAD0D" />
            </linearGradient>
            <linearGradient
                id="7f12d9c4__paint1_linear_7649_66"
                x1={29.0786}
                y1={9.14461}
                x2={55.6915}
                y2={61.5037}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FFE572" />
                <stop offset={1} stopColor="#FFAD0E" />
            </linearGradient>
            <linearGradient
                id="7f12d9c4__paint2_linear_7649_66"
                x1={918.658}
                y1={1448.68}
                x2={1051.32}
                y2={1579.66}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.0026} stopColor="#D8E5FF" />
                <stop offset={0.99879} stopColor="#0269E8" />
            </linearGradient>
        </defs>
    </svg>
);

export default AdLowPriceM;
