import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CovidAviaL = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 191 100"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <path
            d="M109.969 1.18271C90.9537 1.34074 68.467 3.71116 44.718 17.4596C11.422 36.7391 -3.33234 46.2208 0.84938 61.7076C6.05681 80.987 46.9272 95.9997 85.9829 95.9207C102.789 95.8417 120.305 93.5503 135.454 87.3082C211.356 56.1766 173.089 0.708622 109.969 1.18271Z"
            fill="#EDF2F7"
        />
        <path
            d="M144.765 48.9073C145.001 50.4086 145.869 51.7518 147.132 52.621C148.473 53.4901 149.972 53.8062 151.471 53.4901L171.196 49.6184C173.484 49.1444 175.615 48.2752 177.587 47.011C179.323 45.8258 181.374 45.0356 183.426 44.6405L188.397 43.6924C189.264 43.5343 189.896 42.9812 190.369 42.3491C190.842 41.638 191.079 40.8479 190.842 39.9787C190.606 39.1096 190.132 38.4774 189.501 38.0034C188.791 37.5293 188.002 37.2922 187.134 37.5293L182.163 38.4774C180.112 38.8725 177.903 38.8725 175.851 38.4774C173.563 38.0034 171.196 38.0034 168.908 38.3984L149.262 42.1911C146.185 42.7442 144.133 45.8258 144.765 48.9073ZM187.529 38.8725C188.397 38.7145 189.264 39.3466 189.422 40.1367C189.501 40.5318 189.343 41.0059 189.107 41.401C188.87 41.796 188.554 42.0331 188.081 42.1121L183.899 42.9022L183.268 39.6627L187.529 38.8725ZM149.578 43.6924L169.382 39.8207C171.433 39.4256 173.642 39.4256 175.694 39.8207C177.745 40.2158 179.875 40.2948 182.006 39.9787L182.637 43.2973C180.585 43.7714 178.613 44.5615 176.877 45.8258C175.141 47.011 173.169 47.8801 171.038 48.1962L151.234 51.9889C150.13 52.2259 148.946 51.9889 148.078 51.3568C147.132 50.7246 146.5 49.6975 146.343 48.5913C145.711 46.2998 147.211 44.0874 149.578 43.6924Z"
            fill="#00E6C5"
        />
        <path
            d="M160.072 47.7221C160.151 48.1171 160.545 48.3542 160.94 48.2752L171.907 46.1418C172.301 46.0628 172.538 45.6677 172.459 45.2726L171.828 41.875C171.749 41.638 171.67 41.559 171.512 41.4009C171.354 41.2429 171.197 41.2429 170.96 41.3219L159.993 43.4553C159.598 43.5343 159.362 43.9294 159.44 44.3245L160.072 47.7221ZM170.565 42.9022L170.96 44.8776L161.413 46.7739L161.018 44.7985L170.565 42.9022Z"
            fill="#00E6C5"
        />
        <path
            d="M151.314 48.4331L156.995 47.3269C157.389 47.2479 157.626 46.8529 157.547 46.4578C157.468 46.2207 157.389 46.0627 157.231 45.9837C157.073 45.8257 156.916 45.8257 156.679 45.9047L150.998 47.0109C150.604 47.0899 150.367 47.485 150.446 47.88C150.525 48.2751 150.919 48.5122 151.314 48.4331Z"
            fill="#00E6C5"
        />
        <path
            d="M45.6667 7.97805C45.7456 7.97805 41.7217 7.741 41.7217 7.741C41.7217 7.741 45.2722 -0.160416 53.5567 3.00015C46.9291 2.76311 45.6667 7.97805 45.6667 7.97805Z"
            fill="url(#fe7170d7__paint0_linear_9962_575)"
        />
        <path
            d="M16.4732 50.9617C22.154 61.6286 28.9395 68.1867 41.7213 69.53C46.5342 70.0831 56.239 69.1349 58.5271 68.1868C67.364 64.3941 70.9934 21.7264 66.1805 13.5089C61.3675 5.29147 40.3011 3.86921 32.8845 7.18781C25.4678 10.5064 9.92445 38.7145 16.4732 50.9617Z"
            fill="#FFD34D"
        />
        <path
            d="M58.7644 11.6127L54.8983 10.5065C55.2928 7.02991 54.346 3.71132 50.2432 2.28906C58.8433 3.31625 59.1589 9.32132 58.7644 11.6127Z"
            fill="#66B3FF"
        />
        <path
            d="M35.646 15.6425C35.1726 15.9585 34.068 19.0401 34.4625 19.5932C34.857 20.0673 41.0112 21.3315 41.4057 21.0944C41.8002 20.8574 43.1415 17.2228 42.747 16.8277C42.3525 16.4326 36.1194 15.3264 35.646 15.6425Z"
            fill="#0066DA"
        />
        <path
            d="M41.406 68.0289C48.1914 65.1844 52.9255 35.7121 51.1107 30.5761C49.296 25.3612 24.2057 21.3315 19.3928 24.8871C13.3174 29.3119 7.95222 49.6186 8.42562 56.1768C8.97793 62.6559 34.6206 70.7944 41.406 68.0289Z"
            fill="#FFD34D"
            stroke="#FAAC1A"
            strokeWidth={1.30973}
            strokeMiterlimit={10}
        />
        <path
            d="M63.6563 40.2157C64.2875 35.949 64.6031 31.5242 64.682 27.1784C64.682 24.887 64.682 22.5166 64.4453 20.2252C64.2875 18.5659 63.9719 16.8275 63.1829 15.3263C62.3939 13.825 60.8159 12.6398 59.4746 11.7706C57.7387 10.6644 55.8451 9.87429 53.9515 9.16317C49.8487 7.81993 45.5092 7.1088 41.1697 6.87176C39.1971 6.79274 37.2246 6.71373 35.2521 6.87176C34.0686 6.95077 32.7273 7.02978 31.6227 7.58288C30.8337 7.97795 31.5438 9.08415 32.3328 8.7681C32.964 8.45204 34.1475 8.37303 35.0154 8.29401C36.5934 8.13598 38.1714 8.13598 39.7495 8.215C43.7734 8.37303 47.8762 8.92612 51.7423 9.95331C55.2928 10.9805 59.2379 12.4818 61.6049 15.4053C62.5517 16.5115 62.7884 18.0128 63.0251 19.435C63.3407 21.5684 63.4196 23.7018 63.4196 25.8352C63.4196 30.497 63.104 35.2378 62.3939 39.8997C62.2361 40.6898 63.4985 41.0849 63.6563 40.2157Z"
            fill="#FAAC1A"
        />
        <path
            d="M46.1692 38.1232C40.3606 37.3656 34.5635 36.3711 28.8606 35.0648C26.4368 34.5512 24.0168 33.9586 21.6007 33.2872C19.965 32.8119 18.3293 32.3367 16.7839 31.6285C16.0112 31.2744 15.2481 32.3448 16.017 32.7778C17.5585 33.5648 19.273 34.0439 20.9087 34.5192C23.4036 35.1945 25.9024 35.7909 28.4011 36.3873C34.2617 37.7013 40.1376 38.6995 46.0212 39.54C46.9669 39.586 47.0322 38.2444 46.1692 38.1232Z"
            fill="#FAAC1A"
        />
        <path
            d="M45.6668 38.4775C47.0081 39.1886 46.7714 44.9566 46.2191 45.8258C45.5879 46.6949 41.9585 46.2999 41.9585 44.8776C41.8796 43.5344 44.2466 37.7663 45.6668 38.4775Z"
            fill="#FAAC1A"
        />
        <path
            d="M98.2918 98.1331C98.2918 98.1331 124.092 87.5452 157.625 71.3473C158.651 70.8732 159.282 69.846 159.361 69.2139C159.519 68.5028 159.755 66.6855 159.755 66.6855L130.089 54.9124L69.4932 75.5351C69.4932 75.5351 69.8088 77.2734 69.9666 77.9055C70.1244 78.5376 70.5189 79.3277 70.9923 79.8018L90.5596 97.0269C92.6899 98.8442 95.6881 99.3183 98.2918 98.1331Z"
            fill="#4E9CE9"
        />
        <path
            d="M98.292 94.9726L158.809 68.0287C160.071 67.4756 160.071 65.6583 158.809 65.1052L130.089 51.8308L69.5723 75.5351L90.6387 93.8664C92.6901 95.6837 95.6883 96.1578 98.292 94.9726Z"
            fill="#66B3FF"
        />
        <path
            d="M130.089 51.8307L118.175 9.00505C117.544 6.87167 115.335 5.60744 113.205 6.23955L56.4754 23.1486C54.2662 23.7807 53.0827 26.1511 53.7928 28.2845L69.5728 75.535L130.089 51.8307Z"
            fill="#0066DA"
        />
        <path
            d="M125.907 47.4851L115.729 11.4546C115.492 10.5854 114.545 10.0323 113.677 10.3484L59.2362 26.5463C58.2894 26.7833 57.8159 27.8105 58.1315 28.6797L71.9391 67.7127C72.2547 68.5819 73.2015 69.0559 74.0694 68.7399L124.96 49.5394C125.749 49.2234 126.144 48.3542 125.907 47.4851Z"
            fill="white"
        />
        <path
            d="M89.7712 85.412L144.291 62.4189L129.221 55.3076L77.7783 75.4562L89.7712 85.412Z"
            fill="#0066DA"
        />
        <path
            d="M72.7297 32.9464L68.8636 34.1317C68.3902 34.2897 67.8379 34.0526 67.6012 33.4995L66.2599 29.6278C66.1021 29.1538 66.3388 28.6007 66.8911 28.4426L70.7572 27.2574C71.2306 27.0994 71.7829 27.4154 71.9407 27.8895L73.282 31.6822C73.5187 32.3143 73.2031 32.7884 72.7297 32.9464Z"
            fill="#DAE6F2"
        />
        <path
            d="M78.1743 25.9139C78.2532 25.9139 78.3321 25.9929 78.3321 25.9929L79.5945 29.7856V29.8646C79.5945 29.8646 79.5156 29.8646 79.5156 29.9436L75.7284 31.1289C75.7284 31.1289 75.7284 31.1289 75.6495 31.1289C75.5706 31.1289 75.4917 31.1289 75.4917 31.0498L74.3082 27.2572C74.3082 27.1781 74.3082 27.1781 74.3082 27.1781C74.3082 27.1781 74.3082 27.1781 74.3871 27.0991L78.1743 25.9139ZM78.1743 25.1238C78.0954 25.1238 78.0165 25.1238 77.9376 25.1238L74.1504 26.309C73.677 26.467 73.3614 26.9411 73.5981 27.4942L74.9394 31.2869C75.0972 31.682 75.4917 31.919 75.8862 31.919C75.9651 31.919 76.044 31.919 76.2018 31.84L79.989 30.6548C80.4624 30.4967 80.6991 30.0227 80.5413 29.4696L79.2789 25.6769C78.9633 25.4398 78.5688 25.1238 78.1743 25.1238Z"
            fill="#027BF3"
        />
        <path
            d="M86.6951 28.6004L82.9868 29.7856C82.5134 29.9437 81.9611 29.6276 81.8033 29.1535L80.5409 25.3608C80.3831 24.8868 80.6198 24.3337 81.0932 24.1756L84.8015 23.0694C85.2749 22.9114 85.8272 23.2275 85.985 23.7015L87.2474 27.4152C87.4841 27.9683 87.1685 28.4424 86.6951 28.6004Z"
            fill="#DAE6F2"
        />
        <path
            d="M73.5966 35.3168C73.6755 35.3168 73.7545 35.3168 73.7545 35.3958L75.0958 39.1884V39.2675C75.0958 39.2675 75.0958 39.3465 75.0169 39.3465L71.1507 40.6107C71.1507 40.6107 71.1507 40.6107 71.0718 40.6107C70.9929 40.6107 70.914 40.6107 70.914 40.5317L69.5727 36.739V36.66C69.5727 36.66 69.5727 36.581 69.6516 36.581L73.5966 35.3168ZM73.5966 34.5266C73.5177 34.5266 73.4388 34.5266 73.281 34.6056L69.4149 35.7908C68.9415 35.9489 68.6259 36.502 68.7837 36.9761L70.125 40.7687C70.2828 41.1638 70.5984 41.4008 71.0718 41.4008C71.1507 41.4008 71.3085 41.4008 71.3874 41.3218L75.1747 40.0576C75.6481 39.8996 75.8848 39.3465 75.727 38.8724L74.3857 35.0797C74.3857 34.7637 73.9911 34.5266 73.5966 34.5266Z"
            fill="#027BF3"
        />
        <path
            d="M82.1976 37.8452L78.4892 39.0304C78.0158 39.1884 77.4635 38.9514 77.3057 38.4773L76.0433 34.6846C75.8855 34.2105 76.1222 33.6574 76.5956 33.4994L80.3828 32.3142C80.8562 32.1561 81.4085 32.3932 81.5663 32.9463L82.8288 36.66C82.9866 37.134 82.671 37.6871 82.1976 37.8452Z"
            fill="#DAE6F2"
        />
        <path
            d="M89.0625 35.6328L85.4331 36.818C84.9597 36.9761 84.4863 36.739 84.2496 36.2649L82.9872 32.5513C82.8294 32.0772 83.0661 31.5241 83.5395 31.4451L87.2478 30.2599C87.7212 30.1018 88.1946 30.4179 88.3524 30.892L89.5359 34.6056C89.7726 34.9217 89.5359 35.4748 89.0625 35.6328Z"
            fill="#DAE6F2"
        />
        <path
            d="M77.621 47.0107L73.8338 48.275C73.3604 48.433 72.808 48.196 72.6502 47.7219L71.3089 44.0082C71.1511 43.5341 71.3878 42.981 71.8612 42.823L75.6485 41.5588C76.1219 41.4007 76.6742 41.6378 76.832 42.1119L78.0944 45.8255C78.41 46.3786 78.0944 46.8527 77.621 47.0107Z"
            fill="#DAE6F2"
        />
        <path
            d="M84.5652 44.7193L80.8569 45.9836C80.3835 46.1416 79.8312 45.9045 79.6734 45.4305L78.411 41.7168C78.2532 41.2427 78.4899 40.6896 78.9633 40.5316L82.6716 39.3464C83.145 39.1883 83.6973 39.4254 83.8551 39.8995L85.1175 43.6131C85.2753 44.0082 85.0386 44.5613 84.5652 44.7193Z"
            fill="#DAE6F2"
        />
        <path
            d="M91.2707 42.4279L87.6413 43.6131C87.1679 43.7712 86.6945 43.5341 86.5367 43.06L85.2743 39.4254C85.1165 38.9513 85.3532 38.4772 85.8266 38.3192L89.456 37.134C89.9294 36.9759 90.4028 37.213 90.5606 37.6871L91.7441 41.3217C91.9808 41.7168 91.7441 42.2699 91.2707 42.4279Z"
            fill="#DAE6F2"
        />
        <path
            d="M80.0677 53.964L76.3593 55.3072C75.8859 55.4652 75.3336 55.2282 75.1758 54.7541L73.9134 51.0404C73.7556 50.5663 73.9923 50.0132 74.4657 49.8552L78.253 48.591C78.7264 48.433 79.2787 48.67 79.4365 49.1441L80.6989 52.7787C80.7778 53.2528 80.5411 53.8059 80.0677 53.964Z"
            fill="#DAE6F2"
        />
        <path
            d="M86.853 51.5936L83.2236 52.8578C82.7502 53.0158 82.1979 52.7788 82.0401 52.3047L80.7777 48.6701C80.6199 48.196 80.8566 47.7219 81.33 47.4849L85.0383 46.2206C85.5117 46.0626 85.9851 46.2996 86.1429 46.7737L87.4053 50.4084C87.5631 50.8825 87.3264 51.4356 86.853 51.5936Z"
            fill="#DAE6F2"
        />
        <path
            d="M93.5592 49.2231L90.0087 50.4873C89.5353 50.6453 89.0619 50.4083 88.9041 49.9342L87.7206 46.2996C87.5628 45.8255 87.7995 45.3514 88.2729 45.1934L91.9023 43.9291C92.3757 43.7711 92.8491 44.0081 93.0069 44.4822L94.1904 48.0379C94.2693 48.512 94.0326 49.0651 93.5592 49.2231Z"
            fill="#027BF3"
        />
        <path
            d="M82.3557 60.6012L78.6474 61.9444C78.174 62.1024 77.6217 61.8654 77.4639 61.3913L76.2015 57.7567C76.0437 57.2826 76.2804 56.7295 76.7538 56.5714L80.4621 55.2282C80.9355 55.0702 81.4878 55.3072 81.6456 55.7813L82.9081 59.416C83.0659 59.9691 82.8292 60.4431 82.3557 60.6012Z"
            fill="#DAE6F2"
        />
        <path
            d="M89.1408 58.1517L85.5114 59.495C85.038 59.653 84.5646 59.4159 84.4068 58.9419L83.1444 55.3862C82.9866 54.9121 83.2233 54.4381 83.6967 54.28L87.3261 53.0158C87.7995 52.8578 88.2729 53.0948 88.4307 53.5689L89.6142 57.1245C89.8509 57.4406 89.6142 57.9937 89.1408 58.1517Z"
            fill="#DAE6F2"
        />
        <path
            d="M95.6896 55.7024L92.139 56.9666C91.6656 57.1247 91.1922 56.8876 91.0344 56.4135L89.8509 52.8579C89.6931 52.3838 89.9298 51.9097 90.4032 51.7517L93.9538 50.4875C94.4272 50.3294 94.9006 50.5665 95.0584 51.0406L96.2419 54.5962C96.3997 55.0703 96.163 55.5444 95.6896 55.7024Z"
            fill="#DAE6F2"
        />
        <path
            d="M98.214 25.0448L94.6635 26.151C94.1901 26.3091 93.7167 25.993 93.5589 25.5189L92.3753 21.8053C92.2175 21.3312 92.4542 20.8571 92.9276 20.6991L96.4782 19.5929C96.9516 19.4348 97.425 19.7509 97.5828 20.225L98.7663 23.9386C98.8452 24.3337 98.6085 24.8868 98.214 25.0448Z"
            fill="#DAE6F2"
        />
        <path
            d="M104.684 22.9905L101.213 24.0967C100.739 24.2547 100.266 23.9387 100.108 23.4646L98.9247 19.7509C98.7669 19.2768 99.0036 18.8027 99.477 18.6447L102.949 17.6175C103.422 17.4595 103.895 17.7756 104.053 18.2496L105.158 21.8843C105.316 22.3584 105.079 22.8325 104.684 22.9905Z"
            fill="#DAE6F2"
        />
        <path
            d="M110.996 21.0151L107.603 22.0423C107.13 22.2004 106.657 21.8843 106.578 21.4102L105.473 17.7756C105.315 17.3015 105.552 16.8274 106.025 16.6694L109.418 15.6422C109.891 15.4842 110.286 15.8002 110.444 16.2743L111.548 19.9089C111.627 20.383 111.391 20.8571 110.996 21.0151Z"
            fill="#DAE6F2"
        />
        <path
            d="M100.345 31.919L96.8729 33.0252C96.3995 33.1833 95.9261 32.9462 95.7683 32.4721L94.5848 28.8375C94.427 28.3634 94.6637 27.8893 95.1371 27.7313L98.6876 26.6251C99.161 26.4671 99.6344 26.7831 99.7922 27.2572L100.976 30.8919C101.055 31.2869 100.818 31.761 100.345 31.919Z"
            fill="#DAE6F2"
        />
        <path
            d="M106.815 29.7857L103.422 30.8919C102.949 31.0499 102.475 30.8129 102.317 30.3388L101.213 26.7041C101.055 26.2301 101.292 25.756 101.765 25.598L105.237 24.4918C105.71 24.3337 106.183 24.6498 106.262 25.0449L107.367 28.6795C107.446 29.1536 107.209 29.7067 106.815 29.7857Z"
            fill="#DAE6F2"
        />
        <path
            d="M113.048 27.8103L109.734 28.9165C109.339 29.0745 108.866 28.8375 108.708 28.3634L107.603 24.8078C107.446 24.3337 107.682 23.8596 108.156 23.7016L111.548 22.6744C111.943 22.5163 112.416 22.8324 112.574 23.2275L113.679 26.7831C113.679 27.1782 113.442 27.6523 113.048 27.8103Z"
            fill="#DAE6F2"
        />
        <path
            d="M102.476 38.6352L99.0043 39.8204C98.5309 39.9784 98.0575 39.7414 97.8997 39.2673L96.7162 35.6326C96.5584 35.1586 96.7951 34.6845 97.2685 34.5264L100.74 33.3412C101.213 33.1832 101.687 33.4202 101.845 33.8943L102.949 37.45C103.186 37.9241 102.949 38.4772 102.476 38.6352Z"
            fill="white"
        />
        <path
            d="M108.866 36.423L105.473 37.6082C105 37.7662 104.527 37.5292 104.448 37.0551L103.343 33.4994C103.185 33.0253 103.422 32.5513 103.895 32.3932L107.288 31.287C107.762 31.129 108.156 31.3661 108.314 31.8401L109.418 35.3958C109.497 35.7908 109.261 36.2649 108.866 36.423Z"
            fill="#DAE6F2"
        />
        <path
            d="M115.02 34.3687L111.706 35.4749C111.312 35.6329 110.838 35.3959 110.681 34.9218L109.576 31.3661C109.418 30.892 109.655 30.418 110.128 30.2599L113.442 29.1537C113.837 28.9957 114.31 29.2328 114.468 29.7068L115.494 33.2625C115.651 33.7366 115.415 34.2106 115.02 34.3687Z"
            fill="#DAE6F2"
        />
        <path
            d="M104.605 45.2725L101.213 46.4577C100.739 46.6157 100.266 46.3787 100.108 45.9046L98.9247 42.349C98.7669 41.8749 99.0036 41.4008 99.477 41.2428L102.949 40.0575C103.422 39.8995 103.895 40.1366 103.974 40.6106L105.079 44.1663C105.316 44.6404 105.079 45.1144 104.605 45.2725Z"
            fill="#DAE6F2"
        />
        <path
            d="M110.917 43.0601L107.603 44.2453C107.209 44.4033 106.735 44.1663 106.578 43.6922L105.473 40.1366C105.315 39.6625 105.552 39.1884 106.025 39.0304L109.418 37.8451C109.813 37.6871 110.286 37.9242 110.444 38.3982L111.548 41.8749C111.548 42.428 111.312 42.9021 110.917 43.0601Z"
            fill="#DAE6F2"
        />
        <path
            d="M116.993 40.9267L113.758 42.1119C113.364 42.27 112.89 42.0329 112.732 41.5588L111.628 38.0822C111.47 37.6081 111.707 37.134 112.18 36.976L115.494 35.8698C115.888 35.7118 116.362 35.9488 116.52 36.4229L117.545 39.8995C117.624 40.2946 117.466 40.7687 116.993 40.9267Z"
            fill="#DAE6F2"
        />
        <path
            d="M106.656 51.7517L103.263 53.0159C102.79 53.1739 102.317 52.9369 102.238 52.4628L101.133 48.9862C100.975 48.5121 101.212 48.038 101.685 47.88L105.078 46.6948C105.552 46.5367 105.946 46.7738 106.104 47.2479L107.208 50.7245C107.366 51.1195 107.13 51.5936 106.656 51.7517Z"
            fill="#DAE6F2"
        />
        <path
            d="M112.89 49.4603L109.576 50.6455C109.182 50.8036 108.709 50.5665 108.551 50.0924L107.446 46.6158C107.288 46.1417 107.525 45.6676 107.998 45.5096L111.312 44.3244C111.707 44.1664 112.18 44.4034 112.338 44.8775L113.443 48.3541C113.521 48.8282 113.285 49.3023 112.89 49.4603Z"
            fill="#DAE6F2"
        />
        <path
            d="M118.886 47.2479L115.651 48.4331C115.257 48.5911 114.783 48.3541 114.626 47.88L113.6 44.4034C113.442 43.9293 113.679 43.4552 114.152 43.2972L117.387 42.112C117.782 41.954 118.255 42.191 118.413 42.6651L119.439 46.0627C119.596 46.6158 119.36 47.0899 118.886 47.2479Z"
            fill="#DAE6F2"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M105.218 33.7174C113.859 31.005 122.695 27.9648 128.354 25.6771C129.616 25.124 130.405 23.8598 130.011 22.5956C130.011 22.5956 129.064 11.8497 124.172 2.13091C123.541 0.866682 122.357 -0.00247392 121.016 0.392597C121.016 0.392597 97.4247 5.52852 84.1694 10.6644C82.8281 11.2175 82.1969 12.4818 82.4336 13.904C83.7749 23.7018 86.063 29.4698 89.1401 35.87C89.7713 37.1342 91.0337 37.9243 92.375 37.5293C93.4849 37.2227 94.6371 36.8967 95.8208 36.5549C95.6789 38.634 95.0527 40.6634 94.5056 42.0332C94.2689 42.7443 94.979 43.3765 95.6102 43.0604C101.21 40.3637 103.914 36.6003 105.218 33.7174Z"
            fill="#70D164"
        />
        <path
            d="M119.753 14.0621C119.122 13.9831 118.411 13.9831 117.622 14.1411C117.78 14.0621 118.017 13.9831 118.175 13.9041C118.806 13.509 119.279 13.1139 119.516 12.5608C119.753 12.0867 119.832 11.4546 119.595 10.8225C119.279 9.79532 118.648 9.24222 117.544 9.08419C116.518 8.92616 115.019 9.16321 113.204 9.71631L112.888 9.79532L110.206 10.5855L108.943 10.9805L112.336 22.2005L113.598 21.8055L116.281 20.9363L116.597 20.8573C117.701 20.4622 118.727 20.0672 119.516 19.5931C120.305 19.119 120.936 18.5659 121.331 17.9338C121.725 17.3017 121.804 16.5905 121.567 15.8004C121.252 14.7732 120.7 14.2201 119.753 14.0621ZM114.861 12.0077C115.176 11.9287 115.413 11.9287 115.571 12.0077C115.729 12.0867 115.887 12.2448 115.965 12.5608C116.044 12.8769 116.044 13.1139 115.808 13.351C115.65 13.509 115.334 13.667 115.019 13.746L114.151 13.9831L113.677 12.4028L114.861 12.0077ZM117.465 17.4597C117.307 17.6967 116.991 17.8548 116.597 18.0128L115.492 18.3289L114.861 16.3535L115.808 16.0374C116.281 15.8794 116.676 15.8794 116.912 15.9584C117.228 16.0374 117.386 16.2745 117.465 16.5905C117.701 16.9066 117.701 17.2227 117.465 17.4597Z"
            fill="white"
        />
        <path
            d="M91.8223 19.5931L92.9269 23.1488L94.8205 19.8302L97.1086 27.3365L100.896 26.0723L97.5031 14.6152L94.1104 15.6424L91.8223 19.5931Z"
            fill="white"
        />
        <path
            d="M105.235 21.8054C105.551 21.4893 105.867 21.0943 106.103 20.7782C106.656 20.1461 107.05 19.514 107.445 18.8819C107.76 18.2497 107.997 17.6966 108.076 17.0645C108.155 16.5114 108.155 15.8793 107.918 15.2472C107.681 14.4571 107.366 13.904 106.813 13.4299C106.34 12.9558 105.709 12.7188 104.999 12.6397C104.289 12.5607 103.421 12.6397 102.474 12.8768C101.685 13.1138 100.975 13.4299 100.501 13.825C99.9491 14.22 99.5546 14.5361 99.3179 14.8521L100.107 17.5386C100.344 17.2226 100.659 16.8275 101.054 16.5114C101.448 16.1954 101.843 15.9583 102.395 15.8003C102.711 15.7213 102.947 15.7213 103.184 15.7213C103.421 15.8003 103.657 15.8793 103.815 16.0373C103.973 16.1954 104.131 16.5114 104.21 16.8275C104.289 17.1435 104.289 17.4596 104.289 17.8547C104.21 18.1707 104.052 18.5658 103.815 19.0399C103.578 19.514 103.263 19.9881 102.868 20.5412C102.474 21.0943 102 21.8054 101.448 22.5165L102.316 25.44L110.206 22.8326L109.417 20.3041L105.235 21.8054Z"
            fill="white"
        />
        <defs>
            <linearGradient
                id="fe7170d7__paint0_linear_9962_575"
                x1={42.0307}
                y1={4.61909}
                x2={53.3058}
                y2={5.66692}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.0908376} stopColor="#0065D9" />
                <stop offset={0.7003} stopColor="#027BF3" />
            </linearGradient>
        </defs>
    </svg>
);

export default CovidAviaL;
