import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CovidAviaS = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 153 79"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <path
            d="M88.0899 0.943816C72.858 1.06992 54.8452 2.96147 35.8211 13.9325C9.14942 29.3171 -2.66953 36.8833 0.68023 49.2414C4.85162 64.626 37.5908 76.6059 68.8762 76.5428C82.3385 76.4798 96.3695 74.6513 108.504 69.6702C169.306 44.8278 138.652 0.565505 88.0899 0.943816Z"
            fill="#EDF2F7"
        />
        <path
            d="M115.963 39.0269C116.153 40.2249 116.848 41.2968 117.859 41.9904C118.934 42.6839 120.134 42.9362 121.335 42.6839L137.136 39.5944C138.969 39.2161 140.675 38.5225 142.256 37.5137C143.646 36.5679 145.289 35.9374 146.933 35.6222L150.914 34.8655C151.61 34.7394 152.115 34.2981 152.494 33.7937C152.874 33.2262 153.063 32.5957 152.874 31.9021C152.684 31.2085 152.305 30.7041 151.799 30.3258C151.23 29.9475 150.598 29.7583 149.903 29.9475L145.921 30.7041C144.278 31.0194 142.508 31.0194 140.865 30.7041C139.032 30.3258 137.136 30.3258 135.303 30.6411L119.566 33.6675C117.101 34.1089 115.457 36.5679 115.963 39.0269ZM150.219 31.0194C150.914 30.8933 151.61 31.3977 151.736 32.0282C151.799 32.3435 151.673 32.7218 151.483 33.037C151.294 33.3523 151.041 33.5414 150.662 33.6045L147.312 34.235L146.806 31.6499L150.219 31.0194ZM119.818 34.8655L135.682 31.776C137.326 31.4607 139.095 31.4607 140.739 31.776C142.382 32.0913 144.088 32.1543 145.795 31.9021L146.301 34.5503C144.657 34.9286 143.077 35.5591 141.687 36.5679C140.296 37.5137 138.716 38.2073 137.01 38.4595L121.146 41.486C120.261 41.6751 119.313 41.486 118.618 40.9815C117.859 40.4771 117.354 39.6575 117.227 38.7747C116.722 36.9462 117.922 35.1808 119.818 34.8655Z"
            fill="#00E6C5"
        />
        <path
            d="M128.224 38.0812C128.287 38.3965 128.604 38.5856 128.92 38.5226L137.705 36.8202C138.021 36.7571 138.21 36.4419 138.147 36.1266L137.642 33.4154C137.578 33.2262 137.515 33.1632 137.389 33.0371C137.262 32.911 137.136 32.911 136.946 32.974L128.161 34.6764C127.845 34.7395 127.655 35.0547 127.719 35.37L128.224 38.0812ZM136.63 34.2351L136.946 35.8114L129.299 37.3246L128.983 35.7483L136.63 34.2351Z"
            fill="#00E6C5"
        />
        <path
            d="M121.209 38.6487L125.76 37.7659C126.076 37.7029 126.266 37.3876 126.202 37.0724C126.139 36.8832 126.076 36.7571 125.95 36.6941C125.823 36.568 125.697 36.568 125.507 36.631L120.956 37.5137C120.64 37.5768 120.451 37.892 120.514 38.2073C120.577 38.5226 120.893 38.7117 121.209 38.6487Z"
            fill="#00E6C5"
        />
        <path
            d="M36.5815 6.36633C36.6447 6.36633 33.4214 6.17718 33.4214 6.17718C33.4214 6.17718 36.2655 -0.127996 42.9018 2.39407C37.5928 2.20492 36.5815 6.36633 36.5815 6.36633Z"
            fill="url(#0a0217d8__paint0_linear_9962_574)"
        />
        <path
            d="M13.1958 40.6665C17.7464 49.1785 23.1819 54.4118 33.4208 55.4837C37.2762 55.9251 45.0501 55.1684 46.883 54.4118C53.9617 51.3853 56.8691 17.3374 53.0137 10.78C49.1583 4.22266 32.2831 3.08773 26.342 5.7359C20.401 8.38407 7.94998 30.8935 13.1958 40.6665Z"
            fill="#FFD34D"
        />
        <path
            d="M47.073 9.26676L43.976 8.38404C44.2921 5.60976 43.5336 2.96159 40.2471 1.82666C47.1362 2.64633 47.389 7.43826 47.073 9.26676Z"
            fill="#66B3FF"
        />
        <path
            d="M28.554 12.4825C28.1748 12.7347 27.29 15.1937 27.606 15.6351C27.922 16.0134 32.8518 17.0222 33.1679 16.833C33.4839 16.6439 34.5583 13.7435 34.2423 13.4282C33.9263 13.113 28.9333 12.2303 28.554 12.4825Z"
            fill="#0066DA"
        />
        <path
            d="M33.1683 54.2857C38.6037 52.0159 42.3959 28.4976 40.9422 24.3992C39.4885 20.2378 19.39 17.0221 15.5346 19.8595C10.668 23.3904 6.3702 39.5947 6.74942 44.828C7.19184 49.9982 27.7328 56.4925 33.1683 54.2857Z"
            fill="#FFD34D"
            stroke="#FAAC1A"
            strokeWidth={1.30973}
            strokeMiterlimit={10}
        />
        <path
            d="M50.9915 32.0915C51.4972 28.6867 51.75 25.1558 51.8132 21.688C51.8132 19.8595 51.8132 17.9679 51.6236 16.1394C51.4972 14.8153 51.2444 13.4282 50.6123 12.2302C49.9803 11.0322 48.7162 10.0865 47.6418 9.3929C46.2513 8.51018 44.7344 7.87966 43.2176 7.31219C39.931 6.24032 36.4549 5.67285 32.9787 5.48369C31.3986 5.42064 29.8186 5.35759 28.2385 5.48369C27.2904 5.54675 26.216 5.6098 25.3311 6.05116C24.6991 6.36642 25.2679 7.24914 25.9 6.99694C26.4056 6.74473 27.3536 6.68168 28.0489 6.61863C29.3129 6.49252 30.577 6.49252 31.841 6.55557C35.0644 6.68168 38.351 7.12304 41.4479 7.94271C44.292 8.76238 47.4522 9.96037 49.3483 12.2933C50.1067 13.176 50.2963 14.374 50.4859 15.5089C50.7387 17.2113 50.8019 18.9137 50.8019 20.6161C50.8019 24.3362 50.5491 28.1193 49.9803 31.8393C49.8539 32.4698 50.8651 32.7851 50.9915 32.0915Z"
            fill="#FAAC1A"
        />
        <path
            d="M36.9841 30.4216C32.3311 29.817 27.6874 29.0234 23.1191 27.981C21.1775 27.5712 19.239 27.0983 17.3036 26.5625C15.9933 26.1833 14.683 25.804 13.4451 25.2389C12.8262 24.9564 12.2149 25.8105 12.8308 26.156C14.0656 26.7841 15.439 27.1664 16.7493 27.5456C18.7478 28.0845 20.7495 28.5604 22.7511 29.0363C27.4456 30.0848 32.1525 30.8815 36.8656 31.5521C37.6231 31.5889 37.6755 30.5183 36.9841 30.4216Z"
            fill="#FAAC1A"
        />
        <path
            d="M36.5815 30.7043C37.6559 31.2717 37.4663 35.8745 37.0239 36.5681C36.5183 37.2616 33.6109 36.9464 33.6109 35.8115C33.5477 34.7396 35.4438 30.1368 36.5815 30.7043Z"
            fill="#FAAC1A"
        />
        <path
            d="M78.7366 78.3084C78.7366 78.3084 99.4039 69.8595 126.265 56.9339C127.087 56.5555 127.592 55.7359 127.656 55.2315C127.782 54.664 127.972 53.2138 127.972 53.2138L104.207 43.8191L55.6675 60.2756C55.6675 60.2756 55.9203 61.6627 56.0467 62.1671C56.1731 62.6716 56.4891 63.3021 56.8683 63.6804L72.5427 77.4257C74.2492 78.8758 76.6509 79.2542 78.7366 78.3084Z"
            fill="#4E9CE9"
        />
        <path
            d="M78.7363 75.7863L127.213 54.2857C128.224 53.8443 128.224 52.3942 127.213 51.9528L104.207 41.3601L55.7305 60.2756L72.6057 74.9036C74.2489 76.3538 76.6507 76.7321 78.7363 75.7863Z"
            fill="#66B3FF"
        />
        <path
            d="M104.208 41.3599L94.6643 7.18587C94.1587 5.48347 92.389 4.47464 90.6825 4.97906L45.2396 18.4721C43.4699 18.9765 42.5218 20.8681 43.0907 22.5705L55.7313 60.2754L104.208 41.3599Z"
            fill="#0066DA"
        />
        <path
            d="M100.858 37.892L92.7044 9.14046C92.5148 8.44689 91.7564 8.00553 91.0612 8.25773L47.4511 21.1833C46.6927 21.3725 46.3135 22.1922 46.5663 22.8857L57.6268 54.0333C57.8796 54.7269 58.638 55.1052 59.3333 54.853L100.099 39.5314C100.731 39.2792 101.047 38.5856 100.858 37.892Z"
            fill="white"
        />
        <path
            d="M71.911 68.157L115.584 49.8089L103.513 44.1343L62.3042 60.2125L71.911 68.157Z"
            fill="#0066DA"
        />
        <path
            d="M58.2601 26.2905L55.1632 27.2363C54.784 27.3624 54.3416 27.1733 54.152 26.7319L53.0775 23.6424C52.9511 23.2641 53.1407 22.8227 53.5831 22.6966L56.6801 21.7508C57.0593 21.6247 57.5017 21.8769 57.6281 22.2552L58.7026 25.2817C58.8922 25.7861 58.6394 26.1644 58.2601 26.2905Z"
            fill="#DAE6F2"
        />
        <path
            d="M62.6214 20.6789C62.6846 20.6789 62.7478 20.7419 62.7478 20.7419L63.759 23.7684V23.8314C63.759 23.8314 63.6958 23.8314 63.6958 23.8945L60.6621 24.8403C60.6621 24.8403 60.6621 24.8403 60.5989 24.8403C60.5357 24.8403 60.4725 24.8403 60.4725 24.7772L59.5244 21.7507C59.5244 21.6877 59.5244 21.6877 59.5244 21.6877C59.5244 21.6877 59.5244 21.6877 59.5876 21.6246L62.6214 20.6789ZM62.6214 20.0483C62.5582 20.0483 62.495 20.0483 62.4318 20.0483L59.398 20.9941C59.0188 21.1202 58.766 21.4985 58.9556 21.9399L60.03 24.9664C60.1565 25.2816 60.4725 25.4708 60.7885 25.4708C60.8517 25.4708 60.9149 25.4708 61.0413 25.4077L64.075 24.462C64.4543 24.3359 64.6439 23.9575 64.5175 23.5162L63.5062 20.4897C63.2534 20.3005 62.9374 20.0483 62.6214 20.0483Z"
            fill="#027BF3"
        />
        <path
            d="M69.4473 22.8226L66.4768 23.7684C66.0976 23.8945 65.6552 23.6423 65.5288 23.264L64.5175 20.2375C64.3911 19.8592 64.5807 19.4179 64.9599 19.2917L67.9305 18.409C68.3097 18.2829 68.7521 18.5351 68.8785 18.9134L69.8898 21.8769C70.0794 22.3182 69.8266 22.6965 69.4473 22.8226Z"
            fill="#DAE6F2"
        />
        <path
            d="M58.9547 28.1823C59.0179 28.1823 59.0811 28.1823 59.0811 28.2453L60.1555 31.2718V31.3349C60.1555 31.3349 60.1555 31.3979 60.0923 31.3979L56.9954 32.4067C56.9954 32.4067 56.9954 32.4067 56.9322 32.4067C56.869 32.4067 56.8058 32.4067 56.8058 32.3437L55.7313 29.3172V29.2542C55.7313 29.2542 55.7313 29.1911 55.7945 29.1911L58.9547 28.1823ZM58.9547 27.5518C58.8915 27.5518 58.8283 27.5518 58.7019 27.6148L55.6049 28.5606C55.2257 28.6867 54.9729 29.1281 55.0993 29.5064L56.1737 32.5328C56.3001 32.8481 56.553 33.0373 56.9322 33.0373C56.9954 33.0373 57.1218 33.0373 57.185 32.9742L60.2187 31.9654C60.5979 31.8393 60.7875 31.3979 60.6611 31.0196L59.5867 27.9931C59.5867 27.7409 59.2707 27.5518 58.9547 27.5518Z"
            fill="#027BF3"
        />
        <path
            d="M65.8443 30.1998L62.8738 31.1455C62.4946 31.2716 62.0521 31.0825 61.9257 30.7042L60.9145 27.6777C60.7881 27.2994 60.9777 26.858 61.3569 26.7319L64.3907 25.7862C64.7699 25.6601 65.2123 25.8492 65.3387 26.2906L66.3499 29.254C66.4764 29.6323 66.2235 30.0737 65.8443 30.1998Z"
            fill="#DAE6F2"
        />
        <path
            d="M71.3436 28.4343L68.4363 29.3801C68.0571 29.5062 67.6778 29.3171 67.4882 28.9387L66.477 25.9753C66.3506 25.597 66.5402 25.1556 66.9194 25.0926L69.89 24.1468C70.2692 24.0207 70.6484 24.2729 70.7748 24.6512L71.7228 27.6147C71.9125 27.8669 71.7228 28.3082 71.3436 28.4343Z"
            fill="#DAE6F2"
        />
        <path
            d="M62.1782 37.5137L59.1445 38.5226C58.7653 38.6487 58.3229 38.4595 58.1965 38.0812L57.122 35.1178C56.9956 34.7395 57.1852 34.2981 57.5644 34.172L60.5982 33.1632C60.9774 33.0371 61.4198 33.2262 61.5462 33.6045L62.5575 36.568C62.8103 37.0093 62.5575 37.3876 62.1782 37.5137Z"
            fill="#DAE6F2"
        />
        <path
            d="M67.7408 35.6853L64.7703 36.6941C64.391 36.8202 63.9486 36.6311 63.8222 36.2528L62.811 33.2893C62.6846 32.911 62.8742 32.4697 63.2534 32.3436L66.2239 31.3978C66.6031 31.2717 67.0456 31.4608 67.172 31.8392L68.1832 34.8026C68.3096 35.1178 68.12 35.5592 67.7408 35.6853Z"
            fill="#DAE6F2"
        />
        <path
            d="M73.1124 33.8569L70.2051 34.8027C69.8259 34.9288 69.4467 34.7396 69.3203 34.3613L68.309 31.4609C68.1826 31.0826 68.3722 30.7043 68.7514 30.5782L71.6588 29.6324C72.038 29.5063 72.4172 29.6955 72.5436 30.0738L73.4917 32.9742C73.6813 33.2894 73.4917 33.7308 73.1124 33.8569Z"
            fill="#DAE6F2"
        />
        <path
            d="M64.1383 43.0623L61.1677 44.1341C60.7885 44.2602 60.3461 44.0711 60.2197 43.6928L59.2084 40.7293C59.082 40.351 59.2716 39.9097 59.6509 39.7836L62.6846 38.7747C63.0638 38.6486 63.5062 38.8378 63.6326 39.2161L64.6439 42.1165C64.7071 42.4948 64.5175 42.9362 64.1383 43.0623Z"
            fill="#DAE6F2"
        />
        <path
            d="M69.5736 41.1709L66.6663 42.1797C66.287 42.3058 65.8446 42.1167 65.7182 41.7384L64.707 38.838C64.5806 38.4597 64.7702 38.0814 65.1494 37.8922L68.1199 36.8834C68.4992 36.7573 68.8784 36.9464 69.0048 37.3248L70.016 40.2251C70.1424 40.6034 69.9528 41.0448 69.5736 41.1709Z"
            fill="#DAE6F2"
        />
        <path
            d="M74.9455 39.2792L72.1014 40.2881C71.7222 40.4142 71.3429 40.225 71.2165 39.8467L70.2685 36.9463C70.1421 36.568 70.3317 36.1897 70.7109 36.0636L73.6183 35.0548C73.9975 34.9287 74.3767 35.1178 74.5031 35.4961L75.4511 38.3335C75.5144 38.7118 75.3247 39.1531 74.9455 39.2792Z"
            fill="#027BF3"
        />
        <path
            d="M65.9708 48.3587L63.0002 49.4305C62.621 49.5566 62.1786 49.3675 62.0522 48.9892L61.041 46.0888C60.9145 45.7105 61.1042 45.2691 61.4834 45.143L64.4539 44.0711C64.8331 43.945 65.2756 44.1342 65.402 44.5125L66.4132 47.4129C66.5396 47.8542 66.35 48.2325 65.9708 48.3587Z"
            fill="#DAE6F2"
        />
        <path
            d="M71.4064 46.4041L68.499 47.476C68.1198 47.6021 67.7406 47.4129 67.6142 47.0346L66.603 44.1973C66.4766 43.819 66.6662 43.4407 67.0454 43.3146L69.9527 42.3058C70.3319 42.1796 70.7112 42.3688 70.8376 42.7471L71.7856 45.5844C71.9752 45.8366 71.7856 46.278 71.4064 46.4041Z"
            fill="#DAE6F2"
        />
        <path
            d="M76.6521 44.4496L73.8079 45.4584C73.4287 45.5845 73.0495 45.3954 72.9231 45.017L71.975 42.1797C71.8486 41.8014 72.0382 41.4231 72.4175 41.297L75.2616 40.2882C75.6408 40.1621 76.02 40.3512 76.1464 40.7295L77.0945 43.5669C77.2209 43.9452 77.0313 44.3235 76.6521 44.4496Z"
            fill="#DAE6F2"
        />
        <path
            d="M78.6745 19.9854L75.8304 20.8681C75.4512 20.9943 75.0719 20.742 74.9455 20.3637L73.9975 17.4003C73.8711 17.022 74.0607 16.6437 74.4399 16.5176L77.284 15.6349C77.6633 15.5088 78.0425 15.761 78.1689 16.1393L79.1169 19.1027C79.1801 19.418 78.9905 19.8593 78.6745 19.9854Z"
            fill="#DAE6F2"
        />
        <path
            d="M83.8574 18.3462L81.0765 19.2289C80.6973 19.355 80.318 19.1028 80.1916 18.7245L79.2436 15.7611C79.1172 15.3828 79.3068 15.0045 79.686 14.8784L82.467 14.0587C82.8462 13.9326 83.2254 14.1848 83.3518 14.5631L84.2366 17.4635C84.363 17.8418 84.1734 18.2201 83.8574 18.3462Z"
            fill="#DAE6F2"
        />
        <path
            d="M88.9134 16.7698L86.1957 17.5895C85.8165 17.7156 85.4372 17.4634 85.374 17.085L84.4892 14.1847C84.3628 13.8064 84.5524 13.428 84.9316 13.3019L87.6493 12.4823C88.0286 12.3562 88.3446 12.6084 88.471 12.9867L89.3558 15.8871C89.419 16.2654 89.2294 16.6437 88.9134 16.7698Z"
            fill="#DAE6F2"
        />
        <path
            d="M80.3813 25.4709L77.6004 26.3536C77.2212 26.4797 76.842 26.2906 76.7156 25.9122L75.7675 23.0119C75.6411 22.6336 75.8307 22.2553 76.2099 22.1291L79.0541 21.2464C79.4333 21.1203 79.8125 21.3725 79.9389 21.7508L80.8869 24.6512C80.9502 24.9665 80.7605 25.3448 80.3813 25.4709Z"
            fill="#DAE6F2"
        />
        <path
            d="M85.564 23.7686L82.8463 24.6513C82.4671 24.7774 82.0878 24.5883 81.9614 24.21L81.0766 21.3096C80.9502 20.9313 81.1398 20.553 81.519 20.4269L84.2999 19.5441C84.6792 19.418 85.0584 19.6703 85.1216 19.9855L86.0064 22.8859C86.0696 23.2642 85.88 23.7056 85.564 23.7686Z"
            fill="#DAE6F2"
        />
        <path
            d="M90.5563 22.1923L87.9017 23.075C87.5857 23.2011 87.2065 23.012 87.0801 22.6337L86.1952 19.7964C86.0688 19.418 86.2585 19.0397 86.6377 18.9136L89.3554 18.094C89.6714 17.9679 90.0506 18.2201 90.177 18.5353L91.0619 21.3726C91.0619 21.6879 90.8723 22.0662 90.5563 22.1923Z"
            fill="#DAE6F2"
        />
        <path
            d="M82.0879 30.8303L79.3069 31.776C78.9277 31.9021 78.5485 31.713 78.4221 31.3347L77.4741 28.4343C77.3477 28.056 77.5373 27.6777 77.9165 27.5516L80.6974 26.6058C81.0766 26.4797 81.4558 26.6689 81.5822 27.0472L82.4671 29.8845C82.6567 30.2628 82.4671 30.7042 82.0879 30.8303Z"
            fill="white"
        />
        <path
            d="M87.2069 29.0648L84.4891 30.0105C84.1099 30.1366 83.7307 29.9475 83.6675 29.5692L82.7827 26.7318C82.6562 26.3535 82.8459 25.9752 83.2251 25.8491L85.9428 24.9664C86.322 24.8403 86.638 25.0294 86.7644 25.4078L87.6493 28.2451C87.7125 28.5603 87.5229 28.9387 87.2069 29.0648Z"
            fill="#DAE6F2"
        />
        <path
            d="M92.1368 27.4254L89.4823 28.3081C89.1663 28.4342 88.7871 28.2451 88.6607 27.8668L87.7758 25.0295C87.6494 24.6511 87.839 24.2728 88.2182 24.1467L90.8728 23.264C91.1888 23.1379 91.568 23.3271 91.6944 23.7054L92.516 26.5427C92.6424 26.921 92.4528 27.2993 92.1368 27.4254Z"
            fill="#DAE6F2"
        />
        <path
            d="M83.7942 36.1266L81.0765 37.0724C80.6973 37.1985 80.318 37.0093 80.1916 36.631L79.2436 33.7937C79.1172 33.4154 79.3068 33.0371 79.686 32.911L82.4669 31.9652C82.8462 31.8391 83.2254 32.0282 83.2886 32.4065L84.1734 35.2439C84.363 35.6222 84.1734 36.0005 83.7942 36.1266Z"
            fill="#DAE6F2"
        />
        <path
            d="M88.8502 34.3612L86.1957 35.307C85.8797 35.4331 85.5004 35.2439 85.374 34.8656L84.4892 32.0283C84.3628 31.65 84.5524 31.2717 84.9316 31.1456L87.6493 30.1998C87.9654 30.0737 88.3446 30.2628 88.471 30.6412L89.3558 33.4154C89.3558 33.8568 89.1662 34.2351 88.8502 34.3612Z"
            fill="#DAE6F2"
        />
        <path
            d="M93.7172 32.6589L91.1258 33.6047C90.8098 33.7308 90.4306 33.5417 90.3042 33.1633L89.4194 30.3891C89.293 30.0108 89.4826 29.6325 89.8618 29.5063L92.5163 28.6236C92.8323 28.4975 93.2115 28.6867 93.3379 29.065L94.1596 31.8393C94.2228 32.1545 94.0964 32.5328 93.7172 32.6589Z"
            fill="#DAE6F2"
        />
        <path
            d="M85.4368 41.2969L82.7191 42.3057C82.3399 42.4318 81.9607 42.2426 81.8975 41.8643L81.0126 39.0901C80.8862 38.7118 81.0758 38.3334 81.4551 38.2073L84.1728 37.2616C84.552 37.1355 84.868 37.3246 84.9944 37.7029L85.8793 40.4772C86.0057 40.7925 85.8161 41.1708 85.4368 41.2969Z"
            fill="#DAE6F2"
        />
        <path
            d="M90.4303 39.4683L87.7758 40.4141C87.4597 40.5402 87.0805 40.351 86.9541 39.9727L86.0693 37.1985C85.9429 36.8202 86.1325 36.4418 86.5117 36.3157L89.1662 35.37C89.4822 35.2439 89.8614 35.433 89.9879 35.8113L90.8727 38.5856C90.9359 38.9639 90.7463 39.3422 90.4303 39.4683Z"
            fill="#DAE6F2"
        />
        <path
            d="M95.2335 37.7029L92.6422 38.6487C92.3262 38.7748 91.947 38.5857 91.8206 38.2074L90.999 35.4331C90.8726 35.0548 91.0622 34.6765 91.4414 34.5504L94.0327 33.6046C94.3487 33.4785 94.7279 33.6676 94.8543 34.0459L95.676 36.7572C95.8024 37.1985 95.6128 37.5768 95.2335 37.7029Z"
            fill="#DAE6F2"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M84.2842 26.9059C91.2063 24.7415 98.2843 22.3154 102.817 20.4899C103.829 20.0485 104.461 19.0397 104.145 18.0309C104.145 18.0309 103.386 9.45585 99.4676 1.70048C98.962 0.691657 98.0139 -0.00191247 96.9395 0.313346C96.9395 0.313346 78.0418 4.41171 67.4237 8.51007C66.3493 8.95143 65.8436 9.96026 66.0333 11.0952C67.1077 18.9136 68.9406 23.5164 71.4055 28.6236C71.9111 29.6324 72.9224 30.2629 73.9968 29.9477C74.8858 29.703 75.8087 29.4429 76.7569 29.1702C76.6432 30.8292 76.1417 32.4486 75.7034 33.5417C75.5138 34.1091 76.0826 34.6135 76.5882 34.3613C81.0735 32.2094 83.2403 29.2064 84.2842 26.9059Z"
            fill="#70D164"
        />
        <path
            d="M95.9278 11.2213C95.4222 11.1583 94.8534 11.1583 94.2214 11.2844C94.3478 11.2213 94.5374 11.1583 94.6638 11.0952C95.1694 10.7799 95.5486 10.4647 95.7382 10.0233C95.9278 9.64501 95.991 9.1406 95.8014 8.63618C95.5486 7.81651 95.043 7.37515 94.1582 7.24904C93.3365 7.12294 92.1357 7.3121 90.682 7.75346L90.4292 7.81651L88.2803 8.44703L87.269 8.76229L89.9868 17.7156L90.998 17.4004L93.1469 16.7068L93.3997 16.6438C94.2846 16.3285 95.1062 16.0132 95.7382 15.6349C96.3703 15.2566 96.8759 14.8153 97.1919 14.3108C97.5079 13.8064 97.5711 13.239 97.3815 12.6084C97.1287 11.7888 96.6863 11.3474 95.9278 11.2213ZM92.0093 9.58196C92.2621 9.51891 92.4517 9.51891 92.5781 9.58196C92.7045 9.64501 92.8309 9.77111 92.8941 10.0233C92.9573 10.2755 92.9573 10.4647 92.7677 10.6538C92.6413 10.7799 92.3885 10.906 92.1357 10.9691L91.4404 11.1583L91.0612 9.89722L92.0093 9.58196ZM94.095 13.9325C93.9685 14.1217 93.7157 14.2478 93.3997 14.3739L92.5149 14.6261L92.0093 13.0498L92.7677 12.7976C93.1469 12.6715 93.4629 12.6715 93.6525 12.7345C93.9053 12.7976 94.0318 12.9868 94.095 13.239C94.2846 13.4912 94.2846 13.7434 94.095 13.9325Z"
            fill="white"
        />
        <path
            d="M73.5542 15.6349L74.439 18.4722L75.9559 15.824L77.7888 21.8139L80.8225 20.8051L78.1048 11.6626L75.3871 12.4823L73.5542 15.6349Z"
            fill="white"
        />
        <path
            d="M84.2988 17.4004C84.5516 17.1482 84.8044 16.8329 84.994 16.5807C85.4365 16.0763 85.7525 15.5719 86.0685 15.0675C86.3213 14.5631 86.5109 14.1217 86.5741 13.6173C86.6373 13.1759 86.6373 12.6715 86.4477 12.1671C86.2581 11.5366 86.0053 11.0952 85.5629 10.7169C85.1837 10.3386 84.678 10.1494 84.1092 10.0864C83.5404 10.0233 82.8451 10.0864 82.0867 10.2755C81.4547 10.4647 80.8859 10.7169 80.5066 11.0322C80.0642 11.3474 79.7482 11.5996 79.5586 11.8518L80.1906 13.9956C80.3802 13.7434 80.633 13.4281 80.9491 13.1759C81.2651 12.9237 81.5811 12.7346 82.0235 12.6085C82.2763 12.5454 82.4659 12.5454 82.6555 12.5454C82.8451 12.6085 83.0348 12.6715 83.1612 12.7976C83.2876 12.9237 83.414 13.1759 83.4772 13.4281C83.5404 13.6803 83.5404 13.9325 83.5404 14.2478C83.4772 14.5 83.3508 14.8153 83.1612 15.1936C82.9715 15.5719 82.7187 15.9502 82.4027 16.3916C82.0867 16.8329 81.7075 17.4004 81.2651 17.9679L81.9603 20.3008L88.2806 18.2201L87.6486 16.2024L84.2988 17.4004Z"
            fill="white"
        />
        <defs>
            <linearGradient
                id="0a0217d8__paint0_linear_9962_574"
                x1={33.6689}
                y1={3.68595}
                x2={42.7002}
                y2={4.52848}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.0908376} stopColor="#0065D9" />
                <stop offset={0.7003} stopColor="#027BF3" />
            </linearGradient>
        </defs>
    </svg>
);

export default CovidAviaS;
