import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CovidTrainsL = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 191 100"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <path
            d="M109.969 1.18271C90.9537 1.34074 68.467 3.71116 44.718 17.4596C11.422 36.7391 -3.33234 46.2208 0.84938 61.7076C6.05681 80.987 46.9272 95.9997 85.9829 95.9207C102.789 95.8417 120.305 93.5503 135.454 87.3082C211.356 56.1766 173.089 0.708622 109.969 1.18271Z"
            fill="#EDF2F7"
        />
        <path
            d="M144.765 48.9076C145.001 50.4088 145.869 51.7521 147.132 52.6212C148.473 53.4904 149.972 53.8064 151.471 53.4904L171.196 49.6187C173.484 49.1446 175.615 48.2754 177.587 47.0112C179.323 45.826 181.374 45.0359 183.426 44.6408L188.397 43.6926C189.264 43.5346 189.896 42.9815 190.369 42.3494C190.842 41.6383 191.079 40.8481 190.842 39.979C190.606 39.1098 190.132 38.4777 189.501 38.0036C188.791 37.5295 188.002 37.2925 187.134 37.5295L182.163 38.4777C180.112 38.8728 177.903 38.8728 175.851 38.4777C173.563 38.0036 171.196 38.0036 168.908 38.3987L149.262 42.1914C146.185 42.7445 144.133 45.826 144.765 48.9076ZM187.529 38.8728C188.397 38.7147 189.264 39.3468 189.422 40.137C189.501 40.5321 189.343 41.0061 189.107 41.4012C188.87 41.7963 188.554 42.0333 188.081 42.1123L183.899 42.9025L183.268 39.6629L187.529 38.8728ZM149.578 43.6926L169.382 39.8209C171.433 39.4259 173.642 39.4259 175.694 39.8209C177.745 40.216 179.875 40.295 182.006 39.979L182.637 43.2976C180.585 43.7716 178.613 44.5618 176.877 45.826C175.141 47.0112 173.169 47.8804 171.038 48.1964L151.234 51.9891C150.13 52.2262 148.946 51.9891 148.078 51.357C147.132 50.7249 146.5 49.6977 146.343 48.5915C145.711 46.3001 147.211 44.0877 149.578 43.6926Z"
            fill="#00E6C5"
        />
        <path
            d="M160.072 47.7226C160.151 48.1176 160.545 48.3547 160.94 48.2757L171.907 46.1423C172.301 46.0633 172.538 45.6682 172.459 45.2731L171.828 41.8755C171.749 41.6385 171.67 41.5595 171.512 41.4014C171.354 41.2434 171.197 41.2434 170.96 41.3224L159.993 43.4558C159.598 43.5348 159.362 43.9299 159.44 44.3249L160.072 47.7226ZM170.565 42.9027L170.96 44.878L161.413 46.7744L161.018 44.799L170.565 42.9027Z"
            fill="#00E6C5"
        />
        <path
            d="M151.314 48.4334L156.995 47.3272C157.389 47.2482 157.626 46.8531 157.547 46.458C157.468 46.221 157.389 46.063 157.231 45.9839C157.073 45.8259 156.916 45.8259 156.679 45.9049L150.998 47.0111C150.604 47.0901 150.367 47.4852 150.446 47.8803C150.525 48.2754 150.919 48.5124 151.314 48.4334Z"
            fill="#00E6C5"
        />
        <path
            d="M45.6667 7.97805C45.7456 7.97805 41.7217 7.741 41.7217 7.741C41.7217 7.741 45.2722 -0.160416 53.5567 3.00015C46.9291 2.76311 45.6667 7.97805 45.6667 7.97805Z"
            fill="url(#e5a6e113__paint0_linear_9962_271)"
        />
        <path
            d="M16.4732 50.9617C22.154 61.6286 28.9395 68.1867 41.7213 69.53C46.5342 70.0831 56.239 69.1349 58.5271 68.1868C67.364 64.3941 70.9934 21.7264 66.1805 13.5089C61.3675 5.29147 40.3011 3.86921 32.8845 7.18781C25.4678 10.5064 9.92445 38.7145 16.4732 50.9617Z"
            fill="#FFD34D"
        />
        <path
            d="M58.7644 11.6127L54.8983 10.5065C55.2928 7.02991 54.346 3.71132 50.2432 2.28906C58.8433 3.31625 59.1589 9.32132 58.7644 11.6127Z"
            fill="#66B3FF"
        />
        <path
            d="M35.646 15.6425C35.1726 15.9585 34.068 19.0401 34.4625 19.5932C34.857 20.0673 41.0112 21.3315 41.4057 21.0944C41.8002 20.8574 43.1415 17.2228 42.747 16.8277C42.3525 16.4326 36.1194 15.3264 35.646 15.6425Z"
            fill="#0066DA"
        />
        <path
            d="M41.406 68.0286C48.1914 65.1841 52.9255 35.7118 51.1107 30.5759C49.296 25.361 24.2057 21.3312 19.3928 24.8869C13.3174 29.3117 7.95222 49.6183 8.42562 56.1765C8.97793 62.6557 34.6206 70.7941 41.406 68.0286Z"
            fill="#FFD34D"
            stroke="#FAAC1A"
            strokeWidth={1.30973}
            strokeMiterlimit={10}
        />
        <path
            d="M63.6563 40.2155C64.2875 35.9487 64.6031 31.5239 64.682 27.1782C64.682 24.8867 64.682 22.5163 64.4453 20.2249C64.2875 18.5656 63.9719 16.8273 63.1829 15.326C62.3939 13.8248 60.8159 12.6395 59.4746 11.7704C57.7387 10.6642 55.8451 9.87405 53.9515 9.16292C49.8487 7.81968 45.5092 7.10855 41.1697 6.87151C39.1971 6.7925 37.2246 6.71348 35.2521 6.87151C34.0686 6.95053 32.7273 7.02954 31.6227 7.58264C30.8337 7.97771 31.5438 9.08391 32.3328 8.76785C32.964 8.4518 34.1475 8.37278 35.0154 8.29377C36.5934 8.13574 38.1714 8.13574 39.7495 8.21475C43.7734 8.37278 47.8762 8.92588 51.7423 9.95306C55.2928 10.9802 59.2379 12.4815 61.6049 15.405C62.5517 16.5112 62.7884 18.0125 63.0251 19.4348C63.3407 21.5682 63.4196 23.7015 63.4196 25.8349C63.4196 30.4968 63.104 35.2376 62.3939 39.8994C62.2361 40.6896 63.4985 41.0847 63.6563 40.2155Z"
            fill="#FAAC1A"
        />
        <path
            d="M46.1692 38.1235C40.3606 37.3658 34.5635 36.3714 28.8606 35.0651C26.4368 34.5514 24.0168 33.9589 21.6007 33.2874C19.965 32.8122 18.3293 32.3369 16.7839 31.6288C16.0112 31.2747 15.2481 32.345 16.017 32.778C17.5585 33.5651 19.273 34.0442 20.9087 34.5194C23.4036 35.1947 25.9024 35.7911 28.4011 36.3875C34.2617 37.7015 40.1376 38.6998 46.0212 39.5402C46.9669 39.5863 47.0322 38.2446 46.1692 38.1235Z"
            fill="#FAAC1A"
        />
        <path
            d="M45.6668 38.4775C47.0081 39.1886 46.7714 44.9566 46.2191 45.8258C45.5879 46.6949 41.9585 46.2999 41.9585 44.8776C41.8796 43.5344 44.2466 37.7663 45.6668 38.4775Z"
            fill="#FAAC1A"
        />
        <path
            d="M98.2918 98.1334C98.2918 98.1334 124.092 87.5455 157.625 71.3475C158.651 70.8735 159.282 69.8463 159.361 69.2142C159.519 68.503 159.755 66.6857 159.755 66.6857L130.089 54.9126L69.4932 75.5353C69.4932 75.5353 69.8088 77.2736 69.9666 77.9057C70.1244 78.5378 70.5189 79.328 70.9923 79.8021L90.5596 97.0272C92.6899 98.8445 95.6881 99.3186 98.2918 98.1334Z"
            fill="#4E9CE9"
        />
        <path
            d="M98.292 94.9728L158.809 68.029C160.071 67.4759 160.071 65.6585 158.809 65.1054L130.089 51.8311L69.5723 75.5353L90.6387 93.8666C92.6901 95.6839 95.6883 96.158 98.292 94.9728Z"
            fill="#66B3FF"
        />
        <path
            d="M130.089 51.831L118.175 9.0053C117.544 6.87191 115.335 5.60769 113.205 6.2398L56.4754 23.1488C54.2662 23.7809 53.0827 26.1514 53.7928 28.2848L69.5728 75.5352L130.089 51.831Z"
            fill="#0066DA"
        />
        <path
            d="M125.907 47.4853L115.729 11.4548C115.492 10.5857 114.545 10.0326 113.677 10.3486L59.2362 26.5465C58.2894 26.7836 57.8159 27.8108 58.1315 28.6799L71.9391 67.7129C72.2547 68.5821 73.2015 69.0562 74.0694 68.7401L124.96 49.5397C125.749 49.2236 126.144 48.3545 125.907 47.4853Z"
            fill="white"
        />
        <path
            d="M89.7712 85.412L144.291 62.4189L129.221 55.3076L77.7783 75.4562L89.7712 85.412Z"
            fill="#0066DA"
        />
        <path
            d="M72.7297 32.9464L68.8636 34.1317C68.3902 34.2897 67.8379 34.0526 67.6012 33.4995L66.2599 29.6278C66.1021 29.1538 66.3388 28.6007 66.8911 28.4426L70.7572 27.2574C71.2306 27.0994 71.7829 27.4154 71.9407 27.8895L73.282 31.6822C73.5187 32.3143 73.2031 32.7884 72.7297 32.9464Z"
            fill="#DAE6F2"
        />
        <path
            d="M78.1743 25.9142C78.2532 25.9142 78.3321 25.9932 78.3321 25.9932L79.5945 29.7859V29.8649C79.5945 29.8649 79.5156 29.8649 79.5156 29.9439L75.7284 31.1291C75.7284 31.1291 75.7284 31.1291 75.6495 31.1291C75.5706 31.1291 75.4917 31.1291 75.4917 31.0501L74.3082 27.2574C74.3082 27.1784 74.3082 27.1784 74.3082 27.1784C74.3082 27.1784 74.3082 27.1784 74.3871 27.0994L78.1743 25.9142ZM78.1743 25.124C78.0954 25.124 78.0165 25.124 77.9376 25.124L74.1504 26.3092C73.677 26.4673 73.3614 26.9413 73.5981 27.4944L74.9394 31.2871C75.0972 31.6822 75.4917 31.9192 75.8862 31.9192C75.9651 31.9192 76.044 31.9192 76.2018 31.8402L79.989 30.655C80.4624 30.497 80.6991 30.0229 80.5413 29.4698L79.2789 25.6771C78.9633 25.4401 78.5688 25.124 78.1743 25.124Z"
            fill="#027BF3"
        />
        <path
            d="M86.6951 28.6004L82.9868 29.7856C82.5134 29.9437 81.9611 29.6276 81.8033 29.1535L80.5409 25.3608C80.3831 24.8868 80.6198 24.3337 81.0932 24.1756L84.8015 23.0694C85.2749 22.9114 85.8272 23.2275 85.985 23.7015L87.2474 27.4152C87.4841 27.9683 87.1685 28.4424 86.6951 28.6004Z"
            fill="#DAE6F2"
        />
        <path
            d="M73.5966 35.3165C73.6755 35.3165 73.7545 35.3165 73.7545 35.3955L75.0958 39.1882V39.2672C75.0958 39.2672 75.0958 39.3462 75.0169 39.3462L71.1507 40.6105C71.1507 40.6105 71.1507 40.6105 71.0718 40.6105C70.9929 40.6105 70.914 40.6105 70.914 40.5314L69.5727 36.7388V36.6597C69.5727 36.6597 69.5727 36.5807 69.6516 36.5807L73.5966 35.3165ZM73.5966 34.5264C73.5177 34.5264 73.4388 34.5264 73.281 34.6054L69.4149 35.7906C68.9415 35.9486 68.6259 36.5017 68.7837 36.9758L70.125 40.7685C70.2828 41.1636 70.5984 41.4006 71.0718 41.4006C71.1507 41.4006 71.3085 41.4006 71.3874 41.3216L75.1747 40.0574C75.6481 39.8993 75.8848 39.3462 75.727 38.8721L74.3857 35.0795C74.3857 34.7634 73.9911 34.5264 73.5966 34.5264Z"
            fill="#027BF3"
        />
        <path
            d="M82.1976 37.8452L78.4892 39.0304C78.0158 39.1884 77.4635 38.9514 77.3057 38.4773L76.0433 34.6846C75.8855 34.2105 76.1222 33.6574 76.5956 33.4994L80.3828 32.3142C80.8562 32.1561 81.4085 32.3932 81.5663 32.9463L82.8288 36.66C82.9866 37.134 82.671 37.6871 82.1976 37.8452Z"
            fill="#DAE6F2"
        />
        <path
            d="M89.0625 35.6328L85.4331 36.818C84.9597 36.9761 84.4863 36.739 84.2496 36.2649L82.9872 32.5513C82.8294 32.0772 83.0661 31.5241 83.5395 31.4451L87.2478 30.2599C87.7212 30.1018 88.1946 30.4179 88.3524 30.892L89.5359 34.6056C89.7726 34.9217 89.5359 35.4748 89.0625 35.6328Z"
            fill="#DAE6F2"
        />
        <path
            d="M77.621 47.0105L73.8338 48.2747C73.3604 48.4328 72.808 48.1957 72.6502 47.7216L71.3089 44.008C71.1511 43.5339 71.3878 42.9808 71.8612 42.8227L75.6485 41.5585C76.1219 41.4005 76.6742 41.6375 76.832 42.1116L78.0944 45.8253C78.41 46.3784 78.0944 46.8525 77.621 47.0105Z"
            fill="#DAE6F2"
        />
        <path
            d="M84.5652 44.7196L80.8569 45.9838C80.3835 46.1418 79.8312 45.9048 79.6734 45.4307L78.411 41.717C78.2532 41.2429 78.4899 40.6898 78.9633 40.5318L82.6716 39.3466C83.145 39.1886 83.6973 39.4256 83.8551 39.8997L85.1175 43.6134C85.2753 44.0084 85.0386 44.5615 84.5652 44.7196Z"
            fill="#DAE6F2"
        />
        <path
            d="M91.2707 42.4277L87.6413 43.6129C87.1679 43.7709 86.6945 43.5339 86.5367 43.0598L85.2743 39.4251C85.1165 38.951 85.3532 38.477 85.8266 38.3189L89.456 37.1337C89.9294 36.9757 90.4028 37.2127 90.5606 37.6868L91.7441 41.3215C91.9808 41.7165 91.7441 42.2696 91.2707 42.4277Z"
            fill="#DAE6F2"
        />
        <path
            d="M80.0677 53.9637L76.3593 55.3069C75.8859 55.465 75.3336 55.2279 75.1758 54.7538L73.9134 51.0402C73.7556 50.5661 73.9923 50.013 74.4657 49.855L78.253 48.5907C78.7264 48.4327 79.2787 48.6698 79.4365 49.1438L80.6989 52.7785C80.7778 53.2526 80.5411 53.8057 80.0677 53.9637Z"
            fill="#DAE6F2"
        />
        <path
            d="M86.853 51.5936L83.2236 52.8578C82.7502 53.0158 82.1979 52.7788 82.0401 52.3047L80.7777 48.6701C80.6199 48.196 80.8566 47.7219 81.33 47.4849L85.0383 46.2206C85.5117 46.0626 85.9851 46.2996 86.1429 46.7737L87.4053 50.4084C87.5631 50.8825 87.3264 51.4356 86.853 51.5936Z"
            fill="#DAE6F2"
        />
        <path
            d="M93.5592 49.2231L90.0087 50.4873C89.5353 50.6453 89.0619 50.4083 88.9041 49.9342L87.7206 46.2996C87.5628 45.8255 87.7995 45.3514 88.2729 45.1934L91.9023 43.9291C92.3757 43.7711 92.8491 44.0081 93.0069 44.4822L94.1904 48.0379C94.2693 48.512 94.0326 49.0651 93.5592 49.2231Z"
            fill="#027BF3"
        />
        <path
            d="M82.3557 60.6014L78.6474 61.9446C78.174 62.1027 77.6217 61.8656 77.4639 61.3916L76.2015 57.7569C76.0437 57.2828 76.2804 56.7297 76.7538 56.5717L80.4621 55.2284C80.9355 55.0704 81.4878 55.3075 81.6456 55.7815L82.9081 59.4162C83.0659 59.9693 82.8292 60.4434 82.3557 60.6014Z"
            fill="#DAE6F2"
        />
        <path
            d="M89.1408 58.152L85.5114 59.4952C85.038 59.6532 84.5646 59.4162 84.4068 58.9421L83.1444 55.3865C82.9866 54.9124 83.2233 54.4383 83.6967 54.2803L87.3261 53.016C87.7995 52.858 88.2729 53.0951 88.4307 53.5691L89.6142 57.1248C89.8509 57.4408 89.6142 57.9939 89.1408 58.152Z"
            fill="#DAE6F2"
        />
        <path
            d="M95.6896 55.7022L92.139 56.9664C91.6656 57.1244 91.1922 56.8874 91.0344 56.4133L89.8509 52.8577C89.6931 52.3836 89.9298 51.9095 90.4032 51.7515L93.9538 50.4872C94.4272 50.3292 94.9006 50.5662 95.0584 51.0403L96.2419 54.596C96.3997 55.0701 96.163 55.5441 95.6896 55.7022Z"
            fill="#DAE6F2"
        />
        <path
            d="M98.214 25.0448L94.6635 26.151C94.1901 26.3091 93.7167 25.993 93.5589 25.5189L92.3753 21.8053C92.2175 21.3312 92.4542 20.8571 92.9276 20.6991L96.4782 19.5929C96.9516 19.4348 97.425 19.7509 97.5828 20.225L98.7663 23.9386C98.8452 24.3337 98.6085 24.8868 98.214 25.0448Z"
            fill="#DAE6F2"
        />
        <path
            d="M104.684 22.9907L101.213 24.0969C100.739 24.255 100.266 23.9389 100.108 23.4648L98.9247 19.7512C98.7669 19.2771 99.0036 18.803 99.477 18.645L102.949 17.6178C103.422 17.4597 103.895 17.7758 104.053 18.2499L105.158 21.8845C105.316 22.3586 105.079 22.8327 104.684 22.9907Z"
            fill="#DAE6F2"
        />
        <path
            d="M110.996 21.0151L107.603 22.0423C107.13 22.2004 106.657 21.8843 106.578 21.4102L105.473 17.7756C105.315 17.3015 105.552 16.8274 106.025 16.6694L109.418 15.6422C109.891 15.4842 110.286 15.8002 110.444 16.2743L111.548 19.9089C111.627 20.383 111.391 20.8571 110.996 21.0151Z"
            fill="#DAE6F2"
        />
        <path
            d="M100.345 31.919L96.8729 33.0252C96.3995 33.1833 95.9261 32.9462 95.7683 32.4721L94.5848 28.8375C94.427 28.3634 94.6637 27.8893 95.1371 27.7313L98.6876 26.6251C99.161 26.4671 99.6344 26.7831 99.7922 27.2572L100.976 30.8919C101.055 31.2869 100.818 31.761 100.345 31.919Z"
            fill="#DAE6F2"
        />
        <path
            d="M106.815 29.7857L103.422 30.8919C102.949 31.0499 102.475 30.8129 102.317 30.3388L101.213 26.7041C101.055 26.2301 101.292 25.756 101.765 25.598L105.237 24.4918C105.71 24.3337 106.183 24.6498 106.262 25.0449L107.367 28.6795C107.446 29.1536 107.209 29.7067 106.815 29.7857Z"
            fill="#DAE6F2"
        />
        <path
            d="M113.048 27.8103L109.734 28.9165C109.339 29.0745 108.866 28.8375 108.708 28.3634L107.603 24.8078C107.446 24.3337 107.682 23.8596 108.156 23.7016L111.548 22.6744C111.943 22.5163 112.416 22.8324 112.574 23.2275L113.679 26.7831C113.679 27.1782 113.442 27.6523 113.048 27.8103Z"
            fill="#DAE6F2"
        />
        <path
            d="M102.476 38.6352L99.0043 39.8204C98.5309 39.9784 98.0575 39.7414 97.8997 39.2673L96.7162 35.6326C96.5584 35.1586 96.7951 34.6845 97.2685 34.5264L100.74 33.3412C101.213 33.1832 101.687 33.4202 101.845 33.8943L102.949 37.45C103.186 37.9241 102.949 38.4772 102.476 38.6352Z"
            fill="white"
        />
        <path
            d="M108.866 36.423L105.473 37.6082C105 37.7662 104.527 37.5292 104.448 37.0551L103.343 33.4994C103.185 33.0253 103.422 32.5513 103.895 32.3932L107.288 31.287C107.762 31.129 108.156 31.3661 108.314 31.8401L109.418 35.3958C109.497 35.7908 109.261 36.2649 108.866 36.423Z"
            fill="#DAE6F2"
        />
        <path
            d="M115.02 34.3687L111.706 35.4749C111.312 35.6329 110.838 35.3959 110.681 34.9218L109.576 31.3661C109.418 30.892 109.655 30.418 110.128 30.2599L113.442 29.1537C113.837 28.9957 114.31 29.2328 114.468 29.7068L115.494 33.2625C115.651 33.7366 115.415 34.2106 115.02 34.3687Z"
            fill="#DAE6F2"
        />
        <path
            d="M104.605 45.2725L101.213 46.4577C100.739 46.6157 100.266 46.3787 100.108 45.9046L98.9247 42.349C98.7669 41.8749 99.0036 41.4008 99.477 41.2428L102.949 40.0575C103.422 39.8995 103.895 40.1366 103.974 40.6106L105.079 44.1663C105.316 44.6404 105.079 45.1144 104.605 45.2725Z"
            fill="#DAE6F2"
        />
        <path
            d="M110.917 43.0601L107.603 44.2453C107.209 44.4033 106.735 44.1663 106.578 43.6922L105.473 40.1366C105.315 39.6625 105.552 39.1884 106.025 39.0304L109.418 37.8451C109.813 37.6871 110.286 37.9242 110.444 38.3982L111.548 41.8749C111.548 42.428 111.312 42.9021 110.917 43.0601Z"
            fill="#DAE6F2"
        />
        <path
            d="M116.993 40.927L113.758 42.1122C113.364 42.2702 112.89 42.0332 112.732 41.5591L111.628 38.0824C111.47 37.6084 111.707 37.1343 112.18 36.9762L115.494 35.87C115.888 35.712 116.362 35.9491 116.52 36.4231L117.545 39.8998C117.624 40.2948 117.466 40.7689 116.993 40.927Z"
            fill="#DAE6F2"
        />
        <path
            d="M106.656 51.7517L103.263 53.0159C102.79 53.1739 102.317 52.9369 102.238 52.4628L101.133 48.9862C100.975 48.5121 101.212 48.038 101.685 47.88L105.078 46.6948C105.552 46.5367 105.946 46.7738 106.104 47.2479L107.208 50.7245C107.366 51.1195 107.13 51.5936 106.656 51.7517Z"
            fill="#DAE6F2"
        />
        <path
            d="M112.89 49.4601L109.576 50.6453C109.182 50.8033 108.709 50.5663 108.551 50.0922L107.446 46.6156C107.288 46.1415 107.525 45.6674 107.998 45.5094L111.312 44.3241C111.707 44.1661 112.18 44.4032 112.338 44.8772L113.443 48.3539C113.521 48.828 113.285 49.302 112.89 49.4601Z"
            fill="#DAE6F2"
        />
        <path
            d="M118.886 47.2482L115.651 48.4334C115.257 48.5914 114.783 48.3544 114.626 47.8803L113.6 44.4036C113.442 43.9296 113.679 43.4555 114.152 43.2974L117.387 42.1122C117.782 41.9542 118.255 42.1912 118.413 42.6653L119.439 46.0629C119.596 46.616 119.36 47.0901 118.886 47.2482Z"
            fill="#DAE6F2"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M105.218 33.7174C113.859 31.005 122.695 27.9648 128.354 25.6771C129.616 25.124 130.405 23.8598 130.011 22.5956C130.011 22.5956 129.064 11.8497 124.172 2.13091C123.541 0.866682 122.357 -0.00247392 121.016 0.392597C121.016 0.392597 97.4247 5.52852 84.1694 10.6644C82.8281 11.2175 82.1969 12.4818 82.4336 13.904C83.7749 23.7018 86.063 29.4698 89.1401 35.87C89.7713 37.1342 91.0337 37.9243 92.375 37.5293C93.4849 37.2227 94.6371 36.8967 95.8208 36.5549C95.6789 38.634 95.0527 40.6634 94.5056 42.0332C94.2689 42.7443 94.979 43.3765 95.6102 43.0604C101.21 40.3637 103.914 36.6003 105.218 33.7174Z"
            fill="#70D164"
        />
        <path
            d="M89.8192 19.3004C90.2694 16.2323 92.2659 14.1259 95.8088 12.9812C98.4408 12.1308 100.69 12.1802 102.557 13.1293C104.431 14.0762 105.781 15.8262 106.606 18.3793C107.466 21.04 107.427 23.3099 106.489 25.1889C105.55 27.0607 103.814 28.4057 101.283 29.2236C99.0019 29.9605 97.1036 30.0789 95.5876 29.5786C94.0693 29.0712 92.8345 28.1792 91.8834 26.9024L96.0664 24.1846C97.0348 25.6617 98.3186 26.1419 99.9179 25.6252C101.783 25.0227 102.522 23.6709 102.136 21.57L97.3813 23.1063L96.4359 20.1802L101.212 18.637C100.248 16.707 98.8408 16.041 96.9905 16.6388C95.549 17.1046 94.8012 18.0749 94.7471 19.5497L89.8192 19.3004ZM106.718 9.75347L114.818 7.13616C116.582 6.56612 118.038 6.5593 119.184 7.11569C120.337 7.66976 121.164 8.72133 121.664 10.2704C122.179 11.8625 122.1 13.2621 121.429 14.4691C120.765 15.6737 119.45 16.5935 117.485 17.2284L114.817 18.0904L116.708 23.9425L111.813 25.524L106.718 9.75347ZM113.785 14.8954L114.979 14.5096C115.918 14.2061 116.526 13.8315 116.802 13.386C117.075 12.9333 117.13 12.4523 116.965 11.9431C116.806 11.4483 116.505 11.082 116.064 10.8444C115.623 10.6067 114.947 10.635 114.036 10.9293L112.648 11.3777L113.785 14.8954Z"
            fill="white"
        />
        <defs>
            <linearGradient
                id="e5a6e113__paint0_linear_9962_271"
                x1={42.0307}
                y1={4.61909}
                x2={53.3058}
                y2={5.66692}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.0908376} stopColor="#0065D9" />
                <stop offset={0.7003} stopColor="#027BF3" />
            </linearGradient>
        </defs>
    </svg>
);

export default CovidTrainsL;
