import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DesktopInnerLogoTravelSign = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 29 30"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <rect
            width={27.58}
            height={27.58}
            rx={13.79}
            transform="matrix(1 -8.74228e-08 -8.74228e-08 -1 1.00977 28.4902)"
            fill="#FFCC00"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M19.5112 7.53454H18.2852L20.0411 1.94141C20.4061 2.0915 20.7632 2.2568 21.1117 2.43651L19.5112 7.53454Z"
            fill="#292929"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M17.8293 1.2442C17.4486 1.15886 17.062 1.08927 16.6701 1.03613L14.582 7.53462H15.808L17.8293 1.2442Z"
            fill="#292929"
        />
        <path
            d="M9.03628 19.0263C8.69325 18.9246 8.32481 18.9246 7.97543 19.0199C7.36557 19.1597 6.91455 19.9601 6.91455 21.1226C6.91455 22.2851 7.27664 22.9139 7.75944 23.1935C8.12788 23.3141 8.52174 23.3269 8.89653 23.2189C9.32214 23.1109 9.95738 22.2787 9.95738 21.1162C9.95738 19.9537 9.61435 19.1978 9.03628 19.0263Z"
            fill="#292929"
        />
        <path
            d="M20.3751 19.0263C20.0384 18.9246 19.6763 18.9246 19.3333 19.0199C18.7362 19.1597 18.2915 19.9601 18.2915 21.1226C18.2915 22.2851 18.6472 22.9139 19.1237 23.1935C19.4858 23.3141 19.8733 23.3269 20.2417 23.2189C20.661 23.1109 21.2835 22.2787 21.2835 21.1162C21.2835 19.9537 20.9405 19.1978 20.3751 19.0263Z"
            fill="#292929"
        />
        <path
            d="M20.3627 6.84863C20.3691 6.84863 12.4476 6.84863 12.4476 6.84863C10.5482 6.84863 9.88758 8.97667 9.88758 8.97667C9.88758 8.97667 7.6261 16.3074 6.79394 18.9818C5.96177 21.6562 8.89025 22.7107 9.63348 22.7107C10.6562 22.7107 17.8853 22.7107 17.9043 22.7107C18.6603 22.7107 19.1494 22.1517 19.1494 21.0209C19.1494 19.6932 19.8545 19.0263 20.35 19.0453C20.5215 19.0771 20.6803 19.166 20.7883 19.2994C21.5252 16.8918 23.3738 11.0222 23.4436 10.7426C24.3139 8.25885 21.7412 6.84863 20.3627 6.84863Z"
            fill="url(#e3b3a3aa__paint0_linear_16347_126)"
        />
        <path
            d="M21.1564 7.61698C20.9213 7.60427 20.7117 7.75038 20.6418 7.97907L17.3513 18.0604C17.3513 18.0667 17.3449 18.0731 17.3449 18.0858C17.2687 18.4415 17.1353 18.7845 16.9511 19.0958C16.7414 19.3245 16.8304 19.7247 17.8213 19.4897C18.8123 19.2546 18.914 18.6448 19.3459 17.3298C19.7207 16.1864 21.5057 10.5645 21.9695 9.10345C22.0838 8.77312 22.0521 8.41103 21.8869 8.09976C21.7471 7.8139 21.4676 7.63604 21.1564 7.61698Z"
            fill="url(#e3b3a3aa__paint1_linear_16347_126)"
        />
        <path
            d="M17.2303 9.03392C17.0334 9.504 14.4988 17.6097 14.3654 18.029C14.232 18.4483 14.8037 18.5817 14.8037 18.5817L17.9418 8.58925L17.9482 8.57025H17.9291C17.6178 8.53849 17.3256 8.73536 17.2303 9.03392Z"
            fill="url(#e3b3a3aa__paint2_linear_16347_126)"
        />
        <path
            d="M15.2807 8.57031C15.0647 8.61478 14.7598 8.56396 14.5629 9.03404C14.3659 9.50412 11.8313 17.6098 11.6979 18.0291C11.5645 18.4483 12.1362 18.5817 12.1362 18.5817L15.2807 8.57031Z"
            fill="url(#e3b3a3aa__paint3_linear_16347_126)"
        />
        <path
            d="M12.498 8.57034C12.1803 8.53858 11.8818 8.72915 11.7801 9.03406C11.5832 9.50414 9.0486 17.6098 8.9152 18.0291C8.7818 18.4484 9.35351 18.5818 9.35351 18.5818L12.498 8.57034Z"
            fill="url(#e3b3a3aa__paint4_linear_16347_126)"
        />
        <defs>
            <linearGradient
                id="e3b3a3aa__paint0_linear_16347_126"
                x1={15.1327}
                y1={22.5945}
                x2={15.1327}
                y2={6.73497}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.0852} stopColor="#C70100" />
                <stop offset={0.1948} stopColor="#E11C1B" />
                <stop offset={0.979} stopColor="#E11C1B" />
            </linearGradient>
            <linearGradient
                id="e3b3a3aa__paint1_linear_16347_126"
                x1={17.6558}
                y1={19.7038}
                x2={21.3567}
                y2={7.65043}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#E52F2D" />
                <stop offset={0.07468} stopColor="#E63634" />
                <stop offset={1} stopColor="#EF8883" />
            </linearGradient>
            <linearGradient
                id="e3b3a3aa__paint2_linear_16347_126"
                x1={14.5969}
                y1={18.3492}
                x2={18.568}
                y2={5.49397}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.02544} stopColor="#E52F2D" />
                <stop offset={0.5193} stopColor="#EA4A46" />
                <stop offset={1} stopColor="#EF6862" />
            </linearGradient>
            <linearGradient
                id="e3b3a3aa__paint3_linear_16347_126"
                x1={12.1591}
                y1={17.5961}
                x2={16.1302}
                y2={4.74084}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.02544} stopColor="#E52F2D" />
                <stop offset={0.5193} stopColor="#EA4A46" />
                <stop offset={1} stopColor="#EF6862" />
            </linearGradient>
            <linearGradient
                id="e3b3a3aa__paint4_linear_16347_126"
                x1={9.62238}
                y1={16.8126}
                x2={13.5935}
                y2={3.95737}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.02544} stopColor="#E52F2D" />
                <stop offset={0.5193} stopColor="#EA4A46" />
                <stop offset={1} stopColor="#EF6862" />
            </linearGradient>
        </defs>
    </svg>
);

export default DesktopInnerLogoTravelSign;
