import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FlightNoCityPhotoS = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 328 205"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#4e60b009__clip0_25495_5755)">
            <g clipPath="url(#4e60b009__clip1_25495_5755)">
                <path
                    d="M377.767 -1.53809H-237.233V177.76H377.767V-1.53809Z"
                    fill="url(#4e60b009__paint0_linear_25495_5755)"
                />
                <path
                    d="M322.468 141.409C324.907 141.954 327.441 141.913 329.861 141.29C332.282 140.666 334.52 139.477 336.392 137.821C338.037 136.34 339.375 134.5 341.235 133.311C344.823 131 349.476 131.6 353.756 131.615C354.704 131.685 355.655 131.525 356.528 131.149C357.451 130.672 358.066 129.785 358.706 128.96C361.694 125.055 365.743 121.749 370.535 120.663C375.327 119.576 380.877 121.109 383.681 125.147C385.059 127.131 385.7 129.539 386.92 131.625C388.396 134.122 390.65 136.066 393.336 137.16C395.975 138.221 399.204 138.605 400.793 140.968C401.567 142.126 401.777 143.561 401.961 144.945C402.197 146.763 402.416 148.584 402.617 150.408C402.697 150.753 402.656 151.115 402.5 151.433C402.228 151.854 401.649 151.91 401.152 151.946L383.214 152.412C375.66 152.612 368.09 152.807 360.562 152.161C347.877 151.075 335.536 147.615 323.277 144.176"
                    fill="#428C8A"
                />
                <path
                    opacity={0.67}
                    d="M54.9758 109.162H-4.42529C-4.42529 109.162 5.07557 103.537 9.02316 103.837C12.9708 104.137 12.3052 106.909 12.3052 106.909C12.3052 106.909 20.242 100.443 27.2304 100.819C34.2187 101.195 33.3909 104.623 33.3909 104.623C33.3909 104.623 41.0906 96.9439 53.3577 97.9835C62.9833 98.778 54.9758 109.162 54.9758 109.162Z"
                    fill="white"
                />
                <path
                    opacity={0.6}
                    d="M-25.5762 84.0494H-172.013C-172.013 84.0494 -152.513 64.8421 -131.946 61.9802C-111.379 59.1182 -112.092 73.0148 -112.092 73.0148C-112.092 73.0148 -85.2316 33.3912 -44.1026 37.151C-2.97363 40.9108 -19.5483 68.9285 -19.5483 68.9285C-19.5483 68.9285 2.87285 54.5932 17.4116 60.4752C31.9504 66.3573 20.5097 84.0494 20.5097 84.0494H-25.5762Z"
                    fill="url(#4e60b009__paint1_linear_25495_5755)"
                />
                <path
                    opacity={0.4}
                    d="M162.516 56.0616H59.4526C59.4526 56.0616 73.1774 44.3356 87.6401 42.5931C102.103 40.8506 101.616 49.3273 101.616 49.3273C101.616 49.3273 120.512 25.1424 149.458 27.4333C178.404 29.7242 166.734 46.8314 166.734 46.8314C166.734 46.8314 182.504 38.0831 192.754 41.6706C203.004 45.2581 194.937 56.0616 194.937 56.0616H162.516Z"
                    fill="url(#4e60b009__paint2_linear_25495_5755)"
                />
                <path
                    opacity={0.7}
                    d="M147.69 97.7309H74.4998C74.4998 97.7309 86.2053 90.9044 91.074 91.2683C95.9428 91.6322 95.1176 94.9839 95.1176 94.9839C95.1176 94.9839 104.891 87.1427 113.506 87.6039C122.121 88.0652 121.091 92.2164 121.091 92.2164C121.091 92.2164 130.578 82.8889 145.707 84.1702C157.55 85.1388 147.69 97.7309 147.69 97.7309Z"
                    fill="url(#4e60b009__paint3_linear_25495_5755)"
                />
                <path
                    d="M248.161 -7.94385C244.061 1.2299 231.72 30.8627 223.986 68.9312C218.994 93.5055 215.93 119.669 214.156 138.785C213.384 147.124 209.687 154.922 203.719 160.798C197.751 166.674 189.897 170.25 181.546 170.893C169.136 171.84 156.675 171.935 144.251 171.18C124.264 169.976 109.309 152.284 111.251 132.338C113.04 114.036 116.023 90.8251 120.922 68.9312C129.425 30.8678 142.35 1.23503 146.599 -7.94385H63.8042C59.6376 1.45028 46.7175 32.2874 38.6559 71.9857C33.4694 97.4979 30.2867 124.686 28.4469 144.525C27.6374 153.179 23.7952 161.268 17.5992 167.364C11.4032 173.46 3.25209 177.169 -5.414 177.837C-18.2985 178.821 -31.2353 178.92 -44.1334 178.135C-64.8999 176.884 -80.4184 158.511 -78.3991 137.806C-76.5439 118.797 -73.4433 94.7201 -68.3593 71.9703C-59.493 32.2874 -46.004 1.45028 -41.6478 -7.94385H-159.4C-163.71 1.7219 -177.337 34.1683 -185.819 75.9473C-191.252 102.684 -194.562 131.2 -196.515 151.946C-197.354 161.016 -201.373 169.498 -207.863 175.891C-214.352 182.283 -222.893 186.175 -231.975 186.878C-236.075 187.192 -240.161 187.425 -244.234 187.575V197.056H370.766V-7.94385H248.161Z"
                    fill="#BBC5CB"
                />
                <path
                    d="M259.395 0C255.32 9.17375 242.959 38.8065 235.22 76.875C230.228 101.449 227.164 127.612 225.39 146.729C224.619 155.069 220.922 162.867 214.954 168.743C208.986 174.619 201.131 178.195 192.78 178.837C180.371 179.783 167.912 179.879 155.491 179.124C135.503 177.919 120.543 160.228 122.491 140.281C124.274 121.975 127.288 98.7793 132.156 76.875C140.664 38.8065 153.584 9.17375 157.833 0H75.0384C70.8615 9.39412 57.9516 40.2518 49.9002 79.95C44.7137 105.462 41.5363 132.65 39.6964 152.479C38.8867 161.134 35.0438 169.224 28.8467 175.32C22.6497 181.415 14.4974 185.125 5.83037 185.791C-7.05415 186.775 -19.9909 186.874 -32.889 186.089C-53.6555 184.838 -69.1689 166.465 -67.1496 145.76C-65.2995 126.751 -62.1989 102.674 -57.1149 79.9244C-48.2589 40.2517 -34.7648 9.39412 -30.4085 0H-148.166C-152.476 9.66575 -166.103 42.1121 -174.585 83.8911C-180.018 110.628 -183.349 139.118 -185.276 159.9C-186.116 168.974 -190.14 177.458 -196.634 183.851C-203.129 190.245 -211.675 194.134 -220.761 194.832C-224.82 195.139 -228.9 195.362 -233 195.498V205H382V0H259.395Z"
                    fill="#D0DFEA"
                />
                <g opacity={0.3}>
                    <path
                        opacity={0.3}
                        d="M259.395 0C255.32 9.17375 242.959 38.8065 235.22 76.875C230.228 101.449 227.164 127.612 225.39 146.729C224.619 155.069 220.922 162.867 214.954 168.743C208.986 174.619 201.131 178.195 192.78 178.837C180.371 179.783 167.912 179.879 155.491 179.124C135.503 177.919 120.543 160.228 122.491 140.281C124.274 121.975 127.288 98.7793 132.156 76.875C140.664 38.8065 153.584 9.17375 157.833 0H75.0384C70.8615 9.39412 57.9516 40.2518 49.9002 79.95C44.7137 105.462 41.5363 132.65 39.6964 152.479C38.8867 161.134 35.0438 169.224 28.8467 175.32C22.6497 181.415 14.4974 185.125 5.83037 185.791C-7.05415 186.775 -19.9909 186.874 -32.889 186.089C-53.6555 184.838 -69.1689 166.465 -67.1496 145.76C-65.2995 126.751 -62.1989 102.674 -57.1149 79.9244C-48.2589 40.2517 -34.7648 9.39412 -30.4085 0H-148.166C-152.476 9.66575 -166.103 42.1121 -174.585 83.8911C-180.018 110.628 -183.349 139.118 -185.276 159.9C-186.116 168.974 -190.14 177.458 -196.634 183.851C-203.129 190.245 -211.675 194.134 -220.761 194.832C-224.82 195.139 -228.9 195.362 -233 195.498V205H382V0H259.395Z"
                        fill="url(#4e60b009__paint4_linear_25495_5755)"
                    />
                </g>
                <path
                    d="M247.248 -2.96191C247.248 -2.96191 231.089 30.7503 221.726 76.8753C216.729 101.45 213.664 127.613 211.896 146.729C211.124 155.069 207.426 162.868 201.456 168.744C195.487 174.62 187.632 178.195 179.281 178.837C174.658 179.179 170.028 179.415 165.392 179.544C174.527 179.768 183.668 179.532 192.78 178.837C201.131 178.195 208.985 174.62 214.954 168.744C220.922 162.867 224.619 155.069 225.39 146.729C227.163 127.633 230.228 101.45 235.22 76.8753C244.588 30.7503 260.748 -2.96191 260.748 -2.96191H247.248Z"
                    fill="#BBC5CB"
                />
                <g opacity={0.3}>
                    <path
                        opacity={0.5}
                        d="M103.267 -30.6014C97.7166 -18.9215 76.7707 21.4635 65.3932 71.1145C58.0798 103.043 54.1182 133.189 51.197 158.065C49.9178 168.931 44.8372 178.994 36.8538 186.474C28.8704 193.955 18.4986 198.371 7.57296 198.942C-8.65594 199.783 -24.9234 199.507 -41.1145 198.117C-67.1957 195.898 -86.1377 172.308 -82.955 146.329C-80.0338 122.482 -75.3854 92.2961 -68.2873 63.8165C-55.9207 14.2116 -37.9934 -24.1798 -32.2278 -35.875"
                        stroke="#7E9BAD"
                        strokeWidth={1.025}
                        strokeMiterlimit={10}
                        strokeLinecap="round"
                    />
                </g>
                <g opacity={0.3}>
                    <path
                        opacity={0.5}
                        d="M282.396 -27.4707C277.097 -16.3033 260.661 20.4019 249.791 67.8543C242.8 98.3993 238.167 130.969 235.369 154.744C234.147 165.13 229.291 174.749 221.66 181.899C214.029 189.05 204.115 193.271 193.672 193.817C178.155 194.617 162.602 194.353 147.121 193.027C122.193 190.9 104.071 168.361 107.146 143.53C109.94 120.734 114.383 91.8803 121.174 64.6819C133.007 17.2501 150.14 -19.4398 155.655 -30.6021"
                        stroke="#7E9BAD"
                        strokeWidth={1.025}
                        strokeMiterlimit={10}
                        strokeLinecap="round"
                    />
                </g>
                <path
                    opacity={0.3}
                    d="M52.2526 21.9702L50.6843 26.3623L66.2643 21.9702H52.2526Z"
                    fill="#7D9CAE"
                />
                <path
                    d="M-39.6033 21.9712H66.2639C71.9372 6.36558 76.396 -2.96191 76.396 -2.96191H-29.0253C-29.0253 -2.96191 -33.6378 6.36558 -39.6033 21.9712Z"
                    fill="#F2F5F8"
                />
                <path
                    d="M-4.49146 13.9507H37.6207"
                    stroke="#BBC5CB"
                    strokeWidth={3.075}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
                <path
                    d="M149.028 21.0487H251.015C256.468 6.02221 260.753 -2.96191 260.753 -2.96191H159.242C159.242 -2.96191 154.773 6.02221 149.028 21.0487Z"
                    fill="#F2F5F8"
                />
                <path
                    d="M182.848 13.3252H223.407"
                    stroke="#FFD2C6"
                    strokeWidth={3.075}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
                <path
                    d="M372.518 270.483C371.973 222.106 368.808 173.793 363.037 125.758C361.857 116.091 357.751 107.015 351.268 99.7468C344.786 92.4786 336.237 87.365 326.767 85.0913C294.367 77.2911 253.008 72.0431 219.962 71.2538C211.988 71.0642 195.434 72.5453 188.982 76.3788C179.28 82.1701 181.089 92.5277 178.824 104.3C172.085 139.35 162.06 199.451 158.062 264.364"
                    fill="#5F8296"
                />
                <path
                    d="M348.175 273.809C347.632 225.43 344.471 177.116 338.704 129.079C337.523 119.412 333.417 110.337 326.934 103.069C320.452 95.8004 311.904 90.6866 302.434 88.4123C270.034 80.6171 228.675 75.3691 195.629 74.5748C185.961 74.3154 176.514 77.497 168.972 83.5527C161.431 89.6084 156.284 98.1449 154.45 107.641C147.71 142.696 137.686 202.797 133.688 267.705"
                    fill="#4F6C7F"
                />
                <path
                    d="M230.985 -17.188C195.12 -17.188 176.206 12.7646 175.888 31.2599L181.9 42.5376C181.9 42.5376 182.601 55.6739 166.005 64.4859C149.41 73.298 141.392 84.185 147.161 96.0277C147.161 96.0277 131.968 109.623 137.877 124.93C143.786 140.236 164.037 142.717 164.037 142.717L296.881 160.901C296.881 160.901 312.808 165.596 328.443 152.212C344.079 138.827 339.538 115.278 334.593 108.393C328.443 99.829 317.607 95.6159 317.607 95.6159C317.607 95.6159 322.277 83.736 312.043 73.7994C301.81 63.8627 290.935 71.7958 287.7 58.6806C284.465 45.5655 298.831 17.1919 274.887 -5.63812C250.943 -28.4682 230.985 -17.188 230.985 -17.188Z"
                    fill="#333333"
                />
                <path
                    d="M245.034 104.549C283.984 112.57 314.975 133.961 324.067 157.757C333.159 181.552 329.146 215.762 329.146 215.762L206.658 237.42C206.658 237.42 103.712 212.02 104.537 211.482C105.363 210.944 124.402 174.849 138.562 147.599C152.723 120.349 182.909 110.966 199.755 106.42C216.601 101.874 245.034 104.549 245.034 104.549Z"
                    fill="url(#4e60b009__paint5_linear_25495_5755)"
                />
                <path
                    d="M218.174 110.002L213.7 119.109C213.7 119.109 215.376 130.102 208.616 139.184C201.856 148.265 191.903 154.328 178.189 151.443C164.474 148.558 156.823 132.819 159.857 116.941C162.891 101.064 181.1 89.333 181.1 89.333L216.898 90.8141L218.174 110.002Z"
                    fill="url(#4e60b009__paint6_linear_25495_5755)"
                />
                <path
                    d="M210.128 137.826C211.394 139.824 213.413 141.413 216.575 142.095C228.809 144.703 240.53 137.282 240.53 137.282C240.53 137.282 256.063 127.857 256.571 115.624C257.078 103.391 251.266 72.1846 251.266 72.1846L250.867 50.4443V46.9593C250.867 46.9593 232.237 40.3532 222.208 12.6782C222.208 12.6782 203.66 30.3902 175.985 29.8931C175.985 29.8931 175.586 38.2161 175.985 44.7556C176.385 51.2951 178.389 55.7846 177.487 64.7123C176.585 73.6401 176.288 82.1373 179.793 92.4847C183.299 102.832 187.055 108.967 194.804 111.17C201.467 113.062 208.17 112.042 214.858 109.5L215.74 112.641C214.104 113.776 212.972 115.501 212.583 117.454C212.07 120.595 212.983 126.479 212.45 130.958C211.917 135.437 210.128 137.826 210.128 137.826Z"
                    fill="#FFD4C2"
                />
                <path
                    opacity={0.6}
                    d="M241.852 48.2618C239.802 51.8493 235.312 61.8841 239.935 74.8452C244.035 86.3816 250.697 89.2516 254.203 89.9486C252.788 80.3443 251.266 72.1853 251.266 72.1853L250.867 50.4451V46.9601C250.867 46.9601 232.509 40.4513 222.428 13.3247C222.428 13.3247 228.573 38.2476 241.852 48.2618Z"
                    fill="#F4C2AD"
                />
                <path
                    opacity={0.6}
                    d="M237.839 94.6372C231.199 100.728 223.59 105.668 215.325 109.254L214.915 109.766L215.719 112.626C214.083 113.761 212.952 115.486 212.562 117.438C212.121 120.032 212.68 124.49 212.588 128.488C215.181 131.455 218 129.661 218 129.661C218.681 129.034 219.254 128.298 219.696 127.483C220.639 125.905 218.435 120.734 218.435 120.734C234.825 109.874 237.839 94.6372 237.839 94.6372Z"
                    fill="#F8BDA4"
                />
                <path
                    d="M251.902 75.6085C251.902 75.6085 271.761 74.7936 285.619 90.8144C299.477 106.835 301.353 138.738 284.594 154.764C267.835 170.79 235.66 169.34 227.865 152.883C220.07 136.427 230.546 124.45 240.606 119.11C250.666 113.769 255.028 107.286 255.376 99.6345C254.459 91.6754 253.28 83.665 251.902 75.6085Z"
                    fill="url(#4e60b009__paint7_linear_25495_5755)"
                />
                <path
                    d="M222.792 10.8389C222.792 10.8389 226.6 -0.08759 236.527 -5.70459"
                    stroke="#333333"
                    strokeWidth={0.5125}
                    strokeMiterlimit={10}
                />
                <path
                    d="M240.55 91.6602C232.519 101.787 214.858 109.475 214.858 109.475L219.537 124.296C219.537 124.296 221.075 128.207 217.518 129.934"
                    stroke="#E49776"
                    strokeWidth={1.025}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
                <path
                    d="M227.254 82.2956C234.034 79.6277 237.561 72.4623 235.133 66.2912C232.704 60.12 225.24 57.28 218.46 59.9478C211.681 62.6156 208.153 69.781 210.582 75.9522C213.01 82.1233 220.475 84.9634 227.254 82.2956Z"
                    fill="#FC8D72"
                    fillOpacity={0.28}
                />
                <path
                    d="M188.039 67.4497C187.22 65.3193 185.813 63.4654 183.981 62.1043C182.149 60.7432 179.968 59.931 177.692 59.7622C177.712 61.4052 177.637 63.048 177.466 64.6822C176.836 70.945 176.503 77.0181 177.574 83.6447C178.977 83.6424 180.368 83.3782 181.674 82.8657C187.609 80.5287 190.468 73.6253 188.039 67.4497Z"
                    fill="#FC8D72"
                    fillOpacity={0.28}
                />
                <path
                    d="M216.022 55.4488C216.385 53.5154 215.419 51.7114 213.863 51.4196C212.308 51.1277 210.754 52.4584 210.391 54.3918C210.028 56.3252 210.994 58.1292 212.549 58.4211C214.104 58.7129 215.659 57.3822 216.022 55.4488Z"
                    fill="#333333"
                />
                <path
                    d="M189.112 55.4488C189.475 53.5154 188.509 51.7114 186.954 51.4195C185.398 51.1277 183.844 52.4584 183.481 54.3918C183.118 56.3252 184.084 58.1292 185.639 58.4211C187.195 58.7129 188.749 57.3822 189.112 55.4488Z"
                    fill="#333333"
                />
                <path
                    d="M211.26 43.9877C211.26 43.9877 221.388 41.6609 226.097 49.9839"
                    stroke="#333333"
                    strokeWidth={2.05}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
                <path
                    d="M188.956 43.9877C188.956 43.9877 180.679 41.6609 176.825 49.9839"
                    stroke="#333333"
                    strokeWidth={2.05}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
                <path
                    d="M194.717 46.8364C194.717 46.8364 196.721 53.6578 193.646 57.7988C190.571 61.9398 186.297 64.7842 186.297 68.0488C186.297 72.6613 192.959 74.8651 192.959 74.8651"
                    fill="#FFD4C2"
                />
                <path
                    d="M194.717 46.8364C194.717 46.8364 196.721 53.6578 193.646 57.7988C190.571 61.9398 186.297 64.7842 186.297 68.0488C186.297 72.6613 192.959 74.8651 192.959 74.8651"
                    stroke="#E49776"
                    strokeWidth={1.025}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
                <path
                    d="M191.35 91.658C194.221 93.3812 198.142 94.4006 202.393 93.3812C207.119 92.2478 209.864 89.6886 212.362 85.5874"
                    stroke="#E49776"
                    strokeWidth={1.025}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
                <path
                    d="M150.796 181.537L134.754 208.008"
                    stroke="#EEA70D"
                    strokeWidth={1.025}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
                <path
                    d="M267.743 194.77L264.939 213.087"
                    stroke="#EEA70D"
                    strokeWidth={1.025}
                    strokeMiterlimit={10}
                    strokeLinecap="round"
                />
                <path
                    d="M270.71 64.2562C268.804 72.364 270.813 78.7959 264.822 80.523C262.828 81.097 253.403 80.8305 251.369 80.3539C243.23 78.4371 238.695 68.1256 241.237 57.3221C243.384 48.174 249.898 41.6345 256.776 40.999C258.041 40.876 267.215 40.753 268.481 41.0554C276.62 42.9414 273.252 53.4527 270.71 64.2562Z"
                    fill="#507CA0"
                />
                <path
                    d="M275.215 64.2565C273.309 72.3642 268.219 78.7961 262.228 80.5232C260.235 81.0972 257.908 80.8307 255.873 80.3541C247.735 78.4373 243.194 68.1258 245.741 57.3223C247.889 48.1742 254.387 41.6347 261.28 40.9992C262.494 40.8053 263.732 40.8243 264.939 41.0556C273.078 42.9416 277.757 53.453 275.215 64.2565Z"
                    fill="#8AC9FF"
                />
                <path
                    d="M253.941 56.7126L262.469 47.7285L271.3 42.1422C270.496 41.5591 269.582 41.1458 268.614 40.9276C265.39 40.1179 258.041 40.7482 256.76 40.8712C250.497 41.476 244.532 46.9136 241.81 54.7344L253.941 56.7126Z"
                    fill="#75B5E6"
                />
                <path
                    d="M246.643 -2.96289C266.118 8.27623 266.539 40.0871 266.539 40.0871L260.076 40.2152C258.272 40.3587 257.068 42.1166 255.617 42.87L254.413 42.0705C254.413 42.0705 253.977 10.2545 234.523 -0.979515"
                    fill="#8AC9FF"
                />
                <path
                    d="M247.848 -3.32617C267.323 8.20508 267.261 40.6925 267.261 40.6925C265.242 40.5233 259.917 40.3952 255.617 42.8757C255.617 42.8757 255.176 10.2397 235.727 -1.29155"
                    fill="#AEDCFF"
                />
                <path
                    d="M279.703 64.2687C282.248 53.4632 277.713 43.15 269.574 41.2336C261.436 39.3172 252.775 46.5233 250.231 57.3289C247.687 68.1344 252.222 78.4476 260.36 80.364C268.499 82.2804 277.159 75.0742 279.703 64.2687Z"
                    fill="#AEDCFF"
                />
                <path
                    d="M274.216 62.9757C275.813 56.1954 272.966 49.7238 267.858 48.521C262.75 47.3183 257.315 51.8398 255.718 58.6201C254.122 65.4004 256.968 71.872 262.076 73.0748C267.184 74.2775 272.62 69.756 274.216 62.9757Z"
                    fill="#75B5E6"
                />
            </g>
        </g>
        <defs>
            <linearGradient
                id="4e60b009__paint0_linear_25495_5755"
                x1={106.142}
                y1={-46.6381}
                x2={58.1716}
                y2={197.865}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#C0DFFD" />
                <stop offset={1} stopColor="white" />
            </linearGradient>
            <linearGradient
                id="4e60b009__paint1_linear_25495_5755"
                x1={63894.3}
                y1={295.281}
                x2={63846.7}
                y2={7128.51}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="4e60b009__paint2_linear_25495_5755"
                x1={99294}
                y1={1269.19}
                x2={99273.3}
                y2={3739.58}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="4e60b009__paint3_linear_25495_5755"
                x1={51016.6}
                y1={2214.41}
                x2={51012.4}
                y2={2907.75}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="4e60b009__paint4_linear_25495_5755"
                x1={41.9155}
                y1={-7.89762}
                x2={78.6003}
                y2={205}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" stopOpacity={0.6} />
                <stop offset={1} />
            </linearGradient>
            <linearGradient
                id="4e60b009__paint5_linear_25495_5755"
                x1={215.95}
                y1={165.793}
                x2={335.619}
                y2={215.762}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FFCC00" />
                <stop offset={0.973958} stopColor="#FFB21D" />
            </linearGradient>
            <linearGradient
                id="4e60b009__paint6_linear_25495_5755"
                x1={197.09}
                y1={96.2159}
                x2={184.529}
                y2={127.827}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#4D9585" />
                <stop offset={1} stopColor="#7FAC83" />
            </linearGradient>
            <linearGradient
                id="4e60b009__paint7_linear_25495_5755"
                x1={69195.8}
                y1={15727.2}
                x2={70254.6}
                y2={25464.8}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#4D9585" />
                <stop offset={1} stopColor="#7FAC83" />
            </linearGradient>
            <clipPath id="4e60b009__clip0_25495_5755">
                <rect width={328} height={205} fill="white" />
            </clipPath>
            <clipPath id="4e60b009__clip1_25495_5755">
                <rect
                    width={615}
                    height={205}
                    fill="white"
                    transform="translate(-233)"
                />
            </clipPath>
        </defs>
    </svg>
);

export default FlightNoCityPhotoS;
