import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HotelBookingM = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 189 120"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#a63d7f84__clip0_17115_4247)">
            <g clipPath="url(#a63d7f84__clip1_17115_4247)">
                <circle
                    cx={44.386}
                    cy={47.9746}
                    r={20.2174}
                    transform="rotate(-6.38024 44.386 47.9746)"
                    stroke="#00EBC4"
                    strokeWidth={3}
                />
                <path
                    d="M71.7464 44.0186C71.637 43.0402 72.3415 42.1584 73.3199 42.049L82.1777 41.0585C83.1562 40.9491 84.038 41.6536 84.1474 42.632C84.2568 43.6104 83.5523 44.4922 82.5739 44.6016L73.7161 45.5921C72.7377 45.7015 71.8558 44.997 71.7464 44.0186Z"
                    fill="#00EBC4"
                />
                <path
                    d="M2.65513 51.7445C2.54572 50.7661 3.25019 49.8842 4.2286 49.7748L14.858 48.5862C15.8364 48.4768 16.7183 49.1813 16.8277 50.1597C16.9371 51.1381 16.2326 52.02 15.2542 52.1294L4.62479 53.3179C3.64638 53.4273 2.76453 52.7229 2.65513 51.7445Z"
                    fill="#00EBC4"
                />
                <path
                    d="M47.6111 76.8171C48.3151 76.7384 48.9496 77.2452 49.0283 77.9492L50.0188 86.807C50.0975 87.511 49.5907 88.1455 48.8867 88.2242C48.1827 88.303 47.5482 87.7961 47.4695 87.0921L46.479 78.2343C46.4003 77.5303 46.9072 76.8958 47.6111 76.8171Z"
                    fill="#00EBC4"
                    stroke="#00EBC4"
                />
                <path
                    d="M39.6873 5.95403C40.3913 5.87531 41.0258 6.38219 41.1045 7.08616L42.2931 17.7156C42.3718 18.4195 41.8649 19.054 41.1609 19.1328C40.457 19.2115 39.8225 18.7046 39.7437 18.0006L38.5552 7.37123C38.4765 6.66725 38.9833 6.03275 39.6873 5.95403Z"
                    fill="#00EBC4"
                    stroke="#00EBC4"
                />
                <path
                    d="M67.6589 65.7585C68.101 65.2051 68.9081 65.1149 69.4615 65.557L76.4254 71.12C76.9788 71.5622 77.069 72.3692 76.6269 72.9227C76.1848 73.4761 75.3777 73.5664 74.8243 73.1243L67.8605 67.5612C67.307 67.1191 67.2168 66.312 67.6589 65.7585Z"
                    fill="#00EBC4"
                    stroke="#00EBC4"
                />
                <path
                    d="M11.9484 21.2544C12.3906 20.7009 13.1976 20.6107 13.7511 21.0528L22.1077 27.7285C22.6611 28.1706 22.7514 28.9777 22.3092 29.5312C21.8671 30.0846 21.06 30.1749 20.5066 29.7327L12.15 23.057C11.5966 22.6149 11.5063 21.8078 11.9484 21.2544Z"
                    fill="#00EBC4"
                    stroke="#00EBC4"
                />
                <path
                    d="M25.6169 70.4599C26.1704 70.902 26.2606 71.7091 25.8185 72.2626L20.2554 79.2264C19.8133 79.7798 19.0062 79.8701 18.4528 79.4279C17.8993 78.9858 17.8091 78.1787 18.2512 77.6253L23.8143 70.6615C24.2564 70.108 25.0635 70.0178 25.6169 70.4599Z"
                    fill="#00EBC4"
                    stroke="#00EBC4"
                />
                <path
                    d="M70.1213 14.7495C70.6748 15.1916 70.765 15.9987 70.3229 16.5521L63.6472 24.9087C63.2051 25.4621 62.398 25.5524 61.8446 25.1103C61.2911 24.6681 61.2009 23.8611 61.643 23.3076L68.3187 14.951C68.7608 14.3976 69.5679 14.3073 70.1213 14.7495Z"
                    fill="#00EBC4"
                    stroke="#00EBC4"
                />
                <path
                    d="M116.968 75.3779C117.47 70.0838 127.385 61.6384 122.741 56.9745C116.215 50.2939 118.976 44.4955 109.563 42.8569C109.688 42.1006 88.6033 42.2266 87.5992 42.2266H47.4373C47.1863 42.2266 46.9353 42.3527 46.5588 42.2266C46.4332 42.2266 46.4332 42.2266 46.3077 42.2266C44.6762 42.6048 43.0446 43.109 41.664 44.1174C39.7814 45.3779 39.0284 47.3947 38.5264 49.4115V104.243C39.1539 105.63 40.1579 106.764 41.664 107.521C42.5426 107.899 43.4211 108.151 44.2996 108.403H103.664C103.915 108.403 104.166 108.277 104.417 108.151C113.704 108.403 112.951 97.8149 113.956 90.63C114.332 87.8569 114.96 85.0838 115.587 82.4367C115.587 82.4367 115.587 82.4367 115.713 82.4367C118.599 81.6804 119.729 76.8905 116.968 75.3779Z"
                    fill="#ECF2F9"
                />
                <path
                    d="M48 53C48.4 54.2 74.1667 76.8333 87 88L132.5 54.5"
                    stroke="white"
                    strokeWidth={3}
                    strokeLinecap="round"
                    strokeLinejoin="round"
                />
                <path
                    d="M170.019 63.2444L170.021 63.2545L170.024 63.2646C170.047 63.3456 170.056 63.4568 170.031 63.5816C170.006 63.7135 169.955 63.8094 169.91 63.866C169.892 63.8896 169.878 63.9023 169.87 63.9082L169.744 63.944L169.616 64.0278C167.815 65.2094 158.426 71.7704 149.66 85.4621C149.26 83.0683 146.725 69.3603 139.326 58.0256L139.252 57.9123L139.161 57.8326C139.157 57.8251 139.147 57.8052 139.137 57.7677C139.118 57.6973 139.109 57.5919 139.134 57.4655L139.134 57.4654L139.134 57.4653L139.134 57.4653L139.134 57.4652L139.134 57.4652L139.134 57.4651L139.134 57.465L139.134 57.465L139.134 57.4649L139.134 57.4648L139.134 57.4648L139.134 57.4647L139.134 57.4647L139.134 57.4646L139.134 57.4645L139.134 57.4645L139.134 57.4644L139.134 57.4644L139.134 57.4643L139.134 57.4642L139.134 57.4642L139.135 57.4641L139.135 57.4641L139.135 57.464L139.135 57.4639L139.135 57.4639L139.135 57.4638L139.135 57.4638L139.135 57.4637L139.135 57.4636L139.135 57.4636L139.135 57.4635L139.135 57.4635L139.135 57.4634L139.135 57.4633L139.135 57.4633L139.135 57.4632L139.135 57.4632L139.135 57.4631L139.135 57.463L139.135 57.463L139.135 57.4629L139.135 57.4629L139.135 57.4628L139.135 57.4627L139.135 57.4627L139.135 57.4626L139.135 57.4626L139.135 57.4625L139.135 57.4624L139.135 57.4624L139.135 57.4623L139.135 57.4623L139.135 57.4622L139.135 57.4621L139.135 57.4621L139.135 57.462L139.135 57.462L139.135 57.4619L139.135 57.4618L139.135 57.4618L139.135 57.4617L139.135 57.4617L139.135 57.4616L139.135 57.4615L139.135 57.4615L139.135 57.4614L139.135 57.4613L139.135 57.4613L139.135 57.4612L139.135 57.4612L139.135 57.4611L139.135 57.461L139.135 57.461L139.135 57.4609L139.135 57.4609L139.135 57.4608L139.135 57.4607L139.135 57.4607L139.135 57.4606L139.135 57.4606L139.135 57.4605L139.135 57.4604L139.135 57.4604L139.135 57.4603L139.135 57.4603L139.135 57.4602L139.135 57.4601L139.135 57.4601L139.135 57.46L139.135 57.46L139.135 57.4599L139.135 57.4598L139.135 57.4598L139.135 57.4597L139.135 57.4597L139.135 57.4596L139.135 57.4595L139.135 57.4595L139.135 57.4594L139.135 57.4594L139.135 57.4593L139.135 57.4592L139.135 57.4592L139.135 57.4591L139.135 57.4591L139.136 57.459L139.136 57.459L139.136 57.4589L139.136 57.4588L139.136 57.4588L139.136 57.4587L139.136 57.4587L139.136 57.4586L139.136 57.4585L139.136 57.4585L139.136 57.4584L139.136 57.4584L139.136 57.4583L139.136 57.4582L139.136 57.4582L139.136 57.4581L139.136 57.4581L139.136 57.458L139.136 57.4579L139.136 57.4579L139.136 57.4578L139.136 57.4578L139.136 57.4577L139.136 57.4576L139.136 57.4576L139.136 57.4575L139.136 57.4575L139.136 57.4574L139.136 57.4573L139.136 57.4573L139.136 57.4572L139.136 57.4572L139.136 57.4571L139.136 57.457L139.136 57.457L139.136 57.4569L139.136 57.4569L139.136 57.4568L139.136 57.4567L139.136 57.4567L139.136 57.4566L139.136 57.4566L139.136 57.4565L139.136 57.4565L139.136 57.4564L139.136 57.4563L139.136 57.4563L139.136 57.4562L139.136 57.4562L139.136 57.4561L139.136 57.456L139.136 57.456L139.136 57.4559L139.136 57.4559L139.136 57.4558L139.136 57.4557L139.136 57.4557L139.136 57.4556L139.136 57.4556L139.136 57.4555L139.136 57.4554L139.136 57.4554L139.136 57.4553L139.136 57.4553L139.136 57.4552L139.136 57.4552L139.136 57.4551L139.136 57.455L139.136 57.455L139.136 57.4549L139.136 57.4549L139.136 57.4548L139.136 57.4547L139.136 57.4547L139.136 57.4546L139.136 57.4546L139.136 57.4545L139.136 57.4545L139.136 57.4544L139.136 57.4543L139.136 57.4543L139.136 57.4542L139.136 57.4542L139.136 57.4541L139.136 57.454L139.136 57.454L139.137 57.4539L139.137 57.4539L139.137 57.4538L139.137 57.4538L139.137 57.4537L139.137 57.4536L139.137 57.4536L139.137 57.4535L139.137 57.4535L139.137 57.4534L139.137 57.4533L139.137 57.4533L139.137 57.4532L139.137 57.4532L139.137 57.4531L139.137 57.4531L139.137 57.453L139.137 57.4529L139.137 57.4529L139.137 57.4528L139.137 57.4528L139.137 57.4527L139.137 57.4526L139.137 57.4526L139.137 57.4525L139.137 57.4525L139.137 57.4524L139.137 57.4524L139.137 57.4523L139.137 57.4522L139.137 57.4522L139.137 57.4521L139.137 57.4521L139.137 57.452L139.137 57.452L139.137 57.4519L139.137 57.4518L139.137 57.4518L139.137 57.4517L139.137 57.4517L139.137 57.4516L139.137 57.4516L139.137 57.4515L139.137 57.4514L139.137 57.4514L139.137 57.4513L139.137 57.4513L139.137 57.4512L139.137 57.4512L139.137 57.4511L139.137 57.451L139.137 57.451L139.137 57.4509L139.137 57.4509L139.137 57.4508L139.137 57.4508L139.137 57.4507L139.137 57.4506L139.137 57.4506L139.137 57.4505L139.137 57.4505L139.137 57.4504L139.137 57.4504L139.137 57.4503L139.137 57.4502L139.137 57.4502L139.137 57.4501L139.137 57.4501L139.137 57.45L139.137 57.45L139.137 57.4499L139.137 57.4499L139.137 57.4498L139.137 57.4497L139.137 57.4497L139.137 57.4496L139.137 57.4496L139.137 57.4495L139.137 57.4495L139.137 57.4494L139.137 57.4493L139.137 57.4493L139.137 57.4492L139.137 57.4492L139.137 57.4491L139.137 57.4491L139.137 57.449L139.137 57.449L139.137 57.4489L139.138 57.4488L139.138 57.4488L139.138 57.4487L139.138 57.4487L139.138 57.4486L139.138 57.4486L139.138 57.4485L139.138 57.4484L139.138 57.4484L139.138 57.4483L139.138 57.4483L139.138 57.4482L139.138 57.4482L139.138 57.4481L139.138 57.4481L139.138 57.448L139.138 57.4479L139.138 57.4479L139.138 57.4478L139.138 57.4478L139.138 57.4477L139.138 57.4477L139.138 57.4476L139.138 57.4476L139.138 57.4475L139.138 57.4475L139.138 57.4474L139.138 57.4473L139.138 57.4473L139.138 57.4472L139.138 57.4472L139.138 57.4471L139.138 57.4471L139.138 57.447L139.138 57.447L139.138 57.4469L139.138 57.4469L139.138 57.4468L139.138 57.4467L139.138 57.4467L139.138 57.4466L139.138 57.4466L139.138 57.4465L139.138 57.4465L139.138 57.4464L139.138 57.4464L139.138 57.4463L139.138 57.4463L139.138 57.4462L139.138 57.4461L139.138 57.4461L139.138 57.446L139.138 57.446L139.138 57.4459L139.138 57.4459L139.138 57.4458L139.138 57.4458L139.138 57.4457L139.138 57.4457L139.138 57.4456L139.138 57.4455L139.138 57.4455L139.138 57.4454L139.138 57.4454L139.138 57.4453L139.138 57.4453L139.138 57.4452L139.138 57.4452L139.138 57.4451L139.138 57.4451L139.138 57.445L139.138 57.445L139.138 57.4449L139.138 57.4449L139.138 57.4448L139.138 57.4447L139.138 57.4447L139.138 57.4446L139.138 57.4446L139.138 57.4445L139.138 57.4445L139.138 57.4444L139.138 57.4444L139.138 57.4443L139.138 57.4443L139.138 57.4442L139.138 57.4442L139.138 57.4441L139.138 57.4441L139.138 57.444L139.138 57.444L139.138 57.4439L139.138 57.4439L139.138 57.4438L139.139 57.4437L139.139 57.4437L139.139 57.4436L139.139 57.4436L139.139 57.4435L139.139 57.4435L139.139 57.4434L139.139 57.4434L139.139 57.4433L139.139 57.4433L139.139 57.4432L139.139 57.4432L139.139 57.4431L139.139 57.4431L139.139 57.443L139.139 57.443L139.139 57.4429L139.139 57.4429L139.139 57.4428L139.139 57.4428L139.139 57.4427L139.139 57.4427L139.139 57.4426L139.139 57.4426L139.139 57.4425L139.139 57.4425L139.139 57.4424L139.139 57.4424L139.139 57.4423L139.139 57.4422L139.139 57.4422L139.139 57.4421L139.139 57.4421L139.139 57.442L139.139 57.442L139.139 57.4419L139.139 57.4419L139.139 57.4418L139.139 57.4418L139.139 57.4417L139.139 57.4417L139.139 57.4416L139.139 57.4416L139.139 57.4415L139.139 57.4415L139.139 57.4414L139.139 57.4414L139.139 57.4413L139.139 57.4413L139.139 57.4412L139.139 57.4412L139.139 57.4411L139.139 57.4411L139.139 57.441L139.139 57.441L139.139 57.4409L139.139 57.4409L139.139 57.4408L139.139 57.4408L139.139 57.4407L139.139 57.4407L139.139 57.4406L139.139 57.4406L139.139 57.4405L139.139 57.4405L139.139 57.4404L139.139 57.4404L139.139 57.4403L139.139 57.4403L139.139 57.4402L139.139 57.4402L139.139 57.4401L139.139 57.4401L139.139 57.4401L139.139 57.44L139.139 57.44L139.139 57.4399L139.139 57.4399L139.139 57.4398L139.139 57.4398L139.139 57.4397L139.139 57.4397L139.139 57.4396L139.139 57.4396L139.139 57.4395L139.139 57.4395L139.139 57.4394L139.139 57.4394L139.139 57.4393L139.139 57.4393L139.139 57.4392L139.139 57.4392L139.139 57.4391L139.139 57.4391L139.139 57.439L139.139 57.439L139.139 57.4389L139.139 57.4389L139.139 57.4388L139.139 57.4388L139.139 57.4388L139.139 57.4387L139.139 57.4387L139.14 57.4386L139.14 57.4386L139.14 57.4385L139.14 57.4385L139.14 57.4384L139.14 57.4384L139.14 57.4383L139.14 57.4383L139.14 57.4382L139.14 57.4382L139.14 57.4381L139.14 57.4381L139.14 57.438L139.14 57.438L139.14 57.438L139.14 57.4379L139.14 57.4379L139.14 57.4378L139.14 57.4378L139.14 57.4377L139.14 57.4377L139.14 57.4376L139.14 57.4376L139.14 57.4375L139.14 57.4375L139.14 57.4374L139.14 57.4374L139.14 57.4374L139.14 57.4373L139.14 57.4373L139.14 57.4372L139.14 57.4372L139.14 57.4371L139.14 57.4371L139.141 57.4296L139.143 57.4221C139.164 57.3044 139.207 57.2072 139.253 57.1417C139.278 57.1071 139.298 57.0884 139.308 57.0804L139.428 57.0451L139.55 56.9667C141.056 55.9942 150.55 49.5328 159.486 35.5927L159.52 35.5396C159.837 37.493 162.312 51.4992 169.899 63.0603L169.942 63.1251L169.993 63.1817C169.993 63.1818 170.007 63.2001 170.019 63.2444ZM149.437 85.7895C149.437 85.7895 149.437 85.7891 149.438 85.7885C149.437 85.7892 149.437 85.7895 149.437 85.7895Z"
                    stroke="#00EBC4"
                    strokeWidth={2}
                />
                <path
                    d="M118.227 42.8571C118.352 42.1008 97.2672 42.2269 96.2632 42.2269H93L107.182 60.6302C105.802 65.5462 102.915 69.958 100.656 74.3697C98.8988 77.647 97.0162 81.3025 97.1417 85.2101C97.2672 89.2437 98.8988 93.2773 100.028 97.1849C100.154 97.6891 100.405 98.1933 100.781 98.5714C101.158 99.4538 101.409 100.462 101.785 101.345C101.534 101.597 101.283 101.849 101.158 102.227C101.032 102.353 100.907 102.605 100.907 102.857C101.283 104.748 101.785 106.639 102.287 108.529V108.655H112.328C112.579 108.655 112.83 108.529 113.081 108.403C122.368 108.655 121.615 98.0672 122.619 90.8823C122.996 88.1092 123.623 85.3361 124.251 82.6891C124.251 82.6891 124.251 82.6891 124.377 82.6891C126.385 82.0588 127.514 79.6638 127.138 77.647C126.51 78.7815 125.757 79.7899 125.004 80.7983C124.879 80.4202 124.628 80.042 124.502 79.6638V79.5378C122.996 74.1176 121.741 68.6975 120.737 63.2773C120.737 63.0252 120.611 62.8991 120.486 62.7731C120.486 62.2689 120.36 61.6386 120.235 60.7563L129.02 53.9496C125.506 48.6554 126.259 44.2437 118.227 42.8571Z"
                    fill="#DBE1E9"
                />
                <path
                    d="M141.817 47.3951C140.06 43.1094 137.676 38.9498 134.915 35.1683C133.032 32.6473 128.765 35.1683 130.647 37.6893C131.777 39.2019 132.907 40.8405 133.911 42.6052C130.773 45.3783 127.761 48.2775 124.749 51.1767C123.494 52.4372 122.239 53.5716 121.737 55.2103C121.109 56.975 121.36 58.8657 121.485 60.7565C122.364 69.0758 123.745 77.3952 125.753 85.5884C126.255 87.3531 129.016 88.1094 130.145 86.4708C130.271 85.4624 130.647 84.58 131.024 83.6977C131.4 82.6893 132.028 81.6809 132.656 80.7985C132.907 80.2943 133.283 79.7901 133.534 79.412C134.538 77.2691 135.668 75.2523 136.797 73.1094C139.056 69.0758 142.069 65.1683 143.449 60.6304C144.704 56.0926 143.575 51.5548 141.817 47.3951Z"
                    fill="#FFCAC1"
                />
                <path
                    d="M139.684 42.479C139.308 41.5967 138.68 41.0925 138.429 40.084C137.927 38.1933 134.79 37.437 133.911 39.4538C131.526 44.7479 125.879 47.7731 122.866 52.8151C122.615 52.6891 122.364 52.6891 122.113 52.6891C120.733 52.6891 119.729 53.8235 119.603 55.2101C119.352 57.353 119.352 59.6219 119.603 61.7647C119.854 63.7815 119.729 77.7731 121.109 75.8824C127.385 68.1933 140.312 44.1177 140.312 44.1177C140.312 44.1177 140.061 43.2353 139.684 42.479Z"
                    fill="#FFA49A"
                />
                <path
                    d="M142.696 46.3866L119.477 64.5378C117.595 65.9244 114.959 65.6723 113.579 63.7815L83.5827 24.958C82.2021 23.0672 82.4531 20.4202 84.3357 19.0336L107.68 0.88237C109.562 -0.504184 112.198 -0.252084 113.579 1.63867L143.449 40.3362C144.955 42.2269 144.579 44.874 142.696 46.3866Z"
                    fill="url(#a63d7f84__paint0_linear_17115_4247)"
                />
                <path
                    d="M131.526 76.7647C130.648 78.1513 129.769 79.4118 128.891 80.7983C128.765 80.4202 128.514 80.042 128.389 79.6639V79.5378C126.883 74.1176 125.628 68.6975 124.624 63.2773C124.624 63.0252 124.498 62.8992 124.373 62.7731C124.122 59.6218 122.364 45.3781 120.607 42.1008C118.599 38.1933 112.575 39.4538 111.571 44.2437C110.692 48.0252 111.947 52.1849 111.822 55.9664C111.571 62.6471 107.429 68.5714 104.543 74.2437C102.785 77.521 100.903 81.1765 101.028 85.084C101.154 89.1176 102.785 93.1513 103.915 97.0588C104.041 97.563 104.292 98.0672 104.668 98.4454C105.045 99.5798 105.421 100.588 105.923 101.723C105.923 101.849 106.049 101.849 106.049 101.849C106.049 102.101 106.174 102.227 106.174 102.479C106.3 103.235 107.555 102.983 107.429 102.101C107.429 101.723 107.304 101.471 107.304 101.092C107.429 101.092 107.555 101.092 107.68 101.092C107.68 101.218 107.806 101.218 107.806 101.218C108.559 101.597 109.186 101.471 109.814 100.966C109.939 100.84 109.939 100.84 109.939 100.714C110.818 100.588 111.696 100.336 112.575 99.958C112.951 99.8319 113.077 99.5798 112.951 99.3277C113.328 99.2017 113.705 99.2017 114.081 99.0756C116.717 98.4454 119.227 97.437 121.611 96.1765C124.373 94.6639 128.138 92.395 129.769 89.2437C129.769 89.3697 129.895 89.4958 129.895 89.6218C130.02 89.8739 130.146 89.8739 130.397 89.8739C130.397 89.8739 130.522 90 130.648 90C130.271 89.1176 130.146 88.3613 130.02 87.3529C130.02 87.2269 130.02 87.1008 130.02 86.9748C130.02 86.4706 130.02 85.9664 130.146 85.4622C130.146 85.2101 130.271 85.084 130.271 84.8319C130.271 84.7059 130.271 84.5798 130.397 84.5798C130.397 84.4538 130.522 84.2017 130.522 84.0756C130.648 83.8235 130.773 83.5714 130.899 83.3193C131.275 82.437 131.652 81.6807 132.154 80.9244C132.154 80.6723 132.279 80.4202 132.279 80.1681C132.405 79.0336 132.656 78.0252 132.781 76.8908C132.781 76.6386 131.903 76.1344 131.526 76.7647ZM130.899 80.4202C130.773 81.4286 130.648 82.437 130.146 83.4454C130.146 83.3193 130.02 83.1933 130.02 83.0672C129.895 82.6891 129.644 82.437 129.518 82.0588C130.02 81.3025 130.522 80.6723 131.024 79.916C131.024 80.1681 131.024 80.2941 130.899 80.4202Z"
                    fill="#FFCAC1"
                />
                <path
                    d="M140.939 104.622C140.186 102.605 139.057 100.714 137.927 98.9496C136.672 96.4286 135.542 94.0337 134.287 91.5126C134.162 91.2605 133.911 91.0084 133.66 90.8824C133.534 90.5042 133.283 90.2522 133.032 89.874C132.907 89.6219 132.656 89.3698 132.53 89.1177C132.405 88.9916 132.405 88.8656 132.405 88.7395C132.279 88.4874 132.028 88.3614 131.777 88.4874C131.652 88.4874 131.526 88.4874 131.526 88.6135C131.275 88.7395 131.15 89.1177 131.275 89.4958C131.526 89.874 131.652 90.2521 131.903 90.6303C131.777 90.7564 131.652 91.0085 131.652 91.2606C131.652 91.3866 131.652 91.5126 131.652 91.6387C130.648 92.6471 129.518 93.5295 128.138 94.2858C127.008 95.1681 125.878 96.0505 124.623 96.8068C120.482 99.7059 115.587 101.849 110.692 103.487C110.567 103.487 110.441 103.361 110.19 103.361C109.814 103.361 109.563 103.613 109.437 103.866C109.312 103.866 109.186 103.992 109.061 103.992L108.935 103.866C108.81 103.74 108.684 103.74 108.684 103.74V103.613C108.559 103.109 108.182 103.109 107.806 103.235C107.68 102.983 107.304 102.857 107.053 102.857C106.802 102.479 106.3 102.479 106.049 102.731C106.049 102.605 106.049 102.605 106.049 102.479C105.923 101.723 104.668 101.975 104.793 102.857C105.17 104.748 105.672 106.639 106.174 108.529C106.676 110.294 107.178 112.059 108.308 113.445C108.308 113.445 108.308 113.445 108.433 113.571C109.061 115.588 109.688 117.857 111.32 119.244C111.571 119.748 112.073 120.252 112.951 120.126C120.482 119.622 127.761 117.227 134.036 113.067C134.915 112.563 135.919 111.807 137.049 110.924C137.551 110.672 138.178 110.294 138.555 109.916C140.186 108.656 141.818 106.765 140.939 104.622Z"
                    fill="#0077ED"
                />
                <path
                    d="M132.405 89.1178C132.53 88.6136 132.154 88.1094 131.652 87.9834C131.526 87.9834 131.401 87.9834 131.275 88.1094C131.15 88.1094 131.024 88.2355 131.024 88.2355C127.761 91.5128 124.121 94.1599 119.98 96.1767C118.976 96.6809 117.846 97.1851 116.842 97.5632C114.457 98.5716 111.947 99.454 109.437 100.21C108.81 100.336 108.182 100.588 107.555 100.714C107.052 100.841 106.425 100.967 105.923 101.219C105.546 101.471 105.295 101.975 105.295 102.353C105.295 102.731 105.295 102.983 105.546 103.362C105.546 103.866 105.797 104.244 106.425 104.37C106.55 104.37 106.676 104.37 106.801 104.37C106.801 104.37 106.801 104.37 106.927 104.37C108.057 104.496 109.186 104.118 110.19 103.866C111.571 103.488 112.826 102.983 114.081 102.479C116.716 101.471 119.227 100.336 121.737 99.2019C124.121 98.0674 126.38 96.6809 128.389 95.0422C129.393 94.1599 130.397 93.2775 131.401 92.3952C132.279 91.6389 132.907 90.8825 132.907 89.7481C132.53 89.496 132.53 89.3699 132.405 89.1178Z"
                    fill="#009EFF"
                />
                <path
                    d="M165.165 83.4723C165.165 83.4723 165.165 83.4723 165.165 83.4723C165.165 83.4723 165.165 83.4724 165.165 83.4727L165.165 83.4727M165.165 83.4723C165.165 83.4724 165.165 83.4726 165.165 83.4727M165.165 83.4723C165.165 83.4721 165.166 83.4719 165.166 83.4718L164.967 83.3314L164.349 82.8943M165.165 83.4723L164.154 83.3707L164.151 83.3906C164.077 83.7643 164.178 84.1169 164.385 84.3001C169.533 92.1862 171.273 101.773 171.523 103.285C171.527 103.363 171.537 103.436 171.556 103.505C171.618 103.796 171.798 103.977 172.02 104.021C172.075 104.032 172.131 104.037 172.19 104.029C172.413 104.004 172.624 103.817 172.758 103.558C178.837 94.0393 185.352 89.4952 186.558 88.7043C186.833 88.6261 187.076 88.3305 187.152 87.9414C187.19 87.7474 187.179 87.5587 187.134 87.396C187.1 87.2627 187.038 87.1466 186.958 87.0577C181.672 79.0041 179.979 69.1943 179.792 68.0242C179.782 67.8001 179.71 67.6022 179.592 67.4665C179.508 67.3592 179.399 67.2842 179.27 67.2591C178.958 67.1978 178.637 67.4479 178.494 67.8371C172.307 77.4886 165.744 81.9455 164.748 82.5883C164.601 82.6316 164.46 82.7379 164.349 82.8943M165.165 83.4727L164.968 83.3328L164.349 82.8943M165.165 83.4727L164.349 82.8943M186.164 87.6711L186.174 87.682C186.176 87.6974 186.176 87.7205 186.171 87.7489C186.169 87.7594 186.166 87.7688 186.164 87.7769L186.138 87.7843L186.01 87.8681C184.753 88.6925 178.41 93.1273 172.367 102.323C171.822 99.4438 169.907 90.9294 165.223 83.7535L165.149 83.6402L165.127 83.6211C165.128 83.6101 165.129 83.5973 165.132 83.5832L165.132 83.5832L165.132 83.5831L165.132 83.5831L165.132 83.583L165.132 83.583L165.132 83.5829L165.132 83.5829L165.132 83.5829L165.132 83.5828L165.132 83.5828L165.132 83.5827L165.132 83.5827L165.132 83.5826L165.132 83.5826L165.132 83.5826L165.132 83.5825L165.132 83.5825L165.132 83.5824L165.132 83.5824L165.132 83.5823L165.132 83.5823L165.132 83.5823L165.132 83.5822L165.132 83.5822L165.132 83.5821L165.132 83.5821L165.132 83.5821L165.132 83.582L165.132 83.582L165.132 83.5819L165.132 83.5819L165.132 83.5818L165.132 83.5818L165.132 83.5818L165.132 83.5817L165.132 83.5817L165.132 83.5816L165.132 83.5816L165.132 83.5815L165.132 83.5815L165.132 83.5815L165.132 83.5814L165.132 83.5814L165.132 83.5813L165.132 83.5813L165.132 83.5812L165.132 83.5812L165.132 83.5812L165.132 83.5811L165.132 83.5811L165.132 83.581L165.132 83.581L165.132 83.581L165.132 83.5809L165.132 83.5809L165.132 83.5808L165.132 83.5808L165.132 83.5807L165.132 83.5807L165.132 83.5807L165.132 83.5806L165.132 83.5806L165.132 83.5805L165.132 83.5805L165.132 83.5804L165.132 83.5804L165.132 83.5804L165.132 83.5803L165.132 83.5803L165.132 83.5802L165.132 83.5802L165.132 83.5802L165.132 83.5801L165.132 83.5801L165.132 83.58L165.132 83.58L165.132 83.5799L165.132 83.5799L165.132 83.5799L165.133 83.5798L165.133 83.5798L165.133 83.5797L165.133 83.5797L165.133 83.5796L165.133 83.5796L165.133 83.5796L165.133 83.5795L165.133 83.5795L165.133 83.5794L165.133 83.5794L165.133 83.5794L165.133 83.5793L165.133 83.5793L165.133 83.5792L165.133 83.5792L165.133 83.5791L165.133 83.5791L165.133 83.5791L165.133 83.579L165.133 83.579L165.133 83.5789L165.133 83.5789L165.133 83.5788L165.133 83.5788L165.133 83.5788L165.133 83.5787L165.133 83.5787L165.133 83.5786L165.133 83.5786L165.133 83.5786L165.133 83.5785L165.133 83.5785L165.133 83.5784L165.133 83.5784L165.133 83.5783L165.133 83.5783L165.133 83.5783L165.133 83.5782L165.133 83.5782L165.133 83.5781L165.133 83.5781L165.133 83.5781L165.133 83.578L165.133 83.578L165.133 83.5779L165.133 83.5779L165.133 83.5778L165.133 83.5778L165.133 83.5778L165.133 83.5777L165.133 83.5777L165.133 83.5776L165.133 83.5776L165.133 83.5776L165.133 83.5775L165.133 83.5775L165.133 83.5774L165.133 83.5774L165.133 83.5773L165.133 83.5773L165.133 83.5773L165.133 83.5772L165.133 83.5772L165.133 83.5771L165.133 83.5771L165.133 83.5771L165.133 83.577L165.133 83.577L165.133 83.5769L165.133 83.5769L165.133 83.5769L165.133 83.5768L165.133 83.5768L165.133 83.5767L165.133 83.5767L165.133 83.5766L165.133 83.5766L165.133 83.5766L165.133 83.5765L165.133 83.5765L165.133 83.5764L165.133 83.5764L165.133 83.5764L165.133 83.5763L165.133 83.5763L165.133 83.5762L165.133 83.5762L165.133 83.5761L165.133 83.5761L165.133 83.5761L165.133 83.576L165.133 83.576L165.133 83.5759L165.133 83.5759L165.133 83.5759L165.133 83.5758L165.133 83.5758L165.133 83.5757L165.133 83.5757L165.133 83.5757L165.133 83.5756L165.133 83.5756L165.133 83.5755L165.133 83.5755L165.133 83.5755L165.133 83.5754L165.133 83.5754L165.133 83.5753L165.133 83.5753L165.133 83.5752L165.133 83.5752L165.133 83.5752L165.133 83.5751L165.133 83.5751L165.133 83.575L165.133 83.575L165.133 83.575L165.133 83.5749L165.133 83.5749L165.133 83.5748L165.133 83.5748L165.133 83.5748L165.134 83.5747L165.134 83.5747L165.134 83.5746L165.134 83.5746L165.134 83.5746L165.134 83.5745L165.134 83.5745L165.134 83.5744L165.134 83.5744L165.134 83.5744L165.134 83.5743L165.134 83.5743L165.134 83.5742L165.134 83.5742L165.134 83.5742L165.134 83.5741L165.134 83.5741L165.134 83.574L165.134 83.574L165.134 83.5739L165.134 83.5739L165.134 83.5739L165.134 83.5738L165.134 83.5738L165.134 83.5737L165.134 83.5737L165.134 83.5737L165.134 83.5736L165.134 83.5736L165.134 83.5735L165.134 83.5735L165.134 83.5735L165.134 83.5734L165.134 83.5734L165.134 83.5733L165.134 83.5733L165.134 83.5733L165.134 83.5732L165.134 83.5732L165.134 83.5731L165.134 83.5731L165.134 83.5731L165.134 83.573L165.134 83.573L165.134 83.5729L165.134 83.5729L165.134 83.5729L165.134 83.5728L165.134 83.5728L165.134 83.5727L165.134 83.5727L165.134 83.5727L165.134 83.5726L165.134 83.5726L165.134 83.5725L165.134 83.5725L165.134 83.5725L165.134 83.5724L165.134 83.5724L165.134 83.5723L165.134 83.5723L165.134 83.5723L165.134 83.5722L165.134 83.5722L165.134 83.5722L165.134 83.5721L165.134 83.5721L165.134 83.572L165.134 83.572L165.134 83.572L165.134 83.5719L165.134 83.5719L165.134 83.5718L165.134 83.5718L165.134 83.5718L165.134 83.5717L165.134 83.5717L165.134 83.5716L165.134 83.5716L165.134 83.5716L165.134 83.5715L165.134 83.5715L165.134 83.5714L165.134 83.5714L165.134 83.5714L165.134 83.5713L165.134 83.5713L165.134 83.5713L165.134 83.5712L165.134 83.5712L165.134 83.5711L165.134 83.5711L165.134 83.5711L165.134 83.571L165.134 83.571L165.134 83.5709L165.134 83.5709L165.134 83.5709L165.134 83.5708L165.134 83.5708L165.134 83.5707L165.134 83.5707L165.134 83.5707L165.134 83.5706L165.134 83.5706L165.134 83.5706L165.134 83.5705L165.134 83.5705L165.134 83.5704L165.134 83.5704L165.134 83.5704L165.134 83.5703L165.134 83.5703L165.134 83.5702L165.134 83.5702L165.134 83.5702L165.134 83.5701L165.134 83.5701L165.134 83.5701L165.134 83.57L165.134 83.57L165.134 83.5699L165.134 83.5699L165.134 83.5699L165.134 83.5698L165.134 83.5698L165.134 83.5698L165.134 83.5697L165.134 83.5697L165.134 83.5696L165.135 83.5696L165.135 83.5696L165.135 83.5695L165.135 83.5695L165.135 83.5694L165.135 83.5694L165.135 83.5694L165.135 83.5693L165.135 83.5693L165.135 83.5693L165.135 83.5692L165.135 83.5692L165.135 83.5691L165.135 83.5691L165.135 83.5691L165.135 83.569L165.135 83.569L165.135 83.569L165.135 83.5689L165.135 83.5689L165.135 83.5688L165.135 83.5688L165.135 83.5688L165.135 83.5687L165.135 83.5687L165.135 83.5687L165.135 83.5686L165.135 83.5686L165.135 83.5686L165.135 83.5685L165.135 83.5685L165.135 83.5684L165.135 83.5684L165.135 83.5684L165.135 83.5683L165.135 83.5683L165.135 83.5683L165.135 83.5682L165.135 83.5682L165.135 83.5681L165.135 83.5681L165.135 83.5681L165.135 83.568L165.135 83.568L165.135 83.568L165.135 83.5679L165.135 83.5679L165.135 83.5679L165.135 83.5678L165.135 83.5678L165.135 83.5677L165.135 83.5677L165.135 83.5677L165.135 83.5676L165.135 83.5676L165.135 83.5676L165.135 83.5675L165.135 83.5675L165.135 83.5675L165.135 83.5674L165.135 83.5674L165.135 83.5673L165.135 83.5673L165.135 83.5673L165.135 83.5672L165.135 83.5672L165.135 83.5672L165.135 83.5671L165.135 83.5671L165.135 83.5671L165.135 83.567L165.135 83.567L165.135 83.5669L165.135 83.5669L165.135 83.5669L165.135 83.5668L165.135 83.5668L165.135 83.5668L165.135 83.5667L165.135 83.5667L165.135 83.5667L165.135 83.5666L165.135 83.5666L165.135 83.5666L165.135 83.5665L165.135 83.5665L165.135 83.5665L165.135 83.5664L165.135 83.5664L165.135 83.5663L165.135 83.5663L165.135 83.5663L165.135 83.5662L165.135 83.5662L165.135 83.5662L165.135 83.5661L165.135 83.5661L165.135 83.5661L165.135 83.566L165.135 83.566L165.135 83.566L165.135 83.5659L165.135 83.5659L165.135 83.5659L165.135 83.5658L165.135 83.5658L165.135 83.5658L165.135 83.5657L165.135 83.5657L165.135 83.5657L165.135 83.5656L165.135 83.5656L165.135 83.5655L165.135 83.5655L165.135 83.5655L165.135 83.5654L165.135 83.5654L165.135 83.5654L165.135 83.5653L165.135 83.5653L165.135 83.5653L165.135 83.5652L165.135 83.5652L165.135 83.5652L165.135 83.5651L165.135 83.5651L165.135 83.5651L165.135 83.565L165.135 83.565L165.135 83.565L165.135 83.5649L165.135 83.5649L165.135 83.5649L165.135 83.5648L165.135 83.5648L165.135 83.5648L165.135 83.5647L165.135 83.5647L165.135 83.5647L165.135 83.5646L165.135 83.5646L165.135 83.5646L165.136 83.5645L165.136 83.5645L165.136 83.5645L165.136 83.5644L165.136 83.5644L165.136 83.5644L165.136 83.5643L165.136 83.5643L165.136 83.5643L165.136 83.5642L165.136 83.5642L165.136 83.5642L165.136 83.5641L165.136 83.5641L165.136 83.5641L165.136 83.564L165.136 83.564L165.136 83.564L165.136 83.5639L165.136 83.5639L165.136 83.5639L165.136 83.5638L165.136 83.5638L165.136 83.5638L165.136 83.5637L165.136 83.5637L165.136 83.5637L165.136 83.5637L165.136 83.5636L165.136 83.5636L165.136 83.5636L165.136 83.5635L165.136 83.5635L165.136 83.5635L165.136 83.5634L165.136 83.5634L165.136 83.5634L165.136 83.5633L165.137 83.5558L165.139 83.5483C165.141 83.535 165.144 83.5233 165.147 83.5133L165.169 83.5068L165.291 83.4283C166.348 82.7458 172.777 78.3676 178.944 68.9809C179.464 71.7643 181.367 80.361 186.122 87.6063L186.164 87.6711Z"
                    stroke="#00EBC4"
                    strokeWidth={2}
                />
                <path
                    d="M88.7696 24.2165C88.3446 23.6725 88.441 22.8869 88.985 22.4619C89.529 22.0368 90.3146 22.1333 90.7396 22.6773L100.282 34.8915C100.707 35.4355 100.611 36.221 100.067 36.6461C99.5229 37.0711 98.7374 36.9746 98.3123 36.4306L88.7696 24.2165Z"
                    fill="white"
                />
            </g>
        </g>
        <defs>
            <linearGradient
                id="a63d7f84__paint0_linear_17115_4247"
                x1={113.542}
                y1={0.00244141}
                x2={113.542}
                y2={65.4178}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#E64527" />
                <stop offset={1} stopColor="#CB2425" />
            </linearGradient>
            <clipPath id="a63d7f84__clip0_17115_4247">
                <rect width={189} height={120} fill="white" />
            </clipPath>
            <clipPath id="a63d7f84__clip1_17115_4247">
                <rect
                    width={189}
                    height={122}
                    fill="white"
                    transform="translate(0 -1)"
                />
            </clipPath>
        </defs>
    </svg>
);

export default HotelBookingM;
