import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HotelNoCityPhotoL = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 1200 400"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#17c069d2__clip0_25495_5759)">
            <path
                d="M1136 -13H-93V400H1136V-13Z"
                fill="url(#17c069d2__paint0_linear_25495_5759)"
            />
            <path
                opacity={0.67}
                d="M405.905 203H290C290 203 308.538 192.024 316.241 192.61C323.944 193.195 322.645 198.605 322.645 198.605C322.645 198.605 338.131 185.988 351.767 186.722C365.403 187.456 363.788 194.144 363.788 194.144C363.788 194.144 378.812 179.16 402.747 181.189C421.529 182.739 405.905 203 405.905 203Z"
                fill="white"
            />
            <path
                opacity={0.5}
                d="M1109.26 89.5992H966.45C966.45 89.5992 989.29 76.2892 998.74 76.9992C1008.19 77.7092 1006.64 84.2492 1006.64 84.2492C1006.64 84.2492 1025.71 68.9492 1042.51 69.8492C1059.31 70.7492 1057.32 78.8492 1057.32 78.8492C1057.32 78.8492 1075.83 60.6792 1105.37 63.1392C1128.5 64.9992 1109.26 89.5992 1109.26 89.5992Z"
                fill="url(#17c069d2__paint1_linear_25495_5759)"
            />
            <path
                opacity={0.6}
                d="M248.73 154H-37C-37 154 1.04893 116.522 41.1791 110.938C81.3092 105.354 79.9189 132.469 79.9189 132.469C79.9189 132.469 132.329 55.1547 212.581 62.4909C292.832 69.8272 260.492 124.496 260.492 124.496C260.492 124.496 304.24 96.5244 332.608 108.002C360.977 119.479 338.653 154 338.653 154H248.73Z"
                fill="url(#17c069d2__paint2_linear_25495_5759)"
            />
            <path
                opacity={0.4}
                d="M615.74 99.3891H414.64C414.64 99.3891 441.42 76.5091 469.64 73.1091C497.86 69.7091 496.91 86.2491 496.91 86.2491C496.91 86.2491 533.78 39.0591 590.26 43.5291C646.74 47.9991 623.97 81.3791 623.97 81.3791C623.97 81.3791 654.74 64.3091 674.74 71.3091C694.74 78.3091 679 99.3891 679 99.3891H615.74Z"
                fill="url(#17c069d2__paint3_linear_25495_5759)"
            />
            <path
                opacity={0.7}
                d="M620.81 180.696H478C478 180.696 500.84 167.376 510.34 168.086C519.84 168.796 518.23 175.336 518.23 175.336C518.23 175.336 537.3 160.036 554.11 160.936C570.92 161.836 568.91 169.936 568.91 169.936C568.91 169.936 587.42 151.736 616.94 154.236C640.05 156.126 620.81 180.696 620.81 180.696Z"
                fill="url(#17c069d2__paint4_linear_25495_5759)"
            />
            <path
                d="M310.04 297.56C310.96 309.51 339.89 299.13 342.31 310.86C343.31 315.72 352.45 307.35 354.76 311.74C360.56 322.74 372.88 310.32 384.92 313.55C400.15 317.64 416.08 318.05 431.84 318.62C475.726 320.22 519.54 323.22 563.28 327.62C575.58 328.85 588.11 330.19 600.18 327.54C588.38 323.9 585.37 306.99 573.93 302.32C565.93 299.06 555.81 302.76 548.78 297.76C547.142 296.453 545.632 294.993 544.27 293.4C535.984 284.959 524.866 279.886 513.06 279.16C500.73 278.33 487.26 281.72 476.66 275.35C472.51 272.86 469.3 269.1 465.46 266.17C459.201 261.395 451.488 258.923 443.62 259.17C437.21 259.4 430.43 261.39 424.62 258.65C419.01 256.01 416.14 249.76 411.53 245.65C404.29 239.12 393.53 238.38 383.84 239.26C372.5 240.26 361.84 244.52 350.84 247.47C326.59 254 324.99 237.28 306.24 234.65C287.49 232.02 271.77 237.2 259.17 245C251.9 249.47 231.89 289.21 231.89 289.21L303.11 316.61L310.04 297.56Z"
                fill="#63A8A6"
            />
            <path
                d="M816.15 327.56C817.07 339.51 846 329.13 848.42 340.86C849.42 345.72 858.56 337.35 860.87 341.74C866.67 352.74 878.99 340.32 891.03 343.55C906.26 347.64 922.19 348.05 937.95 348.62C981.837 350.22 1025.65 353.22 1069.39 357.62C1081.69 358.85 1094.22 360.19 1106.29 357.54C1094.49 353.9 1091.48 336.99 1080.04 332.32C1072.04 329.06 1061.92 332.76 1054.89 327.76C1053.25 326.453 1051.74 324.993 1050.38 323.4C1042.09 314.959 1030.98 309.886 1019.17 309.16C1006.84 308.33 993.37 311.72 982.77 305.35C978.62 302.86 975.41 299.1 971.57 296.17C965.312 291.395 957.598 288.923 949.73 289.17C943.32 289.4 936.54 291.39 930.73 288.65C925.12 286.01 922.25 279.76 917.64 275.65C910.4 269.12 899.64 268.38 889.95 269.26C878.61 270.26 867.95 274.52 856.95 277.47C832.7 284 831.1 267.28 812.35 264.65C793.6 262.02 777.88 267.2 765.28 275C758.01 279.47 738 319.21 738 319.21L809.22 346.61L816.15 327.56Z"
                fill="#63A8A6"
            />
            <path
                d="M634.46 328.639C636.449 324.056 639.582 320.061 643.559 317.037C647.535 314.013 652.222 312.061 657.17 311.369C660.11 310.999 663.17 311.069 666 310.369C676.54 307.799 681.9 296.139 690.81 289.959C699.51 283.959 710.95 283.579 721.46 284.899C723.62 285.169 725.85 285.489 727.93 284.899C730.063 284.102 731.926 282.715 733.3 280.899C739.3 273.899 742.3 264.799 745.45 256.079C748.6 247.359 752.24 238.399 759.14 232.219C766.04 226.039 777.14 223.529 784.66 228.919C787.34 230.839 789.53 233.679 792.72 234.509C797.99 235.879 803.35 231.189 808.72 232.289C813.49 233.289 816.31 238.449 820.89 240.119C826.04 241.999 831.52 238.949 836.8 237.449C849.86 233.749 863.64 239.769 875.13 246.979C886.62 254.189 897.75 262.979 911.07 265.539C886.214 280.347 859.194 291.175 830.99 297.629C807.15 303.089 782.66 305.379 758.88 311.079C735.74 316.629 713.18 325.419 689.45 327.079C671.45 328.359 652.86 325.519 635.45 330.529"
                fill="#6BACAA"
            />
            <path
                d="M1140.57 358.639C1142.56 354.056 1145.69 350.061 1149.67 347.037C1153.65 344.013 1158.33 342.061 1163.28 341.369C1166.22 340.999 1169.28 341.069 1172.11 340.369C1182.65 337.799 1188.01 326.139 1196.92 319.959C1205.62 313.959 1217.06 313.579 1227.57 314.899C1229.73 315.169 1231.96 315.489 1234.04 314.899C1236.17 314.102 1238.04 312.715 1239.41 310.899C1245.41 303.899 1248.41 294.799 1251.56 286.079C1254.71 277.359 1258.35 268.399 1265.25 262.219C1272.15 256.039 1283.25 253.529 1290.77 258.919C1293.45 260.839 1295.64 263.679 1298.83 264.509C1304.1 265.879 1309.46 261.189 1314.83 262.289C1319.6 263.289 1322.42 268.449 1327 270.119C1332.15 271.999 1337.63 268.949 1342.91 267.449C1355.97 263.749 1369.75 269.769 1381.24 276.979C1392.73 284.189 1403.86 292.979 1417.18 295.539C1392.32 310.347 1365.3 321.175 1337.1 327.629C1313.26 333.089 1288.77 335.379 1264.99 341.079C1241.85 346.629 1219.29 355.419 1195.56 357.079C1177.56 358.359 1158.97 355.519 1141.56 360.529"
                fill="#6BACAA"
            />
            <path
                d="M280.22 291.72C280.22 291.72 522.13 291.89 621.47 329.81C621.47 329.81 789.47 272.03 924.82 272.93C1060.17 273.83 916.14 404.74 916.14 404.74L659.39 535.64L333.48 479.64L280.22 291.72Z"
                fill="#64A298"
            />
            <path
                d="M786.33 321.72C786.33 321.72 1028.24 321.89 1127.58 359.81C1127.58 359.81 1295.58 302.03 1430.93 302.93C1566.28 303.83 1422.25 434.74 1422.25 434.74L1165.5 565.64L839.59 509.64L786.33 321.72Z"
                fill="#64A298"
            />
            <path
                d="M611.42 382.7C611.42 382.7 621.7 378 643.14 374.44C664.58 370.88 686.7 371.56 696.14 371.56C705.58 371.56 723 366.56 727.74 365.02C732.48 363.48 796.32 333.72 837.98 339.74C879.64 345.76 860.37 380.66 860.37 380.66L823.69 417.38L765.24 437.24C750.928 436.428 736.69 434.617 722.63 431.82C701.99 427.45 650.63 416.11 631.52 405.65C612.41 395.19 610.61 391.45 610.17 387.11C609.73 382.77 611.42 382.7 611.42 382.7Z"
                fill="url(#17c069d2__paint5_radial_25495_5759)"
            />
            <path
                d="M1117.53 412.7C1117.53 412.7 1127.81 408 1149.25 404.44C1170.69 400.88 1192.81 401.56 1202.25 401.56C1211.69 401.56 1229.11 396.56 1233.85 395.02C1238.59 393.48 1302.43 363.72 1344.09 369.74C1385.75 375.76 1366.48 410.66 1366.48 410.66L1329.8 447.38L1271.35 467.24C1257.04 466.428 1242.8 464.617 1228.74 461.82C1208.1 457.45 1156.74 446.11 1137.63 435.65C1118.52 425.19 1116.72 421.45 1116.28 417.11C1115.84 412.77 1117.53 412.7 1117.53 412.7Z"
                fill="url(#17c069d2__paint6_radial_25495_5759)"
            />
            <path
                d="M367.954 225L448.231 232.106L505.08 288.955L475.135 323.39L414.468 317.121L378.171 287.954"
                fill="url(#17c069d2__paint7_linear_25495_5759)"
            />
            <path
                d="M431.909 288.955H505.08V395.088L391.393 393.615L421.067 290.416L431.909 288.955Z"
                fill="url(#17c069d2__paint8_linear_25495_5759)"
            />
            <path
                d="M305 288.743L367.954 225L431.909 288.955V395.088H305V288.743Z"
                fill="#A2D1FF"
            />
            <path
                d="M420.088 297.204H315.24V330.496H420.088V297.204Z"
                fill="#6B9EC1"
            />
            <path
                d="M496.819 297.204H476.373V387.157H496.819V297.204Z"
                fill="#6B9EC1"
            />
            <path
                d="M420.088 342.021H315.24V387.156H420.088V342.021Z"
                fill="#6B9EC1"
            />
            <path
                d="M369.626 288.955H366.268V387.169H369.626V288.955Z"
                fill="#A2D1FF"
            />
            <path
                d="M396.202 288.955H392.843V387.169H396.202V288.955Z"
                fill="#A2D1FF"
            />
            <path
                d="M343.052 288.955H339.693V387.169H343.052V288.955Z"
                fill="#A2D1FF"
            />
            <path
                d="M392.843 267.719H343.053V284.654H392.843V267.719Z"
                fill="#6B9EC1"
            />
            <path
                d="M390.58 227.097L452.45 288.954"
                stroke="#F29CAA"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M408.834 228.699L469.089 288.954"
                stroke="#F29CAA"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M424.968 229.983L483.926 288.954"
                stroke="#F29CAA"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M438.296 231.316L495.935 288.955"
                stroke="#F29CAA"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M576.04 268.311L644.16 274.341L692.4 322.581L666.99 351.801L615.51 346.481L584.71 321.731"
                fill="url(#17c069d2__paint9_linear_25495_5759)"
            />
            <path
                d="M630.31 322.58H692.4V412.64L595.93 411.39L621.11 323.82L630.31 322.58Z"
                fill="url(#17c069d2__paint10_linear_25495_5759)"
            />
            <path
                d="M522.62 322.401L576.04 268.311L630.31 322.581V412.641H522.62V322.401Z"
                fill="#A2D1FF"
            />
            <path
                d="M620.28 329.58H531.31V357.83H620.28V329.58Z"
                fill="#6B9EC1"
            />
            <path
                d="M685.4 329.58H668.05V405.91H685.4V329.58Z"
                fill="#6B9EC1"
            />
            <path
                d="M620.28 367.609H531.31V405.909H620.28V367.609Z"
                fill="#6B9EC1"
            />
            <path
                d="M577.47 322.58H574.62V405.92H577.47V322.58Z"
                fill="#A2D1FF"
            />
            <path
                d="M600.02 322.58H597.17V405.92H600.02V322.58Z"
                fill="#A2D1FF"
            />
            <path
                d="M554.91 322.58H552.06V405.92H554.91V322.58Z"
                fill="#A2D1FF"
            />
            <path
                d="M597.17 304.561H554.92V318.931H597.17V304.561Z"
                fill="#6B9EC1"
            />
            <path
                d="M595.25 270.09L647.74 322.58"
                stroke="#F29CAA"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M610.739 271.449L661.859 322.579"
                stroke="#F29CAA"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M624.42 272.539L674.45 322.579"
                stroke="#F29CAA"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M635.729 273.67L684.64 322.58"
                stroke="#F29CAA"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M162.609 211.74L271.769 221.4L349.069 298.7L308.349 345.53L225.859 337.01L176.499 297.35"
                fill="url(#17c069d2__paint11_linear_25495_5759)"
            />
            <path
                d="M249.569 298.699H349.069V443.039L194.479 441.019L234.819 300.699L249.569 298.699Z"
                fill="url(#17c069d2__paint12_linear_25495_5759)"
            />
            <path
                d="M77 298.42L162.61 211.74L249.57 298.7V443.04H77V298.42Z"
                fill="#A2D1FF"
            />
            <path
                d="M233.49 309.93H90.9199V355.2H233.49V309.93Z"
                fill="#6B9EC1"
            />
            <path
                d="M337.84 309.93H310.04V432.25H337.84V309.93Z"
                fill="#6B9EC1"
            />
            <path
                d="M233.49 370.869H90.9199V432.249H233.49V370.869Z"
                fill="#6B9EC1"
            />
            <path
                d="M164.889 298.699H160.319V432.249H164.889V298.699Z"
                fill="#A2D1FF"
            />
            <path
                d="M201.03 298.699H196.46V432.249H201.03V298.699Z"
                fill="#A2D1FF"
            />
            <path
                d="M128.75 298.699H124.18V432.249H128.75V298.699Z"
                fill="#A2D1FF"
            />
            <path
                d="M196.46 269.82H128.75V292.85H196.46V269.82Z"
                fill="#6B9EC1"
            />
            <path
                d="M193.38 214.58L277.5 298.7"
                stroke="#F29CAA"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M218.199 216.77L300.139 298.7"
                stroke="#F29CAA"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M240.13 218.52L320.31 298.7"
                stroke="#F29CAA"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M258.26 220.32L336.64 298.7"
                stroke="#F29CAA"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M325.41 397.171C333.76 385.431 346.96 363.391 356.98 355.561C367.98 346.951 383.66 347.431 397.21 350.911C404.41 352.771 411.55 355.361 418.99 355.471C426.99 355.591 434.81 352.771 442.25 349.681C458.25 343.041 474.54 334.791 491.83 335.931C513.37 337.351 526.65 343.541 536.53 362.741C538.908 367.145 542.122 371.044 545.99 374.221C548.83 376.621 554.47 377.341 558.1 378.121C579.58 382.701 603.1 370.171 623.28 378.911C638.05 385.331 648.05 412.911 662.16 420.711C657.73 422.961 652.57 423.111 647.6 423.211C538.68 425.324 429.746 426.684 320.8 427.291C319.484 427.398 318.161 427.192 316.94 426.691C313.18 424.751 314.51 419.081 316.49 415.341C322.55 403.921 320.75 407.171 328.94 397.171"
                fill="#2E7C6F"
            />
            <path
                d="M831.52 427.171C839.87 415.431 853.07 393.391 863.09 385.561C874.09 376.951 889.77 377.431 903.32 380.911C910.52 382.771 917.66 385.361 925.1 385.471C933.1 385.591 940.92 382.771 948.36 379.681C964.36 373.041 980.65 364.791 997.94 365.931C1019.48 367.351 1032.76 373.541 1042.64 392.741C1045.02 397.145 1048.23 401.044 1052.1 404.221C1054.94 406.621 1060.58 407.341 1064.21 408.121C1085.69 412.701 1109.21 400.171 1129.39 408.911C1144.16 415.331 1154.16 442.911 1168.27 450.711C1163.84 452.961 1158.68 453.111 1153.71 453.211C1044.79 455.324 935.857 456.684 826.91 457.291C825.594 457.398 824.271 457.192 823.05 456.691C819.29 454.751 820.62 449.081 822.6 445.341C828.66 433.921 826.86 437.171 835.05 427.171"
                fill="#2E7C6F"
            />
            <path
                d="M953.61 -123.28L352.89 77.2202C336.574 128.377 325.225 180.987 319 234.32L953.61 1.41022V-123.28Z"
                fill="url(#17c069d2__paint13_linear_25495_5759)"
            />
            <path
                d="M953.16 66.5898L271.95 301.5L284.91 363.53L953.61 118.12L953.16 66.5898Z"
                fill="url(#17c069d2__paint14_linear_25495_5759)"
            />
            <path
                opacity={0.3}
                d="M302.21 42.2402L271.95 50.2602L273.55 42.2402H302.21Z"
                fill="#D38579"
            />
            <path
                d="M735 432.03C735 432.03 735 -214.06 735.25 -215.1L753.66 -210.41C753.4 -209.41 753.91 430.25 753.91 430.25L735 432.03Z"
                fill="#4F6C7F"
            />
            <path
                d="M1117 432.03C1117 432.03 1117 -214.06 1117.25 -215.1L1135.66 -210.41C1135.4 -209.41 1135.91 430.25 1135.91 430.25L1117 432.03Z"
                fill="#4F6C7F"
            />
            <path
                d="M-57 -263.76V449.98H1444.14V-263.76H-57ZM1133.29 434.72H361.41V-205.07H1139L1133.29 434.72Z"
                fill="url(#17c069d2__paint15_linear_25495_5759)"
            />
            <path
                d="M757 434.5L756.72 -205.29M-77.0004 -264V449.74H1476.37V-264H-77.0004ZM1141 432.61L361.41 434.5V-205.31H1141V432.61Z"
                stroke="url(#17c069d2__paint16_linear_25495_5759)"
                strokeWidth={19}
                strokeMiterlimit={10}
            />
            <path
                d="M913.219 -38.0998C844.999 -42.9498 804.879 12.6802 801.719 48.5602L811.599 71.2802C811.599 71.2802 811.119 96.8802 778.339 111.76C745.559 126.64 728.799 146.69 738.129 170.48C738.129 170.48 707.359 194.82 716.479 225.36C725.599 255.9 763.779 263.45 763.779 263.45L1014 316.74C1014 316.74 1033 320.24 1064.51 296.4C1096.02 272.56 1092.03 230.87 1083.62 216.83C1075.21 202.79 1062.48 192.74 1062.48 192.74C1062.48 192.74 1080.48 167.04 1062.41 146.37C1044.34 125.7 1015.53 125.07 1011.12 99.1402C1006.71 73.2102 1016.53 34.3902 974.119 -13.1998C931.709 -60.7898 913.219 -38.0998 913.219 -38.0998Z"
                fill="#333333"
            />
            <path
                d="M929.309 207.74C1006.06 229.33 1067.22 259.09 1077.7 292.13C1093.14 340.85 1081.79 442.3 1081.79 442.3L833.649 468.21C833.649 468.21 667.719 443.21 669.399 442.21C671.079 441.21 699.659 328.78 732.799 276.83C760.249 233.83 790.319 234.57 832.449 226.45C866.819 219.86 929.309 207.74 929.309 207.74Z"
                fill="url(#17c069d2__paint17_linear_25495_5759)"
            />
            <path
                d="M866.389 281.23C888.749 292.61 925.389 274.79 934.739 269.43C944.089 264.07 968.359 247.14 971.119 222.73C956.699 219.5 952.859 176.79 946.389 143.91L948.679 100.35L949.139 93.3504C949.139 93.3504 912.799 77.5004 896.669 20.6904C896.669 20.6904 857.029 53.5004 801.719 48.5604C801.719 48.5604 799.719 65.1504 799.609 78.2504C799.499 91.3504 802.849 100.67 799.779 118.4C796.709 136.13 794.889 153.14 800.439 174.3C805.989 195.46 812.619 208.3 827.809 213.83C840.809 218.56 854.439 217.47 868.179 213.34L869.999 221L870.699 223.91C846.169 244.08 846.299 271 866.389 281.23Z"
                fill="#FFD4C1"
            />
            <path
                opacity={0.6}
                d="M930.999 94.69C926.409 101.56 915.999 121.02 923.389 147.62C929.969 171.28 942.819 177.98 949.789 179.87C948.319 160.44 946.439 143.87 946.439 143.87L948.729 100.31L949.189 93.31C949.189 93.31 913.369 77.74 897.059 22C897.059 22 905.799 72.76 930.999 94.69Z"
                fill="#FEC0AB"
            />
            <path
                opacity={0.6}
                d="M916.319 186.93C902.161 198.152 886.233 206.939 869.189 212.93L868.299 213.87L870.709 223.87C867.827 226.239 865.15 228.849 862.709 231.67C859.344 235.35 856.638 239.582 854.709 244.18C863.709 256.77 871.549 254.18 871.549 254.18C873.006 253.023 874.26 251.631 875.259 250.06C877.369 247.06 873.699 236.38 873.699 236.38C908.119 217 916.319 186.93 916.319 186.93Z"
                fill="#FEC0AB"
            />
            <path
                d="M898.139 17.0999C898.139 17.0999 907.319 -4.23006 927.999 -14.0601"
                stroke="#333333"
                strokeMiterlimit={10}
            />
            <path
                d="M922.129 181.35C904.619 200.47 868.129 213.35 868.129 213.35L875.419 243.68C875.419 243.68 877.889 251.68 870.579 254.68"
                stroke="#E49776"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M896.896 160.749C910.845 156.374 918.926 142.537 914.945 129.842C910.964 117.147 896.429 110.402 882.48 114.776C868.531 119.15 860.45 132.987 864.43 145.682C868.411 158.377 882.946 165.123 896.896 160.749Z"
                fill="#FEC0AB"
            />
            <path
                d="M820.539 125.43C819.203 121.052 816.651 117.143 813.179 114.16C809.707 111.177 805.458 109.241 800.929 108.58C800.729 111.872 800.345 115.151 799.779 118.4C797.619 130.84 796.089 142.94 797.289 156.4C800.08 156.586 802.882 156.247 805.549 155.4C817.809 151.54 824.519 138.13 820.539 125.43Z"
                fill="#FEC0AB"
            />
            <path
                d="M875.281 102.603C876.267 98.7785 874.569 95.0341 871.488 94.2402C868.408 93.4463 865.112 95.9035 864.126 99.7285C863.14 103.553 864.838 107.298 867.918 108.092C870.999 108.886 874.295 106.428 875.281 102.603Z"
                fill="#333333"
            />
            <path
                d="M824.411 101.575C825.412 97.7611 823.733 94.0159 820.661 93.21C817.589 92.4042 814.288 94.8429 813.287 98.6572C812.287 102.471 813.966 106.217 817.037 107.023C820.109 107.828 823.41 105.39 824.411 101.575Z"
                fill="#333333"
            />
            <path
                d="M870.339 81.7901C870.339 81.7901 890.939 78.5701 899.189 95.9001"
                stroke="#333333"
                strokeWidth={4}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M825.719 78.62C825.719 78.62 809.479 72.78 800.579 88.89"
                stroke="#333333"
                strokeWidth={4}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M836.829 85.1299C836.829 85.1299 839.829 99.0599 833.129 106.92C826.429 114.78 817.429 119.85 816.969 126.34C816.319 135.57 829.369 140.94 829.369 140.94"
                fill="#FFD4C1"
            />
            <path
                d="M836.829 85.1299C836.829 85.1299 839.829 99.0599 833.129 106.92C826.429 114.78 817.429 119.85 816.969 126.34C816.319 135.57 829.369 140.94 829.369 140.94"
                stroke="#E49776"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M834.819 134.7L838.259 139.35"
                stroke="#E49776"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M817.909 166.87C825.858 169.799 834.461 170.475 842.77 168.826C851.08 167.176 858.772 163.263 864.999 157.52"
                stroke="#E49776"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M754.359 350.39L724.479 404.83"
                stroke="#EEA60D"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M961.906 391.56L953.686 427.81"
                stroke="#EEA60D"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M868.179 213.34C838.859 223 821.749 211 821.749 211"
                stroke="#D38579"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M986.419 130.81C981.419 146.76 984.559 159.92 972.329 162.52C968.249 163.38 949.429 161.52 945.429 160.27C929.429 155.27 921.799 133.99 928.429 112.73C934.029 94.73 947.999 82.58 961.849 82.23C964.399 82.17 982.779 83.23 985.269 84.01C1001.28 89 993.049 109.55 986.419 130.81Z"
                fill="#507CA0"
            />
            <path
                d="M995.436 131.45C990.436 147.45 979.366 159.55 967.136 162.15C963.056 163.01 958.436 162.15 954.436 160.91C938.436 155.91 930.816 134.63 937.436 113.37C943.036 95.3701 957.006 83.2201 970.856 82.8701C973.314 82.664 975.789 82.8771 978.176 83.5C994.186 88.5 1002.06 110.19 995.436 131.45Z"
                fill="#8AC9FF"
            />
            <path
                d="M953.939 113.33L972.289 96.56L990.789 86.64C989.257 85.3646 987.486 84.4091 985.579 83.83C979.249 81.75 964.449 81.97 961.869 82.03C949.249 82.35 936.539 92.38 929.979 107.64L953.939 113.33Z"
                fill="#75B5E5"
            />
            <path
                d="M947.839 -7.12988C985.159 18.1301 981.509 81.8701 981.509 81.8701L968.509 81.2001C964.889 81.2001 962.219 84.5801 959.219 85.8901L956.999 84.1001C956.999 84.1001 960.649 20.3701 923.319 -4.89988"
                fill="#8AC9FF"
            />
            <path
                d="M950.299 -7.68994C987.579 18.1601 982.869 83.1601 982.869 83.1601C978.869 82.5401 968.219 81.5201 959.269 85.8801C959.269 85.8801 963.029 20.5001 925.749 -5.33994"
                fill="#AEDCFF"
            />
            <path
                d="M1004.44 132.121C1011.06 110.862 1003.46 89.5811 987.446 84.5876C971.433 79.5942 953.079 92.7796 946.449 114.038C939.82 135.296 947.426 156.578 963.438 161.571C979.451 166.565 997.806 153.379 1004.44 132.121Z"
                fill="#AEDCFF"
            />
            <path
                d="M993.638 128.753C997.798 115.414 993.023 102.06 982.974 98.9263C972.925 95.7925 961.406 104.066 957.246 117.405C953.087 130.744 957.861 144.098 967.91 147.232C977.959 150.366 989.478 142.093 993.638 128.753Z"
                fill="#75B5E5"
            />
            <path
                d="M304.351 248.637L279.126 302.429C279.126 302.429 338 307.008 338 351.827C338 383.003 313.69 408.549 279.446 408.549H212.241C191.593 408.549 164.079 383.324 164.079 353.154C164.079 304.352 225.517 302.429 225.517 302.429L200.154 248.729L304.351 248.637Z"
                fill="#C5D3DD"
            />
            <path
                d="M212.104 177.084L235.132 248.639"
                stroke="#C5D3DD"
                strokeWidth={2}
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M265.299 185.782C233.252 200.386 235.221 247.952 235.221 247.952C248.53 242.469 259.252 232.123 265.207 219.018C265.207 219.018 273.539 199.241 265.299 185.782Z"
                fill="#C5D3DD"
            />
            <path
                d="M171.862 193.199C185.184 229.457 225.975 221.171 225.975 221.171C224.979 215.063 222.478 209.299 218.698 204.4C214.917 199.5 209.976 195.62 204.32 193.108C184.955 184.73 171.862 193.199 171.862 193.199Z"
                fill="#C5D3DD"
            />
            <path
                d="M205.101 177.59C192.788 177.59 182.806 167.608 182.806 155.295C182.806 142.982 192.788 133 205.101 133C217.414 133 227.396 142.982 227.396 155.295C227.396 167.608 217.414 177.59 205.101 177.59Z"
                fill="#C5D3DD"
            />
        </g>
        <defs>
            <linearGradient
                id="17c069d2__paint0_linear_25495_5759"
                x1={593.192}
                y1={-116.885}
                x2={467.362}
                y2={439.534}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#C0DFFD" />
                <stop offset={1} stopColor="white" />
            </linearGradient>
            <linearGradient
                id="17c069d2__paint1_linear_25495_5759"
                x1={182072}
                y1={1935.14}
                x2={182081}
                y2={2996.11}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="17c069d2__paint2_linear_25495_5759"
                x1={124970}
                y1={566.16}
                x2={124877}
                y2={13899.3}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="17c069d2__paint3_linear_25495_5759"
                x1={194043}
                y1={2466.48}
                x2={194003}
                y2={7286.73}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="17c069d2__paint4_linear_25495_5759"
                x1={99877.3}
                y1={4310.81}
                x2={99869.1}
                y2={5663.67}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <radialGradient
                id="17c069d2__paint5_radial_25495_5759"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(706.33 327.55) scale(108.23)"
            >
                <stop stopColor="#7CD772" />
                <stop offset={1} stopColor="#4A9185" />
            </radialGradient>
            <radialGradient
                id="17c069d2__paint6_radial_25495_5759"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(1212.44 357.55) scale(108.23)"
            >
                <stop stopColor="#7CD772" />
                <stop offset={1} stopColor="#4A9185" />
            </radialGradient>
            <linearGradient
                id="17c069d2__paint7_linear_25495_5759"
                x1={440.759}
                y1={218.483}
                x2={430.188}
                y2={314.387}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#EA8B9B" />
                <stop offset={1} stopColor="#D96C75" />
            </linearGradient>
            <linearGradient
                id="17c069d2__paint8_linear_25495_5759"
                x1={462.231}
                y1={267.33}
                x2={448.278}
                y2={393.98}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#D1E9FF" />
                <stop offset={1} stopColor="white" />
            </linearGradient>
            <linearGradient
                id="17c069d2__paint9_linear_25495_5759"
                x1={72932.2}
                y1={23042.7}
                x2={72391.7}
                y2={29876.9}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#EA8B9B" />
                <stop offset={1} stopColor="#D96C75" />
            </linearGradient>
            <linearGradient
                id="17c069d2__paint10_linear_25495_5759"
                x1={62341.5}
                y1={28622.1}
                x2={61344.5}
                y2={38315.8}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#D1E9FF" />
                <stop offset={1} stopColor="white" />
            </linearGradient>
            <linearGradient
                id="17c069d2__paint11_linear_25495_5759"
                x1={45960.9}
                y1={28693}
                x2={44572.4}
                y2={46242.8}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#EA8B9B" />
                <stop offset={1} stopColor="#D96C75" />
            </linearGradient>
            <linearGradient
                id="17c069d2__paint12_linear_25495_5759"
                x1={42678.9}
                y1={40612.9}
                x2={40117}
                y2={65509.4}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#D1E9FF" />
                <stop offset={1} stopColor="white" />
            </linearGradient>
            <linearGradient
                id="17c069d2__paint13_linear_25495_5759"
                x1={418667}
                y1={6499.48}
                x2={183088}
                y2={242057}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="17c069d2__paint14_linear_25495_5759"
                x1={437134}
                y1={52491.3}
                x2={247942}
                y2={297205}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="17c069d2__paint15_linear_25495_5759"
                x1={643}
                y1={-284.9}
                x2={751}
                y2={238}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#E5F2FB" />
                <stop offset={1} stopColor="#8BA3B6" />
            </linearGradient>
            <linearGradient
                id="17c069d2__paint16_linear_25495_5759"
                x1={631.27}
                y1={-433.96}
                x2={942.29}
                y2={619.69}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#7B9FB3" />
                <stop offset={1} stopColor="#5F8296" />
            </linearGradient>
            <linearGradient
                id="17c069d2__paint17_linear_25495_5759"
                x1={875.141}
                y1={328.619}
                x2={1099.53}
                y2={417.406}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FFCC00" />
                <stop offset={0.973958} stopColor="#FFB21D" />
            </linearGradient>
            <clipPath id="17c069d2__clip0_25495_5759">
                <rect width={1200} height={400} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export default HotelNoCityPhotoL;
