import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const LinearTemperatureM = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 118 127"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <circle
            cx={77.0007}
            cy={94.6833}
            r={12.3171}
            stroke="#E6ECF8"
            strokeWidth={2}
        />
        <mask id="599fca93__path-2-inside-1_24103_5146" fill="white">
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M77 10C68.7157 10 62 16.7157 62 25V73.6691C55.3448 78.2872 51 85.896 51 94.5C51 108.583 62.6406 120 77 120C91.3594 120 103 108.583 103 94.5C103 85.896 98.6552 78.2872 92 73.6691V25C92 16.7157 85.2843 10 77 10ZM77 12C69.8203 12 64 17.8203 64 25V74.7427C57.3815 78.9267 53 86.2123 53 94.5C53 107.479 63.7452 118 77 118C90.2548 118 101 107.479 101 94.5C101 86.2123 96.6185 78.9267 90 74.7427V25C90 17.8203 84.1797 12 77 12Z"
            />
        </mask>
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M77 10C68.7157 10 62 16.7157 62 25V73.6691C55.3448 78.2872 51 85.896 51 94.5C51 108.583 62.6406 120 77 120C91.3594 120 103 108.583 103 94.5C103 85.896 98.6552 78.2872 92 73.6691V25C92 16.7157 85.2843 10 77 10ZM77 12C69.8203 12 64 17.8203 64 25V74.7427C57.3815 78.9267 53 86.2123 53 94.5C53 107.479 63.7452 118 77 118C90.2548 118 101 107.479 101 94.5C101 86.2123 96.6185 78.9267 90 74.7427V25C90 17.8203 84.1797 12 77 12Z"
            fill="#E6ECF8"
        />
        <path
            d="M62 73.6691L62.5701 74.4907L63 74.1923V73.6691H62ZM92 73.6691H91V74.1923L91.4299 74.4907L92 73.6691ZM64 74.7427L64.5343 75.588L65 75.2936V74.7427H64ZM90 74.7427H89V75.2936L89.4657 75.588L90 74.7427ZM77 9C68.1634 9 61 16.1634 61 25H63C63 17.268 69.268 11 77 11V9ZM61 25V73.6691H63V25H61ZM61.4299 72.8475C54.5213 77.6415 50 85.5493 50 94.5H52C52 86.2426 56.1683 78.933 62.5701 74.4907L61.4299 72.8475ZM50 94.5C50 109.154 62.1067 121 77 121V119C63.1745 119 52 108.013 52 94.5H50ZM77 121C91.8933 121 104 109.154 104 94.5H102C102 108.013 90.8255 119 77 119V121ZM104 94.5C104 85.5493 99.4787 77.6415 92.5701 72.8475L91.4299 74.4907C97.8317 78.933 102 86.2426 102 94.5H104ZM93 73.6691V25H91V73.6691H93ZM93 25C93 16.1634 85.8366 9 77 9V11C84.732 11 91 17.268 91 25H93ZM77 11C69.268 11 63 17.268 63 25H65C65 18.3726 70.3726 13 77 13V11ZM63 25V74.7427H65V25H63ZM63.4657 73.8974C56.5749 78.2534 52 85.8489 52 94.5H54C54 86.5757 58.188 79.5999 64.5343 75.588L63.4657 73.8974ZM52 94.5C52 108.051 63.2128 119 77 119V117C64.2775 117 54 106.907 54 94.5H52ZM77 119C90.7872 119 102 108.051 102 94.5H100C100 106.907 89.7225 117 77 117V119ZM102 94.5C102 85.8489 97.4251 78.2534 90.5343 73.8974L89.4657 75.588C95.812 79.5999 100 86.5757 100 94.5H102ZM91 74.7427V25H89V74.7427H91ZM91 25C91 17.268 84.732 11 77 11V13C83.6274 13 89 18.3726 89 25H91Z"
            fill="#E6ECF8"
            mask="url(#599fca93__path-2-inside-1_24103_5146)"
        />
        <rect x={76} y={43} width={2} height={40} rx={1} fill="#E6ECF8" />
        <rect x={19} y={31.4595} width={28} height={2} rx={1} fill="#E6ECF8" />
        <rect
            x={32}
            y={46.4595}
            width={28}
            height={2}
            rx={1}
            transform="rotate(-90 32 46.4595)"
            fill="#E6ECF8"
        />
    </svg>
);

export default LinearTemperatureM;
