import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const NoHotelPhotoXs = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <path
            d="M18.9736 7.94136C19.9797 7.94136 20.7954 7.12573 20.7954 6.1196C20.7954 5.11348 19.9797 4.29785 18.9736 4.29785C17.9675 4.29785 17.1519 5.11348 17.1519 6.1196C17.1519 7.12573 17.9675 7.94136 18.9736 7.94136Z"
            fill="#FED22D"
        />
        <path
            d="M7.48454 6.077C7.31038 11.8174 7.30476 18.1937 7.48454 23.6523H14.6758C14.8612 18.2563 14.8499 11.9009 14.6758 6.077C14.67 5.96391 14.618 5.85713 14.5302 5.77854C14.4425 5.69995 14.3257 5.6555 14.2038 5.6543H7.95085C7.8291 5.65426 7.71216 5.69846 7.62503 5.77745C7.5379 5.85644 7.48748 5.96394 7.48454 6.077Z"
            fill="#CBD4D9"
        />
        <path
            d="M13.5311 5.65424H8.65023C8.59285 5.02741 8.58003 4.3962 8.61189 3.76696C8.6196 3.62588 8.67206 3.49302 8.75927 3.39375C8.84647 3.29448 8.9623 3.23575 9.08465 3.22879C10.4168 3.1477 11.7517 3.1477 13.0839 3.22879C13.2083 3.23606 13.3259 3.29686 13.4134 3.39921C13.5009 3.50156 13.552 3.63802 13.5567 3.7817C13.577 4.40596 13.5685 5.03103 13.5311 5.65424Z"
            fill="#CBD4D9"
        />
        <path
            d="M11.0171 0.681641V3.53711"
            stroke="#CBD4D9"
            strokeMiterlimit={10}
            strokeLinecap="round"
        />
        <path
            d="M13.7964 6.91357H8.3291V11.5083H13.7964V6.91357Z"
            fill="white"
        />
        <path
            d="M13.7964 13.7974H8.3291V18.3921H13.7964V13.7974Z"
            fill="white"
        />
        <path
            d="M13.7964 20.6758H8.3291V23.2758H13.7964V20.6758Z"
            fill="white"
        />
        <path
            d="M3.00014 13.7403C2.94278 17.0591 2.95425 19.4658 3.00014 23.3993H9.1135C9.2397 18.9353 9.22249 15.2735 9.1135 10.0073L3.00014 13.7403Z"
            fill="#A1B1B7"
        />
        <path
            d="M3.99988 18.1844H7.99988V13.7788H3.99988V18.1844Z"
            fill="#F4F7F9"
        />
        <path
            d="M3.99988 19.6528C3.99988 20.9714 3.99988 22.3181 3.99988 23.693H7.99988V19.6528H3.99988Z"
            fill="#F4F7F9"
        />
        <path
            d="M2.44687 14.1463L9.63531 9.87174C9.69173 9.83969 9.73923 9.79074 9.77262 9.73026C9.80601 9.66978 9.824 9.6001 9.82461 9.52886C9.82462 9.4644 9.8104 9.40095 9.78322 9.34424C9.75605 9.28754 9.71678 9.23935 9.66897 9.20404C9.62115 9.16874 9.56629 9.14741 9.50934 9.142C9.45239 9.13658 9.39514 9.14725 9.34275 9.17303C6.85314 10.4669 4.40299 12.0049 2.12563 13.4799C2.07246 13.513 2.02832 13.5618 1.99799 13.6211C1.96765 13.6804 1.95228 13.7479 1.95354 13.8164C1.95495 13.881 1.97089 13.9442 1.99988 14C2.02886 14.0557 2.06994 14.1023 2.11925 14.1353C2.16856 14.1683 2.22449 14.1866 2.2818 14.1885C2.3391 14.1904 2.3959 14.1759 2.44687 14.1463Z"
            fill="#A1B1B7"
        />
        <path
            d="M20.3015 19.2691C20.3662 22.1937 20.3533 19.9326 20.3015 23.3989H13.1265C12.9841 19.4651 13.0035 20.6202 13.1265 15.9795L20.3015 19.2691Z"
            fill="#A1B1B7"
        />
        <path
            d="M19.1617 19.9996C19.1617 21.4575 19.1617 22.1725 19.1617 23.6927H14.1892V18.2207L19.1617 19.9996Z"
            fill="#F4F7F9"
        />
        <path
            d="M20.5925 19.8744L12.5379 15.8439C12.4742 15.8119 12.4207 15.7629 12.383 15.7024C12.3453 15.6419 12.3251 15.5723 12.3244 15.501C12.3244 15.4366 12.3404 15.3731 12.371 15.3164C12.4017 15.2597 12.446 15.2115 12.4999 15.1762C12.5538 15.1409 12.6157 15.1196 12.6799 15.1142C12.7442 15.1088 12.8087 15.1194 12.8678 15.1452C15.6756 16.4391 18.3863 17.733 20.9548 19.2081C21.0147 19.2411 21.0645 19.2899 21.0987 19.3492C21.1329 19.4085 21.1503 19.4761 21.1488 19.5445C21.1473 19.6091 21.1293 19.6723 21.0966 19.7281C21.0639 19.7839 21.0176 19.8305 20.962 19.8634C20.9063 19.8964 20.8433 19.9147 20.7786 19.9167C20.714 19.9186 20.6499 19.9041 20.5925 19.8744Z"
            fill="#A1B1B7"
        />
        <path
            d="M2 23.5H21"
            stroke="#86949B"
            strokeWidth={0.5}
            strokeMiterlimit={10}
            strokeLinecap="round"
        />
    </svg>
);

export default NoHotelPhotoXs;
