import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const NoTripsL = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 1200 400"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <rect width={1200} height={400} fill="#F5F4F2" />
        <g clipPath="url(#da023442__clip0_24891_5115)">
            <path
                d="M1200 -51.52H0V422.48H1200V-51.52Z"
                fill="url(#da023442__paint0_linear_24891_5115)"
            />
            <path
                d="M367.48 200.25C376.196 186.548 387.387 174.587 400.48 164.98C421.48 149.98 421.48 168.98 421.48 168.98C421.48 168.98 448.48 154.98 462.48 154.98C484.68 154.98 475.48 165.44 475.48 165.44C428.25 178.89 391.31 191.54 367.92 200.08"
                fill="url(#da023442__paint1_linear_24891_5115)"
            />
            <path
                d="M829.5 103C824.5 72.9998 771.5 93.9998 771.5 93.9998C771.5 93.9998 770.5 69.9998 746.5 74.9998C722.5 79.9998 706.5 89.9998 706.5 89.9998C706.5 89.9998 718.5 55.9998 676.5 62.9998C634.5 69.9998 590.5 105 575.5 126C569.5 115 540.5 130 523.01 152.63C606.71 131.25 712.93 110.43 829.5 103Z"
                fill="url(#da023442__paint2_linear_24891_5115)"
            />
            <path
                d="M919.29 182.5C933.07 177 940.5 146 911.5 143C882.5 140 848.5 158 836.5 169C839.5 165 842.5 147 818.5 153C794.5 159 767.5 175 767.5 175H767.39C818.032 174.39 868.664 176.884 919 182.47"
                fill="url(#da023442__paint3_linear_24891_5115)"
            />
            <path
                d="M1099.5 4.99998C1043.21 0.999984 1005.69 62 1005.69 62C1005.69 62 1000.79 31 944.5 43C888.21 55 867 100.79 867 100.79L925 93.52C925 93.52 1038 176.74 1040 175.69C1042 174.64 1099.5 4.99998 1099.5 4.99998Z"
                fill="url(#da023442__paint4_linear_24891_5115)"
            />
            <path
                d="M374.55 138C374.55 138 378.5 123 388.5 114C398.5 105 405.5 113 405.5 113C405.5 113 415.5 51 468.5 20C521.5 -11 513.5 50 513.5 50C513.5 50 534.5 21 564.5 18C594.5 15 596.5 35 596.5 35C596.5 35 599.5 -16 655.5 -28C711.5 -40 921.5 -34 921.5 -34C681.5 -11.5 479.14 81.2 374.67 137.91"
                fill="url(#da023442__paint5_linear_24891_5115)"
            />
            <path
                d="M316.9 87.52C328.5 34 373.5 8 374.5 26C374.5 26 383.5 -24 434.5 -38C485.5 -52 480.5 -30 480.5 -30C420.876 1.6628 365.801 41.2338 316.77 87.64"
                fill="url(#da023442__paint6_linear_24891_5115)"
            />
            <path
                d="M711.38 182.91C711.32 168.6 677.78 181.04 677.78 181.04C677.78 181.04 675.7 171.13 656.13 172.17C644.388 172.81 633.074 176.793 623.52 183.65C623.52 183.65 621.7 163.56 591 165.52C560.3 167.48 535.41 196 535.41 196C535.41 196 533.26 187.2 518.98 189.35C504.7 191.5 480.63 208.87 480.63 208.87C546 199.45 628.55 189.08 711.38 182.91Z"
                fill="url(#da023442__paint7_linear_24891_5115)"
            />
            <path
                d="M501.17 266.32C501.17 266.32 520.8 263.42 552.87 260.81L553.17 260.68C552.162 259.464 550.735 258.668 549.17 258.45C540.75 256.45 527.55 260.45 527.55 260.45C527.55 260.45 529.89 253.7 516.79 253.6C503.69 253.5 491.74 261.6 491.74 261.6"
                fill="url(#da023442__paint8_linear_24891_5115)"
            />
            <path
                d="M619.35 266.001C619.35 266.001 634.48 259.591 644.72 260.171C654.96 260.751 653.65 264.171 653.65 264.171C653.65 264.171 673.74 253.17 689.13 255.37C704.52 257.57 701.13 264.111 701.13 264.111C701.13 264.111 713 258.5 720.43 262.54C727.86 266.58 739.09 269.251 739.09 269.251C699.352 266.054 659.469 265.033 619.62 266.191"
                fill="url(#da023442__paint9_linear_24891_5115)"
            />
            <path
                d="M0 346.34L212 307C212 307 541.09 299.18 523 279.22C512.028 267.274 496.817 260.095 480.62 259.22C480.62 259.22 456.56 224.01 441.69 218.53C426.82 213.05 413.52 228 413.52 228C413.52 228 353.31 105.8 308.65 113.86C275.51 119.86 260.41 152.12 260.41 152.12C193.11 -14.78 104.41 -35.3 104.41 -35.3L57.67 -51.52H0V346.34Z"
                fill="url(#da023442__paint10_linear_24891_5115)"
            />
            <path
                opacity={0.51}
                d="M104.39 -35.3001C104.39 -35.3001 193.11 -14.7801 260.39 152.12C260.39 152.12 274.78 120.55 308.63 114.12C352.76 105.67 413.52 228 413.52 228C413.52 228 426.83 213.13 441.7 218.61C456.57 224.09 480.63 259.3 480.63 259.3C496.827 260.175 512.038 267.354 523.01 279.3C541.09 299.3 212.01 307.08 212.01 307.08L-15.7397 349.26L-5.16974 -73.3501L104.39 -35.3001Z"
                fill="url(#da023442__paint11_linear_24891_5115)"
            />
            <path
                d="M1200 -47.7803C1152.61 -46.7803 1067.91 -22.5503 977.78 111.35C977.78 111.35 953.52 79.2497 905.78 87.8697C858.04 96.4897 799.35 208.7 799.35 208.7C799.35 208.7 778.61 195.7 757.09 208.7C735.57 221.7 701.26 272.57 701.26 272.57C689.26 264.22 656.13 284.31 656.13 284.31L1200 309.8V-47.7803Z"
                fill="url(#da023442__paint12_linear_24891_5115)"
            />
            <path
                opacity={0.51}
                d="M1239.17 -42.6899C1239.17 -42.6899 1114.74 -92.3499 977.78 111.13C977.78 111.13 953.52 79.0301 905.78 87.6401C858.04 96.2501 799.35 208.48 799.35 208.48C799.35 208.48 778.61 195.48 757.09 208.48C735.57 221.48 701.26 272.34 701.26 272.34C689.26 264 656.13 284.08 656.13 284.08L1207.13 309.91L1305.74 300.52L1239.17 -42.6899Z"
                fill="url(#da023442__paint13_linear_24891_5115)"
            />
            <path
                opacity={0.2}
                d="M260.43 152.15L267.08 168.08C267.08 168.08 282.08 201.58 285.71 212.08C285.71 212.08 268.5 128.08 308.71 114.15C278.64 119.49 261.58 148.71 260.43 152.15Z"
                fill="#06001A"
            />
            <path
                opacity={0.07}
                d="M431.84 217.38C421.44 218.94 413.55 227.74 413.55 227.74C413.55 227.74 421.55 244.8 425.81 259.94C425.78 259.94 422.45 226.73 431.84 217.38Z"
                fill="#06001A"
            />
            <g opacity={0.5}>
                <path
                    opacity={0.5}
                    d="M750.73 276.19C771.05 272.3 781.12 243.29 801.81 243.69C806.03 243.77 810.17 245.18 814.38 244.99C829.88 244.27 836.58 224.28 850.38 217.24C864.38 210.1 880.86 217.93 896.27 220.98C910.27 223.76 924.81 222.41 939.06 221.05C947.47 220.24 956.01 219.4 963.82 216.19C977.09 210.72 987.67 198.64 1001.9 196.8C1012.02 195.5 1022.07 199.72 1032.27 199.8C1049.21 199.95 1063.88 189 1078.47 180.38C1088.83 174.26 1099.97 169.06 1111.88 167.38C1120.13 166.236 1128.52 166.807 1136.54 169.058C1144.56 171.309 1152.02 175.19 1158.47 180.46C1164.85 185.808 1170.02 192.45 1173.64 199.948C1177.26 207.445 1179.25 215.627 1179.47 223.95C1179.57 230.05 1178.65 236.29 1175.77 241.65C1171.13 250.28 1162.12 255.56 1153.22 259.65C1110.02 279.41 1061.01 280.42 1013.63 283.76C966.86 287.06 920.16 292.96 873.28 292.34C846.28 291.98 819.28 289.46 792.35 286.93C779.78 285.75 766.9 284.5 755.49 279.07"
                    fill="#4F6C7F"
                />
                <path
                    opacity={0.5}
                    d="M-23.4998 183.49C-17.7798 189.26 -7.8199 185.63 -1.6099 180.4C4.6001 175.17 10.5602 168.23 18.6702 167.82C26.1201 167.45 32.8502 172.9 40.3102 172.94C49.8001 172.99 56.9002 164.64 65.2302 160.1C78.0202 153.15 94.0302 155.4 107.37 161.22C120.71 167.04 132.37 176.05 145.21 182.94C158.05 189.83 172.99 194.63 187.08 190.94C194.69 188.94 201.52 184.68 209.08 182.48C216.951 180.332 225.273 180.487 233.058 182.928C240.843 185.369 247.765 189.993 253 196.25C258.49 203.01 262.1 211.72 269.57 216.17C273.57 218.57 279.17 220.46 279.57 225.17C279.9 229.08 276.14 231.97 272.78 234C195.43 280.68 102.35 295.52 12.0002 293.21C-1.9999 292.85 -16.1598 292.07 -29.5898 288.08C-34.9098 286.49 -40.1798 284.35 -44.4598 280.82C-48.7433 277.087 -52.087 272.397 -54.2198 267.13C-64.6598 243.06 -55.8598 214.36 -40.1298 193.36C-36.1298 187.97 -31.0698 182.58 -24.4298 181.44"
                    fill="#4F6C7F"
                />
            </g>
            <path
                d="M485.75 278.05C485.83 274.557 484.601 271.161 482.305 268.528C480.009 265.895 476.811 264.216 473.34 263.82C468.34 263.43 463.13 265.82 458.34 264.38C456 263.66 454.02 262.09 451.77 261.14C441.77 256.92 430.11 265.56 419.87 262.14C409.87 258.79 406.96 246.5 401.13 237.76C391.43 223.19 369.91 218.07 354.68 226.7C349.48 229.7 344.47 234.1 338.5 233.7C332.82 233.35 328.35 228.7 322.88 227.1C319.03 225.99 314.88 226.46 311.01 225.33C304.37 223.33 300.08 217.15 294.64 212.88C291.156 210.179 287.145 208.236 282.866 207.177C278.586 206.118 274.132 205.965 269.79 206.73C263.79 207.82 258.18 210.65 252.12 211.34C249.339 211.71 246.509 211.351 243.908 210.3C241.307 209.248 239.023 207.539 237.28 205.34C234.13 201.64 232.28 196.68 227.76 194.34C221.86 191.34 214.59 193.99 208.14 192.45C202.42 191.09 197.99 186.56 194.67 181.71C191.35 176.86 188.76 171.48 184.92 167.03C177.58 158.54 165.99 154.25 154.79 154.84C143.59 155.43 132.88 160.61 124.65 168.23C117.9 174.48 112.74 182.23 106.43 188.92C100.12 195.61 92.0003 201.42 82.8203 202C78.9803 202.23 75.1503 201.51 71.3003 201.44C64.0903 201.3 56.8103 203.44 49.7303 202.08C44.7303 201.08 40.1303 198.46 35.1703 197.15C30.9819 196.083 26.6056 195.983 22.3729 196.858C18.1403 197.733 14.1622 199.56 10.7403 202.2C6.74032 205.36 3.59032 209.6 -0.599681 212.55C-4.78968 215.5 -10.7897 216.9 -14.9097 213.86L-9.08968 256.74C-9.08968 256.74 242.13 272.39 246.83 273.18C251.53 273.97 473.78 291.96 473.78 291.96L485.75 278.05Z"
                fill="#4F6C7F"
            />
            <path
                d="M638.38 287.19C643.249 286.171 647.759 283.876 651.45 280.54C653.3 278.87 654.93 276.94 657.02 275.54C661.363 273.121 666.323 272.036 671.28 272.42C673.682 272.964 676.026 273.738 678.28 274.73C685.502 277.373 693.346 277.815 700.82 276C704.59 275.08 708.24 273.58 712.09 273.12C726.66 271.36 740.45 284.48 754.75 281.22C759.18 280.22 763.1 277.69 766.91 275.22C768.17 278.37 767.32 281.96 766.01 285.08C762.74 292.83 756.908 299.223 749.49 303.19C739.58 308.45 727.86 308.85 716.65 308.48C707.63 308.18 698.63 307.457 689.65 306.31C683.2 305.48 676.71 304.42 670.71 301.92C665.53 299.76 660.84 296.59 655.9 293.92C651.148 291.358 646.158 289.265 641 287.67"
                fill="#4F6C7F"
            />
            <path
                d="M781.74 273.45C799.63 270.1 809.74 248.35 827.74 245.53C838.47 243.85 849.3 249.53 860.05 248.01C868.7 246.8 876.05 241.1 882.05 234.79C888.05 228.48 893.28 221.31 900.05 215.79C916.13 202.71 940.63 201.16 958.22 212.13C965.01 216.36 971.02 222.32 978.8 224.18C991.06 227.1 1004.63 219.02 1016.15 224.13C1019.22 225.49 1021.83 227.69 1024.8 229.25C1032.32 233.25 1041.36 232.8 1049.53 235.25C1057.7 237.7 1065.84 245.45 1063.22 253.55C1061.37 259.26 1055.15 262.13 1049.56 264.34C1015.45 277.84 981.2 291.34 945.56 300.06C909.92 308.78 872.56 312.45 836.45 306.06C812.7 301.86 789.94 293.4 767.35 284.94C764.52 283.88 761.06 281.42 762.35 278.68C763.006 277.611 764.036 276.823 765.24 276.47C769.837 274.628 774.84 274.038 779.74 274.76"
                fill="#4F6C7F"
            />
            <path
                d="M1073.42 239.94C1078.27 240.81 1083.04 238.13 1086.91 235.07C1090.78 232.01 1094.41 228.4 1099.09 226.86C1106.84 224.3 1115.45 228.04 1123.38 226.18C1127.08 225.158 1130.51 223.347 1133.44 220.87C1144.94 211.82 1153.12 197.79 1167.02 193.2C1184.2 187.53 1199.52 194.61 1202.25 196.26L1217.07 205.26C1224.39 209.68 1231.79 214.17 1237.75 220.26C1243.71 226.35 1248.17 234.43 1248.22 242.97C1248.28 254.5 1240.16 264.97 1230.01 270.38C1219.86 275.79 1208.01 277.06 1196.43 277.02C1157.65 276.9 1120.16 263.69 1084.28 248.96C1080.71 247.5 1076.99 245.9 1074.58 242.88"
                fill="#4F6C7F"
            />
            <path
                d="M-150 259.82C-67 262.17 54.26 207.39 179.48 212.08C304.7 216.77 441.88 289 599 289C756.12 289 874.54 243.08 1082.96 235.17C1291.38 227.26 1436.31 324.39 1436.31 324.39L1200 644.87L194.39 720L-60.71 594.78L-150 259.82Z"
                fill="url(#da023442__paint14_radial_24891_5115)"
            />
            <path
                opacity={0.41}
                d="M255.31 76.7901C260.816 76.7901 265.28 72.3264 265.28 66.8201C265.28 61.3139 260.816 56.8501 255.31 56.8501C249.804 56.8501 245.34 61.3139 245.34 66.8201C245.34 72.3264 249.804 76.7901 255.31 76.7901Z"
                fill="url(#da023442__paint15_linear_24891_5115)"
            />
            <path
                d="M258.94 75.7028C269.035 70.9268 275.92 64.3113 274.318 60.9265C272.717 57.5418 263.235 58.6695 253.141 63.4454C243.047 68.2213 236.162 74.8369 237.763 78.2216C239.365 81.6064 248.846 80.4787 258.94 75.7028Z"
                fill="url(#da023442__paint16_radial_24891_5115)"
            />
            <path
                d="M259.574 77.0265C269.669 72.2506 276.554 65.6351 274.952 62.2503C273.351 58.8655 263.87 59.9933 253.775 64.7692C243.681 69.5451 236.796 76.1607 238.397 79.5454C239.999 82.9302 249.48 81.8025 259.574 77.0265Z"
                fill="url(#da023442__paint17_radial_24891_5115)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M258.46 73.8901C263.46 71.5501 266.82 68.3001 266.02 66.6301C265.22 64.9601 260.52 65.4801 255.54 67.8101C250.56 70.1401 247.18 73.3901 247.99 75.0701C248.8 76.7501 253.49 76.2201 258.46 73.8901Z"
                fill="white"
            />
            <path
                d="M295.405 166.422L301.725 178.02L300.071 178.729C300.071 178.729 290.227 173.126 289.366 167.451C288.505 161.777 298.249 162.634 298.249 162.634L295.405 166.422Z"
                fill="#2F2F2F"
            />
            <path
                d="M281.147 169.589C282.504 171.668 283.325 175.323 281.255 177.865L284.997 185.184L283.578 185.792C283.578 185.792 277.559 181.236 274.055 176.537C270.551 171.837 273.818 170.437 273.818 170.437L281.147 169.589Z"
                fill="#2F2F2F"
            />
            <path
                d="M265.721 166.59C265.261 164.791 265.485 162.887 266.348 161.244C267.212 159.601 268.654 158.336 270.396 157.695C272.442 156.952 274.839 156.053 277.354 155.06C284.519 152.233 289.599 149.135 293.047 149.471C295.273 149.687 302.29 154.464 307.124 157.909C307.292 156.886 308.313 155.139 309.234 155.023C309.43 155 308.959 158.626 309.536 159.537C309.912 159.267 310.975 158.975 311.369 159.358C311.954 159.931 311.302 160.914 311.302 160.914C311.647 161.166 311.924 161.375 312.123 161.514C313.28 162.346 315.256 164.045 316.817 165.48C317.361 165.983 317.723 166.653 317.845 167.384C317.967 168.115 317.843 168.866 317.492 169.519C317.146 170.16 316.598 170.671 315.934 170.973C315.27 171.275 314.526 171.352 313.814 171.191C311.125 170.573 307.669 169.356 306.211 168.386C304.007 166.906 304.528 165.574 303.374 165.074C303.06 164.936 302.648 164.724 302.215 164.492C302.078 164.417 301.92 164.39 301.765 164.416C301.611 164.441 301.47 164.517 301.363 164.633C301.258 164.748 301.193 164.895 301.18 165.051C301.167 165.207 301.207 165.362 301.292 165.493L307.669 175.454L306.102 176.125C305.381 175.809 304.699 175.412 304.067 174.942C301.839 173.321 295.334 167.445 295.334 167.445L278.556 174.633C278.05 176.676 276.895 178.499 275.266 179.831L279.285 187.614L277.718 188.285C276.657 187.648 275.688 186.87 274.836 185.973C272.3 183.35 270.728 182.496 269.803 181.001C269.247 180.1 267.211 172.419 265.721 166.59Z"
                fill="#E7E7E7"
            />
            <path
                d="M313.842 171.184L313.003 170.98C313.705 168.75 314.685 166.617 315.921 164.632C316.236 164.916 316.551 165.199 316.836 165.453C317.375 165.953 317.735 166.616 317.859 167.341C317.983 168.066 317.864 168.811 317.522 169.462C317.179 170.113 316.632 170.633 315.964 170.941C315.296 171.249 314.545 171.328 313.828 171.166L313.842 171.184Z"
                fill="#FBCDC3"
            />
            <path
                d="M311.065 165.253C311.305 165.15 311.394 164.818 311.263 164.513C311.132 164.208 310.831 164.043 310.591 164.147C310.35 164.249 310.261 164.581 310.392 164.886C310.523 165.191 310.824 165.356 311.065 165.253Z"
                fill="#2F2F2F"
            />
            <path
                d="M312.573 163.298C312.813 163.195 312.902 162.864 312.771 162.559C312.64 162.253 312.339 162.089 312.099 162.192C311.858 162.295 311.77 162.626 311.9 162.932C312.031 163.237 312.332 163.401 312.573 163.298Z"
                fill="#2F2F2F"
            />
            <path
                d="M255.786 169.732C256.103 174.9 262.649 175.848 263.446 170.633C264.695 162.625 266.899 161.177 266.899 161.177"
                stroke="#333333"
                strokeMiterlimit={10}
            />
            <path
                d="M255.992 170.962C255.992 170.962 257.089 167.862 256.479 167.117C255.869 166.372 253.763 166.65 254.662 168.762C255.561 170.875 255.992 170.962 255.992 170.962Z"
                fill="#333333"
            />
            <path
                d="M306.39 157.357C301.594 153.957 295.18 149.667 293.073 149.461C289.826 149.154 285.096 151.896 278.537 154.596C279.039 156.461 280.285 159.158 283.343 159.363C288.044 159.683 290.429 157.297 292.264 159.784C296.082 164.974 303.649 164.697 306.39 157.357Z"
                fill="#525252"
            />
            <path
                d="M270.12 157.814C268.452 158.502 267.089 159.768 266.28 161.38C265.472 162.993 265.273 164.844 265.721 166.591C266.461 169.493 267.344 172.854 268.105 175.608C268.782 175.083 269.277 174.36 269.521 173.538C269.763 172.717 269.743 171.841 269.46 171.032C268.441 168.299 270.643 168.204 272.22 164.116C273.048 161.961 271.643 159.587 270.12 157.814Z"
                fill="#525252"
            />
            <path
                d="M280.053 163.129C277.166 163.026 274.911 166.296 275.672 168.255C276.433 170.214 279.007 172.785 282.91 169.798C286.812 166.81 286.847 166.99 288.53 166.038C290.214 165.086 290.542 162.145 288.131 162.106C285.719 162.066 284.241 163.269 280.053 163.129Z"
                fill="#525252"
            />
            <path
                d="M302.322 171.562C303.221 172.795 303.521 173.582 303.364 174.389C303.621 174.594 303.86 174.782 304.059 174.921C304.69 175.392 305.372 175.789 306.093 176.105L307.66 175.433L302.357 167.086C301.999 168.288 301.528 170.471 302.322 171.562Z"
                fill="#333333"
            />
            <path
                d="M259.52 71.5599L247.88 74.3599V228.74L404.91 266.7L266.02 66.6299L259.52 71.5599Z"
                fill="url(#da023442__paint18_linear_24891_5115)"
            />
            <path
                d="M171.8 294.22C179.91 288.12 183.18 277.17 191.19 270.92C199.99 264.04 212.49 264.42 223.31 267.2C229.06 268.68 234.76 270.76 240.7 270.84C247.12 270.93 253.34 268.68 259.27 266.22C272.05 260.92 285.06 254.33 298.87 255.22C316.07 256.35 330.7 269.34 338.59 284.67C340.39 288.17 342.01 291.94 345.01 294.48C347.366 296.311 350.132 297.54 353.07 298.06C370.22 301.72 389.07 291.71 405.12 298.69C416.91 303.82 423.6 316.69 434.88 322.92C431.34 324.72 427.22 324.83 423.25 324.92C336.27 326.613 249.27 327.7 162.25 328.18C161.2 328.27 160.143 328.105 159.17 327.7C156.17 326.15 157.23 321.63 158.81 318.64C163.67 309.513 169.428 300.894 176 292.91"
                fill="#306468"
            />
            <path
                d="M592.2 311.23C599.746 309.766 607.052 307.262 613.91 303.79C618.07 301.68 622.07 299.22 626.41 297.53C633.557 294.766 641.363 294.184 648.84 295.86C654.14 297.06 659.22 299.39 664.64 299.72C676.02 300.42 686.11 292.34 697.4 290.72C704.75 289.66 712.32 291.44 718.94 294.81C725.56 298.18 731.3 303.06 736.47 308.39C732.691 309.164 728.836 309.5 724.98 309.39L592.75 311.09"
                fill="#306468"
            />
            <path
                d="M811.61 298.86C834.54 289.51 854.24 270.3 878.97 269.1C898.25 268.17 915.97 278.5 933.12 287.41C950.27 296.32 991 301.26 1009.37 295.35C1029.23 288.97 1041.6 268.16 1061.2 261.03C1076.8 255.35 1094 259.32 1110.58 260.23C1125.52 261.036 1140.48 259.284 1154.83 255.05C1171.41 250.16 1187.14 241.95 1204.29 239.72C1234.49 235.81 1263.56 250.83 1290.29 265.38C1292.29 266.45 1294.43 267.76 1294.99 269.94C1295.55 272.12 1294.42 274.04 1293.38 275.87L1267.08 321.87"
                fill="#306468"
            />
            <path
                d="M-28.6499 305.911C468.6 341.191 992.27 245.151 1207.48 305.911L1076.88 487.171L643.22 574.001L129.83 503.521L-28.6499 446.001V305.911Z"
                fill="url(#da023442__paint19_radial_24891_5115)"
            />
            <path
                d="M895.096 307.784L900.826 331.063H906.232C906.232 331.063 908.961 315.052 906.09 304.046C903.218 293.04 895.096 300.334 895.096 300.334V307.784Z"
                fill="black"
            />
            <path
                d="M920.032 299.727C919.191 304.564 920.549 311.897 926.292 314.872L925.166 331.116H930.34C930.34 331.116 937.349 318.26 940.052 306.957C942.755 295.653 933.987 295.537 933.987 295.537L920.032 299.727Z"
                fill="black"
            />
            <path
                d="M951.136 282.23C950.569 278.584 948.667 275.28 945.798 272.961C942.929 270.642 939.299 269.474 935.616 269.685C931.309 269.931 926.252 270.163 920.898 270.319C905.65 270.758 893.984 269.025 887.97 272.375C884.09 274.509 885.681 306.506 885.448 307.915L883.573 331.04H888.578C889.628 329.837 890.565 328.539 891.372 327.16C894.152 322.465 900.425 306.816 900.425 306.816H934.051C936.638 310.14 938.901 312.494 943.104 313.709L940.699 331.092H946.273C947.709 329.101 948.87 326.926 949.726 324.625C951.466 320.483 952.674 316.137 953.322 311.692C953.567 309.584 952.96 294.064 951.136 282.23Z"
                fill="#AA4635"
            />
            <path
                d="M965.35 304.561C965.35 304.561 957.073 304.924 955.676 292.753C953.839 276.807 944.76 273.289 944.76 273.289"
                stroke="#8D1C2F"
                strokeWidth={1.29332}
                strokeMiterlimit={10}
            />
            <path
                d="M960.991 303.312C960.991 303.312 965.117 301.204 966.281 301.89C967.445 302.575 967.458 305.601 964.328 304.748C961.198 303.894 960.991 303.312 960.991 303.312Z"
                fill="#3A1515"
            />
            <path
                d="M956.18 303.116C953.697 301.176 957.719 278.724 943.764 271.533C941.293 270.128 938.467 269.469 935.629 269.632C931.322 269.877 926.266 270.11 920.911 270.265C912.492 270.511 905.172 270.11 899.287 270.265C894.114 270.265 891.1 270.964 889.328 271.74C888.877 271.891 888.444 272.09 888.035 272.335C876.24 280.573 875.024 293.804 874.365 305.534C874.638 307.403 875.44 309.154 876.677 310.579C877.916 312.006 879.537 313.047 881.349 313.579C881.045 313.299 880.803 312.958 880.64 312.578C880.478 312.199 880.398 311.789 880.405 311.376C880.412 310.962 880.507 310.556 880.683 310.182C880.859 309.809 881.112 309.476 881.426 309.207C883.909 310.113 885.009 313.229 884.414 315.79C883.635 318.326 882.095 320.561 880.004 322.192C881.29 322.444 882.621 322.359 883.865 321.945C885.11 321.53 886.226 320.799 887.104 319.825C887.88 321.002 888.389 322.333 888.598 323.727C888.806 325.122 888.706 326.544 888.307 327.896C889.892 327.491 891.377 326.761 892.666 325.754C893.956 324.745 895.02 323.479 895.795 322.037C897.425 319.205 898.77 317.717 899.106 314.471C900.702 316.189 901.581 318.451 901.563 320.795C903.301 319.49 904.495 317.587 904.913 315.454C906.206 315.984 906.814 317.368 907.5 318.558C908.185 319.748 909.349 320.951 910.707 320.718C910.518 319.612 910.663 318.475 911.123 317.452C911.585 316.429 912.34 315.567 913.294 314.975C914.058 316.09 914.654 317.31 915.065 318.597C915.875 318.365 916.623 317.957 917.254 317.399C917.884 316.842 918.383 316.151 918.713 315.376C919.755 316.543 920.508 317.94 920.907 319.452C921.308 320.965 921.345 322.55 921.015 324.08C922.805 323.42 924.401 322.322 925.658 320.887C926.916 319.454 927.796 317.728 928.219 315.868C928.618 316.893 929.305 317.782 930.197 318.427C931.09 319.071 932.15 319.445 933.249 319.502C932.435 318.506 933.534 316.915 934.801 316.786C935.442 316.808 936.072 316.962 936.65 317.237C937.228 317.514 937.744 317.906 938.164 318.39C939.755 319.89 941.191 321.908 940.919 324.08C943.158 323.461 945.143 322.151 946.594 320.338C948.045 318.524 948.888 316.3 949.002 313.98C950.414 315.034 951.489 316.476 952.093 318.131C952.093 318.131 953.27 316.928 952.998 313.385C952.85 311.984 952.338 310.645 951.511 309.505C952.908 309.117 954.344 308.884 955.715 308.405C956.641 308.147 957.484 307.654 958.164 306.975C958.843 306.295 959.336 305.451 959.594 304.525C958.372 304.29 957.211 303.81 956.18 303.116Z"
                fill="#752936"
            />
            <path
                d="M870.385 270.671C870.385 270.671 870.432 282.415 870.936 287.131C871.44 291.847 874.726 297.271 880.406 297.042C886.085 296.814 891.383 291.718 892.216 283.967C893.05 276.216 893.531 270.023 893.531 270.023L870.385 270.671Z"
                fill="#AA4635"
            />
            <path
                opacity={0.5}
                d="M880.836 283.982C877.405 283.84 873.985 284.449 870.815 285.767C870.848 286.266 870.887 286.736 870.936 287.137C871.43 291.869 874.726 297.277 880.405 297.048C885.69 296.84 890.614 292.427 891.962 285.6C888.346 284.549 884.602 284.004 880.836 283.982Z"
                fill="#FBCDC3"
            />
            <path
                d="M876.775 287.692C874.915 287.724 874.805 292.649 876.475 292.919C878.145 293.189 878.877 287.665 876.775 287.692Z"
                fill="#AA4635"
            />
            <path
                d="M883.157 287.235C881.314 287.49 881.8 292.397 883.503 292.485C885.207 292.573 885.248 286.958 883.157 287.235Z"
                fill="#AA4635"
            />
            <path
                d="M870.568 260.811C868.495 260.324 866.578 259.323 864.994 257.901C863.131 255.858 862.575 250.594 862.575 250.594C862.575 250.594 859.549 257.345 860.467 260.501C861.385 263.657 867.528 267.123 867.528 267.123L870.568 260.811Z"
                fill="#AA4635"
            />
            <path
                d="M891.597 261.149C891.597 261.149 895.942 260.128 898.064 257.735C900.185 255.342 900.896 249.173 900.896 249.173C900.896 249.173 904.44 257.088 903.353 260.813C902.267 264.538 895.089 268.573 895.089 268.573L891.597 261.149Z"
                fill="#AA4635"
            />
            <path
                d="M894.868 259.319C893.16 257 890.747 255.297 887.99 254.461C882.738 253.172 877.212 253.589 872.213 255.653C872.277 256.181 872.519 256.672 872.899 257.045C873.28 257.417 873.778 257.647 874.307 257.697C874.307 257.697 865.744 258.604 863.181 275.201C863.627 275.475 864.134 275.634 864.655 275.664C865.178 275.695 865.7 275.595 866.174 275.375C866.874 277.028 867.318 278.778 867.492 280.564C867.61 281.694 867.371 282.832 866.811 283.82C866.811 283.82 877.92 284.267 883.069 277.115C883.443 277.56 883.721 278.078 883.884 278.637C884.046 279.195 884.091 279.782 884.013 280.358C884.013 280.358 895.964 276.975 896.776 270.244C897.335 266.492 896.666 262.66 894.868 259.319Z"
                fill="#752936"
            />
            <path
                d="M387.824 309.799L392.487 328.823H395.344C395.344 328.823 397.711 316.08 395.344 307.108C392.977 298.136 387.808 303.762 387.808 303.762L387.824 309.799Z"
                fill="#2F2F2F"
            />
            <path
                d="M408.158 303.225C407.472 307.171 408.577 313.152 413.264 315.574L412.34 328.823H414.85C414.85 328.823 420.894 318.233 423.103 309.025C425.313 299.816 419.576 299.816 419.576 299.816L408.158 303.225Z"
                fill="#2F2F2F"
            />
            <path
                d="M408.876 279.246C413.24 279.089 417.359 278.923 420.87 278.733C423.874 278.568 426.83 279.526 429.165 281.423C431.499 283.32 433.043 286.018 433.496 288.991C434.987 298.594 436.849 311.283 436.597 313.003C436.178 315.812 434.379 318.085 432.288 323.584C431.592 325.459 430.647 327.232 429.479 328.855H426.749L427.767 314.652C424.503 313.71 421.631 311.74 419.576 309.034H390.096C390.096 309.034 384.178 321.888 381.906 325.715C381.265 326.813 380.503 327.834 379.633 328.761H376.879L379.965 309.918C381.543 300.528 377.953 290.617 368.507 287.689C366.03 286.9 360.617 284.139 356.734 282.103C355.583 281.495 354.706 280.472 354.28 279.241C353.856 278.01 353.915 276.664 354.446 275.475C354.865 274.528 355.56 273.73 356.439 273.185C357.32 272.64 358.344 272.374 359.378 272.421C362.652 272.571 367.316 272.815 369.226 273.084L370.843 273.297C370.843 273.297 373.21 270.14 374.528 270.14C375.428 270.14 375.783 271.261 375.925 271.995C379.081 270.322 383.729 268.097 384.028 269.383C384.36 270.851 383.326 273.384 380.399 274.591L384.754 277.676C386.751 279.09 389.15 279.821 391.596 279.759C396.496 279.609 404.9 279.388 408.876 279.246Z"
                fill="#E7E7E7"
            />
            <path
                d="M359.378 272.413C358.344 272.365 357.32 272.632 356.439 273.176C355.56 273.722 354.865 274.519 354.446 275.466C353.915 276.655 353.856 278.002 354.28 279.233C354.706 280.464 355.583 281.487 356.734 282.095L357.31 282.394C358.84 279.225 360.031 275.903 360.861 272.484L359.378 272.413Z"
                fill="#FBCDC3"
            />
            <path
                d="M367.728 276.831C368.22 276.619 368.485 276.132 368.318 275.744C368.152 275.356 367.617 275.212 367.124 275.424C366.632 275.634 366.367 276.121 366.534 276.51C366.701 276.898 367.235 277.041 367.728 276.831Z"
                fill="#2F2F2F"
            />
            <path
                d="M445.111 307.171C445.111 307.171 438.356 307.463 437.22 297.544C435.721 284.532 428.319 281.668 428.319 281.668"
                stroke="white"
                strokeMiterlimit={10}
            />
            <path
                d="M441.552 306.153C441.552 306.153 444.921 304.425 445.868 304.985C446.815 305.545 446.831 308.023 444.29 307.352C441.749 306.681 441.552 306.153 441.552 306.153Z"
                fill="white"
            />
            <path
                d="M397.301 283.712C399.108 283.483 401.057 283.033 402.185 281.597C402.662 280.959 402.987 280.219 403.132 279.435C399.699 279.538 395.794 279.64 392.779 279.719C389.564 279.801 386.408 278.84 383.784 276.981L380.399 274.614C383.326 273.406 384.344 270.874 384.028 269.406C383.729 268.12 379.081 270.345 375.925 272.018C375.873 271.75 375.801 271.487 375.712 271.229C375.091 272.288 374.635 273.434 374.354 274.63C374.137 276.029 374.137 277.452 374.354 278.851C374.468 280.982 375.047 283.061 376.051 284.943C376.7 285.976 377.556 286.863 378.566 287.549C379.574 288.235 380.714 288.704 381.914 288.928C384.334 289.358 386.828 288.898 388.936 287.633C390.736 286.568 392.251 284.982 394.223 284.304C395.226 284.001 396.257 283.803 397.301 283.712Z"
                fill="#525252"
            />
            <path
                d="M435.373 301.418C434.813 297.394 434.134 292.912 433.519 288.959C433.067 285.986 431.523 283.287 429.189 281.391C426.855 279.494 423.897 278.535 420.894 278.701L417.548 278.867C417.47 278.904 417.393 278.946 417.319 278.993C414.494 280.618 412.459 283.349 410.952 286.237C409.999 287.95 409.363 289.821 409.074 291.76C408.786 293.701 409.182 295.682 410.194 297.363C410.819 298.269 411.587 299.069 412.467 299.73C414.834 301.584 417.809 302.886 420.799 302.563C422.433 302.325 424.014 301.807 425.47 301.032C426.654 300.464 427.901 299.825 429.203 299.974C430.234 300.232 431.232 300.609 432.178 301.095C433.203 301.451 434.298 301.561 435.373 301.418Z"
                fill="#525252"
            />
            <path
                d="M383.168 302.317C382.338 301.512 381.407 300.816 380.399 300.25L379.61 299.769C380.445 303.084 380.58 306.538 380.004 309.908L378.71 317.799C380.422 317.654 382.06 317.04 383.445 316.023C384.964 314.745 385.926 312.926 386.128 310.95C386.319 308.984 385.97 307.003 385.117 305.221C384.643 304.146 383.984 303.163 383.168 302.317Z"
                fill="#525252"
            />
            <path
                d="M410.944 306.413C409.819 305.818 408.552 305.544 407.283 305.624C407.043 305.66 406.797 305.621 406.58 305.513C406.418 305.383 406.296 305.211 406.225 305.016C405.436 303.217 404.434 301.355 402.745 300.329C401.162 299.533 399.389 299.197 397.624 299.358C396.262 299.294 394.915 299.672 393.785 300.438C392.655 301.203 391.804 302.314 391.359 303.604C390.898 304.976 390.548 306.382 390.31 307.809C390.231 308.228 390.152 308.638 390.065 309.056H413.106C412.749 307.932 411.975 306.986 410.944 306.413Z"
                fill="#525252"
            />
            <path
                d="M1028.52 322.29L1036.07 353.08H1040.72C1040.72 353.08 1044.49 332.45 1040.72 317.93C1036.95 303.41 1028.52 312.52 1028.52 312.52V322.29Z"
                fill="black"
            />
            <path
                d="M1061.43 311.64C1060.32 318.03 1062.11 327.71 1069.7 331.64L1068.21 353.09H1072.27C1072.27 353.09 1082.05 335.95 1085.63 321.04C1089.21 306.13 1079.92 306.13 1079.92 306.13L1061.43 311.64Z"
                fill="black"
            />
            <path
                d="M1102.49 288.539C1101.74 283.729 1099.23 279.371 1095.44 276.313C1091.65 273.255 1086.86 271.717 1082 271.999C1076.32 272.309 1069.64 272.629 1062.57 272.829C1042.44 273.409 1027.05 271.179 1019.11 275.539C1013.98 278.349 1003.11 295.199 995.02 308.459C995.09 303.339 992.02 300.179 989.58 299.739C987.49 299.359 987.82 307.739 988.3 313.459C987.12 313.199 985.21 313.009 984.65 314.359C983.82 316.359 987.02 321.859 987.02 321.859C986.45 322.859 986.02 323.599 985.66 324.139C983.021 328.806 980.619 333.602 978.46 338.509C977.672 340.276 977.494 342.255 977.954 344.134C978.414 346.013 979.486 347.686 981 348.889C982.492 350.079 984.332 350.747 986.24 350.79C988.147 350.833 990.016 350.25 991.56 349.129C997.42 344.869 1004.44 338.399 1006.94 334.509C1010.71 328.629 1008.1 326.009 1010.35 323.619C1010.96 322.969 1011.73 322.039 1012.53 321.029C1012.78 320.706 1013.13 320.477 1013.53 320.376C1013.92 320.276 1014.34 320.311 1014.71 320.475C1015.09 320.64 1015.39 320.924 1015.59 321.284C1015.78 321.643 1015.85 322.057 1015.78 322.459L1010.78 352.969H1015.24C1016.65 351.469 1017.88 349.815 1018.92 348.039C1022.59 341.839 1032.18 321.039 1032.18 321.039H1079.9C1083.23 325.42 1087.88 328.611 1093.16 330.139L1091.52 353.089H1096C1097.89 350.464 1099.43 347.595 1100.55 344.559C1103.94 335.659 1106.84 331.979 1107.55 327.429C1107.92 324.639 1104.9 304.089 1102.49 288.539Z"
                fill="white"
            />
            <path
                d="M991.58 349.129C992.17 348.699 992.78 348.239 993.38 347.769C989.403 343.13 984.853 339.014 979.84 335.519C979.37 336.519 978.91 337.519 978.48 338.519C977.694 340.275 977.51 342.241 977.956 344.112C978.402 345.983 979.453 347.654 980.947 348.866C982.441 350.078 984.293 350.763 986.216 350.814C988.138 350.865 990.024 350.28 991.58 349.149V349.129Z"
                fill="#FBCDC3"
            />
            <path
                d="M989.14 330.341C989.82 330.341 990.37 329.638 990.37 328.771C990.37 327.904 989.82 327.201 989.14 327.201C988.461 327.201 987.91 327.904 987.91 328.771C987.91 329.638 988.461 330.341 989.14 330.341Z"
                fill="#151515"
            />
            <path
                d="M995.22 308.149C995.78 309.629 997.66 310.149 999.28 310.349C1002.28 310.699 1005.66 310.599 1007.9 308.559C1011.02 305.699 1010.44 300.559 1012.76 296.999C1014.66 294.109 1018.2 292.739 1020.46 290.119C1022.72 287.499 1023.46 283.779 1023.33 280.289C1023.3 279.352 1023.18 278.421 1022.96 277.509C1022.67 276.429 1022.24 275.393 1021.67 274.429C1020.79 274.719 1019.94 275.087 1019.13 275.529C1014 278.319 1003.29 294.939 995.22 308.149Z"
                fill="#333333"
            />
            <path
                d="M1082 271.999C1076.32 272.309 1069.64 272.629 1062.57 272.829C1049.11 273.219 1037.76 272.349 1029.35 273.039C1031.91 275.099 1033.52 278.479 1034.41 281.739C1035.61 286.109 1036.06 290.799 1038.41 294.679C1039.3 296.155 1040.43 297.468 1041.76 298.559C1042.63 299.296 1043.61 299.875 1044.68 300.269C1045.9 300.625 1047.16 300.804 1048.43 300.799C1050.74 301.024 1053.07 300.789 1055.29 300.109C1057.02 299.339 1058.61 298.288 1060 296.999C1062 295.451 1063.78 293.649 1065.31 291.639C1067.31 288.849 1068.49 285.319 1071.4 283.519C1074.74 281.449 1079.06 282.419 1082.94 281.759C1086.24 281.176 1089.22 279.396 1091.29 276.759C1091.85 276.041 1092.33 275.267 1092.73 274.449C1089.46 272.62 1085.74 271.77 1082 271.999Z"
                fill="#333333"
            />
            <path
                d="M1018.62 310.541H1017.77L1016.96 313.291L1012.61 341.701C1014.36 341.231 1015.92 340.232 1017.08 338.841C1017.96 337.739 1018.58 336.456 1018.9 335.085C1019.22 333.713 1019.23 332.287 1018.93 330.911C1018.85 330.637 1018.85 330.345 1018.93 330.071C1019.03 329.869 1019.18 329.694 1019.36 329.561L1021.84 327.421C1022.88 326.626 1023.76 325.634 1024.42 324.501C1024.83 323.582 1025.04 322.587 1025.05 321.581C1025.19 317.071 1022.74 312.381 1018.62 310.541Z"
                fill="#333333"
            />
            <path
                d="M1076.07 306.119C1076.07 306.119 1076.07 317.949 1081.98 323.649C1087.89 329.349 1093.12 330.129 1093.12 330.129C1093.12 330.129 1097.76 325.959 1096.12 320.249C1094.48 314.539 1085.67 314.249 1085.67 313.719C1085.67 313.189 1084.16 304.569 1076.07 306.119Z"
                fill="#333333"
            />
            <path
                d="M1121.26 318C1121.26 318 1110.32 318.47 1108.48 302.41C1106.06 281.36 1094.08 276.71 1094.08 276.71"
                stroke="white"
                strokeMiterlimit={10}
            />
            <path
                d="M1115.49 316.381C1115.49 316.381 1120.95 313.591 1122.49 314.491C1124.03 315.391 1124.05 319.401 1119.91 318.271C1115.77 317.141 1115.49 316.381 1115.49 316.381Z"
                fill="white"
            />
            <path
                d="M150.47 242.85C150.47 242.85 171.17 227.85 173.34 208.99C173.389 208.55 173.579 208.138 173.881 207.815C174.183 207.491 174.581 207.274 175.016 207.194C175.452 207.114 175.901 207.177 176.298 207.373C176.695 207.568 177.018 207.886 177.22 208.28C181.92 217.48 187.81 234.55 177.72 249.88C163 272.21 150.47 242.85 150.47 242.85Z"
                fill="white"
            />
            <path
                d="M99.5304 244.56C99.5304 244.56 73.3004 233.61 66.1404 213.69C65.9786 213.222 65.6696 212.82 65.2597 212.542C64.8498 212.265 64.3611 212.128 63.8667 212.151C63.3723 212.175 62.8989 212.358 62.5174 212.673C62.1359 212.989 61.8667 213.419 61.7504 213.9C59.0104 225.07 56.9704 245.06 71.7504 259.1C93.4004 279.56 99.5304 244.56 99.5304 244.56Z"
                fill="white"
            />
            <path
                d="M164.55 245.13C164.55 245.13 177.73 235.84 195.72 252.36C196.343 252.956 196.718 253.765 196.77 254.625C196.821 255.485 196.547 256.334 196 257C192.61 261.17 184.1 268.49 168.07 264.67"
                fill="white"
            />
            <path
                d="M193 254.24C186.3 251.64 179.84 250.3 167.7 251.47C163.83 251.84 160.63 256.05 160.34 259.15C160.345 259.21 160.345 259.27 160.34 259.33C159.9 262.91 163.09 265.98 167.56 265.85C178.77 265.52 188.77 262.06 193.95 257.29C195.25 256.05 194.77 254.94 193 254.24Z"
                fill="#D9D9D9"
            />
            <path
                d="M211.87 296.84C195.06 271.84 174.4 248.22 167.28 242.77C157.28 235.09 139.75 231.25 113.72 236.58C87.6902 241.91 83.2101 254.3 83.2101 254.3C83.2101 254.3 59.2802 244.72 40.5302 269.3C39.9417 270.091 39.6663 271.072 39.7568 272.054C39.8472 273.036 40.2971 273.95 41.0202 274.62C44.2602 277.62 50.7702 280.8 61.2302 282.37L47.1002 289.75C28.1454 294.143 8.72458 296.201 -10.7298 295.88C-56.9099 295.09 -135.73 285.6 -171.94 295.88C-208.15 306.16 -225.28 322.88 -228.86 365.1C-232.44 407.32 -234.44 488.5 -234.44 488.5L111.48 491.2L134.19 376.34L140.79 347.44L161.57 356.74C169.088 360.105 177.45 361.107 185.55 359.614C193.65 358.121 201.106 354.204 206.93 348.38C213.597 341.691 217.734 332.896 218.635 323.495C219.536 314.095 217.145 304.673 211.87 296.84Z"
                fill="#F7F7F7"
            />
            <path
                d="M174.06 284.17C168.687 280.057 163.333 275.867 158 271.6C156.614 270.602 155.393 269.394 154.38 268.02C152.08 264.54 151.38 259.16 154.03 255.94C157.03 252.36 158.73 249.11 158.88 244.94C158.879 242.131 158.192 239.364 156.88 236.88C146.5 233.26 132.15 232.37 113.4 236.22C107.696 237.312 102.15 239.109 96.8901 241.57C97.0257 246.231 98.1041 250.817 100.06 255.05C100.767 256.798 101.869 258.359 103.28 259.61C104.517 260.503 105.897 261.179 107.36 261.61C109.98 262.521 112.652 263.279 115.36 263.88C121.83 265.32 128.84 266.04 134.01 270.19C140.51 275.41 142.43 281.29 148.25 290.59C150.03 293.44 160.25 306.99 163.77 307.1C168.08 307.23 175.05 297.61 179 295.88C179.67 295.59 186 299.31 186.48 298.75C187.78 297.25 176.15 285.76 174.06 284.17Z"
                fill="#1F1F1F"
            />
            <path
                d="M-75.9998 331.69C-28.5498 332.76 -36.9998 360.33 13.0602 358C45.2502 356.53 72.0602 321.61 71.5502 283.63C68.0795 283.518 64.6258 283.096 61.2302 282.37L47.1002 289.75C28.1454 294.143 8.72469 296.201 -10.7298 295.88C-43.7998 295.31 -93.5998 290.29 -132.51 291.27C-126.36 305.32 -110.45 330.92 -75.9998 331.69Z"
                fill="#1F1F1F"
            />
            <path
                d="M120.02 282.25C123.174 282.25 125.73 279.313 125.73 275.69C125.73 272.067 123.174 269.13 120.02 269.13C116.867 269.13 114.31 272.067 114.31 275.69C114.31 279.313 116.867 282.25 120.02 282.25Z"
                fill="#1F1F1F"
            />
            <path
                d="M168.1 272.33C171.254 272.33 173.81 269.393 173.81 265.77C173.81 262.147 171.254 259.21 168.1 259.21C164.947 259.21 162.39 262.147 162.39 265.77C162.39 269.393 164.947 272.33 168.1 272.33Z"
                fill="#1F1F1F"
            />
            <path
                d="M206.24 349.1C213.203 342.445 217.585 333.54 218.608 323.963C219.631 314.386 217.23 304.756 211.83 296.78C209.94 293.97 213.83 299.53 211.83 296.78C200.65 288.44 169.39 293.36 154.02 305.51C136.15 319.64 133.09 339.51 144.02 348.94L161.55 356.78C168.917 360.077 177.099 361.107 185.054 359.74C193.009 358.372 200.377 354.668 206.22 349.1H206.24Z"
                fill="#FBCDC3"
            />
            <path
                d="M174.3 315.8C167.7 315.31 165.03 340.09 173.19 341.17C181.35 342.25 180.67 316.27 174.3 315.8Z"
                fill="#D38579"
            />
            <path
                d="M196.94 311.24C190.33 311.61 190.86 336.53 199.08 336.55C207.3 336.57 203.31 310.89 196.94 311.24Z"
                fill="#D38579"
            />
            <path
                opacity={0.2}
                d="M140.79 347.48C119.21 338.79 106.7 331.21 106.7 331.21C107.89 344.49 124.32 364.15 137.7 361.15C138 361.07 140.79 347.48 140.79 347.48Z"
                fill="#666666"
            />
            <path
                d="M151 338.79C151 338.79 153 353.73 171.16 355.56"
                stroke="#D38579"
                strokeWidth={2}
                strokeMiterlimit={10}
                strokeLinecap="round"
            />
            <path
                d="M46.25 274.59C50.77 276.78 59.14 279.86 71.32 280.49C73.2054 280.579 75.0584 279.977 76.5314 278.797C78.0042 277.617 78.9958 275.939 79.32 274.08C79.32 274.01 79.32 273.93 79.32 273.86C79.5677 272.83 79.5997 271.759 79.414 270.716C79.2284 269.673 78.8292 268.679 78.2414 267.797C77.6536 266.916 76.89 266.165 75.9983 265.593C75.1067 265.02 74.1063 264.638 73.06 264.47C61.91 262.95 51.53 265.56 45.75 270.62C44.25 271.94 44.46 273.72 46.25 274.59Z"
                fill="#D9D9D9"
            />
            <path
                opacity={0.2}
                d="M924 86.21C955.48 106.28 928 182.5 928 182.5C955.76 134.92 977.71 111.13 977.71 111.13C977.71 111.13 959.7 87.21 924 86.21Z"
                fill="#06001A"
            />
            <path
                opacity={0.07}
                d="M799.35 208.48C792.341 204.525 784.395 202.535 776.35 202.72C787.99 220.31 767.56 261.91 767.56 261.91C788.41 224.61 799.35 208.48 799.35 208.48Z"
                fill="#06001A"
            />
            <path
                d="M193.64 397.17C193.64 397.17 253.09 368.45 400.22 367.55C547.35 366.65 669.04 414.39 821.22 416.34C973.4 418.29 1103.06 292.75 1298.22 301.23C1493.38 309.71 1269.71 448.06 1269.71 448.06L574.71 508.69L242.87 448.06L193.64 397.17Z"
                fill="#065E66"
            />
            <path
                d="M300.59 426.94C300.59 426.94 306.64 346.17 404.91 333.39C383.93 389.93 300.59 426.94 300.59 426.94Z"
                fill="#0B4E51"
            />
            <path
                d="M1128.2 286.4C1128.2 286.4 1237.11 307.93 1238.29 443.76C1164.82 405.88 1128.2 286.4 1128.2 286.4Z"
                fill="#0B4E51"
            />
            <path
                d="M1248.43 442.6C1248.43 442.6 1138.05 454.49 1096.43 325.19C1177.87 339.45 1248.43 442.6 1248.43 442.6Z"
                fill="#0B4E51"
            />
            <path
                d="M769.766 340C769.766 340 788.346 412.62 705.936 452.88C707.626 397.09 769.766 340 769.766 340Z"
                fill="#0B4E51"
            />
            <path
                d="M267.72 321.26C267.72 321.26 260.31 392.87 289.66 427.69C318.8 368.2 267.72 321.26 267.72 321.26Z"
                fill="#0B4E51"
            />
            <path
                d="M892.21 353.08C892.21 353.08 887.3 400.62 906.78 423.75C926.13 384.25 892.21 353.08 892.21 353.08Z"
                fill="#0B4E51"
            />
            <path
                d="M231 328.19C231 328.19 284.13 350.19 282.8 424.56C229 390.91 231 328.19 231 328.19Z"
                fill="#0B4E51"
            />
            <path
                d="M538.08 340.23C538.08 340.23 591.2 362.23 589.88 436.6C536.12 403 538.08 340.23 538.08 340.23Z"
                fill="#0B4E51"
            />
            <path
                d="M869.91 359.71C869.91 359.71 905.18 374.33 904.3 423.71C868.61 401.35 869.91 359.71 869.91 359.71Z"
                fill="#0B4E51"
            />
            <path
                d="M280.87 431.63C280.87 431.63 271.87 371.18 340.36 331.72C339.09 399.11 280.87 431.63 280.87 431.63Z"
                fill="#0B4E51"
            />
            <path
                d="M700.366 453.27C700.366 453.27 677.776 396.48 735.366 342.38C749.596 408.27 700.366 453.27 700.366 453.27Z"
                fill="#0B4E51"
            />
            <path
                d="M905.55 419.41C905.55 419.41 890.89 372.33 925.26 353.1C934.93 403.84 905.55 419.41 905.55 419.41Z"
                fill="#0B4E51"
            />
        </g>
        <defs>
            <linearGradient
                id="da023442__paint0_linear_24891_5115"
                x1={600}
                y1={-50.09}
                x2={600}
                y2={336.52}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FFEDE4" />
                <stop offset={1} stopColor="#FFD0C9" />
            </linearGradient>
            <linearGradient
                id="da023442__paint1_linear_24891_5115"
                x1={425.97}
                y1={88.33}
                x2={422.32}
                y2={183.55}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="da023442__paint2_linear_24891_5115"
                x1={697.5}
                y1={-50.5002}
                x2={701}
                y2={153}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.1} stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="da023442__paint3_linear_24891_5115"
                x1={842.742}
                y1={132.568}
                x2={847.843}
                y2={171.95}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.1} stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="da023442__paint4_linear_24891_5115"
                x1={1011.5}
                y1={-48}
                x2={975}
                y2={126}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.1} stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="da023442__paint5_linear_24891_5115"
                x1={625.78}
                y1={-79.49}
                x2={654.47}
                y2={90.07}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.1} stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="da023442__paint6_linear_24891_5115"
                x1={392.038}
                y1={-75.6983}
                x2={439.125}
                y2={35.3176}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.1} stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="da023442__paint7_linear_24891_5115"
                x1={604}
                y1={122.5}
                x2={605.455}
                y2={209.261}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.1} stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="da023442__paint8_linear_24891_5115"
                x1={518}
                y1={235}
                x2={519.486}
                y2={266.215}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.1} stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="da023442__paint9_linear_24891_5115"
                x1={679}
                y1={216}
                x2={679}
                y2={274.001}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.1} stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="da023442__paint10_linear_24891_5115"
                x1={139}
                y1={263}
                x2={139}
                y2={-93}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FF806C" />
                <stop offset={1} stopColor="#FFEDE4" />
            </linearGradient>
            <linearGradient
                id="da023442__paint11_linear_24891_5115"
                x1={152.65}
                y1={251.25}
                x2={257.52}
                y2={106.46}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#06003E" />
                <stop offset={0.99} stopColor="#471F98" stopOpacity={0.5} />
            </linearGradient>
            <linearGradient
                id="da023442__paint12_linear_24891_5115"
                x1={1055}
                y1={258}
                x2={1055}
                y2={-33.0003}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FF806C" />
                <stop offset={1} stopColor="#FFEDE4" />
            </linearGradient>
            <linearGradient
                id="da023442__paint13_linear_24891_5115"
                x1={1204.63}
                y1={202.967}
                x2={872.63}
                y2={24.4674}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#06003E" />
                <stop offset={1} stopColor="#471F98" stopOpacity={0.5} />
            </linearGradient>
            <radialGradient
                id="da023442__paint14_radial_24891_5115"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(643.22 465.9) scale(588.94)"
            >
                <stop stopColor="#BECCA5" />
                <stop offset={1} stopColor="#365953" />
            </radialGradient>
            <linearGradient
                id="da023442__paint15_linear_24891_5115"
                x1={5137.42}
                y1={1389.24}
                x2={5535.02}
                y2={1389.24}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#06003E" />
                <stop offset={0.99} stopColor="#471F98" stopOpacity={0.5} />
            </linearGradient>
            <radialGradient
                id="da023442__paint16_radial_24891_5115"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(256.041 69.5741) rotate(-25.32) scale(15.08)"
            >
                <stop stopColor="#BEC0FF" />
                <stop offset={1} stopColor="#8184CA" />
            </radialGradient>
            <radialGradient
                id="da023442__paint17_radial_24891_5115"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(256.675 70.8979) rotate(-25.32) scale(15.08)"
            >
                <stop stopColor="#9FB4FF" />
                <stop offset={1} stopColor="#846895" />
            </radialGradient>
            <linearGradient
                id="da023442__paint18_linear_24891_5115"
                x1={248}
                y1={26.4999}
                x2={286}
                y2={224}
                gradientUnits="userSpaceOnUse"
            >
                <stop offset={0.1} stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <radialGradient
                id="da023442__paint19_radial_24891_5115"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(589.41 429.591) scale(448.8)"
            >
                <stop stopColor="#4C9E67" />
                <stop offset={1} stopColor="#418075" />
            </radialGradient>
            <clipPath id="da023442__clip0_24891_5115">
                <rect width={1200} height={400} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export default NoTripsL;
