import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const PlusPromoM = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 375 378"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        xmlnsXlink="http://www.w3.org/1999/xlink"
        focusable="false"
        {...props}
    >
        <g clipPath="url(#f2e5ff76__clip0_27804_6153)">
            <rect width={375} height={378} fill="white" />
            <g clipPath="url(#f2e5ff76__clip1_27804_6153)">
                <rect
                    width={800}
                    height={300}
                    transform="translate(-137 78)"
                    fill="white"
                />
                <g opacity={0.4} filter="url(#f2e5ff76__filter0_f_27804_6153)">
                    <path
                        d="M-179.966 209.785L215.103 -42.0179L615.176 133.682L214.761 551.533L-179.966 209.785Z"
                        fill="url(#f2e5ff76__paint0_radial_27804_6153)"
                    />
                    <path
                        d="M-179.966 209.785L215.103 -42.0179L615.176 133.682L214.761 551.533L-179.966 209.785Z"
                        fill="url(#f2e5ff76__paint1_radial_27804_6153)"
                    />
                    <path
                        d="M-179.966 209.785L215.103 -42.0179L615.176 133.682L214.761 551.533L-179.966 209.785Z"
                        fill="url(#f2e5ff76__paint2_linear_27804_6153)"
                    />
                </g>
                <path
                    fillRule="evenodd"
                    clipRule="evenodd"
                    d="M-70.6636 12.5351C-69.9636 12.5351 -69.3961 11.9676 -69.3961 11.2676C-69.3961 10.5675 -69.9636 10 -70.6636 10C-71.3637 10 -71.9312 10.5675 -71.9312 11.2676C-71.9312 11.9676 -71.3637 12.5351 -70.6636 12.5351ZM-111.649 13.3803C-111.649 14.7804 -112.784 15.9154 -114.184 15.9154C-115.584 15.9154 -116.719 14.7804 -116.719 13.3803C-116.719 11.9801 -115.584 10.8451 -114.184 10.8451C-112.784 10.8451 -111.649 11.9801 -111.649 13.3803ZM118.204 45.4921C122.871 45.4921 126.655 41.7087 126.655 37.0417C126.655 32.3746 122.871 28.5912 118.204 28.5912C113.537 28.5912 109.754 32.3746 109.754 37.0417C109.754 41.7087 113.537 45.4921 118.204 45.4921ZM80.1773 148.589C80.1773 153.256 76.3939 157.039 71.7268 157.039C67.0597 157.039 63.2763 153.256 63.2763 148.589C63.2763 143.922 67.0597 140.138 71.7268 140.138C76.3939 140.138 80.1773 143.922 80.1773 148.589ZM-122.634 233.093C-118.901 233.093 -115.874 230.066 -115.874 226.333C-115.874 222.599 -118.901 219.572 -122.634 219.572C-126.368 219.572 -129.395 222.599 -129.395 226.333C-129.395 230.066 -126.368 233.093 -122.634 233.093ZM-78.6917 301.541C-74.958 301.541 -71.9313 298.514 -71.9313 294.781C-71.9313 291.047 -74.958 288.02 -78.6917 288.02C-82.4253 288.02 -85.452 291.047 -85.452 294.781C-85.452 298.514 -82.4253 301.541 -78.6917 301.541ZM150.316 309.992C150.316 312.793 148.046 315.063 145.246 315.063C142.446 315.063 140.176 312.793 140.176 309.992C140.176 307.192 142.446 304.922 145.246 304.922C148.046 304.922 150.316 307.192 150.316 309.992ZM129.19 388.582C131.057 388.582 132.57 387.069 132.57 385.202C132.57 383.335 131.057 381.822 129.19 381.822C127.323 381.822 125.81 383.335 125.81 385.202C125.81 387.069 127.323 388.582 129.19 388.582ZM-31.3692 372.525C-31.3692 376.259 -34.3959 379.286 -38.1296 379.286C-41.8632 379.286 -44.8899 376.259 -44.8899 372.525C-44.8899 368.792 -41.8632 365.765 -38.1296 365.765C-34.3959 365.765 -31.3692 368.792 -31.3692 372.525ZM-47.4249 495.903C-42.7579 495.903 -38.9744 492.119 -38.9744 487.452C-38.9744 482.785 -42.7579 479.002 -47.4249 479.002C-52.092 479.002 -55.8754 482.785 -55.8754 487.452C-55.8754 492.119 -52.092 495.903 -47.4249 495.903ZM-34.7491 309.146C-34.7491 312.413 -37.3975 315.062 -40.6645 315.062C-43.9314 315.062 -46.5798 312.413 -46.5798 309.146C-46.5798 305.879 -43.9314 303.231 -40.6645 303.231C-37.3975 303.231 -34.7491 305.879 -34.7491 309.146ZM132.57 249.994C137.237 249.994 141.021 246.21 141.021 241.543C141.021 236.876 137.237 233.093 132.57 233.093C127.903 233.093 124.12 236.876 124.12 241.543C124.12 246.21 127.903 249.994 132.57 249.994ZM-101.508 66.6179C-101.508 71.285 -105.291 75.0684 -109.958 75.0684C-114.625 75.0684 -118.409 71.285 -118.409 66.6179C-118.409 61.9509 -114.625 58.1674 -109.958 58.1674C-105.291 58.1674 -101.508 61.9509 -101.508 66.6179ZM-80.3821 200.981C-75.715 200.981 -71.9316 197.198 -71.9316 192.531C-71.9316 187.864 -75.715 184.08 -80.3821 184.08C-85.0491 184.08 -88.8326 187.864 -88.8326 192.531C-88.8326 197.198 -85.0491 200.981 -80.3821 200.981ZM-10.2429 148.589C-10.2429 153.256 -14.0263 157.039 -18.6934 157.039C-23.3605 157.039 -27.1439 153.256 -27.1439 148.589C-27.1439 143.922 -23.3605 140.138 -18.6934 140.138C-14.0263 140.138 -10.2429 143.922 -10.2429 148.589ZM66.6564 527.17C71.3235 527.17 75.1069 523.386 75.1069 518.719C75.1069 514.052 71.3235 510.269 66.6564 510.269C61.9894 510.269 58.206 514.052 58.206 518.719C58.206 523.386 61.9894 527.17 66.6564 527.17ZM92.0079 401.257C92.0079 405.924 88.2245 409.708 83.5574 409.708C78.8903 409.708 75.1069 405.924 75.1069 401.257C75.1069 396.59 78.8903 392.807 83.5574 392.807C88.2245 392.807 92.0079 396.59 92.0079 401.257ZM-114.184 331.962C-109.517 331.962 -105.733 328.179 -105.733 323.512C-105.733 318.845 -109.517 315.061 -114.184 315.061C-118.851 315.061 -122.634 318.845 -122.634 323.512C-122.634 328.179 -118.851 331.962 -114.184 331.962ZM-40.6644 119.012C-40.6644 122.746 -43.6911 125.772 -47.4248 125.772C-51.1584 125.772 -54.1851 122.746 -54.1851 119.012C-54.1851 115.278 -51.1584 112.252 -47.4248 112.252C-43.6911 112.252 -40.6644 115.278 -40.6644 119.012ZM-118.409 147.742C-114.675 147.742 -111.649 144.715 -111.649 140.981C-111.649 137.248 -114.675 134.221 -118.409 134.221C-122.143 134.221 -125.169 137.248 -125.169 140.981C-125.169 144.715 -122.143 147.742 -118.409 147.742ZM-12.7781 225.487C-12.7781 228.287 -15.0481 230.557 -17.8483 230.557C-20.6486 230.557 -22.9186 228.287 -22.9186 225.487C-22.9186 222.687 -20.6486 220.417 -17.8483 220.417C-15.0481 220.417 -12.7781 222.687 -12.7781 225.487ZM-20.3834 429.144C-17.1165 429.144 -14.4681 426.495 -14.4681 423.228C-14.4681 419.961 -17.1165 417.313 -20.3834 417.313C-23.6504 417.313 -26.2987 419.961 -26.2987 423.228C-26.2987 426.495 -23.6504 429.144 -20.3834 429.144ZM101.303 353.933C101.303 356.734 99.0333 359.004 96.233 359.004C93.4328 359.004 91.1627 356.734 91.1627 353.933C91.1627 351.133 93.4328 348.863 96.233 348.863C99.0333 348.863 101.303 351.133 101.303 353.933ZM96.233 163.799C99.0333 163.799 101.303 161.529 101.303 158.728C101.303 155.928 99.0333 153.658 96.233 153.658C93.4328 153.658 91.1627 155.928 91.1627 158.728C91.1627 161.529 93.4328 163.799 96.233 163.799ZM-80.3818 77.6041C-80.3818 80.4043 -82.6519 82.6744 -85.4521 82.6744C-88.2524 82.6744 -90.5224 80.4043 -90.5224 77.6041C-90.5224 74.8039 -88.2524 72.5338 -85.4521 72.5338C-82.6519 72.5338 -80.3818 74.8039 -80.3818 77.6041ZM53.1359 82.6744C55.9362 82.6744 58.2062 80.4043 58.2062 77.6041C58.2062 74.8039 55.9362 72.5338 53.1359 72.5338C50.3357 72.5338 48.0656 74.8039 48.0656 77.6041C48.0656 80.4043 50.3357 82.6744 53.1359 82.6744ZM70.8819 308.301C70.8819 311.102 68.6119 313.372 65.8116 313.372C63.0114 313.372 60.7413 311.102 60.7413 308.301C60.7413 305.501 63.0114 303.231 65.8116 303.231C68.6119 303.231 70.8819 305.501 70.8819 308.301ZM-75.3118 433.369C-72.5116 433.369 -70.2415 431.099 -70.2415 428.299C-70.2415 425.499 -72.5116 423.229 -75.3118 423.229C-78.112 423.229 -80.3821 425.499 -80.3821 428.299C-80.3821 431.099 -78.112 433.369 -75.3118 433.369ZM157.076 450.27C157.076 453.07 154.806 455.34 152.006 455.34C149.206 455.34 146.936 453.07 146.936 450.27C146.936 447.47 149.206 445.2 152.006 445.2C154.806 445.2 157.076 447.47 157.076 450.27ZM26.9392 235.628C28.3393 235.628 29.4744 234.493 29.4744 233.093C29.4744 231.692 28.3393 230.557 26.9392 230.557C25.5391 230.557 24.4041 231.692 24.4041 233.093C24.4041 234.493 25.5391 235.628 26.9392 235.628ZM91.1626 198.446C91.1626 199.846 90.0276 200.981 88.6275 200.981C87.2274 200.981 86.0924 199.846 86.0924 198.446C86.0924 197.045 87.2274 195.91 88.6275 195.91C90.0276 195.91 91.1626 197.045 91.1626 198.446ZM88.6275 273.655C90.0276 273.655 91.1626 272.52 91.1626 271.12C91.1626 269.72 90.0276 268.585 88.6275 268.585C87.2274 268.585 86.0924 269.72 86.0924 271.12C86.0924 272.52 87.2274 273.655 88.6275 273.655ZM91.1626 125.771C91.1626 127.171 90.0276 128.306 88.6275 128.306C87.2274 128.306 86.0924 127.171 86.0924 125.771C86.0924 124.371 87.2274 123.236 88.6275 123.236C90.0276 123.236 91.1626 124.371 91.1626 125.771ZM-51.65 153.658C-50.2499 153.658 -49.1149 152.523 -49.1149 151.123C-49.1149 149.723 -50.2499 148.588 -51.65 148.588C-53.0501 148.588 -54.1851 149.723 -54.1851 151.123C-54.1851 152.523 -53.0501 153.658 -51.65 153.658ZM-49.1149 72.5328C-49.1149 73.9329 -50.2499 75.0679 -51.65 75.0679C-53.0501 75.0679 -54.1851 73.9329 -54.1851 72.5328C-54.1851 71.1326 -53.0501 69.9976 -51.65 69.9976C-50.2499 69.9976 -49.1149 71.1326 -49.1149 72.5328ZM126.655 75.0679C128.055 75.0679 129.19 73.9329 129.19 72.5328C129.19 71.1326 128.055 69.9976 126.655 69.9976C125.255 69.9976 124.12 71.1326 124.12 72.5328C124.12 73.9329 125.255 75.0679 126.655 75.0679ZM55.6709 42.9565C55.6709 44.3566 54.5359 45.4917 53.1358 45.4917C51.7357 45.4917 50.6006 44.3566 50.6006 42.9565C50.6006 41.5564 51.7357 40.4214 53.1358 40.4214C54.5359 40.4214 55.6709 41.5564 55.6709 42.9565ZM53.1358 179.855C54.5359 179.855 55.6709 178.72 55.6709 177.32C55.6709 175.92 54.5359 174.785 53.1358 174.785C51.7357 174.785 50.6006 175.92 50.6006 177.32C50.6006 178.72 51.7357 179.855 53.1358 179.855ZM-98.1278 177.32C-98.1278 178.72 -99.2628 179.855 -100.663 179.855C-102.063 179.855 -103.198 178.72 -103.198 177.32C-103.198 175.92 -102.063 174.785 -100.663 174.785C-99.2628 174.785 -98.1278 175.92 -98.1278 177.32ZM-100.663 353.933C-99.2628 353.933 -98.1278 352.798 -98.1278 351.398C-98.1278 349.998 -99.2628 348.863 -100.663 348.863C-102.063 348.863 -103.198 349.998 -103.198 351.398C-103.198 352.798 -102.063 353.933 -100.663 353.933ZM68.3466 351.398C68.3466 352.798 67.2116 353.933 65.8115 353.933C64.4114 353.933 63.2763 352.798 63.2763 351.398C63.2763 349.998 64.4114 348.863 65.8115 348.863C67.2116 348.863 68.3466 349.998 68.3466 351.398ZM65.8115 421.538C67.2116 421.538 68.3466 420.403 68.3466 419.003C68.3466 417.603 67.2116 416.468 65.8115 416.468C64.4114 416.468 63.2763 417.603 63.2763 419.003C63.2763 420.403 64.4114 421.538 65.8115 421.538ZM-93.0579 445.2C-93.0579 446.6 -94.1929 447.735 -95.593 447.735C-96.9931 447.735 -98.1282 446.6 -98.1282 445.2C-98.1282 443.8 -96.9931 442.665 -95.593 442.665C-94.1929 442.665 -93.0579 443.8 -93.0579 445.2ZM52.2906 460.411C53.6908 460.411 54.8258 459.276 54.8258 457.876C54.8258 456.475 53.6908 455.34 52.2906 455.34C50.8905 455.34 49.7555 456.475 49.7555 457.876C49.7555 459.276 50.8905 460.411 52.2906 460.411ZM55.6709 102.111C55.6709 103.511 54.5359 104.646 53.1358 104.646C51.7357 104.646 50.6006 103.511 50.6006 102.111C50.6006 100.711 51.7357 99.5755 53.1358 99.5755C54.5359 99.5755 55.6709 100.711 55.6709 102.111ZM-134.465 104.646C-133.065 104.646 -131.93 103.511 -131.93 102.111C-131.93 100.711 -133.065 99.5755 -134.465 99.5755C-135.865 99.5755 -137 100.711 -137 102.111C-137 103.511 -135.865 104.646 -134.465 104.646ZM-7.70763 102.111C-7.70763 103.511 -8.84265 104.646 -10.2428 104.646C-11.6429 104.646 -12.7779 103.511 -12.7779 102.111C-12.7779 100.711 -11.6429 99.5755 -10.2428 99.5755C-8.84265 99.5755 -7.70763 100.711 -7.70763 102.111ZM-10.2428 42.9571C-8.84265 42.9571 -7.70763 41.8221 -7.70763 40.4219C-7.70763 39.0218 -8.84265 37.8868 -10.2428 37.8868C-11.6429 37.8868 -12.7779 39.0218 -12.7779 40.4219C-12.7779 41.8221 -11.6429 42.9571 -10.2428 42.9571ZM-54.1854 387.735C-52.7853 387.735 -51.6502 386.6 -51.6502 385.2C-51.6502 383.8 -52.7853 382.665 -54.1854 382.665C-55.5855 382.665 -56.7205 383.8 -56.7205 385.2C-56.7205 386.6 -55.5855 387.735 -54.1854 387.735ZM-51.6502 536.464C-51.6502 537.865 -52.7853 539 -54.1854 539C-55.5855 539 -56.7205 537.865 -56.7205 536.464C-56.7205 535.064 -55.5855 533.929 -54.1854 533.929C-52.7853 533.929 -51.6502 535.064 -51.6502 536.464ZM115.67 436.749C117.07 436.749 118.205 435.614 118.205 434.214C118.205 432.813 117.07 431.678 115.67 431.678C114.269 431.678 113.134 432.813 113.134 434.214C113.134 435.614 114.269 436.749 115.67 436.749ZM108.909 489.987C108.909 491.387 107.774 492.522 106.374 492.522C104.973 492.522 103.838 491.387 103.838 489.987C103.838 488.587 104.973 487.452 106.374 487.452C107.774 487.452 108.909 488.587 108.909 489.987ZM-129.394 516.183C-127.994 516.183 -126.859 515.048 -126.859 513.648C-126.859 512.248 -127.994 511.113 -129.394 511.113C-130.795 511.113 -131.93 512.248 -131.93 513.648C-131.93 515.048 -130.795 516.183 -129.394 516.183ZM-126.859 416.468C-126.859 417.868 -127.994 419.003 -129.394 419.003C-130.795 419.003 -131.93 417.868 -131.93 416.468C-131.93 415.068 -130.795 413.933 -129.394 413.933C-127.994 413.933 -126.859 415.068 -126.859 416.468ZM15.9538 487.452C17.3539 487.452 18.4889 486.317 18.4889 484.917C18.4889 483.517 17.3539 482.382 15.9538 482.382C14.5537 482.382 13.4186 483.517 13.4186 484.917C13.4186 486.317 14.5537 487.452 15.9538 487.452ZM55.6709 222.107C55.6709 223.508 54.5359 224.643 53.1358 224.643C51.7357 224.643 50.6006 223.508 50.6006 222.107C50.6006 220.707 51.7357 219.572 53.1358 219.572C54.5359 219.572 55.6709 220.707 55.6709 222.107ZM13.4183 315.907C15.2851 315.907 16.7985 314.393 16.7985 312.526C16.7985 310.66 15.2851 309.146 13.4183 309.146C11.5515 309.146 10.0381 310.66 10.0381 312.526C10.0381 314.393 11.5515 315.907 13.4183 315.907ZM10.0386 266.895C10.0386 267.828 9.28192 268.585 8.34851 268.585C7.4151 268.585 6.65842 267.828 6.65842 266.895C6.65842 265.961 7.4151 265.204 8.34851 265.204C9.28192 265.204 10.0386 265.961 10.0386 266.895ZM-20.8059 276.19C-20.1059 276.19 -19.5384 275.622 -19.5384 274.922C-19.5384 274.222 -20.1059 273.655 -20.8059 273.655C-21.506 273.655 -22.0735 274.222 -22.0735 274.922C-22.0735 275.622 -21.506 276.19 -20.8059 276.19ZM-19.5384 197.178C-19.5384 197.878 -20.1059 198.446 -20.8059 198.446C-21.506 198.446 -22.0735 197.878 -22.0735 197.178C-22.0735 196.478 -21.506 195.91 -20.8059 195.91C-20.1059 195.91 -19.5384 196.478 -19.5384 197.178ZM114.402 198.446C115.102 198.446 115.67 197.878 115.67 197.178C115.67 196.478 115.102 195.91 114.402 195.91C113.702 195.91 113.134 196.478 113.134 197.178C113.134 197.878 113.702 198.446 114.402 198.446ZM115.67 120.278C115.67 120.978 115.102 121.545 114.402 121.545C113.702 121.545 113.134 120.978 113.134 120.278C113.134 119.578 113.702 119.01 114.402 119.01C115.102 119.01 115.67 119.578 115.67 120.278ZM114.402 58.1672C115.102 58.1672 115.67 57.5997 115.67 56.8996C115.67 56.1996 115.102 55.6321 114.402 55.6321C113.702 55.6321 113.134 56.1996 113.134 56.8996C113.134 57.5997 113.702 58.1672 114.402 58.1672ZM-27.1437 56.8996C-27.1437 57.5997 -27.7112 58.1672 -28.4113 58.1672C-29.1113 58.1672 -29.6788 57.5997 -29.6788 56.8996C-29.6788 56.1996 -29.1113 55.6321 -28.4113 55.6321C-27.7112 55.6321 -27.1437 56.1996 -27.1437 56.8996ZM34.5446 11.2676C34.5446 11.9676 33.9771 12.5351 33.277 12.5351C32.5769 12.5351 32.0094 11.9676 32.0094 11.2676C32.0094 10.5675 32.5769 10 33.277 10C33.9771 10 34.5446 10.5675 34.5446 11.2676ZM33.277 166.334C33.9771 166.334 34.5446 165.766 34.5446 165.066C34.5446 164.366 33.9771 163.799 33.277 163.799C32.5769 163.799 32.0094 164.366 32.0094 165.066C32.0094 165.766 32.5769 166.334 33.277 166.334ZM1.58781 345.062C1.58781 345.762 1.02031 346.329 0.320251 346.329C-0.379822 346.329 -0.947327 345.762 -0.947327 345.062C-0.947327 344.362 -0.379822 343.794 0.320251 343.794C1.02031 343.794 1.58781 344.362 1.58781 345.062ZM0.320251 522.943C1.02031 522.943 1.58781 522.376 1.58781 521.676C1.58781 520.975 1.02031 520.408 0.320251 520.408C-0.379822 520.408 -0.947327 520.975 -0.947327 521.676C-0.947327 522.376 -0.379822 522.943 0.320251 522.943ZM131.725 521.676C131.725 522.376 131.158 522.943 130.458 522.943C129.758 522.943 129.19 522.376 129.19 521.676C129.19 520.975 129.758 520.408 130.458 520.408C131.158 520.408 131.725 520.975 131.725 521.676ZM-99.3952 522.943C-98.6951 522.943 -98.1276 522.376 -98.1276 521.676C-98.1276 520.975 -98.6951 520.408 -99.3952 520.408C-100.095 520.408 -100.663 520.975 -100.663 521.676C-100.663 522.376 -100.095 522.943 -99.3952 522.943ZM-98.1276 392.385C-98.1276 393.085 -98.6951 393.652 -99.3952 393.652C-100.095 393.652 -100.663 393.085 -100.663 392.385C-100.663 391.685 -100.095 391.117 -99.3952 391.117C-98.6951 391.117 -98.1276 391.685 -98.1276 392.385ZM-99.3952 289.711C-98.6951 289.711 -98.1276 289.144 -98.1276 288.444C-98.1276 287.744 -98.6951 287.176 -99.3952 287.176C-100.095 287.176 -100.663 287.744 -100.663 288.444C-100.663 289.144 -100.095 289.711 -99.3952 289.711ZM96.2333 308.724C96.2333 309.424 95.6658 309.992 94.9657 309.992C94.2656 309.992 93.6981 309.424 93.6981 308.724C93.6981 308.024 94.2656 307.457 94.9657 307.457C95.6658 307.457 96.2333 308.024 96.2333 308.724ZM96.6555 219.571C97.3556 219.571 97.9231 219.004 97.9231 218.304C97.9231 217.604 97.3556 217.036 96.6555 217.036C95.9555 217.036 95.388 217.604 95.388 218.304C95.388 219.004 95.9555 219.571 96.6555 219.571ZM97.9231 54.3651C97.9231 55.0651 97.3556 55.6326 96.6555 55.6326C95.9555 55.6326 95.388 55.0651 95.388 54.3651C95.388 53.665 95.9555 53.0975 96.6555 53.0975C97.3556 53.0975 97.9231 53.665 97.9231 54.3651ZM42.995 260.979C44.3952 260.979 45.5302 259.844 45.5302 258.444C45.5302 257.044 44.3952 255.909 42.995 255.909C41.5949 255.909 40.4599 257.044 40.4599 258.444C40.4599 259.844 41.5949 260.979 42.995 260.979ZM129.19 268.584C129.19 269.984 128.055 271.119 126.655 271.119C125.255 271.119 124.12 269.984 124.12 268.584C124.12 267.184 125.255 266.049 126.655 266.049C128.055 266.049 129.19 267.184 129.19 268.584ZM-111.649 271.119C-110.249 271.119 -109.114 269.984 -109.114 268.584C-109.114 267.184 -110.249 266.049 -111.649 266.049C-113.049 266.049 -114.184 267.184 -114.184 268.584C-114.184 269.984 -113.049 271.119 -111.649 271.119Z"
                    fill="white"
                    fillOpacity={0.5}
                />
                <path
                    fillRule="evenodd"
                    clipRule="evenodd"
                    d="M384.816 536.465C384.116 536.465 383.549 537.032 383.549 537.732C383.549 538.432 384.116 539 384.816 539C385.517 539 386.084 538.432 386.084 537.732C386.084 537.032 385.517 536.465 384.816 536.465ZM425.801 535.62C425.801 534.22 426.937 533.085 428.337 533.085C429.737 533.085 430.872 534.22 430.872 535.62C430.872 537.02 429.737 538.155 428.337 538.155C426.937 538.155 425.801 537.02 425.801 535.62ZM195.948 503.508C191.281 503.508 187.498 507.291 187.498 511.958C187.498 516.625 191.281 520.409 195.948 520.409C200.616 520.409 204.399 516.625 204.399 511.958C204.399 507.291 200.616 503.508 195.948 503.508ZM233.976 400.411C233.976 395.744 237.759 391.961 242.426 391.961C247.093 391.961 250.876 395.744 250.876 400.411C250.876 405.078 247.093 408.862 242.426 408.862C237.759 408.862 233.976 405.078 233.976 400.411ZM436.787 315.907C433.053 315.907 430.027 318.934 430.027 322.667C430.027 326.401 433.053 329.428 436.787 329.428C440.521 329.428 443.547 326.401 443.547 322.667C443.547 318.934 440.521 315.907 436.787 315.907ZM392.844 247.459C389.111 247.459 386.084 250.486 386.084 254.219C386.084 257.953 389.111 260.98 392.844 260.98C396.578 260.98 399.605 257.953 399.605 254.219C399.605 250.486 396.578 247.459 392.844 247.459ZM163.837 239.008C163.837 236.207 166.107 233.937 168.907 233.937C171.707 233.937 173.977 236.207 173.977 239.008C173.977 241.808 171.707 244.078 168.907 244.078C166.107 244.078 163.837 241.808 163.837 239.008ZM184.963 160.418C183.096 160.418 181.583 161.931 181.583 163.798C181.583 165.665 183.096 167.178 184.963 167.178C186.83 167.178 188.343 165.665 188.343 163.798C188.343 161.931 186.83 160.418 184.963 160.418ZM345.522 176.475C345.522 172.741 348.548 169.714 352.282 169.714C356.016 169.714 359.042 172.741 359.042 176.475C359.042 180.208 356.016 183.235 352.282 183.235C348.548 183.235 345.522 180.208 345.522 176.475ZM361.578 53.0975C356.911 53.0975 353.127 56.8809 353.127 61.548C353.127 66.215 356.911 69.9984 361.578 69.9984C366.245 69.9984 370.028 66.215 370.028 61.548C370.028 56.8809 366.245 53.0975 361.578 53.0975ZM348.902 239.854C348.902 236.587 351.55 233.938 354.817 233.938C358.084 233.938 360.733 236.587 360.733 239.854C360.733 243.121 358.084 245.769 354.817 245.769C351.55 245.769 348.902 243.121 348.902 239.854ZM181.582 299.006C176.915 299.006 173.132 302.79 173.132 307.457C173.132 312.124 176.915 315.907 181.582 315.907C186.25 315.907 190.033 312.124 190.033 307.457C190.033 302.79 186.25 299.006 181.582 299.006ZM415.661 482.382C415.661 477.715 419.444 473.932 424.111 473.932C428.778 473.932 432.562 477.715 432.562 482.382C432.562 487.049 428.778 490.833 424.111 490.833C419.444 490.833 415.661 487.049 415.661 482.382ZM394.535 348.019C389.868 348.019 386.084 351.802 386.084 356.469C386.084 361.136 389.868 364.92 394.535 364.92C399.202 364.92 402.985 361.136 402.985 356.469C402.985 351.802 399.202 348.019 394.535 348.019ZM324.395 400.411C324.395 395.744 328.179 391.961 332.846 391.961C337.513 391.961 341.296 395.744 341.296 400.411C341.296 405.078 337.513 408.862 332.846 408.862C328.179 408.862 324.395 405.078 324.395 400.411ZM247.496 21.8301C242.829 21.8301 239.046 25.6136 239.046 30.2806C239.046 34.9477 242.829 38.7311 247.496 38.7311C252.163 38.7311 255.947 34.9477 255.947 30.2806C255.947 25.6136 252.163 21.8301 247.496 21.8301ZM222.145 147.743C222.145 143.076 225.928 139.292 230.595 139.292C235.263 139.292 239.046 143.076 239.046 147.743C239.046 152.41 235.263 156.193 230.595 156.193C225.928 156.193 222.145 152.41 222.145 147.743ZM428.337 217.038C423.67 217.038 419.886 220.821 419.886 225.488C419.886 230.155 423.67 233.939 428.337 233.939C433.004 233.939 436.787 230.155 436.787 225.488C436.787 220.821 433.004 217.038 428.337 217.038ZM354.817 429.988C354.817 426.254 357.844 423.228 361.578 423.228C365.311 423.228 368.338 426.254 368.338 429.988C368.338 433.722 365.311 436.748 361.578 436.748C357.844 436.748 354.817 433.722 354.817 429.988ZM432.562 401.258C428.828 401.258 425.801 404.285 425.801 408.019C425.801 411.752 428.828 414.779 432.562 414.779C436.296 414.779 439.322 411.752 439.322 408.019C439.322 404.285 436.296 401.258 432.562 401.258ZM326.931 323.513C326.931 320.713 329.201 318.443 332.001 318.443C334.801 318.443 337.071 320.713 337.071 323.513C337.071 326.313 334.801 328.583 332.001 328.583C329.201 328.583 326.931 326.313 326.931 323.513ZM334.536 119.856C331.269 119.856 328.621 122.505 328.621 125.772C328.621 129.039 331.269 131.687 334.536 131.687C337.803 131.687 340.452 129.039 340.452 125.772C340.452 122.505 337.803 119.856 334.536 119.856ZM212.85 195.067C212.85 192.266 215.12 189.996 217.92 189.996C220.72 189.996 222.99 192.266 222.99 195.067C222.99 197.867 220.72 200.137 217.92 200.137C215.12 200.137 212.85 197.867 212.85 195.067ZM217.92 385.201C215.12 385.201 212.85 387.471 212.85 390.272C212.85 393.072 215.12 395.342 217.92 395.342C220.72 395.342 222.99 393.072 222.99 390.272C222.99 387.471 220.72 385.201 217.92 385.201ZM394.535 471.396C394.535 468.596 396.805 466.326 399.605 466.326C402.405 466.326 404.675 468.596 404.675 471.396C404.675 474.196 402.405 476.466 399.605 476.466C396.805 476.466 394.535 474.196 394.535 471.396ZM261.017 466.326C258.217 466.326 255.947 468.596 255.947 471.396C255.947 474.196 258.217 476.466 261.017 476.466C263.817 476.466 266.087 474.196 266.087 471.396C266.087 468.596 263.817 466.326 261.017 466.326ZM243.271 240.699C243.271 237.898 245.541 235.628 248.341 235.628C251.141 235.628 253.411 237.898 253.411 240.699C253.411 243.499 251.141 245.769 248.341 245.769C245.541 245.769 243.271 243.499 243.271 240.699ZM389.465 115.631C386.664 115.631 384.394 117.901 384.394 120.701C384.394 123.501 386.664 125.771 389.465 125.771C392.265 125.771 394.535 123.501 394.535 120.701C394.535 117.901 392.265 115.631 389.465 115.631ZM157.076 98.73C157.076 95.9298 159.346 93.6598 162.147 93.6598C164.947 93.6598 167.217 95.9298 167.217 98.73C167.217 101.53 164.947 103.8 162.147 103.8C159.346 103.8 157.076 101.53 157.076 98.73ZM287.214 313.372C285.813 313.372 284.678 314.507 284.678 315.907C284.678 317.308 285.813 318.443 287.214 318.443C288.614 318.443 289.749 317.308 289.749 315.907C289.749 314.507 288.614 313.372 287.214 313.372ZM222.99 350.554C222.99 349.154 224.125 348.019 225.525 348.019C226.925 348.019 228.06 349.154 228.06 350.554C228.06 351.955 226.925 353.09 225.525 353.09C224.125 353.09 222.99 351.955 222.99 350.554ZM225.525 275.345C224.125 275.345 222.99 276.48 222.99 277.88C222.99 279.28 224.125 280.415 225.525 280.415C226.925 280.415 228.06 279.28 228.06 277.88C228.06 276.48 226.925 275.345 225.525 275.345ZM222.99 423.229C222.99 421.829 224.125 420.694 225.525 420.694C226.925 420.694 228.06 421.829 228.06 423.229C228.06 424.629 226.925 425.764 225.525 425.764C224.125 425.764 222.99 424.629 222.99 423.229ZM365.803 395.342C364.403 395.342 363.268 396.477 363.268 397.877C363.268 399.277 364.403 400.412 365.803 400.412C367.203 400.412 368.338 399.277 368.338 397.877C368.338 396.477 367.203 395.342 365.803 395.342ZM363.268 476.467C363.268 475.067 364.403 473.932 365.803 473.932C367.203 473.932 368.338 475.067 368.338 476.467C368.338 477.867 367.203 479.002 365.803 479.002C364.403 479.002 363.268 477.867 363.268 476.467ZM187.498 473.932C186.098 473.932 184.963 475.067 184.963 476.467C184.963 477.867 186.098 479.002 187.498 479.002C188.898 479.002 190.033 477.867 190.033 476.467C190.033 475.067 188.898 473.932 187.498 473.932ZM258.482 506.043C258.482 504.643 259.617 503.508 261.017 503.508C262.417 503.508 263.552 504.643 263.552 506.043C263.552 507.444 262.417 508.579 261.017 508.579C259.617 508.579 258.482 507.444 258.482 506.043ZM261.017 369.145C259.617 369.145 258.482 370.28 258.482 371.68C258.482 373.08 259.617 374.215 261.017 374.215C262.417 374.215 263.552 373.08 263.552 371.68C263.552 370.28 262.417 369.145 261.017 369.145ZM412.281 371.68C412.281 370.28 413.416 369.145 414.816 369.145C416.216 369.145 417.351 370.28 417.351 371.68C417.351 373.08 416.216 374.215 414.816 374.215C413.416 374.215 412.281 373.08 412.281 371.68ZM414.816 195.067C413.416 195.067 412.281 196.202 412.281 197.602C412.281 199.002 413.416 200.137 414.816 200.137C416.216 200.137 417.351 199.002 417.351 197.602C417.351 196.202 416.216 195.067 414.816 195.067ZM245.806 197.602C245.806 196.202 246.941 195.067 248.341 195.067C249.741 195.067 250.876 196.202 250.876 197.602C250.876 199.002 249.741 200.137 248.341 200.137C246.941 200.137 245.806 199.002 245.806 197.602ZM248.341 127.463C246.941 127.463 245.806 128.598 245.806 129.998C245.806 131.398 246.941 132.533 248.341 132.533C249.741 132.533 250.876 131.398 250.876 129.998C250.876 128.598 249.741 127.463 248.341 127.463ZM407.211 103.8C407.211 102.4 408.346 101.265 409.746 101.265C411.146 101.265 412.281 102.4 412.281 103.8C412.281 105.2 411.146 106.335 409.746 106.335C408.346 106.335 407.211 105.2 407.211 103.8ZM261.862 88.5893C260.462 88.5893 259.327 89.7243 259.327 91.1244C259.327 92.5246 260.462 93.6596 261.862 93.6596C263.262 93.6596 264.397 92.5246 264.397 91.1244C264.397 89.7243 263.262 88.5893 261.862 88.5893ZM258.482 446.889C258.482 445.489 259.617 444.354 261.017 444.354C262.417 444.354 263.552 445.489 263.552 446.889C263.552 448.289 262.417 449.425 261.017 449.425C259.617 449.425 258.482 448.289 258.482 446.889ZM448.618 444.354C447.218 444.354 446.083 445.489 446.083 446.889C446.083 448.289 447.218 449.425 448.618 449.425C450.018 449.425 451.153 448.289 451.153 446.889C451.153 445.489 450.018 444.354 448.618 444.354ZM321.86 446.889C321.86 445.489 322.995 444.354 324.396 444.354C325.796 444.354 326.931 445.489 326.931 446.889C326.931 448.289 325.796 449.425 324.396 449.425C322.995 449.425 321.86 448.289 321.86 446.889ZM324.396 506.043C322.995 506.043 321.86 507.178 321.86 508.578C321.86 509.978 322.995 511.113 324.396 511.113C325.796 511.113 326.931 509.978 326.931 508.578C326.931 507.178 325.796 506.043 324.396 506.043ZM368.338 161.265C366.938 161.265 365.803 162.4 365.803 163.8C365.803 165.2 366.938 166.335 368.338 166.335C369.738 166.335 370.873 165.2 370.873 163.8C370.873 162.4 369.738 161.265 368.338 161.265ZM365.803 12.5356C365.803 11.1355 366.938 10.0004 368.338 10.0004C369.738 10.0004 370.873 11.1355 370.873 12.5356C370.873 13.9357 369.738 15.0707 368.338 15.0707C366.938 15.0707 365.803 13.9357 365.803 12.5356ZM198.483 112.251C197.083 112.251 195.948 113.386 195.948 114.786C195.948 116.187 197.083 117.322 198.483 117.322C199.883 117.322 201.018 116.187 201.018 114.786C201.018 113.386 199.883 112.251 198.483 112.251ZM205.244 59.0128C205.244 57.6127 206.379 56.4777 207.779 56.4777C209.179 56.4777 210.314 57.6127 210.314 59.0128C210.314 60.4129 209.179 61.5479 207.779 61.5479C206.379 61.5479 205.244 60.4129 205.244 59.0128ZM443.547 32.8165C442.147 32.8165 441.012 33.9515 441.012 35.3517C441.012 36.7518 442.147 37.8868 443.547 37.8868C444.947 37.8868 446.082 36.7518 446.082 35.3517C446.082 33.9515 444.947 32.8165 443.547 32.8165ZM441.012 132.532C441.012 131.132 442.147 129.997 443.547 129.997C444.947 129.997 446.082 131.132 446.082 132.532C446.082 133.932 444.947 135.067 443.547 135.067C442.147 135.067 441.012 133.932 441.012 132.532ZM298.199 61.5476C296.799 61.5476 295.664 62.6826 295.664 64.0828C295.664 65.4829 296.799 66.6179 298.199 66.6179C299.599 66.6179 300.734 65.4829 300.734 64.0828C300.734 62.6826 299.599 61.5476 298.199 61.5476ZM258.482 326.893C258.482 325.492 259.617 324.357 261.017 324.357C262.417 324.357 263.552 325.492 263.552 326.893C263.552 328.293 262.417 329.428 261.017 329.428C259.617 329.428 258.482 328.293 258.482 326.893ZM300.735 233.093C298.868 233.093 297.354 234.607 297.354 236.474C297.354 238.34 298.868 239.854 300.735 239.854C302.601 239.854 304.115 238.34 304.115 236.474C304.115 234.607 302.601 233.093 300.735 233.093ZM304.115 282.105C304.115 281.172 304.871 280.415 305.805 280.415C306.738 280.415 307.495 281.172 307.495 282.105C307.495 283.039 306.738 283.796 305.805 283.796C304.871 283.796 304.115 283.039 304.115 282.105ZM334.959 272.81C334.259 272.81 333.691 273.378 333.691 274.078C333.691 274.778 334.259 275.345 334.959 275.345C335.659 275.345 336.226 274.778 336.226 274.078C336.226 273.378 335.659 272.81 334.959 272.81ZM333.691 351.822C333.691 351.122 334.259 350.554 334.959 350.554C335.659 350.554 336.226 351.122 336.226 351.822C336.226 352.522 335.659 353.09 334.959 353.09C334.259 353.09 333.691 352.522 333.691 351.822ZM199.751 350.554C199.051 350.554 198.483 351.122 198.483 351.822C198.483 352.522 199.051 353.09 199.751 353.09C200.451 353.09 201.018 352.522 201.018 351.822C201.018 351.122 200.451 350.554 199.751 350.554ZM198.483 428.722C198.483 428.022 199.051 427.455 199.751 427.455C200.451 427.455 201.018 428.022 201.018 428.722C201.018 429.422 200.451 429.99 199.751 429.99C199.051 429.99 198.483 429.422 198.483 428.722ZM199.751 490.833C199.051 490.833 198.483 491.4 198.483 492.1C198.483 492.8 199.051 493.368 199.751 493.368C200.451 493.368 201.018 492.8 201.018 492.1C201.018 491.4 200.451 490.833 199.751 490.833ZM341.297 492.1C341.297 491.4 341.864 490.833 342.564 490.833C343.264 490.833 343.832 491.4 343.832 492.1C343.832 492.8 343.264 493.368 342.564 493.368C341.864 493.368 341.297 492.8 341.297 492.1ZM279.608 537.732C279.608 537.032 280.175 536.465 280.875 536.465C281.576 536.465 282.143 537.032 282.143 537.732C282.143 538.432 281.576 539 280.875 539C280.175 539 279.608 538.432 279.608 537.732ZM280.875 382.666C280.175 382.666 279.608 383.234 279.608 383.934C279.608 384.634 280.175 385.201 280.875 385.201C281.576 385.201 282.143 384.634 282.143 383.934C282.143 383.234 281.576 382.666 280.875 382.666ZM312.565 203.938C312.565 203.238 313.133 202.671 313.833 202.671C314.533 202.671 315.1 203.238 315.1 203.938C315.1 204.638 314.533 205.206 313.833 205.206C313.133 205.206 312.565 204.638 312.565 203.938ZM313.833 26.0569C313.133 26.0569 312.565 26.6244 312.565 27.3244C312.565 28.0245 313.133 28.592 313.833 28.592C314.533 28.592 315.1 28.0245 315.1 27.3244C315.1 26.6244 314.533 26.0569 313.833 26.0569ZM182.427 27.3244C182.427 26.6244 182.995 26.0569 183.695 26.0569C184.395 26.0569 184.963 26.6244 184.963 27.3244C184.963 28.0245 184.395 28.592 183.695 28.592C182.995 28.592 182.427 28.0245 182.427 27.3244ZM413.548 26.0569C412.848 26.0569 412.28 26.6244 412.28 27.3244C412.28 28.0245 412.848 28.592 413.548 28.592C414.248 28.592 414.816 28.0245 414.816 27.3244C414.816 26.6244 414.248 26.0569 413.548 26.0569ZM412.28 156.615C412.28 155.915 412.848 155.348 413.548 155.348C414.248 155.348 414.816 155.915 414.816 156.615C414.816 157.315 414.248 157.883 413.548 157.883C412.848 157.883 412.28 157.315 412.28 156.615ZM413.548 259.289C412.848 259.289 412.28 259.856 412.28 260.556C412.28 261.256 412.848 261.824 413.548 261.824C414.248 261.824 414.816 261.256 414.816 260.556C414.816 259.856 414.248 259.289 413.548 259.289ZM217.92 240.276C217.92 239.576 218.487 239.008 219.187 239.008C219.887 239.008 220.455 239.576 220.455 240.276C220.455 240.976 219.887 241.543 219.187 241.543C218.487 241.543 217.92 240.976 217.92 240.276ZM217.497 329.429C216.797 329.429 216.23 329.996 216.23 330.696C216.23 331.396 216.797 331.964 217.497 331.964C218.197 331.964 218.765 331.396 218.765 330.696C218.765 329.996 218.197 329.429 217.497 329.429ZM216.23 494.635C216.23 493.935 216.797 493.367 217.497 493.367C218.197 493.367 218.765 493.935 218.765 494.635C218.765 495.335 218.197 495.903 217.497 495.903C216.797 495.903 216.23 495.335 216.23 494.635ZM271.158 288.021C269.758 288.021 268.623 289.156 268.623 290.556C268.623 291.956 269.758 293.091 271.158 293.091C272.558 293.091 273.693 291.956 273.693 290.556C273.693 289.156 272.558 288.021 271.158 288.021ZM184.963 280.416C184.963 279.016 186.098 277.881 187.498 277.881C188.898 277.881 190.033 279.016 190.033 280.416C190.033 281.816 188.898 282.951 187.498 282.951C186.098 282.951 184.963 281.816 184.963 280.416ZM425.802 277.881C424.402 277.881 423.267 279.016 423.267 280.416C423.267 281.816 424.402 282.951 425.802 282.951C427.202 282.951 428.337 281.816 428.337 280.416C428.337 279.016 427.202 277.881 425.802 277.881Z"
                    fill="white"
                    fillOpacity={0.5}
                />
                <path
                    opacity={0.4}
                    fillRule="evenodd"
                    clipRule="evenodd"
                    d="M36.5565 235.676C37.381 245.567 44.3261 255.319 57.3916 262.872L188.477 338.656C216.368 354.78 261.589 354.78 289.48 338.656L420.565 262.872C433.631 255.319 440.576 245.567 441.4 235.676C442.336 246.899 435.391 258.301 420.565 266.872L289.48 342.656C261.589 358.78 216.368 358.78 188.477 342.656L57.3916 266.872C42.5659 258.301 35.6208 246.899 36.5565 235.676Z"
                    fill="#F5F4F2"
                />
                <path
                    opacity={0.6}
                    d="M57.3916 262.872C29.5003 246.747 29.5003 220.604 57.3917 204.48L188.477 128.696C216.368 112.571 261.589 112.571 289.48 128.696L420.565 204.48C448.456 220.604 448.456 246.747 420.565 262.872L289.48 338.656C261.589 354.78 216.368 354.78 188.477 338.656L57.3916 262.872Z"
                    fill="white"
                />
                <mask
                    id="f2e5ff76__mask0_27804_6153"
                    style={{
                        maskType: 'alpha',
                    }}
                    maskUnits="userSpaceOnUse"
                    x={36}
                    y={55}
                    width={406}
                    height={296}
                >
                    <path
                        d="M56.9185 263.024C29.0272 246.899 29.0272 220.756 56.9185 204.631L139.631 67.0935C167.522 50.9688 300.245 50.9688 328.137 67.0935L420.092 204.631C447.983 220.756 447.983 246.899 420.092 263.024L289.007 338.807C261.116 354.932 215.895 354.932 188.003 338.807L56.9185 263.024Z"
                        fill="#48CCE0"
                    />
                </mask>
                <g mask="url(#f2e5ff76__mask0_27804_6153)">
                    <rect
                        x={141}
                        y={117}
                        width={176}
                        height={229}
                        rx={21}
                        stroke="white"
                        strokeWidth={10}
                    />
                    <rect
                        x={145.599}
                        y={121.188}
                        width={167.746}
                        height={360.061}
                        rx={17.7863}
                        fill="#F5F4F2"
                    />
                </g>
                <mask
                    id="f2e5ff76__mask1_27804_6153"
                    style={{
                        maskType: 'alpha',
                    }}
                    maskUnits="userSpaceOnUse"
                    x={145}
                    y={121}
                    width={167}
                    height={230}
                >
                    <path
                        fillRule="evenodd"
                        clipRule="evenodd"
                        d="M311.746 324.798L288.101 338.468C260.21 354.593 214.989 354.593 187.098 338.468L145 314.13V138.933C145 129.11 152.963 121.146 162.786 121.146H179.683L180.08 121.243C180.919 121.446 181.61 122.074 181.908 122.881C181.923 122.92 181.927 122.963 181.927 123.006L181.924 124.686C181.924 130.352 186.503 134.931 192.151 134.931H264.595C270.244 134.931 274.822 130.352 274.822 124.704L274.82 123.006C274.819 122.963 274.826 122.921 274.841 122.881C275.137 122.068 275.823 121.447 276.666 121.243L277.063 121.146H293.96C303.783 121.146 311.746 129.11 311.746 138.933V324.798Z"
                        fill="#48CCE0"
                    />
                </mask>
                <g mask="url(#f2e5ff76__mask1_27804_6153)">
                    <rect
                        opacity={0.7}
                        width={126.325}
                        height={126.325}
                        rx={20}
                        transform="matrix(1 0 0 -1 179.32 406.949)"
                        fill="white"
                    />
                    <rect
                        opacity={0.7}
                        width={126.325}
                        height={126.325}
                        rx={20}
                        transform="matrix(1 0 0 -1 44.2334 406.949)"
                        fill="white"
                    />
                    <rect
                        opacity={0.7}
                        width={126.325}
                        height={126.325}
                        rx={20}
                        transform="matrix(1 0 0 -1 44.2334 270.639)"
                        fill="white"
                    />
                    <g filter="url(#f2e5ff76__filter1_d_27804_6153)">
                        <rect
                            x={160}
                            y={268}
                            width={56}
                            height={24}
                            rx={12}
                            fill="white"
                        />
                        <mask
                            id="f2e5ff76__mask2_27804_6153"
                            style={{
                                maskType: 'alpha',
                            }}
                            maskUnits="userSpaceOnUse"
                            x={165}
                            y={271}
                            width={45}
                            height={19}
                        >
                            <path
                                fillRule="evenodd"
                                clipRule="evenodd"
                                d="M173.204 284.295L174.167 279.697L178.087 279.697C178.103 279.872 178.11 280.049 178.11 280.227C178.11 283.586 175.388 286.308 172.029 286.308C168.671 286.308 165.948 283.586 165.948 280.227C165.948 276.869 168.671 274.146 172.029 274.146C172.537 274.146 173.03 274.209 173.501 274.326L172.7 278.165L168.322 278.165L167.993 279.697L172.372 279.697L171.387 284.295L173.204 284.295ZM175.173 275.021L174.517 278.165L177.752 278.165C177.276 276.845 176.356 275.737 175.173 275.021Z"
                                fill="url(#f2e5ff76__paint3_linear_27804_6153)"
                            />
                            <path
                                d="M190.67 281.158C190.67 281.748 190.564 282.291 190.353 282.787C190.143 283.271 189.842 283.693 189.452 284.051C189.062 284.399 188.598 284.673 188.061 284.874C187.523 285.063 186.928 285.158 186.274 285.158C185.515 285.158 184.888 285.074 184.393 284.905C183.908 284.736 183.486 284.547 183.128 284.336L183.128 282.391C183.497 282.634 183.924 282.866 184.409 283.087C184.904 283.298 185.478 283.403 186.132 283.403C186.87 283.403 187.428 283.198 187.808 282.787C188.198 282.375 188.393 281.864 188.393 281.253C188.393 280.642 188.24 280.157 187.934 279.798C187.639 279.44 187.175 279.261 186.543 279.261C186.153 279.261 185.832 279.324 185.579 279.45C185.326 279.577 185.136 279.719 185.009 279.877L183.349 279.877L183.349 273.664L190.132 273.664L190.132 275.498L185.294 275.498L185.294 278.075C185.473 277.938 185.71 277.817 186.005 277.711C186.301 277.595 186.685 277.537 187.16 277.537C188.245 277.537 189.099 277.859 189.721 278.502C190.353 279.134 190.67 280.02 190.67 281.158ZM199.13 285L191.636 285L191.636 282.913C192.595 282.196 193.407 281.564 194.071 281.016C194.746 280.468 195.288 279.967 195.699 279.514C196.111 279.06 196.406 278.639 196.585 278.249C196.775 277.848 196.869 277.432 196.869 277C196.869 276.473 196.711 276.062 196.395 275.767C196.089 275.461 195.652 275.308 195.083 275.308C194.514 275.308 193.966 275.429 193.439 275.672C192.912 275.914 192.416 276.236 191.952 276.636L191.952 274.644C192.395 274.307 192.885 274.038 193.423 273.838C193.96 273.627 194.614 273.521 195.383 273.521C195.952 273.521 196.469 273.601 196.933 273.759C197.396 273.906 197.792 274.128 198.118 274.423C198.456 274.718 198.714 275.081 198.893 275.514C199.083 275.935 199.178 276.415 199.178 276.952C199.178 277.501 199.067 278.017 198.846 278.502C198.624 278.987 198.292 279.472 197.85 279.956C197.418 280.441 196.875 280.947 196.221 281.474C195.578 281.991 194.825 282.56 193.96 283.182L199.13 283.182L199.13 285ZM205.103 285.158C204.439 285.158 203.817 285.037 203.237 284.794C202.668 284.541 202.167 284.173 201.735 283.688C201.314 283.192 200.982 282.581 200.739 281.854C200.497 281.126 200.376 280.283 200.376 279.324C200.376 278.365 200.497 277.527 200.739 276.81C200.982 276.083 201.314 275.477 201.735 274.992C202.167 274.507 202.668 274.143 203.237 273.901C203.817 273.648 204.439 273.521 205.103 273.521C205.767 273.521 206.389 273.643 206.969 273.885C207.548 274.128 208.049 274.491 208.471 274.976C208.892 275.461 209.224 276.067 209.467 276.794C209.709 277.511 209.83 278.344 209.83 279.292C209.83 280.241 209.709 281.079 209.467 281.806C209.224 282.534 208.892 283.15 208.471 283.656C208.049 284.151 207.548 284.526 206.969 284.779C206.389 285.032 205.767 285.158 205.103 285.158ZM205.087 283.403C205.446 283.403 205.778 283.329 206.083 283.182C206.389 283.034 206.652 282.802 206.874 282.486C207.095 282.159 207.269 281.738 207.395 281.221C207.522 280.705 207.585 280.078 207.585 279.34C207.585 278.602 207.522 277.975 207.395 277.458C207.269 276.931 207.095 276.51 206.874 276.193C206.652 275.867 206.389 275.63 206.083 275.482C205.778 275.334 205.451 275.261 205.103 275.261C204.755 275.261 204.428 275.334 204.123 275.482C203.828 275.63 203.569 275.867 203.348 276.193C203.127 276.51 202.953 276.931 202.826 277.458C202.7 277.975 202.636 278.602 202.636 279.34C202.636 280.078 202.7 280.705 202.826 281.221C202.953 281.738 203.127 282.159 203.348 282.486C203.569 282.802 203.828 283.034 204.123 283.182C204.418 283.329 204.739 283.403 205.087 283.403Z"
                                fill="url(#f2e5ff76__paint4_linear_27804_6153)"
                            />
                        </mask>
                        <g mask="url(#f2e5ff76__mask2_27804_6153)">
                            <rect
                                x={159}
                                y={271}
                                width={51}
                                height={21}
                                fill="url(#f2e5ff76__paint5_linear_27804_6153)"
                            />
                        </g>
                    </g>
                    <g clipPath="url(#f2e5ff76__clip2_27804_6153)">
                        <g clipPath="url(#f2e5ff76__clip3_27804_6153)">
                            <rect
                                width={126.325}
                                height={126.325}
                                transform="matrix(1 0 0 -1 179.32 271.949)"
                                fill="url(#f2e5ff76__paint6_radial_27804_6153)"
                            />
                            <rect
                                width={126.325}
                                height={126.325}
                                transform="matrix(1 0 0 -1 179.32 271.949)"
                                fill="url(#f2e5ff76__paint7_radial_27804_6153)"
                            />
                            <rect
                                width={126.325}
                                height={126.325}
                                transform="matrix(1 0 0 -1 179.32 271.949)"
                                fill="white"
                                fillOpacity={0.2}
                            />
                            <rect
                                x={220.32}
                                y={192.625}
                                width={86}
                                height={80}
                                fill="url(#f2e5ff76__pattern0)"
                            />
                        </g>
                    </g>
                    <path
                        d="M199.868 164.559V173.987H197.609V164.559H194.214V162.664H203.263V164.559H199.868ZM208.636 173.893C208.457 174.387 208.267 174.824 208.067 175.203C207.867 175.582 207.63 175.898 207.357 176.151C207.093 176.414 206.778 176.609 206.409 176.735C206.041 176.872 205.598 176.94 205.082 176.94C204.767 176.94 204.488 176.914 204.245 176.862C204.003 176.819 203.766 176.746 203.535 176.64V174.745C203.714 174.872 203.93 174.972 204.182 175.045C204.446 175.13 204.73 175.172 205.035 175.172C205.372 175.172 205.646 175.109 205.856 174.982C206.067 174.866 206.246 174.687 206.393 174.445L203.124 165.791H205.446L207.499 171.713L209.504 165.791H211.51L208.636 173.893ZM217.49 174.145C216.88 174.145 216.353 174.014 215.911 173.75C215.48 173.477 215.127 173.113 214.853 172.661V176.783H212.674V165.791H214.711L214.822 167.133C215.095 166.66 215.453 166.291 215.895 166.028C216.338 165.765 216.875 165.633 217.506 165.633C217.991 165.633 218.449 165.723 218.88 165.902C219.322 166.07 219.707 166.333 220.033 166.691C220.37 167.039 220.633 167.481 220.823 168.018C221.012 168.544 221.107 169.165 221.107 169.881C221.107 170.608 221.007 171.239 220.807 171.776C220.617 172.303 220.359 172.745 220.033 173.103C219.707 173.45 219.322 173.714 218.88 173.893C218.438 174.061 217.975 174.145 217.49 174.145ZM216.875 172.392C217.464 172.392 217.943 172.187 218.312 171.776C218.68 171.366 218.864 170.734 218.864 169.881C218.864 169.039 218.68 168.413 218.312 168.002C217.943 167.581 217.469 167.37 216.89 167.37C216.301 167.37 215.811 167.581 215.422 168.002C215.032 168.413 214.837 169.039 214.837 169.881C214.837 170.734 215.032 171.366 215.422 171.776C215.811 172.187 216.295 172.392 216.875 172.392ZM229.398 171.081C229.398 171.555 229.308 171.976 229.13 172.345C228.961 172.703 228.724 173.008 228.419 173.261C228.114 173.503 227.745 173.687 227.313 173.814C226.892 173.929 226.429 173.987 225.924 173.987H222.544V165.791H224.723V168.286H225.955C227.04 168.286 227.882 168.523 228.482 168.997C229.093 169.46 229.398 170.155 229.398 171.081ZM232.304 173.987H230.109V165.791H232.304V173.987ZM224.723 169.944V172.345H225.671C226.113 172.345 226.466 172.255 226.729 172.076C227.003 171.887 227.14 171.576 227.14 171.145C227.14 170.724 227.013 170.418 226.761 170.229C226.518 170.039 226.161 169.944 225.687 169.944H224.723ZM198.794 192.145C198.109 192.145 197.493 192.05 196.946 191.861C196.409 191.661 195.951 191.382 195.572 191.024C195.193 190.655 194.898 190.208 194.688 189.682C194.488 189.155 194.388 188.555 194.388 187.881C194.388 187.218 194.488 186.623 194.688 186.097C194.898 185.57 195.193 185.128 195.572 184.77C195.951 184.402 196.414 184.123 196.962 183.933C197.509 183.733 198.125 183.633 198.809 183.633C199.441 183.633 199.968 183.702 200.389 183.838C200.81 183.965 201.141 184.117 201.384 184.296V186.034C201.068 185.833 200.731 185.676 200.373 185.56C200.015 185.433 199.557 185.37 198.999 185.37C197.42 185.37 196.63 186.207 196.63 187.881C196.63 189.555 197.409 190.392 198.967 190.392C199.546 190.392 200.015 190.334 200.373 190.219C200.731 190.092 201.068 189.934 201.384 189.745V191.466C201.141 191.645 200.805 191.803 200.373 191.94C199.952 192.077 199.425 192.145 198.794 192.145ZM208.978 188.797H208.268V191.987H206.088V183.791H208.268V187.06H209.01L211.41 183.791H213.606L210.731 187.676L213.811 191.987H211.253L208.978 188.797ZM221.508 191.45C221.382 191.524 221.234 191.603 221.066 191.687C220.908 191.761 220.713 191.835 220.482 191.908C220.26 191.972 219.997 192.024 219.692 192.066C219.397 192.119 219.044 192.145 218.634 192.145C217.033 192.145 215.849 191.771 215.08 191.024C214.312 190.276 213.928 189.229 213.928 187.881C213.928 187.218 214.028 186.623 214.228 186.097C214.438 185.57 214.728 185.128 215.096 184.77C215.465 184.402 215.902 184.123 216.407 183.933C216.923 183.733 217.491 183.633 218.113 183.633C218.744 183.633 219.313 183.738 219.818 183.949C220.324 184.149 220.739 184.449 221.066 184.849C221.403 185.249 221.634 185.755 221.761 186.365C221.887 186.976 221.887 187.681 221.761 188.481H216.202C216.286 189.124 216.518 189.608 216.897 189.934C217.286 190.25 217.902 190.408 218.744 190.408C219.418 190.408 219.966 190.334 220.387 190.187C220.818 190.04 221.192 189.887 221.508 189.729V191.45ZM218.144 185.26C217.66 185.26 217.255 185.407 216.928 185.702C216.602 185.997 216.381 186.423 216.265 186.981H219.676C219.687 186.402 219.56 185.97 219.297 185.686C219.034 185.402 218.65 185.26 218.144 185.26ZM234.21 191.987H223.377V183.791H225.556V190.25H227.704V183.791H229.899V190.25H232.015V183.791H234.21V191.987ZM244.028 187.929C244.028 188.613 243.923 189.218 243.712 189.745C243.502 190.271 243.207 190.713 242.828 191.071C242.459 191.429 242.017 191.698 241.501 191.877C240.996 192.056 240.448 192.145 239.859 192.145C239.259 192.145 238.706 192.045 238.201 191.845C237.695 191.635 237.258 191.329 236.89 190.929C236.521 190.529 236.232 190.029 236.021 189.429C235.811 188.818 235.705 188.108 235.705 187.297C235.705 186.486 235.742 185.776 235.816 185.165C235.89 184.544 236.006 184.002 236.163 183.538C236.332 183.065 236.542 182.659 236.795 182.322C237.048 181.985 237.348 181.691 237.695 181.438C238.138 181.133 238.617 180.927 239.132 180.822C239.659 180.706 240.217 180.633 240.806 180.601C241.217 180.59 241.564 180.575 241.849 180.554C242.133 180.522 242.375 180.485 242.575 180.443C242.786 180.401 242.959 180.359 243.096 180.317C243.233 180.264 243.36 180.206 243.475 180.143V182.054C243.36 182.117 243.233 182.175 243.096 182.228C242.97 182.27 242.807 182.307 242.607 182.338C242.417 182.37 242.186 182.401 241.912 182.433C241.638 182.454 241.307 182.48 240.917 182.512C240.422 182.554 239.98 182.612 239.59 182.686C239.201 182.749 238.864 182.896 238.58 183.128C238.274 183.37 238.032 183.702 237.853 184.123C237.685 184.533 237.564 185.049 237.49 185.67C238.006 184.512 239.017 183.933 240.522 183.933C240.975 183.933 241.412 184.023 241.833 184.202C242.254 184.381 242.628 184.644 242.954 184.991C243.281 185.328 243.539 185.744 243.728 186.239C243.928 186.734 244.028 187.297 244.028 187.929ZM239.859 190.392C240.417 190.392 240.875 190.197 241.233 189.808C241.591 189.418 241.77 188.813 241.77 187.992C241.77 187.192 241.591 186.597 241.233 186.207C240.875 185.807 240.417 185.607 239.859 185.607C239.311 185.607 238.859 185.807 238.501 186.207C238.143 186.597 237.964 187.186 237.964 187.976C237.964 188.797 238.143 189.408 238.501 189.808C238.859 190.197 239.311 190.392 239.859 190.392ZM252.081 187.881C252.081 188.555 251.975 189.155 251.765 189.682C251.565 190.208 251.275 190.655 250.896 191.024C250.517 191.382 250.054 191.661 249.506 191.861C248.959 192.05 248.348 192.145 247.674 192.145C247.032 192.145 246.501 192.077 246.079 191.94C245.658 191.803 245.321 191.645 245.069 191.466V189.745C245.227 189.84 245.385 189.929 245.542 190.013C245.711 190.087 245.89 190.155 246.079 190.219C246.269 190.271 246.479 190.313 246.711 190.345C246.943 190.376 247.206 190.392 247.501 190.392C248.806 190.392 249.57 189.818 249.791 188.671H246.632V186.95H249.759C249.506 185.897 248.754 185.37 247.501 185.37C246.932 185.37 246.469 185.428 246.111 185.544C245.764 185.66 245.432 185.823 245.116 186.034V184.296C245.358 184.117 245.69 183.965 246.111 183.838C246.543 183.702 247.074 183.633 247.706 183.633C248.38 183.633 248.985 183.733 249.522 183.933C250.07 184.123 250.533 184.402 250.912 184.77C251.291 185.128 251.58 185.57 251.78 186.097C251.981 186.623 252.081 187.218 252.081 187.881ZM256.402 188.797H255.691V191.987H253.512V183.791H255.691V187.06H256.434L258.834 183.791H261.029L258.155 187.676L261.235 191.987H258.676L256.402 188.797ZM265.489 192.145C264.899 192.145 264.352 192.056 263.847 191.877C263.352 191.687 262.915 191.414 262.536 191.056C262.167 190.687 261.878 190.24 261.667 189.713C261.457 189.176 261.351 188.566 261.351 187.881C261.351 187.197 261.457 186.592 261.667 186.065C261.878 185.528 262.167 185.081 262.536 184.723C262.915 184.365 263.352 184.096 263.847 183.917C264.352 183.728 264.899 183.633 265.489 183.633C266.079 183.633 266.626 183.728 267.131 183.917C267.647 184.096 268.089 184.365 268.458 184.723C268.837 185.081 269.132 185.528 269.342 186.065C269.563 186.592 269.674 187.197 269.674 187.881C269.674 188.566 269.563 189.176 269.342 189.713C269.132 190.24 268.837 190.687 268.458 191.056C268.089 191.414 267.647 191.687 267.131 191.877C266.626 192.056 266.079 192.145 265.489 192.145ZM265.489 190.392C266.058 190.392 266.521 190.187 266.879 189.776C267.237 189.366 267.416 188.734 267.416 187.881C267.416 187.039 267.237 186.413 266.879 186.002C266.521 185.591 266.058 185.386 265.489 185.386C264.952 185.386 264.499 185.591 264.131 186.002C263.773 186.413 263.594 187.039 263.594 187.881C263.594 188.734 263.773 189.366 264.131 189.776C264.499 190.187 264.952 190.392 265.489 190.392ZM278.705 186.57L276.573 191.308H275.041L273.051 186.602V191.987H271.109V183.791H273.967L275.973 188.545L278.105 183.791H280.885V191.987H278.705V186.57Z"
                        fill="white"
                    />
                </g>
                <g filter="url(#f2e5ff76__filter2_d_27804_6153)">
                    <rect
                        x={288}
                        y={179}
                        width={75}
                        height={27}
                        rx={13.5}
                        fill="white"
                    />
                    <mask
                        id="f2e5ff76__mask3_27804_6153"
                        style={{
                            maskType: 'alpha',
                        }}
                        maskUnits="userSpaceOnUse"
                        x={294}
                        y={182}
                        width={62}
                        height={21}
                    >
                        <path
                            fillRule="evenodd"
                            clipRule="evenodd"
                            d="M302.656 196.968L303.715 191.916L308.023 191.916C308.04 192.108 308.048 192.303 308.048 192.499C308.048 196.19 305.057 199.182 301.366 199.182C297.675 199.182 294.683 196.19 294.683 192.499C294.683 188.808 297.675 185.816 301.366 185.816C301.923 185.816 302.465 185.885 302.983 186.013L302.103 190.232L297.292 190.232L296.931 191.916L301.742 191.916L300.66 196.968L302.656 196.968ZM304.82 186.777L304.1 190.232L307.654 190.232C307.131 188.782 306.121 187.564 304.82 186.777Z"
                            fill="url(#f2e5ff76__paint8_linear_27804_6153)"
                        />
                        <path
                            d="M319.592 195.29L319.592 198L317.194 198L317.194 195.29L311.564 195.29L311.564 193.5L317.09 185.542L319.592 185.542L319.592 193.396L321.103 193.396L321.103 195.29L319.592 195.29ZM317.194 193.396L317.194 188.461L313.788 193.396L317.194 193.396ZM331.967 193.778C331.967 194.496 331.834 195.127 331.567 195.672C331.313 196.216 330.965 196.674 330.525 197.044C330.096 197.415 329.598 197.699 329.031 197.896C328.463 198.081 327.878 198.174 327.276 198.174C326.581 198.174 325.938 198.069 325.347 197.861C324.768 197.653 324.27 197.317 323.853 196.853C323.436 196.378 323.112 195.776 322.88 195.046C322.648 194.305 322.532 193.401 322.532 192.336C322.532 191.386 322.642 190.494 322.863 189.66C323.083 188.814 323.419 188.073 323.87 187.436C324.334 186.799 324.919 186.295 325.625 185.924C326.343 185.554 327.195 185.368 328.179 185.368C328.816 185.368 329.384 185.432 329.882 185.56C330.38 185.687 330.809 185.866 331.168 186.098L331.168 188.096C330.693 187.818 330.212 187.616 329.726 187.488C329.251 187.361 328.787 187.297 328.336 187.297C327.351 187.297 326.587 187.61 326.042 188.235C325.509 188.849 325.168 189.706 325.017 190.807C325.399 190.378 325.834 190.071 326.32 189.886C326.818 189.689 327.363 189.591 327.953 189.591C328.475 189.591 328.979 189.672 329.465 189.834C329.952 189.996 330.38 190.251 330.751 190.598C331.121 190.934 331.417 191.369 331.637 191.901C331.857 192.423 331.967 193.048 331.967 193.778ZM327.293 196.263C327.583 196.263 327.855 196.21 328.11 196.106C328.376 196.002 328.608 195.851 328.805 195.654C329.013 195.446 329.175 195.191 329.291 194.89C329.419 194.577 329.482 194.218 329.482 193.813C329.482 193.419 329.424 193.077 329.309 192.788C329.193 192.486 329.036 192.243 328.84 192.058C328.654 191.861 328.434 191.716 328.179 191.623C327.924 191.531 327.658 191.484 327.38 191.484C327.079 191.484 326.795 191.531 326.529 191.623C326.262 191.716 326.025 191.861 325.816 192.058C325.619 192.243 325.457 192.486 325.33 192.788C325.214 193.077 325.156 193.419 325.156 193.813C325.133 194.612 325.33 195.22 325.747 195.637C326.164 196.054 326.679 196.263 327.293 196.263ZM338.586 198.174C337.856 198.174 337.173 198.041 336.536 197.774C335.91 197.496 335.36 197.091 334.885 196.558C334.422 196.013 334.057 195.342 333.791 194.542C333.524 193.743 333.391 192.816 333.391 191.762C333.391 190.708 333.524 189.787 333.791 189C334.057 188.201 334.422 187.534 334.885 187.002C335.36 186.469 335.91 186.069 336.536 185.803C337.173 185.525 337.856 185.386 338.586 185.386C339.316 185.386 339.999 185.519 340.636 185.785C341.273 186.052 341.824 186.451 342.287 186.984C342.75 187.517 343.115 188.183 343.382 188.982C343.648 189.77 343.781 190.685 343.781 191.728C343.781 192.77 343.648 193.691 343.382 194.49C343.115 195.29 342.75 195.967 342.287 196.523C341.824 197.068 341.273 197.479 340.636 197.757C339.999 198.035 339.316 198.174 338.586 198.174ZM338.569 196.245C338.963 196.245 339.327 196.164 339.663 196.002C339.999 195.84 340.289 195.585 340.532 195.237C340.775 194.878 340.966 194.415 341.105 193.847C341.244 193.28 341.314 192.591 341.314 191.78C341.314 190.969 341.244 190.28 341.105 189.712C340.966 189.133 340.775 188.67 340.532 188.322C340.289 187.963 339.999 187.702 339.663 187.54C339.327 187.378 338.968 187.297 338.586 187.297C338.204 187.297 337.845 187.378 337.509 187.54C337.184 187.702 336.901 187.963 336.657 188.322C336.414 188.67 336.223 189.133 336.084 189.712C335.945 190.28 335.876 190.969 335.876 191.78C335.876 192.591 335.945 193.28 336.084 193.847C336.223 194.415 336.414 194.878 336.657 195.237C336.901 195.585 337.184 195.84 337.509 196.002C337.833 196.164 338.186 196.245 338.569 196.245ZM350.43 198.174C349.7 198.174 349.016 198.041 348.379 197.774C347.754 197.496 347.204 197.091 346.729 196.558C346.265 196.013 345.9 195.342 345.634 194.542C345.368 193.743 345.234 192.816 345.234 191.762C345.234 190.708 345.368 189.787 345.634 189C345.9 188.201 346.265 187.534 346.729 187.002C347.204 186.469 347.754 186.069 348.379 185.803C349.016 185.525 349.7 185.386 350.43 185.386C351.159 185.386 351.843 185.519 352.48 185.785C353.117 186.052 353.667 186.451 354.13 186.984C354.594 187.517 354.959 188.183 355.225 188.982C355.491 189.77 355.625 190.685 355.625 191.728C355.625 192.77 355.491 193.691 355.225 194.49C354.959 195.29 354.594 195.967 354.13 196.523C353.667 197.068 353.117 197.479 352.48 197.757C351.843 198.035 351.159 198.174 350.43 198.174ZM350.412 196.245C350.806 196.245 351.171 196.164 351.507 196.002C351.843 195.84 352.132 195.585 352.376 195.237C352.619 194.878 352.81 194.415 352.949 193.847C353.088 193.28 353.157 192.591 353.157 191.78C353.157 190.969 353.088 190.28 352.949 189.712C352.81 189.133 352.619 188.67 352.376 188.322C352.132 187.963 351.843 187.702 351.507 187.54C351.171 187.378 350.812 187.297 350.43 187.297C350.047 187.297 349.688 187.378 349.352 187.54C349.028 187.702 348.744 187.963 348.501 188.322C348.258 188.67 348.067 189.133 347.928 189.712C347.789 190.28 347.719 190.969 347.719 191.78C347.719 192.591 347.789 193.28 347.928 193.847C348.067 194.415 348.258 194.878 348.501 195.237C348.744 195.585 349.028 195.84 349.352 196.002C349.677 196.164 350.03 196.245 350.412 196.245Z"
                            fill="url(#f2e5ff76__paint9_linear_27804_6153)"
                        />
                    </mask>
                    <g mask="url(#f2e5ff76__mask3_27804_6153)">
                        <rect
                            x={281}
                            y={182}
                            width={82}
                            height={21}
                            fill="url(#f2e5ff76__paint10_linear_27804_6153)"
                        />
                    </g>
                </g>
                <g filter="url(#f2e5ff76__filter3_d_27804_6153)">
                    <rect
                        x={151}
                        y={132}
                        width={67}
                        height={25}
                        rx={12.5}
                        fill="white"
                    />
                    <mask
                        id="f2e5ff76__mask4_27804_6153"
                        style={{
                            maskType: 'alpha',
                        }}
                        maskUnits="userSpaceOnUse"
                        x={156}
                        y={134}
                        width={57}
                        height={20}
                    >
                        <path
                            fillRule="evenodd"
                            clipRule="evenodd"
                            d="M164.517 148.572L165.526 143.759L169.631 143.759C169.647 143.942 169.655 144.128 169.655 144.315C169.655 147.831 166.805 150.681 163.289 150.681C159.774 150.681 156.923 147.831 156.923 144.315C156.923 140.799 159.774 137.949 163.289 137.949C163.82 137.949 164.335 138.014 164.828 138.136L163.99 142.155L159.407 142.155L159.063 143.759L163.647 143.759L162.615 148.572L164.517 148.572ZM166.579 138.864L165.892 142.155L169.28 142.155C168.781 140.773 167.818 139.613 166.579 138.864Z"
                            fill="url(#f2e5ff76__paint11_linear_27804_6153)"
                        />
                        <path
                            d="M179.686 150L177.385 150L177.385 140.648L174.936 143.081L174.936 140.847L177.65 138.132L179.686 138.132L179.686 150ZM189.57 150L181.724 150L181.724 147.815C182.729 147.065 183.578 146.403 184.273 145.829C184.98 145.255 185.548 144.731 185.978 144.257C186.409 143.782 186.718 143.341 186.905 142.932C187.104 142.513 187.203 142.077 187.203 141.625C187.203 141.073 187.038 140.643 186.706 140.334C186.386 140.014 185.929 139.854 185.333 139.854C184.737 139.854 184.163 139.981 183.611 140.234C183.06 140.488 182.541 140.825 182.055 141.244L182.055 139.159C182.519 138.806 183.032 138.524 183.595 138.314C184.158 138.094 184.842 137.983 185.647 137.983C186.243 137.983 186.784 138.066 187.269 138.232C187.755 138.386 188.169 138.618 188.511 138.927C188.864 139.236 189.134 139.617 189.322 140.069C189.52 140.51 189.62 141.012 189.62 141.575C189.62 142.149 189.504 142.69 189.272 143.197C189.04 143.705 188.693 144.212 188.229 144.72C187.777 145.228 187.209 145.757 186.524 146.309C185.851 146.85 185.062 147.446 184.158 148.097L189.57 148.097L189.57 150ZM195.822 150.166C195.127 150.166 194.476 150.039 193.869 149.785C193.274 149.52 192.749 149.134 192.297 148.626C191.856 148.108 191.508 147.468 191.254 146.706C191 145.945 190.874 145.062 190.874 144.058C190.874 143.054 191 142.177 191.254 141.426C191.508 140.665 191.856 140.03 192.297 139.523C192.749 139.015 193.274 138.634 193.869 138.381C194.476 138.116 195.127 137.983 195.822 137.983C196.518 137.983 197.169 138.11 197.776 138.364C198.382 138.618 198.907 138.999 199.348 139.506C199.789 140.014 200.137 140.648 200.391 141.41C200.645 142.16 200.771 143.032 200.771 144.025C200.771 145.018 200.645 145.895 200.391 146.657C200.137 147.418 199.789 148.063 199.348 148.593C198.907 149.112 198.382 149.503 197.776 149.768C197.169 150.033 196.518 150.166 195.822 150.166ZM195.806 148.328C196.181 148.328 196.529 148.251 196.849 148.097C197.169 147.942 197.445 147.699 197.676 147.368C197.908 147.026 198.09 146.585 198.222 146.044C198.355 145.503 198.421 144.847 198.421 144.074C198.421 143.302 198.355 142.646 198.222 142.105C198.09 141.553 197.908 141.112 197.676 140.781C197.445 140.439 197.169 140.19 196.849 140.036C196.529 139.881 196.187 139.804 195.822 139.804C195.458 139.804 195.116 139.881 194.796 140.036C194.487 140.19 194.217 140.439 193.985 140.781C193.754 141.112 193.571 141.553 193.439 142.105C193.307 142.646 193.24 143.302 193.24 144.074C193.24 144.847 193.307 145.503 193.439 146.044C193.571 146.585 193.754 147.026 193.985 147.368C194.217 147.699 194.487 147.942 194.796 148.097C195.105 148.251 195.442 148.328 195.806 148.328ZM207.105 150.166C206.41 150.166 205.759 150.039 205.152 149.785C204.556 149.52 204.032 149.134 203.579 148.626C203.138 148.108 202.79 147.468 202.537 146.706C202.283 145.945 202.156 145.062 202.156 144.058C202.156 143.054 202.283 142.177 202.537 141.426C202.79 140.665 203.138 140.03 203.579 139.523C204.032 139.015 204.556 138.634 205.152 138.381C205.759 138.116 206.41 137.983 207.105 137.983C207.8 137.983 208.451 138.11 209.058 138.364C209.665 138.618 210.189 138.999 210.63 139.506C211.072 140.014 211.419 140.648 211.673 141.41C211.927 142.16 212.054 143.032 212.054 144.025C212.054 145.018 211.927 145.895 211.673 146.657C211.419 147.418 211.072 148.063 210.63 148.593C210.189 149.112 209.665 149.503 209.058 149.768C208.451 150.033 207.8 150.166 207.105 150.166ZM207.088 148.328C207.463 148.328 207.811 148.251 208.131 148.097C208.451 147.942 208.727 147.699 208.959 147.368C209.19 147.026 209.372 146.585 209.505 146.044C209.637 145.503 209.703 144.847 209.703 144.074C209.703 143.302 209.637 142.646 209.505 142.105C209.372 141.553 209.19 141.112 208.959 140.781C208.727 140.439 208.451 140.19 208.131 140.036C207.811 139.881 207.469 139.804 207.105 139.804C206.741 139.804 206.399 139.881 206.079 140.036C205.77 140.19 205.499 140.439 205.268 140.781C205.036 141.112 204.854 141.553 204.721 142.105C204.589 142.646 204.523 143.302 204.523 144.074C204.523 144.847 204.589 145.503 204.721 146.044C204.854 146.585 205.036 147.026 205.268 147.368C205.499 147.699 205.77 147.942 206.079 148.097C206.388 148.251 206.724 148.328 207.088 148.328Z"
                            fill="url(#f2e5ff76__paint12_linear_27804_6153)"
                        />
                    </mask>
                    <g mask="url(#f2e5ff76__mask4_27804_6153)">
                        <rect
                            x={146}
                            y={132}
                            width={69}
                            height={21}
                            fill="url(#f2e5ff76__paint13_linear_27804_6153)"
                        />
                    </g>
                </g>
            </g>
        </g>
        <defs>
            <filter
                id="f2e5ff76__filter0_f_27804_6153"
                x={-259.458}
                y={-121.511}
                width={954.126}
                height={752.536}
                filterUnits="userSpaceOnUse"
                colorInterpolationFilters="sRGB"
            >
                <feFlood floodOpacity={0} result="BackgroundImageFix" />
                <feBlend
                    mode="normal"
                    in="SourceGraphic"
                    in2="BackgroundImageFix"
                    result="shape"
                />
                <feGaussianBlur
                    stdDeviation={39.7462}
                    result="effect1_foregroundBlur_27804_6153"
                />
            </filter>
            <filter
                id="f2e5ff76__filter1_d_27804_6153"
                x={135.676}
                y={253.406}
                width={104.648}
                height={72.648}
                filterUnits="userSpaceOnUse"
                colorInterpolationFilters="sRGB"
            >
                <feFlood floodOpacity={0} result="BackgroundImageFix" />
                <feColorMatrix
                    in="SourceAlpha"
                    type="matrix"
                    values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                    result="hardAlpha"
                />
                <feOffset dy={9.72961} />
                <feGaussianBlur stdDeviation={12.162} />
                <feColorMatrix
                    type="matrix"
                    values="0 0 0 0 0.458824 0 0 0 0 0.45098 0 0 0 0 0.435294 0 0 0 0.2 0"
                />
                <feBlend
                    mode="normal"
                    in2="BackgroundImageFix"
                    result="effect1_dropShadow_27804_6153"
                />
                <feBlend
                    mode="normal"
                    in="SourceGraphic"
                    in2="effect1_dropShadow_27804_6153"
                    result="shape"
                />
            </filter>
            <pattern
                id="f2e5ff76__pattern0"
                patternContentUnits="objectBoundingBox"
                width={1}
                height={1}
            >
                <use
                    xlinkHref="#f2e5ff76__image0_27804_6153"
                    transform="scale(0.00581395 0.00625)"
                />
            </pattern>
            <filter
                id="f2e5ff76__filter2_d_27804_6153"
                x={265.569}
                y={165.196}
                width={119.862}
                height={71.8621}
                filterUnits="userSpaceOnUse"
                colorInterpolationFilters="sRGB"
            >
                <feFlood floodOpacity={0} result="BackgroundImageFix" />
                <feColorMatrix
                    in="SourceAlpha"
                    type="matrix"
                    values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                    result="hardAlpha"
                />
                <feOffset dy={8.62733} />
                <feGaussianBlur stdDeviation={11.2155} />
                <feColorMatrix
                    type="matrix"
                    values="0 0 0 0 0.555272 0 0 0 0 0.810518 0 0 0 0 0.954094 0 0 0 0.34 0"
                />
                <feBlend
                    mode="normal"
                    in2="BackgroundImageFix"
                    result="effect1_dropShadow_27804_6153"
                />
                <feBlend
                    mode="normal"
                    in="SourceGraphic"
                    in2="effect1_dropShadow_27804_6153"
                    result="shape"
                />
            </filter>
            <filter
                id="f2e5ff76__filter3_d_27804_6153"
                x={125.536}
                y={116.721}
                width={117.928}
                height={75.9284}
                filterUnits="userSpaceOnUse"
                colorInterpolationFilters="sRGB"
            >
                <feFlood floodOpacity={0} result="BackgroundImageFix" />
                <feColorMatrix
                    in="SourceAlpha"
                    type="matrix"
                    values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                    result="hardAlpha"
                />
                <feOffset dy={10.1857} />
                <feGaussianBlur stdDeviation={12.7321} />
                <feColorMatrix
                    type="matrix"
                    values="0 0 0 0 0.458824 0 0 0 0 0.45098 0 0 0 0 0.435294 0 0 0 0.2 0"
                />
                <feBlend
                    mode="normal"
                    in2="BackgroundImageFix"
                    result="effect1_dropShadow_27804_6153"
                />
                <feBlend
                    mode="normal"
                    in="SourceGraphic"
                    in2="effect1_dropShadow_27804_6153"
                    result="shape"
                />
            </filter>
            <radialGradient
                id="f2e5ff76__paint0_radial_27804_6153"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(-175.546 -52.532) rotate(38.1137) scale(995.825 1470.7)"
            >
                <stop offset={0.0755925} stopColor="#48CCE0" />
                <stop offset={0.307872} stopColor="#428BEB" />
                <stop offset={0.647543} stopColor="#505ADD" />
            </radialGradient>
            <radialGradient
                id="f2e5ff76__paint1_radial_27804_6153"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(607.957 562.115) rotate(-178.458) scale(784.106 2064.35)"
            >
                <stop offset={0.109375} stopColor="#FCAB14" />
                <stop offset={0.291667} stopColor="#FA6641" />
                <stop offset={0.53125} stopColor="#BE40C0" />
                <stop offset={1} stopColor="#505ADD" stopOpacity={0} />
            </radialGradient>
            <linearGradient
                id="f2e5ff76__paint2_linear_27804_6153"
                x1={216}
                y1={129.5}
                x2={215.215}
                y2={207.492}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="white" />
                <stop offset={1} stopColor="white" stopOpacity={0} />
            </linearGradient>
            <linearGradient
                id="f2e5ff76__paint3_linear_27804_6153"
                x1={165.948}
                y1={280.227}
                x2={196.962}
                y2={280.227}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#30ABD1" />
                <stop offset={0.219512} stopColor="#397DDB" />
                <stop offset={0.427817} stopColor="#505ADD" />
                <stop offset={0.693662} stopColor="#BE40C0" />
                <stop offset={0.864437} stopColor="#F06151" />
                <stop offset={1} stopColor="#F2991D" />
            </linearGradient>
            <linearGradient
                id="f2e5ff76__paint4_linear_27804_6153"
                x1={183.067}
                y1={280}
                x2={212}
                y2={280}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#6854D7" />
                <stop offset={0.412724} stopColor="#BE40C0" />
                <stop offset={0.736034} stopColor="#F06151" />
                <stop offset={1} stopColor="#F2991D" />
            </linearGradient>
            <linearGradient
                id="f2e5ff76__paint5_linear_27804_6153"
                x1={210}
                y1={281.5}
                x2={159}
                y2={281.5}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#30ABD1" />
                <stop offset={0.219512} stopColor="#397DDB" />
                <stop offset={0.427817} stopColor="#505ADD" />
                <stop offset={0.693662} stopColor="#BE40C0" />
                <stop offset={0.864437} stopColor="#F06151" />
                <stop offset={1} stopColor="#F2991D" />
            </linearGradient>
            <radialGradient
                id="f2e5ff76__paint6_radial_27804_6153"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(0 126.325) rotate(-45) scale(178.651 270.385)"
            >
                <stop stopColor="#48CCE0" />
                <stop offset={0.288462} stopColor="#428BEB" />
                <stop offset={0.601763} stopColor="#505ADD" />
            </radialGradient>
            <radialGradient
                id="f2e5ff76__paint7_radial_27804_6153"
                cx={0}
                cy={0}
                r={1}
                gradientUnits="userSpaceOnUse"
                gradientTransform="translate(126.325) rotate(-180) scale(124.784 353.993)"
            >
                <stop stopColor="#FCAB14" />
                <stop offset={0.159058} stopColor="#FA6641" />
                <stop offset={0.402081} stopColor="#BE40C0" />
                <stop offset={1} stopColor="#505ADD" stopOpacity={0} />
            </radialGradient>
            <linearGradient
                id="f2e5ff76__paint8_linear_27804_6153"
                x1={294.683}
                y1={192.499}
                x2={328.765}
                y2={192.499}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#30ABD1" />
                <stop offset={0.219512} stopColor="#397DDB" />
                <stop offset={0.427817} stopColor="#505ADD" />
                <stop offset={0.693662} stopColor="#BE40C0" />
                <stop offset={0.864437} stopColor="#F06151" />
                <stop offset={1} stopColor="#F2991D" />
            </linearGradient>
            <linearGradient
                id="f2e5ff76__paint9_linear_27804_6153"
                x1={313.788}
                y1={192.5}
                x2={356.722}
                y2={192.5}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#6854D7" />
                <stop offset={0.412724} stopColor="#BE40C0" />
                <stop offset={0.736034} stopColor="#F06151" />
                <stop offset={1} stopColor="#F2991D" />
            </linearGradient>
            <linearGradient
                id="f2e5ff76__paint10_linear_27804_6153"
                x1={363}
                y1={192.5}
                x2={281}
                y2={192.501}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#30ABD1" />
                <stop offset={0.219512} stopColor="#397DDB" />
                <stop offset={0.427817} stopColor="#505ADD" />
                <stop offset={0.693662} stopColor="#BE40C0" />
                <stop offset={0.864437} stopColor="#F06151" />
                <stop offset={1} stopColor="#F2991D" />
            </linearGradient>
            <linearGradient
                id="f2e5ff76__paint11_linear_27804_6153"
                x1={156.923}
                y1={144.315}
                x2={189.39}
                y2={144.315}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#30ABD1" />
                <stop offset={0.219512} stopColor="#397DDB" />
                <stop offset={0.427817} stopColor="#505ADD" />
                <stop offset={0.693662} stopColor="#BE40C0" />
                <stop offset={0.864437} stopColor="#F06151" />
                <stop offset={1} stopColor="#F2991D" />
            </linearGradient>
            <linearGradient
                id="f2e5ff76__paint12_linear_27804_6153"
                x1={174.867}
                y1={144.5}
                x2={215}
                y2={144.5}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#6854D7" />
                <stop offset={0.412724} stopColor="#BE40C0" />
                <stop offset={0.736034} stopColor="#F06151" />
                <stop offset={1} stopColor="#F2991D" />
            </linearGradient>
            <linearGradient
                id="f2e5ff76__paint13_linear_27804_6153"
                x1={215}
                y1={142.5}
                x2={146}
                y2={142.501}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#30ABD1" />
                <stop offset={0.219512} stopColor="#397DDB" />
                <stop offset={0.427817} stopColor="#505ADD" />
                <stop offset={0.693662} stopColor="#BE40C0" />
                <stop offset={0.864437} stopColor="#F06151" />
                <stop offset={1} stopColor="#F2991D" />
            </linearGradient>
            <clipPath id="f2e5ff76__clip0_27804_6153">
                <rect width={375} height={378} fill="white" />
            </clipPath>
            <clipPath id="f2e5ff76__clip1_27804_6153">
                <rect
                    width={800}
                    height={300}
                    fill="white"
                    transform="translate(-137 78)"
                />
            </clipPath>
            <clipPath id="f2e5ff76__clip2_27804_6153">
                <rect
                    x={179.32}
                    y={145.625}
                    width={126.325}
                    height={126.325}
                    rx={19.4369}
                    fill="white"
                />
            </clipPath>
            <clipPath id="f2e5ff76__clip3_27804_6153">
                <rect
                    width={126.34}
                    height={126.34}
                    fill="white"
                    transform="translate(179.32 145.625)"
                />
            </clipPath>
            <image
                id="f2e5ff76__image0_27804_6153"
                width={172}
                height={160}
                xlinkHref="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAKwAAACgCAMAAACmLXeRAAAABGdBTUEAALGPC/xhBQAAAAFzUkdCAK7OHOkAAAAJcEhZcwAAFiUAABYlAUlSJPAAAAMAUExURUdwTNS1ivjNo/XSsNm7leTGlLCOb+jVxtrHp+LInciqa7SSc7udf9+7TbaZf9OkecyjKLWWeb2NXvjRq/TPq/jLoPjXoa6Nb/zWq7KRcrmXd7eXfPnOpfvXsrqYeNCoNK6PcvnQqLSWd9GmHM+pObuNYLGQc6+OcO6+kvvTqe3GQb6Saa+Pc5RwUOvBm8qhIcifH/vTq9esJObBUNSpItOvTsqgLqmIarORcqeCYvzatPXTVue8ON+1LPncafTNUs+nL+/EnOrAm/XInqiJbey+lezAmaOAX/fLoMedEsidGLiKX9+xhv/aru3DPfLOT8acFv7asc+kfNKsi+K0icuge+K4McmgcuS2jOe8krOLF8yge/bFQ/3Vqv7RPtWqK/7PMbeXetWoZLqTItWpKO+6OKWReee8bP7Tc7eOEL2YDr+XD72VDcCYEL+WDr+WD76WDryUDcKYEsCXDsaYE72VD8GYEcSYEsOZEsiZFMSXE7yTDcOZD//TLbmQD7aODsKWE//RK7qSD8SaFP/UMf/PK/jKn8qbFLuTD7GNa/K8Ir2TEsCVEvTFmf/XOrSMDvvOoq2Lav/LKOSvHeeyHuq1H/C6IfzQpLaGWf7HJ/jAJP/UNrqJW9qoHPPHnfrCJbODVdelGvW+JKuHZrSRcMWbEd2qG+23IP/JJ/zFJrKKDf/NKeCtHf/WNq+IDcebGP/ZPfDCmNOiGe2/lf/nO62GDP/RMei8kvPClL2WFv/oQ//QN//LNr2ZJLqTb82dF//LLr2XHv/jNriOZ6WCYr+XDqyDW/7Up514V86iF7+bK6l/VOm5jtipf+GvJqqDD/nIms+ngqB9XraVdsabdMCRZv3GL7OJY//bRP/Yq96xiNithsmeFMaXbayGYO+8jsWfffnDNb+Ydei1MOO1jMKcI7mMYM2edP/fR/C7Mu24KKmCHf/iTv/qTKqEL6iEQv/gsfXFLeu3hrWMQLaOKeGwasufTeOufOrBKc6hOdqtTJp1D7Onm9i6nebWyP7RZ5PuJkYAAABqdFJOUwAb/iYOFP4BBQkjpC9FP/62TP5jQt816enzhluuU3R4tYZm/WDmz5HovaS+w/79y92Z+lTrMqH13dZ5Zc7qJ3mTd1HPfb6T7PP96fPK9L2R9M3ng+rR25eoZvOu/vnay+/q9NTe0v7cxPoNMOmvAAAdF0lEQVR42uya3W8TZxbGk+B4nARD2IRAYCGEhm/YBCgQFShsP3bZsCpsu6Xa9qqLVGk1H+9MRmNZspVIsRR5VFZkruILK7Lk4YYLUIWqyBf2KnJMSmhU0RBFggZFiISLSrsX7d3uxZ5z3nds/oBJ4kh5CSZfWA+Pf+c557yhpmbjbJyNs3E2zsbZOBtn46zvE2p9p3W9aG04ufPJl1vWidh36h4sBg/WrwutUufY+EzB+UBaF2pbx2eKBXvHegBBavvbov3jdwX7eKDqtdZfu/johTN54rFt76r2IDh941+JxPRkdvLEC7d9c1UTED56KpFI9N/PZLM/nrCD+0JVTMDRt39K9OPJAwjfvbCD+6tW6qWLIDXaH+mPsDu/nCvMz0MiNFYnAedvvJVAWyORiMr069s+nHlaKDhNVZgIUtvRU/dBahRsVVWmaD91tb2aeb1gt1cdCFL9NYA1irCqINXS4vGlZqnz1fPXBWdHlXXd+vMAqyCAMV1Ro0vTuaXGwPuvZp66TlMVJYIkhS88uk91hbZauhlPTOcmpnNna947/GwrgLC7esS+i7ASrWSrFk8sTeTyeUvpqw11fo8gVM341XDtIsEKdXVLVhUdYCWphmJEOmrqEQQ7e6gqxq/A+YuPElFIAIiACCOpeSRAMQxFUboDNa2/e7Z1zjlXDeNX+AIka5THFdQVwjqRm55QUCmc/q6ahj98P/O0mD0YWHtY34ZkTVDDorhKgK35CYNr1eF3c0NN7XawFkBYY1gvAQHlhmVxAvL5HAFgkFjjerimpmV8ZqGYXdM5PHT6wiMEAGxVmcwUleIKpKJQXUdb8bEZvvPks9dzRed4w9r11o/ewmRFW1UVYb0PsOYBVsPgtupc7HUYYzYd3rpQtIMfhNYwWaNew1IErHkjxpUSsaRW0S/Dt7eQtTvWZA4PXboBDQsjoF+NqBYQAL0VYBUqxaOOxupKTy3Q/eHWhWXb2bf6YSshrAlvYtF1JCCXA6lgq47xqgtjdV2DR7kD/s6mv76eA7V7V1vqux+dKk8sMtNL8SglayWuDKouEqrLuqF0Q6uVfg/WFu3e1QWh9topXAV4w7J0TcSVxRtWBQF4ANMVVAyNARrdnxfmll17NccvWAXKyXqLCFjicVWW6iUWQsBKqJgaA6TH1rnl5WBw26o1gTBP1ggSoJZ7ay5WCSvvAY+mwRtaGw3j3/5kYTkzH+ytXb24ilJrjWAEaCQVeqthxMphxWuKrEUMQC2DzzfTeP7pXCpjB1dl/OJ7Kx5orapOvfXr/EQSlFIAiKgiSnkD001NaE9QXbWCtQ/t1QDhPExX/XxmVWWFJyvCGosRrzoPVs1LV8JARghk+G7tMgH/2Vz68by90nN4CHprguZrWrFxa1miuEKpisKHAQUh5ajqCiEAQmFtUOFf0EdXB/W9ywCCfWjFYfWSVeW9VcAKamMYsAb3sgQlJaDFP5mslRhQqyu3OuiJ3gOxKbd9RUBo2NMSErDSLoi3ATQITicnYGshnaRWoVRV9BJRyjQQK6N405RBP7yr9NRzENLpTHFF7sPb/jL+sikU/vuSSNZ+GWz19lZDiSkxrC0hljcBZuqaIjMuWdNMtVRCFHQl0sVbSm86nSoE/e+6oZ1T467zxcezqRwCIMOKrZQwrr7GQRDrijjw+gHoK8GbDK8/3hsArwCCCVJRraV382F292/SqaL/16BSQ93o8JNs1p4N/nIrcouv2HeW8lZ+wkKJChGLannKwtdBZgkQBVjRWhnCoKTKQC2qTYQ5WU2kdp/vC9mR4ZEHBSfrzgZ/tWBmVeIUV9MWFwp+xii3UCwNLiAOSp8xkKwjBEiAqZrkrSU38yfdfCCdTruzvoPQdmVk9JnjOK77cMjisEJvpVcehBIESUPhH+LMAq5iiWFiEbRMRqGmKsPR9T+d4c+6F8QW3S99B6FzeGps0ck67uTPmkhWCtYYhhVHgWsWWxd4iwGAjYCBVFBZUk0T1GrwOdbM+2zoWCqVKri+34fXHxkZHS84k3888V8Le2veEF2ANwJOg1DL00orlUxMBMgNzAJUChyoKF7vO+OBkEotF4K+3361XpkaeW47u8+c/ZVgjXEnFV5fXCvnl6BFXksypJWGnIJiVUaxIBc4YOpl8ax7wdqi6/s1qNQ5MvXNYvZgQOrJ52J0DEXxOiy+m4yRWj5wmUCtrJlAQAn1ka8yLGngLTQT1iOu6wMchCafxy8psH10FBLhkNQxiEoVXvukDh8shbcxg4+wzJRNjZkmiMWqUtFVfCNrGYt2iKfdchW6bsH/a9A9ELbP7XNbGnsGYkO8vRpcLT7iMpPkXlukFrMVDGW6jAJBJviqIrqktlsM3tKhVCpTnO31+wcj0m9HRsYW7YMN4X8MJWO8CVRIELr5jMjFmtADEAHyU41ETHiDD+ArspY47Q0dBzgIfidC7XZIhFlnV8PNgaGhIVRLViqGFwleGFg0ZkFl6bIs5JokGaZKSC/IMmZ1C3USgJBadmd9H79ahhGEHZu7bg+QtzGBQJkD7xaOBliG5hKwJgGLxuKwppLjd8Le3HGIEqHX764bAhAeLDrHG28ODgxVAoGqCx4QAssqL4k0uIBer7wiSAK8hxUHpdfsJUDjQZxs3V1+L2S1V0bGxl17f8ddUDtE1lrUxCohppNamcR6hzOLcqkzYJjp5vUz3rNug0RYdtv9vgaVWkam/vncbt/2+e1BQYKXBwQCqrUsHedZxoRSBu2AfKU0wGNq8Bktfrb8rE2pTKbo+j6HNxyBsF209529Ozj4Brdi5uaDt2VZlAY6l2sStGQr3ohGTIQWMND6ynFVf2BlQGjbOVr3yg1+9jlXm6TG8IZYix5oPZQ9rbJAFpWSs9gwTDPeURa3/2omM+//+FXTWTc69sRuv3kPQABukzGRV2WxYKuFkwypFe4StNQXxDjDsMR6yjcyIQRh3j3ud9iGCATnwLf3sMhiyWSSrLW4pZZBDCAGIBYlM4RWmEsZhj0MoZXVaFeZ2kYEwXb9n8PrpsZeufa/v72LRYbeWrgwkFrA1VK4XMaEuaLKKGiJAJnyAH6p3RUn96czqZW4/eocHf3mif3iB6E2KYZulInNS9QXOkvgUobBi85JMNFT7GL44Z3TlZ/3HcNECDYFfO4Nge0jww9m7f/8cI+rjcU4AyTXqmQB8YoJBmpVVuKFVUKx4K2G/UxtrtT/ZqixjB389PAn/oLbemWk7pnr/AzY3h4YGMBIMLB3kVCrXF0ok/FOhnsNnw5JMS2OCMX1cCXC94K1qaD7crHJ1x87SScpER5yEHiAJYVYngXkLaM2xngr47cGZKuGczijySZ+tmJj/bFM5nHRDc5+5e9wW/s+LWQCBFQLelGtwqvLYrwl8J5LvUzn6y3t4nwjo+jtO1N51i1XMw8BhKzr7/9Vk/YMAwg2gTDoeStAQA54xCK4JJkUkmTyV4WGoOIOCWrjl9/oWrsK/3s4bztZvwPsJCxkTx0AAXpDRa3BkwuTADHAH+CQXMZLTYWaw90BGJBxf4xE4vG+N1aEwLGvJsHaSb9H202wkI27AALHlqoMsAW5DMTSvZzMUwvrC3ZdClvcwoEEnYlxPB6P3+l44wXblc5k0nZwt98zQkvdVN0TJ0uJMEhiEVsyFyuM0cuOsxd3mKyVKXhVQgFzF8Sq8Z5KsEpfzKVTeA3qd2uAhWxq7KXzGKy9K6aEpJdfWGIyK1FTqAQuXx3wA5UukrDA0NquSh58vPB/Ws41tqnzjOO5QOxAWULGtq5cqjLR0q4EBmsZdGoLdNCudFI1ulEWbVK1qpPSYGocx/FQsGLNxLWdxOMyp0mcwEm4VCiJE0GMgnIREaXYThxygSRLHAIClUggAgFB127P5T3HJ92+5ey1MQmffvr7/1ze530PGT48GNH8Nmgybsi83tvddXUlTAu8n+QKXExY1B0Iz9IHWQBHitk7DbzNAdg9K5U2dmPaTZT2hjNF8+sIsCFL6pHYCLK2RZxuDaLeGpgYTxN251A6Q0vIe0gKMMuet2Rpdb9Nu4nS+s5pfy1Yv8hRGhjHGFPTshN20VbBwEUBLYtbRMNO7hSQeDePPIx7LLWWlUym02+NpI3c8FX4QNolWsdY8puO0qEUNALDFsSllbVlMdGl3NySaXdBiFHmgq2DBUwrS5u8bSitL3QBx6BOrTdkOt0GT6kDMwIVMplWlhbKGFvWILJs3LvZ3ODiSeoei8VSy9LqNoavR0YurPgp0F7W3gipm6KOcKtiBFEcPiFhP1bEpdkM1QTRLvLuAVhzCFaWVrc50DQ0cmEdzcOd2h+M/DAYjQ55pdtEK2tLtLyzwSZBCSk+/6BSQRNFUtYMnq21r8I+a9Ymf2Co/8IbuiUZYATt76XoNnuisMXBqvu5qGSFRdyIkw0w3wolRQkT0Lgdy0ZWoxF9QNImBxyeoXMX5ifo0QjnJM3vpeg3RT3NNVLcCIWk7cdYdFHWXZxuDaJsiS4BNznY4LK0dntt7ao5CboNQYAd3ZLIByM3pLWaXwte0BQMDkudEGOKbQuLlDqGjt3JcbWbph3Zu4QVeKuLR5Ugrb32rdf1ul95HE3DnXS+sCQjA6T9kdZVV785Fmwa64SqW0e23ct1l2hxLpNr2MmJK0f4Fn+SackHZqPdUlv763n65Q5HOO3SG3TshkZwSprfD5+9PBhsTulUZwSFVp7P8XlCDlpV+ICVzSHTGskI6QuCjmi47xLn1++htN61mo9BN8aCnp7OzglFWnTtX0VpMIguBoOfsysZliLMrMCiEf75UTAanDy3LpFT+FOcETTfmW+PeZpaZSOU8FAJZwkobbZBHIKxkohMuYBrgjAtujbP/pNYNPZwVJyE6GahEWqcz+m1N4IHYuz2Kc5f8lAplzIC5gKmzMnhr1/ozKmAlGVxax8HJ9MuKXvF+cvw8FH76wjvTwYDfdJ3jUB1LJeamDitgYnNlGTphoVZwBot9VOTI1ueUE2/KipaUzS/FqzfHg42j3Oy/W5GMHBWNbNHSVT4F1lU8cHq2r6curwu/rWnLvNVA63WY1Bd8rag53rNKBmhROkWOcLQobvNZjFKzhbAigOIFj9t8Hp0QX1lZqGvGvpw7efhYARPj/f8RDzGhLSGXJ7FmFXSmuMZlm9bEa7R7Xabbqstmjq3Gqdfz2p9LTh163QjcEPDNjCQQ41MK5/dxSOL7wYZzTZc9WumjVKWVVf7/g/tV/K2cNOQUxJGENIWCReIyM/huBKyIifkAHr+xiaW26Ye0CToFmZUVJ93av943obJWKxHab8o2RYKWE6nZgVYgaXF2hrNbjfCWlepafV/qPCFLntf1L7qhmNhMMKpOnUfTrRyQjUryyhaQ4GL2prNbjbCSvUh7py3K6pDzrVLtW4WX5uMBckIdXHbYmEw5KjyFG0OctivFrvFkpdnwb+MwgS2MzZ7fbo6oJagEbTvw+d8EEYjjHar01cuFQSzCHqVrCQsoOIbtRW0VhvQqqagCdB+oRE0v5fy+sNwDDPCqfjO3OXKNchCGo3TYPH7z7PnEWyeNR5jVjvQqg7voA/3VXu1fk5T99LFWLhpmIzAPqDCYHCDtEo6VWQFWIC0m/JwWfOsVkY9A7TW+rb0RNWsDoww6tX6YESX/iCeEVjaIpfLYACTGpWlpFc7OsBEuPC2WGXXWq2meqCdrRqDohFSNL6OoJu3I+1h7Hqr8w5Jywc56ANVcyUbgkxgAUw7ogKrVWhr7WDaPyk5Qf/E2xU+n+bXgmen33841NdXo0y/2LRuUVrNZoVXNqyJXmgEhAVc+IBVD7R/nqdXG+GyU2Mj6OY98Pf0djpTQjxYxMLgwoJrNqhbAVlWjC6ENalgmRZh237+tEyb+F6Gz1eTMlfj87HlSZljvZdqKMZIWjCty4A3LRUjKJXLQpEFrBheREvAyIq09W2rX5CNO7+/wtdfo/EYNPnNb7/5prdTcnZOiC68CGlz3W4uCjKq0WLlHEuJwCRQTeJPvYlYGyu7fiesoPt9f0aG1n34Yv+3/8oc854fd4bU0gIs4sZlNWJEoax5JsQzmUwEi7/Az2SCxsOVq7u6rr3wKkfDe/39/a3epzTMCPpFnszM5rFLl2+2em+L2ReEmMvlPpMNuDYZ1ooesJKoeQLQJD5N+fmgaWPj4cOrKyu7YH34Csm58ebISL9Ty+c0Z/8g4E9q7l3RH+mpGZ0QI9siF4qL2tooDwApiap881aByaj72r5E1MpKFBakvXbtl2ugi9FtT0sDCV7UrqFZkBRw+HucK0Yi4T7vnTp5vuxyCVqzzWg1irgir5KwKtJ8JkVUkrXrGtICbmpC4rZI5KZT0u7/S1nv8SQFxkYnRiKx61B1ldG9DAtGsFlkrwqzMiaCAmqjELWyC1hPsrC0frMm8f1IJNInrdWs/Xo+6Pdnjoe+vvcwHMANGbByW8uwNhCWnConAaRUSPP3yd9/5dGjJwmVWb+i9eFrWyORtHOdWt1LmZUUdPibe+98PfFBLNjcKt0pkcfLsrQ2a9yjeVZZVNM0VCAl1ANdB67dusWoWV9lXb2alTWVdlOStGm/dAs8Ab+/J2XpRPd92OsOSZ23xXRZNi12KVZOV+zVfLH27Wtjrx5F1JP793ftP3Dg4C1YiHqV1llYWVP9nWu1uQ36DMAGxn4x++Xu7gexoGdMCrGyBUJZG8GqslQctk2FCqwHFNQjdxVSWKdbsh74NJmH698NBMAFcxPm7Oj+fCrmaHJKdwjWVaiCzYuLKhtA6CqT7gcDHDx4DFiPHLl7Ny7r2RZY5eVZj19J1aLWAuxwzcKEhKfr6i5OBh3DknQfhS1QXAC0Jo4qxQOACnY9zF5lUQn10KFPj6CsA7DOKqwt5cXFxQ1//MuiZxbPtNY2gQtwoDorvaTkQSzqGJdG9yJqQdyyJGs+ycqs+SSrCvUgoB479CmgHqm6O6CwtvAqBtqGhoYr/47O8LYEWLapl2rMSzv2djwMOppbvfdUwrqt06JKwKJdiRUNIFCJ9W5V1UAVsg4osMXlqCzSNlyZ4fmd3++/TrdbUhd/VFDwKBZNGvaCEQpVwlrZp9PSACaso4qsMupnn1WdOAGo7QPtcVZ8ASvQXmmYoWU9kLhqYPOR/Pw7g48LXFOeUv+4VF2gDq/puqKsQlch6zFiJdSqE+QBZG0/23JWMUFLAyk7M9jvOzxg2R+nJv7sncHBpEiHq2My+kWmU7pXKFit01j3cXJtZFlPTkM9Aqiga1lZOy/FsKir7IMZwS4C2KbxZ9c/OTj4RfON0L0zrkfB0sEhafS+AmsSmMAJcSXqgJpVcQCiDpQNEGl7S/tpyLDl5fAuR96GmcM+iZbt3Qaogb5QKDT3ZdeZqeg/ksa91dNg91GyQlIur0f/m5VkBV2PC2FPnz6NCRZoi8tZ2OIZwiYnQRcz3Js0WJp2PhRaN18/K911MebAx/PuASynWE6rorZyIyBCS6AKXavKygaOl7UfZ1SQFV6KsBrYYL0fa+1Y0rAPUJfi4+CzVroeB0tLI06pg4QVqG1t00j/h6xk17LjfydZ/4bCwiqnVUzazljZdz1NUGvHz4VCW57jTanu1VUdkBE8ff9p5Wx/mrriON4HSqkKOktZ1TbKWCI4MWG6TdiDTzwsmw9BY+ayoC7ZH+EL+6JJe0yXXHJLxu6s2sRBDaY2eneJbXxBHDZtCcXQUkIfAAnrgBhMijo392q/c869l4u6COih8A7y6fd8z/f8zu+eAkYQTXDhglgFENJrN6isnT/RbYDICol18frFHmAlsE7n7dt3JdRLYs5i1rk3qbjaeMGb7Z4cjGwrk+95lH7152OEb6o9lVjFVCVjsWbplFPAo9AVYJ23RV0VuIQ2PT+/ala15QgnCJCykfp3FFVGybGb/zIsl3NN/i6zyrN/46V9QE4szNrR4SRDRHUAaIB+gbDz848erVJVXeWRTAEJQX5kU6MStfzw7LObjxHyTruewOKCo6BYA5CtVa5ZlKiEtQej+gEUlCWwDoeDyEpZb81h1jurqwyN5kwhmmHiwWC3ssGjPTU0u3HwyfMQNoLrKalZpXpFYu1UhqtHSizC6vfLsjoILeENtAfSBPXOamD1FZZCIcPkNKF4MKf4AFrRgeMTE5FYLHb5r+FhlOgeu0lYJU3xqpJQMavHI6crtgBFBVgb1VVmDYCsBHU1sLq6I4VCdGhmShPKx6e+l/p8+oOHZ0d/GQTWZMs3pgfDwnTxE8IqTj4VlWSAuLAUdgVlRVZM66CwgBsIBNqxAwjqrX9WfEJsMIOs2bFIJMjy+fzIB6IxKprWpy7HCOp2Nb6ghLLdrueEVcTslAoBRQZQVmoBoLU7nTY8HLKyxAEi6sD5FZrV2gqo8b5IZHKt2SvEc+I/6tQ2r5+YIaqGSYzpm4dDKFE8c4VkKsYUSeVo9SxlFXNAyeoIOIgDMGlveuHqed/Aym501RQKBW9qMBLZuU7bBrAJ0pIEs86ORpKAmpRiTGcKsXyf+xndVcXxs0LW66JbiV1lw9qdi7ABR3t6jqL2Xrrh8w38tmElZq3E1VUOHPDuFoPKyDFCfnpTiUoFcTUxNgik4U8a5U61dRixWdfYh+KCwuPHxR2LqIpTAMuKTeDEsHa7nbCKtOn0I0LaCw7wjQ/8sPt13U+t1arVGfCxxWA0R6NcEBzQshn/Vg3LC/mRbXrtqfUT9yJJjLpW0VQ3WBCLplwzneLc4295XUkGkBKLCktllZRNz2FZMeoCRt2z9bWNWgzYZm6tqTRaTdFMhk9hs5KOg96M+GBu5ERzIjVKUMM7y5Yc7rUmxAl9rmcEVcG6uLA6ekRZqa5gWLtNUrYdowJpb//C1XPjA1X7X/9wQWtmEUIsx3Esl8kUuETfWH0ZNWVFFPavqZGpvnuTYYxa/96L79zIs2zO5bpPOBWskgNelNUu2cDmCKTTdyhq4P64b6Bqw0fLaHLozBpWowFeL4PQMBeNsshcU9dg1UJ5yCEhPt09FplMYl23q1/6c0UWOJClujb+AbRiDMjbQA91QIffL8er3S5ZFsw6T1HbiVn3vL+cTw7qDTVenvd6ERkMg3+CGTLBr9eoWjVIyHe7IQNqY8ltr2pK6tXVKMq73Zv3ff6Q5KvnVw91AC4Ge/yyqBKonVoAMgCj9vf3L1Sdw2ZdZjNGb90lBAWBB2KGYSg0y3J9scZyzssIQ8VdydraWEvZqydJb2S4TK5r7zr11s9AXnrSlrzqV6hqt8uy2gIEFUj77147Bw74eI1qmX0uvcp4yOvlAZfhGQaYMTIcvpMuM2J4IVUcrh39+wF/GIQt0ulfnpgmfCDDt0yLSo8+9Ig1S4ecrFK2ElmpBW5Jqjru+3zjVWdKS1ZUC2rLjZUWExDz4hAEIZHnNAxUXO5YbDQXHxprLGkwmVstlcaKpausXECZrNuNax1D6Y6F62IALILKqlJZ0+k5itovmnWlz5X0eKh02oMHLIdMu7xeLLDXG2X5eLa4qzZ2LzWUm2xpZrkoh1+sqabuQLkYzSp8P1yTcIsfttftOy3Ovh/rSV7Uq5S1XXYANev+VT8Cw8RE5roakxlpMnBKSBSHk2GAzU9P82BlMDOrYRDsHCwyHbJUWivUBl0TA7tul3S5sGj30bOKuVeKasNxRVFtV3w4rt68gYyRi9TahjZWEKbc0y5XH8AGGWYYrzwIZTA34lgSdrxQXd3UhMuvsFsueku+OHZWnnwbjQCSArIDHJ3j4IAzpW/tYpceAjgYHNl7Yu3J1OxQNg+JEQoxITiSASKEhobTeBHN51AIoZS7fstiDqs/Pb3UqdQBS8y69a0+Dbd+uStLroUY1pR929xUXS2Al4VgPM8H4zxkMgBrNCA1wz8IoaCrq2vi+MnvThzU6ooAuqR0x1kn8arthbhauEL21v9zwH+RVooziMN3mAAAAABJRU5ErkJggg=="
            />
        </defs>
    </svg>
);

export default PlusPromoM;
